# Controlling how Tests are run
`cargo run` -> Compiles and run binary
`cargo test` -> Compiles and run tests

There are more command line options to change the behaviour
`cargo test --help` -> Shows all options
`cargot test -- --help` -> Shows options that start with `--`

## Running Tests in Parallel or Consecutively
By default, they run concurrently in multiple threads, as long as they don't depend on each other, shared state or environment (working directory or environment variables).

`cargo test -- --test-threads=1` -> If for any reason you need to run it in a single thread in order
Ex: 1st function creates file, consecutive functions read and write data into the file.

## Showing Function Output
`print!` and `println!` and similar, will not output, only on test function failure will it be printed.
```rust
// Example: Only the failed test will show output in the summary of failure
running 2 tests
test tests::this_test_will_fail ... FAILED
test tests::this_test_will_pass ... ok

failures:

---- tests::this_test_will_fail stdout ----
I got the value 8
thread 'main' panicked at 'assertion failed: `(left == right)`
  left: `5`,
 right: `10`', src/lib.rs:19:9
```
`--show_output` -> Adds summary for successes that show the output they have
```rust
running 2 tests
test tests::this_test_will_fail ... FAILED
test tests::this_test_will_pass ... ok

successes:

---- tests::this_test_will_pass stdout ----
I got the value 4


successes:
    tests::this_test_will_pass

failures:

---- tests::this_test_will_fail stdout ----
I got the value 8
thread 'main' panicked at 'assertion failed: `(left == right)`
  left: `5`,
 right: `10`', src/lib.rs:19:9
```

## Running a subset of tests by Name
```rust
cargo test "function_name" // Calls a single function
cargo test "string_slice" // All functions that contain the slice, will run

// Ignoring
#[test]
#[ignore] // add it to be ignored when running
fn somefun(){}

// Execute ignored only
cargo test -- --ignored
```