# Improving with more *Rustlike* code

## Encoding States and Behaviours as Types
Basically, implement transformation of types instead of implicit function usage,...
```rust
// Post is the end product, which only requires a string
pub struct Post {
    content: String,
}

impl Post {
    // Creating a new Post starts from a DrafPost
    pub fn new() -> DraftPost { 
        DraftPost { content: String::new(), }
    }

    // Allow to return actual content
    pub fn content(&self) -> &str {
        &self.content
    }
}

pub struct DraftPost {
    content: String,
}

impl DraftPost {
    // Draft is the one that allows text to be changed
    pub fn add_text(&mut self, text:&str) {
        self.content.push_str(text);
    }

    // To go to the next step we transform it into PendingReview type
    pub fn request_review(self) -> PendingReviewPost {
        PendingReviewPost {
            content: self.content,
            approvals: 0,
        }
    }
}

pub struct PendingReviewPost {
    content: String,
    approvals: u32,
}

impl PendingReviewPost {
    // Review Type can be approved and converted into fully featured Post
    pub fn approve(mut self) -> Post {
        Post { content: self.content }
    }

    // Or rejected and back to being a Draft
    pub fn reject(self) -> DraftPost {
        DraftPost { content: self.content, }
    }
}
```
All this time, we have not really creating new memory, we are transferring ownership of the string!

This is a more Rust way to do things

The 2 step approval system is a bit tricky, that could be solved with a new `PendingReviewPlus` struct that just went ahead.