# Objectives of Chapter 14
 - Customize profiles
 - Publishing on [](https://crates.io/)
 - Organizing in workspaces
 - Install Binaries from [](https://crates.io/)
 - Extend Cargo with custom commands

===

# Customizing Builds with Release Profiles
`dev` -> "Debug" Unoptimized with Debug Info Profile -> `cargo build`
`release` -> Release Optimized Profile -> `cargo build --release`

In `Cargo.toml` you can add [profile.*] sections to specify new profiles or override settings, for example:
```rust
[profile.dev]
opt-level = 0

[profile.release]
opt-level = 3
```

# Publishing a Crate to Crates.io

### Useful Documentation Comments
 - Document packages
 - `///` Documentation Comment (not `//` which is normal comment)
 - Give an example per function
 - `cargo doc` -> Generates html documentation
    - `--open` option opens it after building it
 - Documentation parses Markdown <3

### Common Sections
 - Panics -> Describe Scenarios in which the fun might panic
 - Errors -> Describe `Err` types if it returns a `Result`
 - Safety -> If function is `unsafe` -> Explain what the caller should do to keep usage safe

### Comments as Tests
`cargo test` runs the examples in the library!

### Commenting Contained Items
`//!` Adds documentation to the item that contains the comment, not the item the comment follows
```rust
//! # Doc My Crate
//! `my_crate` description

/// Comment about some fun
```
A section for fun will be created after the `//!` lines, and those before will be explaining the module for example instead of specific function or struct data.

## Exporting a Convenient Public API with `pub use`
Item Re-exporting!
```rust
// Ex:
use my_crate::some_module::another_module::UsefulType;
// Ew, bad, long, boring

// lib.rs
pub use self::some_module::another_module::UsefulType;

// user_code.rs
use crate::UsefulType;
// Wow, fast, good, direct
```
You have to figure out which types are most used and practical to use directly, then re-export them to facilitate its usage!

The documentation will list and link to the Re-exported items, so they will be easy to find and get used to.

## Setting up a Crates.io Account
Create account
Create New API Token
`cargo login <token>` on the repo

## Adding Metadata to a New Crate
```rust
// Cargo.toml
[package] // Where the metadata is set
name = ""
description = "" 
license = <[License Identifier Value](https://spdx.org/licenses/)>
```

## Publishing on Crates.io
`cargo publish`
This is permament, it can't be deleted, but you can keep overriding the version unlimitedly.

I've had to use `--allow-dirty` option as I am not using git to keep track of this, it is folder per folder.

### Publishing new Version
Change `version` value and run `cargo publish` again

### "Removing" Versions with `Yank`
Yank does not really delete it, it just takes it out of the usage for new users. Proejcts that already used it and depended on it can still download it and use it.
`cargo yank --vers 0.1.0`
`--undo` to undo a yank

===

# Cargo Workspaces
Projets get big, having them in a single folder file per file is an abomination 

## Creating a Workspace
 - Create the folder
 - Add the directory in `Cargo.toml`
```rust
[workspace]
members = [
    "binary_project_name",
]
```
 - `cargo new <project>`
    - `cargo init` if the folder is already created

That's it, now you can continue on with the development, is similar to nesting crates.

A "base workspace" `cargo.toml` will only hold workspaces and maybe some other information. For now know that the base can't hold dependencies or package name. A `Workspace` Crate is only that, a crate to organize other packages.

## Creating a Second Package
```rust
[workspace]
members = [
    "binary_project_name",
    "library_project_name",
    ...
]
```
 - Repeat

If we want to make a project depend on another
```rust
// Cargo.toml of a project x
[dependencies]
project_y = {"../project_y_fodler"}
```
Interdependencies must be explicit.

`cargo build` -> Will build all packages
`cargo run` -> will run all packages?
`cargo run -p <package_name>` -> will run the specified packages

## Depending on External Packages
 - add `crate_name = "Semantic.Version.Number"` to cargo.toml under [dependencies]

This dependency will be local to the package, not to every one.
We should specify to each `cargo.toml` that does depend on a crate, it will not duplicate the download or anything strange, it is to declare its usage.

## Adding Tests to a Workspace
`cargo test` will run ALL the test in all the crates by default, do the same as with `cargo run`

## Publishing a Workspace
You can't, publish for each crate.

===

# Installing Binaries from `Crates.io` with `cargo install`
`cargo install <crate_name>`
They are installed at `$HOME/.cargo/bin`

# Extending with custom commands
Basically, anything in `$PATH` that has a name `cargo-somethign` can be run as `cargo something` and will be listen when doing `cargo --list`.

There are crates that are actual extensions to `cargo` and then amplify the experience.