# Refutability: Checking whether a Pattern might fail to match

There are two types of patterns:
 - Irrefutable : they always match `let x = 5:`, left matches to right
`for` and `let` will always be irrefutable, because on failure they can't do anything.

 - Refutable : the can not match `let Some(x) = value`, right must match left
`if let` and `while let` should be refutable as they rely on something matching sometimes. Irrefutable patterns are discouraged as the condition is intended to handle failure.

```rust
let Some(x) = Function_returns_option();
// This is invalid, in case this fails, the program does not know what to do, X will be invalid and can't be used elsewehere but it has been declared.

if let Some(x) = Function_returns_option() {
    // use x here
};
// Now it is valid, x is only valid for usage in condition completion

if let x = 5 {
    println!("{}", x);
};
// We use an irrefutable pattern, the condition is always met!
```
