# Object Oriented Programming Features of Rust
Object oriented programming is easy to understand, things are semantically comprised of other things.
Such as a:
Car -> Wheel -> Tire -> Rubber

But this model is bad for runtime efficiency at lower level (you can create a good abstraction like Godot's to make it much better).
Rust is strong in DOP, but can be used in a OOP way.

# Characteristics of Object Oriented Languages
Similar to Functional programming, but not really, see following characteristics and how Rsut supports them.

## Object Contain both Data and Behaviour

Rust has `struct` and `impl` block, together they would form what would be an object that has data and behaviour.

## Hiding Implementation Details - Encapsulation
Only through controlled meanings, should a user could modify the details of an object. For example, through public/private interface. In Rust we use the `pub` keyword on methods, functions and data members.

Ex:
```rust
// Publicly accessible struct, private members
pub struct AveragedCollection {
    list: Vec<i32>,
    average: f64,
}

// Public methods to interface with data
// We want to control how the average goes when values are modified
// Only interface is allowed to play with data
impl AveragedCollection {
    pub fn add(&mut self, value: i32) {
        self.list.push(value);
        self.update_average();
    }

    pub fn remove(&mut self) -> Option<i32> {
        let result = self.list.pop();
        match result {
            Some(value) => {
                self.update_average();
                Some(value)
            }
            None => None,
        }
    }

    pub fn average(&self) -> f64 {
        self.average
    }

    fn update_average(&mut self) {
        let total: i32 = self.list.iter().sum();
        self.average = total as f64 / self.list.len() as f64;
    }
}
```

## Inheritance as a Type System and as Code Sharing
Inheritance in which we can designate a semantic structure to items. An object may relate to another, so instead of rewriting that functionality, it implements it and expands on it.

Rust does not have inheritance. But:
 - Share code using default trait methods -> Implement same Traits!

Polymorphism, we can transform one type to another or use it as the other as long as they have a inheritance relation.
Ex: Components of an Engine -> One object might have a plethora of components, so we want to have a list of `Component` that they themselves can interpret its specific type and act upon them.

### Inheritance is bad
 - It is risky, might share more code than necessary
 - Method repetition on subclasses
 - Single Parent inheritance (on some language) which is restricting

Rust goes into Traits to solve this, which can be freely implemented and specify when the distinct implementation should do some extra work.