## Variables and mutability
Vars are `const` by default, have to add `mut` to make them mutable

## Constants are basically C/C++ macros but only data types
`const MACRO_NAME: data_type =  expression_or_value`
They must be resolved at compile time!
Can't be shadowed as they are constant through all execution time
https://doc.rust-lang.org/reference/const_eval.html

## Variable Shadowing
You can redeclare a variable, changing its data type and mutability
This works like a stack when using scopes, in every scope the value can be shadowed but leaving a shadowed var in a scope will reveal the previous value out of scope.

## Data Types
Rust can infer data type by the functions and context, but most of the time it is essential that we sepcify value types

### Scalar Types - Numbers
Signed values use Twos Complement
 - 1st bit is negative/positive
 - Next bits generate a number
 - Number is summed to 0 if positve or summed to -max from the other bites
 - 001 = positve 0 + 1 = 1
 - 101 - negative 0 = -(11 to decimal + 1) + 01 = -4 + 1 = -3
#### Integer types
i8, i16, i32, i64, i128
u8, u16, u32, u64, u128
##### isize - usize
- Depending on processor / OS architecture, it will be a 32-64 bit value
##### Literals
Decuma, Hex, Octal, Binary, Byte(u8 - ubyte)

#### Overflow
In debug it will `panic!` whic his exit with an error
In release it will just overflow (from max to min, from min to max) looping around.

To explicitly handle the possibility of overflow, you can use these families of methods provided by the standard library for primitive numeric types:

 - Wrap in all modes with the wrapping_* methods, such as wrapping_add
 - Return the None value if there is overflow with the checked_* methods
 - Return the value and a boolean indicating whether there was overflow with the overflowing_* methods
 - Saturate at the value’s minimum or maximum values with saturating_* methods

#### Floating Point Types
f32 , f64 
single and double basically

#### Numeric Operations
Sum, difference, product, quotient, remainer.
Integer operations are floored
https://doc.rust-lang.org/book/appendix-02-operators.html

#### Booleans - bool
#### Character - 'char' - 4byte Unicode Scalar (more than ASCII <3)


### Compound Types
Multiple values in a single type

#### Tuple
Fixed length multi type
`let tup: (i32, f64, u8) = (500, 6.4, 1);`
Tuples will then store the types/vars in subvars like an array (tup.0, tup.1,...);
And can be destructure into multiple vars
`let (x, y, z) = tup;`
But we must make the number of variables it initializes to the number of variables it holds!

#### Array
Fixed length
`let a = [1, 2, 3, 4, 5];`
Can be pre_sized and set the vartype, but those 2 must be done at the same type:
`let a: [type;size] = [1,2,3,4,5];`
Or initialize a number of spaces to a value
`let a = [init_value; size];`

## Functions
```
fn function_name_snake_case(varname: data_type, other_var: data_type) {
    // do things
}
```

### Statements
Do not return a value -> `let x = "caca"` -> is evaluating and puting value to x but does not return anything

### Expressions
Do return a value
`let x = 3 + 4;` -> `3+4` is an expression
Calling functions, macros,... are basically expressions as they do return a value
```
fn main() {
    let y = {
        let x = 3;
        x + 1
    };
    // Inside the {} it is a returning expression that initializes y, and x is left locally

    println!("The value of y is: {}", y); // Is an expression that may return an error value or do something
    // The ; will mean an expression ends and the value has already been used and not returned any further
}
```

#### Function Return Value
`fn function() -> data_type { expression_var_or_something }`
The last line without `;` will be an expression that evaluates to the return `data_type` sepcified after `->`

```
fn five() -> i32 {
    5
}

fn main() {
    let x = five();

    println!("The value of x is: {}", x);
}
```

If the last line of a function with a specified return type, has a `;` then it will cause a compile error as it is implicitly returning a `()` emtpy value that can't be used for the specified return type.

## Control flow

### If - Else

Same as C/C++, but condition **MUST** be a `bool`
We can't check with random types, existance and such.
`()` are not necessary but are needed to display conditional checking order like in arithmetic

IfElse can be used in other statements, as it then executes an {expression} than can return a value.
`let x = if 10 < 0 {5} else {6};`
But the data_types of the resulting expressions **MUST** match (priority in the first block)

### Loops

#### loop
directly loop forever, can on be exited with error, crash, panic or `break`

`continue` -> skip the rest of the code until the `}` and start a new iteration on the existing loop

We can label loops, then accordingly lable the `continue` and `break` to specify the action in every loop.
```rust
'loopname1: loop {
    'loopname2: loop{
        if a == 0 {
            break; // breaks the most inner loop, does not regard labels
        }
        else {
            break 'loopname1; // breaks the first loop as it is specifically telling it
        }
    }
}
```

You can also set a return value to the break
```rust
break `loopname {expression};
break expression; // if not specifying a loopname
```

#### while
`while (condition) {}`
same as a C/C++ while, still can implement `continue` and `break` inside shown previously


#### for
`for element in collection {}`
This default iterates over every element of the collection

`for number in (1..4).rev() {}`
This executes a for 4 times, using number as a variable index
As we use `.rev()` in the range, we reverse the order so
It will be: `4,3,2,1` for number in each subsequent iteration
This is a controlled way of doing 4 iterations and having the index

### RANGES
we define a range by `x...y` where `y > x`
This can be used to iterate by a number range as seen previously, but also for other things seen later. in `Slices`