# STRUCTS
Similar to `Tuple` get multiple data types in a single "variable". More like defining a new variable type.

``` rust
// Form
struct DataType_Name {
    variable_name: data_type,
    //...
}
// Ex:
struct User {
    active: bool,
    username: String,
    email: String,
    sign_in_count: u64,
}

// Initialization
let var = User {
    email: String::from("someone@example.com"),
    username: String::from("someusername123"),
    active: true,
    sign_in_count: 1,
};

```
As seen, each member/data inside a struct is a KVP (Key-Value Pair), so you can initialize it not sequentially. 

To get things from a struct `var.value`  in dot notation.

All structs are mutable by default.
You can initialize a variable without having to reference the key, if the variable name is the same as the key
``` rust
let email = "someone@example.com";
let var = User {
    email,
};
// Initialize email with var email

fn build_user(email: String, username: String) -> User {
    User {
        email,
        username,
        active: true,
        sign_in_count: 1,
    }
}
```
### Instances with Struct Update Syntax
You can move other vars of the same struct_type and just initialize the ones you need to generate a new one.

``` rust
// This one copies it
let user2 = User {
    active: user1.active,
    username: user1.username,
    email: String::from("another@example.com"),
    sign_in_count: user1.sign_in_count,
};

// This one uses Struct Update Syntax, it moves ownership of the fields to user2
 let user2 = User {
    email: String::from("another@example.com"),
    ..user1 // ..other var to just grab the same fields from the other var
};
```
In the 2nd, we are generating an instanc with the same values except email, but we lose validity to `user1` becuse that uses `move` syntax.

This happens on types that do not implement `Copy` trait, so they are `Move`d form variable to variable. `active` and `sign_in_count` are `Copy` trait vars, so they are copied and will remain valid.

## TUPLE Structs
Structs similar to tuples, basically a struct with no associated keys.
```rust
struct ColorRGB(i32, i32, i32);
struct Point(i32, i32, i32);

let black = ColorRGB(0,0,0);
// println!("{}", black.1);
let origin = Point(0,0,0);

println!("{} {}", black.0, origin.0);
```

## UNIT Structs
`struct AlwaysEqual;`
This basically accomplishes the task of doing nothing, but can be done.
basically we can have it equal to a type that holds nothing, but can have different traits -> later on.

## Lifetimes
Instead of using a `&str` it was used a `String`, so that ownership is completely moved from one to other. But we would rather have references to objects instead of messing up with ownership.

Later on, the lifetimes are explained, just know that for a struct to have a valid access or ownerhip of references, they have to specify until which moment the ownership of that reference will be valid.

# Using derivates
Structs can implement other struct, types and traits.
In the latter case, we use
```rust
#[derive(Trait)]
struct StructName{}
```
This will make the struct acquire the trait.
Ex:
```rust
struct st1{}

#[derive(Debug)]
struct st2{}

...
println!("{:?} {:?}", st1, st2;)
...
```
1st, `:?` means to use a set format for the type, which must be a trait.
`st1` will not print, as it is not marked with a format to print
`st2` derives the `Debug` trait to make it be able to print in a Debug style when formatted.
```rust
// Example log from a formatted type
Rectangle { width: 30, height: 50 }
```

`:#?` is similar to `:?` but prettier (better spaced and more readble)

```rust
rect1 is Rectangle {
    width: 30,
    height: 50,
}
```

To print `Debug` information, we can also use `dbg!(&var);` which is more direct. It also return ownership of what is being passed, so if you can debug the result of an expression and set it somewhere.
```rust
    let scale = 2;
    let rect1 = Rectangle {
        width: dbg!(30 * scale),
        height: 50,
    };

    dbg!(&rect1);

//---
[src/main.rs:10] 30 * scale = 60
[src/main.rs:14] &rect1 = Rectangle {
    width: 60,
    height: 50,
}
```

There are many more derivable traits like and very different from `Debug`
https://doc.rust-lang.org/book/appendix-03-derivable-traits.html

 More attributes to use other than `derive` 
https://doc.rust-lang.org/reference/attributes.html

---

# Method Syntax

Struct automatically implement a type called `self`, which basically is used to pass its own information to their methods (like in C/C++ with `this`).

To define methods to implement we have to create an implementation zone:
```rust
impl Rectangle {
    fn area(&self) -> u32 {
        self.width * self.height
    }
}
```
Inside this implementation we can declare functions that use self to make them be methods usable by the type. Instead of `&Rectangle` we just reference itself so that no info has to be passed down, it uses its own data.

This borrows the `self` mutably or immutably, like any other functions, so now that has the ownership of the variable.

## Multiple parameters
Like a function, add parameters to the method after `&self`/`&mut self`(if we want to modify self in the method).
```rust
fn can_hold(&self, cmp: &Rectangle) -> bool {
        (self.width > cmp.width && self.height > cmp.width) 
        || (self.width > cmp.height && self.height > cmp.width)
    }
```

## Associated Functions
Basically not use `self`, would be like a `static` function in a C++ Class, or a functor in a C `struct`.
Then to call them we use the `StructType::function()` syntax instead.

## Separate implementation blocks
You don't have to write all the implemented methods and functions in a single `impl` block. You can separate them!