use std::fmt;

pub enum HyperBoolean {
    HyperTrue,
    True,
    Neutral,
    False,
    HyperFalse,
}

impl fmt::Debug for HyperBoolean {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self {
            HyperBoolean::HyperTrue => write!(f, "HyperTrue"),
            HyperBoolean::True => write!(f, "True"),
            HyperBoolean::Neutral => write!(f, "Neutral"),
            HyperBoolean::False => write!(f, "False"),
            HyperBoolean::HyperFalse => write!(f, "HyperFalse"),
        }
    }
}

impl PartialEq for HyperBoolean {
    fn eq(&self, other: &Self) -> bool {
        let x = match self {
            HyperBoolean::HyperTrue => 0,
            HyperBoolean::True => 1,
            HyperBoolean::Neutral => 2,
            HyperBoolean::False => 3,
            HyperBoolean::HyperFalse => 4,
        };

        return match other {
            HyperBoolean::HyperTrue => 0 == x,
            HyperBoolean::True => 1 == x,
            HyperBoolean::Neutral =>  2 == x,
            HyperBoolean::False => 3 == x,
            HyperBoolean::HyperFalse => 4 == x,
        };
    }
}