use super::component::LoggerComponent;
use crate::core::logger::message::Message;

use std::fs::{create_dir, File, OpenOptions};
use std::io::{Error, Write};
use std::path::Path;

pub struct FileComponent {
    file: File,
}

impl FileComponent {
    pub fn new(log_file_name: &str) -> Self {
        if !Path::new("./log/").exists() {
            if let Err(error) = create_dir(Path::new("./log/")) {
                panic!(
                    "Failed to create directory for logger files output with error: {}",
                    error
                );
            }
        }

        FileComponent {
            file: match OpenOptions::new()
                .create(true)
                .append(true)
                .open(Path::new(format!("./log/{}.log", log_file_name).as_str()))
            {
                Ok(value) => value,
                Err(error) => {
                    panic!("Failed to open logger file due to error: {}", error);
                }
            },
        }
    }
}

impl LoggerComponent for FileComponent {
    fn log(&mut self, msg: &Message) -> Result<(), Error> {
        match self.file.write(msg.to_string().as_bytes()) {
            Ok(_) => Ok(()),
            Err(error) => Err(error),
        }
    }
}
