use super::component::LoggerComponent;
use crate::core::logger::message::Message;
use std::io::Error;

pub struct ConsoleComponent {}

impl ConsoleComponent {
    pub fn new() -> Self {
        ConsoleComponent {}
    }
}

impl LoggerComponent for ConsoleComponent {
    fn log(&mut self, msg: &Message) -> Result<(), Error> {
        println!("{}", msg.to_string());
        Ok(())
    }
}
