use super::component::LoggerComponent;
use super::message::Message;
use std::cell::{RefCell};
use std::collections::LinkedList;
use std::io::{Error, ErrorKind};
use std::rc::Rc;

pub struct Logger {
    components: LinkedList<Rc<RefCell<dyn LoggerComponent>>>,
}

impl Logger {
    pub fn new() -> Self {
        Logger {
            components: LinkedList::new(),
        }
    }

    pub fn add_component(&mut self, component: Rc<RefCell<dyn LoggerComponent>>) {
        self.components.push_back(component);
    }
}

impl LoggerComponent for Logger {
    fn log(&mut self, msg: &Message) -> Result<(), Error> {
        for component in &self.components {
            if let Err(error) = component.borrow_mut().log(msg) {
                return Err(error);
            }
        }
        Ok(())
    }
}
