use super::component::LoggerComponent;
use std::io::Error;
use crate::core::logger::message::Message;

pub struct ConsoleComponent {}

impl ConsoleComponent {
    pub fn new() -> Self {
        ConsoleComponent {}
    }
}

impl LoggerComponent for ConsoleComponent {
    fn log(&mut self, msg: &Message) -> Result<(), Error> {
        println!("{}", msg.to_string());
        Ok(())
    }
}
