use chrono::{Local};

pub enum MessageType {
    CLIENT,
    DEBUG,
    ENGINE
}

impl ToString for MessageType {
    fn to_string(&self) -> String {
        match self {
            MessageType::CLIENT => {String::from("CLIENT: ")}
            MessageType::DEBUG => {String::from("DEBUG: ")}
            MessageType::ENGINE => {String::from("ENGINE: ")}
        }
    }
}

pub enum MessageSeverity {
    TRACE,
    WARN,
    ERROR(String) // MessageTypeData is the debug string from the error produced
}

impl ToString for MessageSeverity {
    fn to_string(&self) -> String {
        match self {
            MessageSeverity::TRACE => {String::from("TRACE: ")}
            MessageSeverity::WARN => {String::from("WARN: ")}
            MessageSeverity::ERROR(_) => {String::from("ERROR: ")}
        }
    }
}

pub struct Message {
    mtype: MessageType,
    mseverity: MessageSeverity,
    mdata: String
}

impl ToString for Message {
    fn to_string(&self) -> String {
        let mut sbuilder = String::new();

        let now = Local::now();
        sbuilder.push_str(now.to_string().as_str());
        sbuilder.push('\n');

        sbuilder.push_str(self.mtype.to_string().as_str());
        sbuilder.push_str(self.mseverity.to_string().as_str());
        sbuilder.push_str(self.mdata.as_str());
        sbuilder.push('\n');
        if let MessageSeverity::ERROR(error) = &self.mseverity {
            sbuilder.push_str(error.as_str());
            sbuilder.push('\n');
        }

        sbuilder
    }
}