use super::component::LoggerComponent;

use std::fs::{File, OpenOptions};
use std::io::{Error, Write};
use std::path::Path;

pub struct FileComponent {
    file: File,
}

impl FileComponent {
    pub fn new(log_file_name: &str) -> Self {
        FileComponent {
            file: match OpenOptions::new().create(true).append(true).open(Path::new(log_file_name)) {
                Ok(value) => value,
                Err(error) => {
                    panic!("Failed to open logger file due to error: {}", error);
                }
            },
        }
    }
}

impl LoggerComponent for FileComponent {
    fn log(&mut self, msg: &str) -> Result<(), Error> {
        match self.file.write(msg.as_bytes()) {
            Ok(_) => Ok(()),
            Err(error) => Err(error),
        }
    }
}
