//
// A rust binding for the GSL library by Guillaume Gomez (guillaume1.gomez@gmail.com)
//

/// This function computes the probability density p(x) at x for a uniform distribution from a to b, using the formula given above.
#[doc(alias = "gsl_ran_flat_pdf")]
pub fn flat_pdf(x: f64, a: f64, b: f64) -> f64 {
    unsafe { sys::gsl_ran_flat_pdf(x, a, b) }
}

/// This function computes the cumulative distribution functions P(x), Q(x) and their inverses for a uniform distribution from a to b.
#[doc(alias = "gsl_cdf_flat_P")]
pub fn flat_P(x: f64, a: f64, b: f64) -> f64 {
    unsafe { sys::gsl_cdf_flat_P(x, a, b) }
}

/// This function computes the cumulative distribution functions P(x), Q(x) and their inverses for a uniform distribution from a to b.
#[doc(alias = "gsl_cdf_flat_Q")]
pub fn flat_Q(x: f64, a: f64, b: f64) -> f64 {
    unsafe { sys::gsl_cdf_flat_Q(x, a, b) }
}

/// This function computes the cumulative distribution functions P(x), Q(x) and their inverses for a uniform distribution from a to b.
#[doc(alias = "gsl_cdf_flat_Pinv")]
pub fn flat_Pinv(P: f64, a: f64, b: f64) -> f64 {
    unsafe { sys::gsl_cdf_flat_Pinv(P, a, b) }
}

/// This function computes the cumulative distribution functions P(x), Q(x) and their inverses for a uniform distribution from a to b.
#[doc(alias = "gsl_cdf_flat_Qinv")]
pub fn flat_Qinv(Q: f64, a: f64, b: f64) -> f64 {
    unsafe { sys::gsl_cdf_flat_Qinv(Q, a, b) }
}
