use CanaryValidationLib::*;

#[test]
fn simple_email(){
    assert!(CanaryValidateOtherAPI::email_address_simple("test@domain.com"));
    assert!(CanaryValidateOtherAPI::email_address_simple("lastname@domain.com"));
    assert!(CanaryValidateOtherAPI::email_address_simple("test.email.with+symbol@domain.com"));
    assert!(CanaryValidateOtherAPI::email_address_simple("id-with-dash@domain.com"));
    assert!(CanaryValidateOtherAPI::email_address_simple("a@domain.com"));
    assert!(CanaryValidateOtherAPI::email_address_simple("example-abc@abc-domain.com"));
    assert!(CanaryValidateOtherAPI::email_address_simple("admin@mailserver1"));
    assert!(CanaryValidateOtherAPI::email_address_simple("example@localhost"));
    assert!(CanaryValidateOtherAPI::email_address_simple("example@s.solutions"));
    assert!(CanaryValidateOtherAPI::email_address_simple("test@localserver"));
    assert!(CanaryValidateOtherAPI::email_address_simple("test@[IPv6:2018:db8::1]"));
    assert!(CanaryValidateOtherAPI::email_address_simple("test@domain.com"));
    assert!(CanaryValidateOtherAPI::email_address_simple("test@domain.com"));
}

#[test]
fn invalid_email(){
    assert_eq!(CanaryValidateOtherAPI::email_address_simple("example.com"),false);
}

#[test]
fn valid_phone_numbers(){
    assert!(CanaryValidateOtherAPI::phone_number("123-456-7890"));
    assert!(CanaryValidateOtherAPI::phone_number("(123) 456-7890"));
    assert!(CanaryValidateOtherAPI::phone_number("123 456 7890"));
    assert!(CanaryValidateOtherAPI::phone_number("123.456.7890"));
    assert!(CanaryValidateOtherAPI::phone_number("+91 (123) 456-7890"));
    
    // ALL INVALID
    //assert!(CanaryValidateOtherAPI::phone_number("1-212-456-7890"));
    //assert!(CanaryValidateOtherAPI::phone_number("+212-456-7890"));
    //assert!(CanaryValidateOtherAPI::phone_number("+12124567890"));
    //assert!(CanaryValidateOtherAPI::phone_number("(212)456-7890"));
    //assert!(CanaryValidateOtherAPI::phone_number("2124567890"));


}