use super::*;

// noinspection DuplicatedCode
impl LevelUpCostDB {
    #[inline]
    fn map_exp() -> Self {
        Self {
            stage0: vec![
                100, 117, 134, 151, 168, 185, 202, 219, 236, 253, 270, 287, 304, 321, 338, 355, 372, 389, 406, 423, 440, 457,
                474, 491, 508, 525, 542, 559, 574, 589, 605, 621, 637, 653, 669, 685, 701, 716, 724, 739, 749, 759, 770, 783,
                804, 820, 836, 852, 888,
            ],
            elite1: 0,
            stage1: vec![
                120, 172, 224, 276, 328, 380, 432, 484, 536, 588, 640, 692, 744, 796, 848, 900, 952, 1004, 1056, 1108, 1160,
                1212, 1264, 1316, 1368, 1420, 1472, 1524, 1576, 1628, 1706, 1784, 1862, 1940, 2018, 2096, 2174, 2252, 2330,
                2408, 2584, 2760, 2936, 3112, 3288, 3464, 3640, 3816, 3992, 4168, 4344, 4520, 4696, 4890, 5326, 6019, 6312,
                6505, 6838, 7391, 7657, 7823, 8089, 8355, 8621, 8887, 9153, 9419, 9605, 9951, 10448, 10945, 11442, 11939,
                12436, 12933, 13430, 13927, 14549,
            ],
            elite2: 0,
            stage2: vec![
                191, 303, 415, 527, 639, 751, 863, 975, 1087, 1199, 1311, 1423, 1535, 1647, 1759, 1871, 1983, 2095, 2207, 2319,
                2431, 2543, 2655, 2767, 2879, 2991, 3103, 3215, 3327, 3439, 3602, 3765, 3928, 4091, 4254, 4417, 4580, 4743,
                4906, 5069, 5232, 5395, 5558, 5721, 5884, 6047, 6210, 6373, 6536, 6699, 6902, 7105, 7308, 7511, 7714, 7917,
                8120, 8323, 8526, 8729, 9163, 9597, 10031, 10465, 10899, 11333, 11767, 12201, 12729, 13069, 13747, 14425,
                15103, 15781, 16459, 17137, 17815, 18493, 19171, 19849, 21105, 22361, 23617, 24873, 26129, 27385, 28641, 29897,
                31143,
            ],
        }
    }
    #[inline]
    fn map_cash() -> Self {
        Self {
            stage0: vec![
                30, 36, 43, 50, 57, 65, 73, 81, 90, 99, 108, 118, 128, 138, 149, 160, 182, 206, 231, 258, 286, 315, 346, 378,
                411, 446, 482, 520, 557, 595, 635, 677, 720, 764, 809, 856, 904, 952, 992, 1042, 1086, 1131, 1178, 1229, 1294,
                1353, 1413, 1474, 1572,
            ],
            elite1: 0,
            stage1: vec![
                48, 71, 95, 120, 146, 173, 201, 231, 262, 293, 326, 361, 396, 432, 470, 508, 548, 589, 631, 675, 719, 765, 811,
                859, 908, 958, 1010, 1062, 1116, 1171, 1245, 1322, 1400, 1480, 1562, 1645, 1731, 1817, 1906, 1996, 2171, 2349,
                2531, 2717, 2907, 3100, 3298, 3499, 3705, 3914, 4127, 4344, 4565, 4807, 5294, 6049, 6413, 6681, 7098, 7753,
                8116, 8378, 8752, 9132, 9518, 9909, 10306, 10709, 11027, 11533, 12224, 12926, 13639, 14363, 15097, 15843,
                16599, 17367, 18303,
            ],
            elite2: 0,
            stage2: vec![
                76, 124, 173, 225, 279, 334, 392, 451, 513, 577, 642, 710, 780, 851, 925, 1001, 1079, 1159, 1240, 1324, 1410,
                1498, 1588, 1680, 1773, 1869, 1967, 2067, 2169, 2273, 2413, 2556, 2702, 2851, 3003, 3158, 3316, 3477, 3640,
                3807, 3976, 4149, 4324, 4502, 4684, 4868, 5055, 5245, 5438, 5634, 5867, 6103, 6343, 6587, 6835, 7086, 7340,
                7599, 7861, 8127, 8613, 9108, 9610, 10120, 10637, 11163, 11696, 12238, 12882, 13343, 14159, 14988, 15828,
                16681, 17545, 18422, 19311, 20213, 21126, 22092, 23722, 25380, 27065, 28778, 30519, 32287, 34083, 35906, 37745,
            ],
        }
    }

    /// 升级 1 星干员所需要的经验值
    pub fn star1_exp() -> Self {
        let map = Self::map_exp();
        Self {
            stage0: map.stage0.into_iter().take(29).collect(),
            stage1: map.stage1.into_iter().take(0).collect(),
            stage2: map.stage2.into_iter().take(0).collect(),
            elite1: 0,
            elite2: 0,
        }
    }

    /// 升级 1 星干员所需要的龙门币
    pub fn star1_cash() -> Self {
        let map = Self::map_cash();
        Self {
            stage0: map.stage0.into_iter().take(29).collect(),
            stage1: map.stage1.into_iter().take(0).collect(),
            stage2: map.stage2.into_iter().take(0).collect(),
            elite1: 0,
            elite2: 0,
        }
    }

    /// 升级 1 星干员所需要的经验值
    pub fn star2_exp() -> Self {
        let map = Self::map_exp();
        Self {
            stage0: map.stage0.into_iter().take(29).collect(),
            stage1: map.stage1.into_iter().take(0).collect(),
            stage2: map.stage2.into_iter().take(0).collect(),
            elite1: 0,
            elite2: 0,
        }
    }

    /// 升级 2 星干员所需要的龙门币
    pub fn star2_cash() -> Self {
        let map = Self::map_cash();
        Self {
            stage0: map.stage0.into_iter().take(29).collect(),
            stage1: map.stage1.into_iter().take(0).collect(),
            stage2: map.stage2.into_iter().take(0).collect(),
            elite1: 0,
            elite2: 0,
        }
    }

    /// 升级 1 星干员所需要的经验值
    pub fn star3_exp() -> Self {
        let map = Self::map_exp();
        Self {
            stage0: map.stage0.into_iter().take(39).collect(),
            stage1: map.stage1.into_iter().take(54).collect(),
            stage2: map.stage2.into_iter().take(0).collect(),
            elite1: 0,
            elite2: 0,
        }
    }

    /// 升级 3 星干员所需要的龙门币
    pub fn star3_cash() -> Self {
        let map = Self::map_cash();
        Self {
            stage0: map.stage0.into_iter().take(39).collect(),
            stage1: map.stage1.into_iter().take(54).collect(),
            stage2: map.stage2.into_iter().take(0).collect(),
            elite1: 10000,
            elite2: 0,
        }
    }

    /// 升级 1 星干员所需要的经验值
    pub fn star4_exp() -> Self {
        let map = Self::map_exp();
        Self {
            stage0: map.stage0.into_iter().take(44).collect(),
            stage1: map.stage1.into_iter().take(59).collect(),
            stage2: map.stage2.into_iter().take(69).collect(),
            elite1: 0,
            elite2: 0,
        }
    }

    /// 升级 4 星干员所需要的龙门币
    pub fn star4_cash() -> Self {
        let map = Self::map_cash();
        Self {
            stage0: map.stage0.into_iter().take(44).collect(),
            stage1: map.stage1.into_iter().take(59).collect(),
            stage2: map.stage2.into_iter().take(69).collect(),
            elite1: 15000,
            elite2: 60000,
        }
    }

    /// 升级 1 星干员所需要的经验值
    pub fn star5_exp() -> Self {
        let map = Self::map_exp();
        Self {
            stage0: map.stage0.into_iter().take(49).collect(),
            stage1: map.stage1.into_iter().take(69).collect(),
            stage2: map.stage2.into_iter().take(79).collect(),
            elite1: 0,
            elite2: 0,
        }
    }

    /// 升级 5 星干员所需要的龙门币
    pub fn star5_cash() -> Self {
        let map = Self::map_cash();
        Self {
            stage0: map.stage0.into_iter().take(49).collect(),
            stage1: map.stage1.into_iter().take(69).collect(),
            stage2: map.stage2.into_iter().take(79).collect(),
            elite1: 20000,
            elite2: 120000,
        }
    }

    /// 升级 1 星干员所需要的经验值
    pub fn star6_exp() -> Self {
        let map = Self::map_exp();
        Self {
            stage0: map.stage0.into_iter().take(49).collect(),
            stage1: map.stage1.into_iter().take(79).collect(),
            stage2: map.stage2.into_iter().take(89).collect(),
            elite1: 0,
            elite2: 0,
        }
    }

    /// 升级 6 星干员所需要的龙门币
    pub fn star6_cash() -> Self {
        let map = Self::map_cash();
        Self {
            stage0: map.stage0.into_iter().take(49).collect(),
            stage1: map.stage1.into_iter().take(79).collect(),
            stage2: map.stage2.into_iter().take(89).collect(),
            elite1: 30000,
            elite2: 180000,
        }
    }
}
