## ----style, echo = FALSE, results = 'asis'------------------------------------
BiocStyle::markdown()
options(width=80, max.print=1000)
knitr::opts_chunk$set(
    eval=as.logical(Sys.getenv("KNITR_EVAL", "TRUE")),
    cache=as.logical(Sys.getenv("KNITR_CACHE", "TRUE")), 
    tidy.opts=list(width.cutoff=80), tidy=TRUE)

## ----setup, echo=FALSE, messages=FALSE, warnings=FALSE------------------------
suppressPackageStartupMessages({
    library(systemPipeR)
})

## ----dir, eval=TRUE, echo=FALSE, out.width="100%", fig.align = "center", fig.cap= "*systemPipeR's* preconfigured directory structure."----
knitr::include_graphics(system.file("extdata/images", "spr_project.png", package = "systemPipeR"))  

## ----genRna_workflow_single, eval=FALSE---------------------------------------
#  library(systemPipeRdata)
#  genWorkenvir(workflow="rnaseq")
#  setwd("rnaseq")

## ----project_rnaseq, eval=FALSE-----------------------------------------------
#  sal <- SPRproject()
#  sal <- importWF(sal, file_path = "systemPipeRNAseq.Rmd", verbose = FALSE)

## ----run_rnaseq, eval=FALSE---------------------------------------------------
#  sal <- runWF(sal)

## ----plot_rnaseq, eval=FALSE--------------------------------------------------
#  plotWF(sal)

## ----report_rnaseq, eval=FALSE------------------------------------------------
#  sal <- renderReport(sal)
#  sal <- renderLogs(sal)

## ----genChip_workflow, eval=FALSE---------------------------------------------
#  library(systemPipeRdata)
#  genWorkenvir(workflow="chipseq")
#  setwd("chipseq")

## ----project_chipseq, eval=FALSE----------------------------------------------
#  sal <- SPRproject()
#  sal <- importWF(sal, file_path = "systemPipeChIPseq.Rmd", verbose = FALSE)

## ----run_chipseq, eval=FALSE--------------------------------------------------
#  sal <- runWF(sal)

## ----plot_chipseq, eval=FALSE-------------------------------------------------
#  plotWF(sal)

## ----report_chipseq, eval=FALSE-----------------------------------------------
#  sal <- renderReport(sal)
#  sal <- renderLogs(sal)

## ----genVar_workflow_single, eval=FALSE---------------------------------------
#  library(systemPipeRdata)
#  genWorkenvir(workflow="varseq")
#  setwd("varseq")

## ----project_varseq, eval=FALSE-----------------------------------------------
#  sal <- SPRproject()
#  sal <- importWF(sal, file_path = "systemPipeVARseq.Rmd", verbose = FALSE)

## ----run_varseq, eval=FALSE---------------------------------------------------
#  sal <- runWF(sal)

## ----plot_varseq, eval=FALSE--------------------------------------------------
#  plotWF(sal)

## ----report_varseq, eval=FALSE------------------------------------------------
#  sal <- renderReport(sal)
#  sal <- renderLogs(sal)

## ----genRibo_workflow_single, eval=FALSE--------------------------------------
#  library(systemPipeRdata)
#  genWorkenvir(workflow="riboseq")
#  setwd("riboseq")

## ----project_riboseq, eval=FALSE----------------------------------------------
#  sal <- SPRproject()
#  sal <- importWF(sal, file_path = "systemPipeRIBOseq.Rmd", verbose = FALSE)

## ----run_riboseq, eval=FALSE--------------------------------------------------
#  sal <- runWF(sal)

## ----plot_riboseq, eval=FALSE-------------------------------------------------
#  plotWF(sal)

## ----report_riboseq, eval=FALSE-----------------------------------------------
#  sal <- renderReport(sal)
#  sal <- renderLogs(sal)

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

