/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.hmm.scoring;

import edu.msu.cme.rdp.alignment.hmm.ProfileHMM;
import edu.msu.cme.rdp.alignment.hmm.TSC;
import edu.msu.cme.rdp.alignment.hmm.XSC;
import edu.msu.cme.rdp.alignment.hmm.XSTATES;
import edu.msu.cme.rdp.alignment.hmm.scoring.HMMScorer;

public class ForwardScorer
extends HMMScorer {
    private static final double[] logsumLookup = new double[16000];

    private static final double logsum(double a, double b) {
        double max = StrictMath.max(a, b);
        double min = StrictMath.min(a, b);
        if (min == Double.NEGATIVE_INFINITY) {
            return max;
        }
        return max + StrictMath.log(1.0 + StrictMath.exp(min - max));
    }

    public ForwardScorer(ProfileHMM hmm) {
        this(hmm, -1);
    }

    public ForwardScorer(ProfileHMM hmm, int startingState) {
        super(hmm, startingState);
    }

    protected final void initializeSM() {
        for (int k = 0; k <= this.hmm.M(); ++k) {
            if (k == this.startingState || this.startingState == -1) {
                this.mmx(0, k, 0.0);
                this.imx(0, k, 0.0);
                this.dmx(0, k, 0.0);
                continue;
            }
            this.mmx(0, k, Double.NEGATIVE_INFINITY);
            this.imx(0, k, Double.NEGATIVE_INFINITY);
            this.dmx(0, k, Double.NEGATIVE_INFINITY);
        }
        this.xmx(0, XSTATES.N, 0.0);
        this.xmx(0, XSTATES.B, this.hmm.xsc(XSTATES.N, XSC.MOVE));
        this.xmx(0, XSTATES.E, Double.NEGATIVE_INFINITY);
        this.xmx(0, XSTATES.C, Double.NEGATIVE_INFINITY);
        this.xmx(0, XSTATES.J, Double.NEGATIVE_INFINITY);
    }

    public final void consume(char b) {
        double sc;
        this.extend();
        this.mmx(this.i, 0, Double.NEGATIVE_INFINITY);
        this.imx(this.i, 0, Double.NEGATIVE_INFINITY);
        this.dmx(this.i, 0, Double.NEGATIVE_INFINITY);
        this.xmx(this.i, XSTATES.E, Double.NEGATIVE_INFINITY);
        double lastMaxScore = this.i == 0 ? Double.NEGATIVE_INFINITY : (Double)this.maxScores.get(this.i - 1);
        for (int k = 1; k < this.hmm.M(); ++k) {
            sc = ForwardScorer.logsum(ForwardScorer.logsum(this.mmx(this.i - 1, k - 1) + this.hmm.tsc(k - 1, TSC.MM), this.imx(this.i - 1, k - 1) + this.hmm.tsc(k - 1, TSC.IM)), this.dmx(this.i - 1, k - 1) + this.hmm.tsc(k - 1, TSC.DM));
            this.mmx(this.i, k, sc + this.hmm.msc(k, b));
            sc = ForwardScorer.logsum(this.mmx(this.i - 1, k) + this.hmm.tsc(k, TSC.MI), this.imx(this.i - 1, k) + this.hmm.tsc(k, TSC.II));
            this.imx(this.i, k, sc + this.hmm.isc(k, b));
            sc = ForwardScorer.logsum(this.mmx(this.i, k - 1) + this.hmm.tsc(k - 1, TSC.MD), this.dmx(this.i, k - 1) + this.hmm.tsc(k - 1, TSC.DD));
            this.dmx(this.i, k, sc);
            lastMaxScore = StrictMath.max(StrictMath.max(this.mmx(this.i, k), this.dmx(this.i, k)), lastMaxScore);
        }
        sc = ForwardScorer.logsum(ForwardScorer.logsum(this.mmx(this.i - 1, this.hmm.M() - 1) + this.hmm.tsc(this.hmm.M() - 1, TSC.MM), this.imx(this.i - 1, this.hmm.M() - 1) + this.hmm.tsc(this.hmm.M() - 1, TSC.IM)), this.dmx(this.i - 1, this.hmm.M() - 1) + this.hmm.tsc(this.hmm.M() - 1, TSC.DM));
        this.mmx(this.i, this.hmm.M(), sc + this.hmm.msc(this.hmm.M(), b));
        this.imx(this.i, this.hmm.M(), Double.NEGATIVE_INFINITY);
        sc = ForwardScorer.logsum(this.mmx(this.i, this.hmm.M() - 1) + this.hmm.tsc(this.hmm.M() - 1, TSC.MD), this.dmx(this.i, this.hmm.M() - 1) + this.hmm.tsc(this.hmm.M() - 1, TSC.DD));
        this.dmx(this.i, this.hmm.M(), sc);
        lastMaxScore = StrictMath.max(StrictMath.max(this.mmx(this.i, this.hmm.M()), this.dmx(this.i, this.hmm.M())), lastMaxScore);
        this.maxScores.add(lastMaxScore);
        sc = StrictMath.max(this.xmx(this.i, XSTATES.E), this.mmx(this.i, this.hmm.M()));
        this.xmx(this.i, XSTATES.E, StrictMath.max(sc, this.dmx(this.i, this.hmm.M())));
        sc = this.xmx(this.i - 1, XSTATES.J) + this.hmm.xsc(XSTATES.J, XSC.LOOP);
        this.xmx(this.i, XSTATES.J, StrictMath.max(sc, this.xmx(this.i, XSTATES.E) + this.hmm.xsc(XSTATES.E, XSC.LOOP)));
        sc = this.xmx(this.i - 1, XSTATES.C) + this.hmm.xsc(XSTATES.C, XSC.LOOP);
        this.xmx(this.i, XSTATES.C, StrictMath.max(sc, this.xmx(this.i, XSTATES.E) + this.hmm.xsc(XSTATES.E, XSC.MOVE)));
        this.xmx(this.i, XSTATES.N, this.xmx(this.i - 1, XSTATES.N) + this.hmm.xsc(XSTATES.N, XSC.LOOP));
        sc = this.xmx(this.i, XSTATES.N) + this.hmm.xsc(XSTATES.N, XSC.MOVE);
        this.xmx(this.i, XSTATES.B, StrictMath.max(sc, this.xmx(this.i, XSTATES.J) + this.hmm.xsc(XSTATES.J, XSC.MOVE)));
    }

    static {
        for (int i = 0; i < 16000; ++i) {
            ForwardScorer.logsumLookup[i] = StrictMath.log(1.0 + StrictMath.exp((double)i / 1000.0));
        }
    }
}

