/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree;

import edu.msu.cme.rdp.taxatree.Node;
import edu.msu.cme.rdp.taxatree.Taxon;
import edu.msu.cme.rdp.taxatree.VisitInfo;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonHolder<E extends Node> {
    private final E taxon;
    private TaxonHolder<E> parent;
    private List<TaxonHolder<E>> children = new ArrayList<TaxonHolder<E>>();

    public TaxonHolder(E taxon) {
        this.taxon = taxon;
    }

    TaxonHolder(E taxon, TaxonHolder<E> parent) {
        this.taxon = taxon;
        this.parent = parent;
    }

    public E getTaxon() {
        return this.taxon;
    }

    public void addChild(E child, int parentId) {
        TaxonHolder<E> parentHolder = this.getChild(parentId);
        if (parentHolder != null) {
            TaxonHolder<E> childHolder = new TaxonHolder<E>(child, parentHolder);
            parentHolder.addChild(childHolder);
        }
    }

    public Collection<E> getChildren() {
        ArrayList<E> ret = new ArrayList<E>();
        for (TaxonHolder<E> child : this.children) {
            ret.add(child.getTaxon());
        }
        return ret;
    }

    public List<TaxonHolder<E>> getChildHolders() {
        return Collections.unmodifiableList(this.children);
    }

    public E getChildTaxon(int idToFind) {
        TaxonHolder<E> result = this.getChild(idToFind);
        if (result == null) {
            return null;
        }
        return result.getTaxon();
    }

    public TaxonHolder<E> getImediateChildTaxon(String name) {
        for (TaxonHolder<E> child : this.children) {
            if (!((Taxon)child.getTaxon()).getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public TaxonHolder<E> getChild(int idToFind) {
        return this.findSubNode(idToFind);
    }

    void setParent(TaxonHolder<E> parent) {
        this.parent = parent;
    }

    public TaxonHolder<E> getParent() {
        return this.parent;
    }

    void addChild(TaxonHolder<E> childHolder) {
        this.children.add(childHolder);
    }

    private TaxonHolder<E> findSubNode(int taxid) {
        if (taxid == ((Node)this.taxon).getTaxid()) {
            return this;
        }
        TaxonHolder<E> ret = null;
        for (TaxonHolder<E> child : this.children) {
            ret = super.findSubNode(taxid);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void topDownVisit(TreeVisitor<E> visitor) {
        TaxonHolder.topDownVisit(this, visitor, 0);
    }

    private static boolean topDownVisit(TaxonHolder t, TreeVisitor v, int depth) {
        if (!v.visitNode(new VisitInfo(t, VisitInfo.VisitType.down))) {
            return false;
        }
        for (TaxonHolder taxonHolder : t.getChildHolders()) {
            if (TaxonHolder.topDownVisit(taxonHolder, v, depth + 1)) continue;
            return false;
        }
        return true;
    }

    public void biDirectionDepthFirst(TreeVisitor visitor) {
        TaxonHolder.biDirectionDepthFirst(this, visitor, 0);
    }

    private static boolean biDirectionDepthFirst(TaxonHolder t, TreeVisitor v, int depth) {
        if (!v.visitNode(new VisitInfo(t, VisitInfo.VisitType.down))) {
            return false;
        }
        for (TaxonHolder taxonHolder : t.getChildHolders()) {
            if (TaxonHolder.biDirectionDepthFirst(taxonHolder, v, depth + 1)) continue;
            return false;
        }
        return v.visitNode(new VisitInfo(t, VisitInfo.VisitType.up));
    }
}

