/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.gbregion;

import edu.msu.cme.rdp.readseq.utils.IUBUtilities;
import edu.msu.cme.rdp.readseq.utils.gbregion.Extends;
import edu.msu.cme.rdp.readseq.utils.gbregion.SingleSeqRegion;

public class ComplementRegion
extends SingleSeqRegion {
    private SingleSeqRegion complementOf;

    public ComplementRegion(SingleSeqRegion complementOf) {
        if (complementOf == null) {
            throw new IllegalArgumentException("ComplementOf must not be null");
        }
        this.complementOf = complementOf;
    }

    public SingleSeqRegion getComplementOf() {
        return this.complementOf;
    }

    public String toString() {
        return "complement(" + this.complementOf.toString() + ")";
    }

    public String getId() {
        return this.complementOf.getId();
    }

    public int getSeqStart() {
        return this.complementOf.getSeqStart();
    }

    public int getSeqStop() {
        return this.complementOf.getSeqStop();
    }

    public String getSeqRegion(String seq, int offset) {
        return IUBUtilities.reverseComplement(this.complementOf.getSeqRegion(seq, offset));
    }

    public Extends getExtends() {
        Extends e = this.complementOf.getExtends();
        if (e == Extends.BEYOND_BEGIN) {
            return Extends.BEYOND_END;
        }
        if (e == Extends.BEYOND_END) {
            return Extends.BEYOND_BEGIN;
        }
        return e;
    }
}

