/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import edu.msu.cme.rdp.readseq.QSequence;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.readers.core.FastqCore;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import edu.msu.cme.rdp.readseq.writers.FastqWriter;
import edu.msu.cme.rdp.readseq.writers.SequenceWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;

public class SequenceSelector {
    public static void main(String[] args) throws IOException {
        String line;
        if (args.length < 5) {
            System.err.println("USAGE: SequenceSelector ids_file outfile outputformat keep[Y|N] seqfile(s) \nInput format is fasta or fastq. The outputformat can be either fasta or fastq if inputs are fastq\nDefault is to keep the sequences in the ids_file. If keep is false or N, the sequences will be removed from output ");
            System.exit(1);
        }
        File idFile = new File(args[0]);
        SequenceWriter out = null;
        if (args[2].equalsIgnoreCase("fasta")) {
            out = new FastaWriter(args[1]);
        } else if (args[2].equalsIgnoreCase("fastq")) {
            out = new FastqWriter(args[1], FastqCore.Phred33QualFunction);
        } else {
            throw new IllegalArgumentException("only fasta and fastq output are supported");
        }
        boolean keep = true;
        if (args[3].equalsIgnoreCase("N") || args[3].equalsIgnoreCase("false")) {
            keep = false;
        }
        HashSet<String> ids = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new FileReader(idFile));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            ids.add(line);
        }
        reader.close();
        HashSet<String> foundIds = new HashSet<String>();
        for (int index = 4; index < args.length; ++index) {
            SequenceReader seqReader = new SequenceReader(new File(args[index]));
            Sequence seq = seqReader.readNextSequence();
            if (out instanceof FastqWriter && !(seq instanceof QSequence)) {
                throw new IllegalArgumentException("input file " + args[index] + " format is not fastq, can not write fastq output");
            }
            boolean contains = ids.contains(seq.getSeqName());
            if (contains && keep || !contains && !keep) {
                out.writeSeq(seq);
                if (keep) {
                    foundIds.add(seq.getSeqName());
                }
            }
            while ((seq = seqReader.readNextSequence()) != null) {
                contains = ids.contains(seq.getSeqName());
                if ((!contains || !keep) && (contains || keep)) continue;
                out.writeSeq(seq);
                if (!keep) continue;
                foundIds.add(seq.getSeqName());
                if (foundIds.size() != ids.size()) continue;
            }
            seqReader.close();
        }
        out.close();
    }
}

