## ----setup,echo=FALSE,results="hide",message=FALSE----------------------------
library(knitr)
library(ontoProc)
cl = getOnto("cellOnto", "2023") # for continuity -- 	has_high_plasma_membrane_amount: list
#	has_low_plasma_membrane_amount: list are present in 2021 not 2022 - seems these have
# moved to RO (relations ontology)
#> grep("plasma", nn, value=TRUE)
#                       RO:0002104                        RO:0015015 
#       "has plasma membrane part" "has high plasma membrane amount" 
#                       RO:0015016 
# "has low plasma membrane amount" 
#
go = getOnto("goOnto")
pr = getOnto("PROnto")
library(ontologyPlot)
library(BiocStyle)
library(SingleCellExperiment)
library(celldex)

## ----setup2, message=FALSE----------------------------------------------------
library(ontoProc)
library(ontologyPlot)
library(BiocStyle)  # for package references
cl = getOnto("cellOnto", "2023") # for continuity -- 	has_high_plasma_membrane_amount: list
go = getOnto("goOnto", "2023")  # if updated, some assertions will fail...
pr = getOnto("PROnto", "2023")  # important case change

## ----lksco--------------------------------------------------------------------
data(packDesc2023)
kable(packDesc2023[,-c(1,7)])

## ----lklk---------------------------------------------------------------------
kable(stab <- seur3kTab())

## ----lklklk-------------------------------------------------------------------
library(ontoProc)
cl = getOnto("cellOnto", "2023")
onto_plot2(cl, stab$tag)

## ----lkfa---------------------------------------------------------------------
suppressMessages({
kable(CLfeats(cl, "CL:0002531", pr=pr, go=go))
})

## ----lksy---------------------------------------------------------------------
kable(sdf <- as.data.frame(sym2CellOnto("ITGAM", cl, pr)))
table(sdf$cond)
kable(as.data.frame(sym2CellOnto("FOXP3", cl, pr)))

## ----lksig--------------------------------------------------------------------
sigels = c("CL:X01"="GRIK3", "CL:X02"="NTNG1", "CL:X03"="BAGE2",
             "CL:X04"="MC4R", "CL:X05"="PAX6", "CL:X06"="TSPAN12", 
             "CL:X07"="hSHISA8", "CL:X08"="SNCG", "CL:X09"="ARHGEF28", 
             "CL:X10"="EGF")

## ----lkdfff-------------------------------------------------------------------
cs = cyclicSigset(sigels)
dim(cs)
cs[c(1:5,9:13),]
table(cs$cond)

## ----lklk1--------------------------------------------------------------------
 makeIntnProlog = function(id, ...) {
 # make type-specific prologs as key-value pairs
     c(  
       sprintf("id: %s", id),
       sprintf("name: %s-expressing cortical layer 1 interneuron, human", ...),
       sprintf("def: '%s-expressing cortical layer 1 interneuron, human described via RNA-seq observations' [PMID 29322913]", ...),
       "is_a: CL:0000099 ! interneuron",
       "intersection_of: CL:0000099 ! interneuron")
 }

## ----doterm-------------------------------------------------------------------
pmap = c("hasExp"="has_expression_of", lacksExp="lacks_expression_of")
head(unlist(tms <- ldfToTerms(cs, pmap, sigels, makeIntnProlog)), 20)

## ----lkmap--------------------------------------------------------------------
hpca_map = read.csv(system.file("extdata/hpca.csv", package="ontoProc"), strings=FALSE)
head(hpca_map)

## ----doren--------------------------------------------------------------------
names(hpca_map) = c("informal", "formal")  # obligatory for now

## ----gethpca, eval=TRUE-------------------------------------------------------
library(SingleCellExperiment)
library(celldex)
hpca_sce = HumanPrimaryCellAtlasData()

## ----dobind, eval=TRUE--------------------------------------------------------
hpca_sce = bind_formal_tags(hpca_sce, "label.fine", hpca_map)
length(unique(hpca_sce$label.ont))

## ----justna, eval=TRUE--------------------------------------------------------
length(xx <- which(is.na(hpca_sce$label.ont)))
if (length(xx)>0) print(colData(hpca_sce)[xx,])
sum(hpca_sce$label.ont == "", na.rm=TRUE) # iPS and BM

## ----dosub, eval=TRUE---------------------------------------------------------
cell_onto = ontoProc::getOnto("cellOnto", "2023")
hpca_mono = subset_descendants( hpca_sce, cell_onto, "^monocyte$" )
table(hpca_mono$label.fine)
table(hpca_mono$label.ont) # not much diversity
hpca_tcell = subset_descendants( hpca_sce, cell_onto, "^T cell$" )
table(hpca_tcell$label.fine)
table(hpca_tcell$label.ont) # 
uu = unique(hpca_tcell$label.ont)
onto_plot2(cell_onto, uu)

## ----lkefo--------------------------------------------------------------------
ef = getOnto("efoOnto")
alla <- grep("sthma", ef$name, value=TRUE) 
aa <- grep("obso", alla, invert=TRUE, value=TRUE)
onto_plot2(ef, names(aa))

## ----lkhdo,eval=FALSE---------------------------------------------------------
#  hdo_2022_09 = get_OBO(
#    "https://github.com/DiseaseOntology/HumanDiseaseOntology/raw/main/src/ontology/HumanDO.obo",
#    extract_tags = "everything"
#    )

