/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.utils;

public class Alphabet {
    public static final Alphabet BINARY = new Alphabet("01");
    public static final Alphabet OCTAL = new Alphabet("01234567");
    public static final Alphabet DECIMAL = new Alphabet("0123456789");
    public static final Alphabet HEXADECIMAL = new Alphabet("0123456789ABCDEF");
    public static final Alphabet DNA = new Alphabet("ACGT");
    public static final Alphabet LOWERCASE = new Alphabet("abcdefghijklmnopqrstuvwxyz");
    public static final Alphabet UPPERCASE = new Alphabet("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
    public static final Alphabet PROTEIN = new Alphabet("ACDEFGHIKLMNPQRSTVWY");
    public static final Alphabet BASE64 = new Alphabet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
    public static final Alphabet ASCII = new Alphabet(128);
    public static final Alphabet EXTENDED_ASCII = new Alphabet(256);
    public static final Alphabet UNICODE16 = new Alphabet(65536);
    private char[] alphabet;
    private int[] inverse;
    private int R;

    public Alphabet(String alpha) {
        int i;
        boolean[] unicode = new boolean[65535];
        for (i = 0; i < alpha.length(); ++i) {
            char c = alpha.charAt(i);
            if (unicode[c]) {
                throw new IllegalArgumentException("Illegal alphabet: character = '" + c + "'");
            }
            unicode[c] = true;
        }
        this.alphabet = alpha.toCharArray();
        this.R = alpha.length();
        this.inverse = new int[65535];
        for (i = 0; i < this.inverse.length; ++i) {
            this.inverse[i] = -1;
        }
        for (int c = 0; c < this.R; ++c) {
            this.inverse[this.alphabet[c]] = c;
        }
    }

    private Alphabet(int R) {
        int i;
        this.alphabet = new char[R];
        this.inverse = new int[R];
        this.R = R;
        for (i = 0; i < R; ++i) {
            this.alphabet[i] = (char)i;
        }
        for (i = 0; i < R; ++i) {
            this.inverse[i] = i;
        }
    }

    public Alphabet() {
        this(256);
    }

    public boolean contains(char c) {
        return this.inverse[c] != -1;
    }

    public int R() {
        return this.R;
    }

    public int lgR() {
        int lgR = 0;
        for (int t = this.R - 1; t >= 1; t /= 2) {
            ++lgR;
        }
        return lgR;
    }

    public int toIndex(char c) {
        if (c < '\u0000' || c >= this.inverse.length || this.inverse[c] == -1) {
            return -1;
        }
        return this.inverse[c];
    }

    public int[] toIndices(String s) {
        char[] source = s.toCharArray();
        int[] target = new int[s.length()];
        for (int i = 0; i < source.length; ++i) {
            target[i] = this.toIndex(source[i]);
        }
        return target;
    }

    public char toChar(int index) {
        if (index < 0 || index >= this.R) {
            throw new IndexOutOfBoundsException("Alphabet index out of bounds");
        }
        return this.alphabet[index];
    }

    public String toChars(int[] indices) {
        StringBuilder s = new StringBuilder(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            s.append(this.toChar(indices[i]));
        }
        return s.toString();
    }
}

