/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget;

import fr.cea.ig.metatarget.MetaBin;
import fr.cea.ig.metatarget.datastructures.ClusterPoisson;
import fr.cea.ig.metatarget.datastructures.ClusterVectorAB;
import fr.cea.ig.metatarget.datastructures.Dictionary;
import fr.cea.ig.metatarget.datastructures.FastaManager;
import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.datastructures.SequenceProcessor;
import fr.cea.ig.metatarget.datastructures.VectorUtils;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;

public class MTxAB
implements MetaBin {
    private static String version;
    private static Dictionary dictionary;
    private static FastaManager frm;
    private StringBuilder sb = null;
    private List<BufferedOutputStream> bos;
    private List<AtomicInteger> spc;

    public String go(String[] args) throws Exception {
        version = new Date(Utils.classBuildTimeMillis(this.getClass())).toString();
        System.out.println("version MTxAB =" + version);
        int numOfThreads = 1;
        int excludeMin = 1;
        int excludeMax = 0;
        int kAB = 10;
        int numOfClustersAB = 3;
        List<String> inputFastaFileNames = null;
        String outputClustersFileNamePrefix = null;
        boolean keepQualities = false;
        boolean compressOut = false;
        boolean dryRun = false;
        BasicParser parser = new BasicParser();
        Options options = this.createOptions();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
            if (args.length < 1) {
                throw new Exception();
            }
            if (cmd.hasOption("t")) {
                numOfThreads = Integer.parseInt(cmd.getOptionValue("t"));
            }
            if (cmd.hasOption("i")) {
                inputFastaFileNames = Arrays.asList(cmd.getOptionValues("i"));
            }
            if (cmd.hasOption("kAB")) {
                kAB = Integer.parseInt(cmd.getOptionValue("kAB"));
            }
            if (cmd.hasOption("nAB")) {
                numOfClustersAB = Integer.parseInt(cmd.getOptionValue("nAB"));
            }
            if (cmd.hasOption("oAB")) {
                outputClustersFileNamePrefix = cmd.getOptionValue("oAB");
            }
            if (cmd.hasOption("eMin")) {
                excludeMin = Integer.parseInt(cmd.getOptionValue("eMin"));
            }
            if (cmd.hasOption("eMax")) {
                excludeMax = Integer.parseInt(cmd.getOptionValue("eMax"));
            }
            if (cmd.hasOption("q")) {
                keepQualities = true;
            }
            if (cmd.hasOption("z")) {
                compressOut = true;
            }
            if (cmd.hasOption("d")) {
                dryRun = true;
            }
        }
        catch (Exception exp) {
            formatter.printHelp("MTxAB", options, true);
            exp.printStackTrace(System.err);
            return null;
        }
        this.sb = new StringBuilder();
        this.processSequencesAB_count(numOfThreads, kAB, inputFastaFileNames, excludeMin, excludeMax);
        this.removeMinKmers(excludeMin);
        System.out.println(Utils.RAMInfo(Runtime.getRuntime()));
        TIntLongHashMap countsHistoAB = dictionary.getCountsHisto();
        if (!dryRun) {
            this.save_histogram(countsHistoAB, outputClustersFileNamePrefix);
        }
        ClusterPoisson[] clusterPoissonsAB = VectorUtils.createABClusterPoissonsEMsync(numOfClustersAB, excludeMin, excludeMax, dictionary);
        ClusterVectorAB[] clusterVectorsAB = dictionary.createABClusterVectors(clusterPoissonsAB, excludeMin, excludeMax);
        dictionary.clear();
        dictionary = null;
        this.prepareOutputFiles(numOfClustersAB, outputClustersFileNamePrefix, keepQualities, compressOut, dryRun);
        this.processSequencesAB_assign(numOfThreads, kAB, inputFastaFileNames, clusterVectorsAB, keepQualities);
        for (ClusterVectorAB cv : clusterVectorsAB) {
            cv.clear();
            cv = null;
        }
        clusterVectorsAB = null;
        this.closeOutputFiles(numOfClustersAB);
        System.out.println(Utils.RAMInfo(Runtime.getRuntime()));
        return this.sb.toString();
    }

    private Options createOptions() {
        Options options = new Options();
        OptionBuilder.withArgName("numOfThreads");
        OptionBuilder.withLongOpt("numOfThreads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Number of threads to use.");
        OptionBuilder.isRequired(false);
        Option t = OptionBuilder.create("t");
        options.addOption(t);
        OptionBuilder.withArgName("kMerSizeAB");
        OptionBuilder.withLongOpt("kMerSizeAB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("k-mer length for AB.");
        OptionBuilder.isRequired(false);
        Option k = OptionBuilder.create("kAB");
        options.addOption(k);
        OptionBuilder.withArgName("input");
        OptionBuilder.withLongOpt("input");
        OptionBuilder.hasArgs(Integer.MAX_VALUE);
        OptionBuilder.withDescription("Input Fasta/q files paths.");
        OptionBuilder.isRequired(true);
        Option input = OptionBuilder.create("i");
        options.addOption(input);
        OptionBuilder.withArgName("eMin");
        OptionBuilder.withLongOpt("eMin");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("ExcludeMin kmers.");
        OptionBuilder.isRequired(false);
        Option excludeMinOption = OptionBuilder.create("eMin");
        options.addOption(excludeMinOption);
        OptionBuilder.withArgName("eMax");
        OptionBuilder.withLongOpt("eMax");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("ExcludeMax kmers.");
        OptionBuilder.isRequired(false);
        Option excludeMaxOption = OptionBuilder.create("eMax");
        options.addOption(excludeMaxOption);
        OptionBuilder.withArgName("outputAB");
        OptionBuilder.withLongOpt("outputAB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Output Abundance Based Clusters files prefix.");
        OptionBuilder.isRequired(true);
        Option output_AB = OptionBuilder.create("oAB");
        options.addOption(output_AB);
        OptionBuilder.withArgName("numOfClustersAB");
        OptionBuilder.withLongOpt("numOfClustersAB");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Number of Clusters for AB.");
        OptionBuilder.isRequired(false);
        Option numOfClusters = OptionBuilder.create("nAB");
        options.addOption(numOfClusters);
        OptionBuilder.withArgName("q");
        OptionBuilder.withLongOpt("quality");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Keep qualities.");
        OptionBuilder.isRequired(false);
        Option keepQualities = OptionBuilder.create("q");
        options.addOption(keepQualities);
        OptionBuilder.withArgName("z");
        OptionBuilder.withLongOpt("gzip");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Compress output.");
        OptionBuilder.isRequired(false);
        Option compressOut = OptionBuilder.create("z");
        options.addOption(compressOut);
        OptionBuilder.withArgName("d");
        OptionBuilder.withLongOpt("dry");
        OptionBuilder.hasArg(false);
        OptionBuilder.withDescription("Dry run.");
        OptionBuilder.isRequired(false);
        Option dryRun = OptionBuilder.create("d");
        options.addOption(dryRun);
        return options;
    }

    private void processSequencesAB_count(int numOfThreads, int kAB, List<String> inputFastaFileNames, int excludeMin, int excludeMax) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            dictionary = new Dictionary(0x100000, usingThreads, excludeMin, excludeMax);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            System.out.println(Utils.time() + " START of AB Counting");
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            if (frm != null) {
                frm.clear();
                frm = null;
            }
            frm = new FastaManager(false, inputFastaFileNames, startSignal, doneSignal);
            pool.execute(frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(this, dictionary, frm, SequenceProcessor.MODE.AB_KMERCOUNT, kAB, startSignal, doneSignal, null);
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
            System.out.println(Utils.time() + " END of AB Counting");
            System.out.println(Utils.time() + " Loaded sequences: " + SequenceProcessor.getSequenceCount().get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removeMinKmers(int excludeMin) {
        try {
            System.out.println(Utils.time() + " Total kmers(before remove):\t" + dictionary.getKmerCodes().size() + "\n");
            if (excludeMin > 1) {
                System.out.println(Utils.time() + " Removing kmer with global count < " + excludeMin);
                dictionary.removeAll(excludeMin);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void save_histogram(TIntLongHashMap countsHistoAB, String outputClustersFileNamePrefix) {
        try {
            File f = new File(outputClustersFileNamePrefix + "__AB.histogram.tsv").getCanonicalFile();
            f.getParentFile().mkdirs();
            BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(f));
            IOUtils.write("counts\tfrequency\n", (OutputStream)bo, StandardCharsets.UTF_8);
            TIntLongIterator it = countsHistoAB.iterator();
            while (it.hasNext()) {
                it.advance();
                IOUtils.write(it.key() + "\t" + it.value() + "\n", (OutputStream)bo, StandardCharsets.UTF_8);
            }
            bo.flush();
            bo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareOutputFiles(int numOfClustersAB, String outputClustersFileNamePrefix, boolean keepQualities, boolean compressOut, boolean dryRun) {
        try {
            this.bos = Arrays.asList(new BufferedOutputStream[numOfClustersAB + 1]);
            this.spc = new ArrayList<AtomicInteger>(numOfClustersAB);
            for (int i = 0; i < numOfClustersAB; ++i) {
                if (!dryRun) {
                    File f = compressOut ? new File(outputClustersFileNamePrefix + "__AB." + (i + 1) + (MTxAB.frm.isFastq && keepQualities ? ".fastq.gz" : ".fasta.gz")).getCanonicalFile() : new File(outputClustersFileNamePrefix + "__AB." + (i + 1) + (MTxAB.frm.isFastq && keepQualities ? ".fastq" : ".fasta")).getCanonicalFile();
                    f.getParentFile().mkdirs();
                    BufferedOutputStream bo = null;
                    bo = compressOut ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(f))) : new BufferedOutputStream(new FileOutputStream(f));
                    this.bos.set(i, bo);
                }
                this.spc.add(new AtomicInteger(0));
            }
            List numbers = Stream.iterate(1, n -> n + 1).limit(numOfClustersAB).collect(Collectors.toList());
            String line = "read_id\tAB\tAB." + numbers.stream().map(String::valueOf).collect(Collectors.joining("\tAB.")) + "\n";
            this.sb.append(line);
            if (!dryRun) {
                File f = new File(outputClustersFileNamePrefix + "__AB.assignments.tsv").getCanonicalFile();
                f.getParentFile().mkdirs();
                this.bos.set(numOfClustersAB, new BufferedOutputStream(new FileOutputStream(f)));
                IOUtils.write(line, (OutputStream)this.bos.get(numOfClustersAB), StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void processSequencesAB_assign(int numOfThreads, int kAB, List<String> inputFastaFileNames, ClusterVectorAB[] ABClusterVectors, boolean keepQualities) {
        try {
            int cpus = Runtime.getRuntime().availableProcessors();
            int usingThreads = cpus < numOfThreads ? cpus : numOfThreads;
            System.out.println("cpus=" + cpus);
            System.out.println("using=" + usingThreads);
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            System.out.println(Utils.time() + " START of AB Binning");
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            if (frm != null) {
                frm.clear();
                frm = null;
            }
            frm = new FastaManager(false, inputFastaFileNames, startSignal, doneSignal);
            pool.execute(frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(this, dictionary, frm, SequenceProcessor.MODE.AB_BINNING, kAB, startSignal, doneSignal, new Object[]{keepQualities});
                sp.setABClusterVectors(ABClusterVectors);
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
            System.out.println(Utils.time() + " END of AB Binning");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void closeOutputFiles(int numOfClustersAB) {
        try {
            BufferedOutputStream bo;
            System.out.println("\tClustered reads:");
            for (int i = 0; i < numOfClustersAB; ++i) {
                bo = this.bos.get(i);
                if (bo != null) {
                    bo.flush();
                    bo.close();
                }
                System.out.println("\t\tAB Cluster " + (i + 1) + ": " + this.spc.get(i).get());
            }
            bo = this.bos.get(numOfClustersAB);
            if (bo != null) {
                bo.flush();
                bo.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public synchronized boolean saveSeqToCluster(Sequence sequence, boolean keepQualities) {
        try {
            BufferedOutputStream bo;
            int clusterId = sequence.getAssignedCluster();
            if (clusterId <= 0) {
                return false;
            }
            this.spc.get(clusterId - 1).incrementAndGet();
            String line = sequence.getShortName() + "\t" + clusterId + "\t" + Arrays.stream(sequence.getDistancesToClusters()).mapToObj(String::valueOf).collect(Collectors.joining("\t")) + "\n";
            this.sb.append(line);
            if (this.bos.get(this.bos.size() - 1) != null) {
                IOUtils.write(line, (OutputStream)this.bos.get(this.bos.size() - 1), StandardCharsets.UTF_8);
            }
            if ((bo = this.bos.get(clusterId - 1)) == null) {
                return false;
            }
            if (sequence.getHeader() != null) {
                IOUtils.write(sequence.getHeader(), (OutputStream)bo);
                IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
            }
            if (sequence.getSeq() != null) {
                IOUtils.write(sequence.getSeq(), (OutputStream)bo);
                IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
            }
            if (keepQualities && sequence.getQual() != null) {
                IOUtils.write("+\n", (OutputStream)bo, StandardCharsets.UTF_8);
                IOUtils.write(sequence.getQual(), (OutputStream)bo);
                IOUtils.write("\n", (OutputStream)bo, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        MTxAB MT_AB = new MTxAB();
        try {
            System.out.println(MT_AB.go(args));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    static {
        dictionary = null;
        frm = null;
    }
}

