## ---- echo=FALSE--------------------------------------------------------------
library(BiocStyle)
self <- Githubpkg("ArtifactDB/alabaster.sce")
knitr::opts_chunk$set(error=FALSE, warning=FALSE, message=FALSE)

## -----------------------------------------------------------------------------
library(SingleCellExperiment)
example(SingleCellExperiment, echo=FALSE) # can't be bothered to copy it here.
sce

library(alabaster.sce)
tmp <- tempfile()
dir.create(tmp)
meta <- stageObject(sce, tmp, "sce")
.writeMetadata(meta, tmp)

list.files(tmp, recursive=TRUE)

## -----------------------------------------------------------------------------
meta <- acquireMetadata(tmp, "sce/experiment.json")
roundtrip <- loadObject(meta, tmp)
class(roundtrip)

## -----------------------------------------------------------------------------
sessionInfo()

