## ---- echo=FALSE--------------------------------------------------------------
library(BiocStyle)
self <- Biocpkg("alabaster.base");
knitr::opts_chunk$set(error=FALSE, warning=FALSE, message=FALSE)

## -----------------------------------------------------------------------------
library(S4Vectors)
df <- DataFrame(X=1:10, Y=letters[1:10])
df

## -----------------------------------------------------------------------------
staging <- tempfile()

library(alabaster.base)
saveLocalObject(df, staging, "my_favorite_df")

## -----------------------------------------------------------------------------
readLocalObject(staging, "my_favorite_df")

## -----------------------------------------------------------------------------
tmp <- tempfile()
dir.create(tmp)

# DataFrame method already defined for the stageObject generic:
meta <- stageObject(df, tmp, path="my_df")
str(meta)

# Writing the metadata to file.
invisible(.writeMetadata(meta, tmp))

list.files(tmp, recursive=TRUE)

## -----------------------------------------------------------------------------
remeta <- acquireMetadata(tmp, "my_df/simple.csv.gz")
loadObject(remeta, tmp)

## -----------------------------------------------------------------------------
# Creating a nested DF to be a little spicy:
df2 <- DataFrame(Z=factor(1:5), AA=I(DataFrame(B=runif(5), C=rnorm(5))))

meta2 <- stageObject(df2, tmp, path="my_df2")
list.files(tmp, recursive=TRUE)

## -----------------------------------------------------------------------------
meta2$path
new.dir <- tempfile()
dir.create(new.dir)
invisible(file.copy(tmp, new.dir, recursive=TRUE))
loadObject(meta2, file.path(new.dir, basename(tmp)))

## -----------------------------------------------------------------------------
# Writing the metadata to file.
invisible(.writeMetadata(meta, dir=tmp))
invisible(.writeMetadata(meta2, dir=tmp))

# Reading a snippet.
meta.path <- file.path(tmp, paste0(meta$path, ".json"))
cat(head(readLines(meta.path), 20), sep="\n")

## -----------------------------------------------------------------------------
meta.fail <- meta
meta.fail[["data_frame"]][["columns"]] <- NULL
try(.writeMetadata(meta.fail, dir=tmp))

## -----------------------------------------------------------------------------
re.read <- acquireMetadata(tmp, "my_df2/simple.csv.gz")
loadObject(re.read, tmp)

## -----------------------------------------------------------------------------
sessionInfo()

