## ---- eval=FALSE--------------------------------------------------------------
#  if (!require("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("RESOLVE")

## ---- message=FALSE-----------------------------------------------------------
library("RESOLVE")
data(ssm560_reduced)

## ---- message=FALSE-----------------------------------------------------------
library("BSgenome.Hsapiens.1000genomes.hs37d5")
imported_data = getSBSCounts(data = ssm560_reduced, reference = BSgenome.Hsapiens.1000genomes.hs37d5)

## ----fig.width=7, fig.height=7, fig.cap="Visualization of the counts for patient PD10010a from the dataset published in Nik-Zainal, Serena, et al."----
patientsSBSPlot(trinucleotides_counts=imported_data,samples="PD10010a")

## ---- eval=FALSE--------------------------------------------------------------
#  data(background)
#  data(patients)
#  set.seed(12345)
#  res_denovo = signaturesDecomposition(x = patients,
#                                       K = 1:15,
#                                       background_signature = background,
#                                       nmf_runs = 100,
#                                       num_processes = 50)

## ---- eval=FALSE--------------------------------------------------------------
#  set.seed(12345)
#  res_cv = signaturesCV(x = patients,
#                        beta = res_denovo$beta,
#                        cross_validation_repetitions = 100,
#                        num_processes = 50)

## -----------------------------------------------------------------------------
sessionInfo()

