/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import loci.common.DataTools;
import loci.common.DebugTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.CoreMetadata;
import loci.formats.DimensionSwapper;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;

public final class RBioFormats {
    private static DimensionSwapper reader;
    private static IFormatWriter writer;
    private static OMEXMLMetadata meta;
    private static MetadataStore omexml;
    private static String dimensionOrder;

    public static IFormatReader getReader() {
        if (reader == null) {
            reader = new DimensionSwapper((IFormatReader)new ChannelSeparator((IFormatReader)new ChannelFiller()));
        }
        return reader;
    }

    public static IFormatWriter getWriter() {
        writer = new ImageWriter();
        return writer;
    }

    public static void initializeMetadata() throws Exception {
        meta = RBioFormats.getOMEXMLMetadata();
    }

    public static MetadataStore getOMEXML() {
        return omexml;
    }

    public static String getCurrentFile() {
        return reader.getCurrentFile();
    }

    public static void setupReader(String string, boolean bl, boolean bl2, boolean bl3) throws FormatException, IOException {
        reader.setMetadataFiltered(bl);
        reader.setOriginalMetadataPopulated(bl2);
        reader.setFlattenedResolutions(false);
        omexml = bl3 ? RBioFormats.getOMEXMLMetadata() : new DummyMetadata();
        reader.setMetadataStore(omexml);
        reader.setId(string);
        reader.setOutputOrder(dimensionOrder);
    }

    public static void setupWriter(String string) throws FormatException, IOException {
        writer.setMetadataRetrieve((MetadataRetrieve)meta);
        writer.setId(string);
    }

    public static void populateMetadata(int[] nArray, int n, String string, boolean bl) {
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[3];
        int n5 = nArray[2];
        int n6 = nArray[4];
        MetadataTools.populateMetadata((MetadataStore)meta, (int)n, null, (boolean)bl, (String)dimensionOrder, (String)string, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)1);
    }

    public static Object readPixels(int n, int n2, int n3, int n4, int n5, boolean bl) throws FormatException, IOException {
        int n6 = reader.getPixelType();
        int n7 = n4 * n5 * FormatTools.getBytesPerPixel((int)n6) * reader.getRGBChannelCount();
        byte[] byArray = new byte[n7];
        reader.openBytes(n, byArray, n2, n3, n4, n5);
        int n8 = FormatTools.getBytesPerPixel((int)n6);
        boolean bl2 = FormatTools.isFloatingPoint((int)n6);
        boolean bl3 = reader.isLittleEndian();
        if (bl) {
            return RBioFormats.normalizedDataArray(byArray, n8, bl2, bl3, n6);
        }
        return RBioFormats.rawDataArray(byArray, n8, FormatTools.isSigned((int)n6), bl2, bl3);
    }

    public static OMEXMLMetadata getOMEXMLMetadata() throws FormatException {
        try {
            ServiceFactory serviceFactory = new ServiceFactory();
            OMEXMLService oMEXMLService = (OMEXMLService)serviceFactory.getInstance(OMEXMLService.class);
            return oMEXMLService.createOMEXMLMetadata();
        }
        catch (DependencyException dependencyException) {
            throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, (Throwable)dependencyException);
        }
        catch (ServiceException serviceException) {
            throw new FormatException((Throwable)serviceException);
        }
    }

    private static Object rawDataArray(byte[] byArray, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = bl ? n : n * 2;
        int n3 = byArray.length / n;
        if (n2 == 1) {
            short[] sArray = new short[n3];
            for (int i = 0; i < n3; ++i) {
                sArray[i] = byArray[i];
            }
            return sArray;
        }
        if (n2 == 2) {
            short[] sArray = new short[n3];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n3) {
                sArray[n4] = DataTools.bytesToShort((byte[])byArray, (int)n5, (int)n, (boolean)bl3);
                ++n4;
                n5 += n;
            }
            return sArray;
        }
        if (n2 == 4 && bl2) {
            float[] fArray = new float[n3];
            int n6 = 0;
            int n7 = 0;
            while (n6 < n3) {
                fArray[n6] = DataTools.bytesToFloat((byte[])byArray, (int)n7, (int)n, (boolean)bl3);
                ++n6;
                n7 += n;
            }
            return fArray;
        }
        if (n2 == 4 && !bl) {
            int[] nArray = new int[n3];
            int n8 = 0;
            int n9 = 0;
            while (n8 < n3) {
                nArray[n8] = DataTools.bytesToInt((byte[])byArray, (int)n9, (int)n, (boolean)bl3);
                ++n8;
                n9 += n;
            }
            return nArray;
        }
        if (n2 == 4) {
            double[] dArray = new double[n3];
            int n10 = 0;
            int n11 = 0;
            while (n10 < n3) {
                dArray[n10] = DataTools.bytesToInt((byte[])byArray, (int)n11, (int)n, (boolean)bl3);
                ++n10;
                n11 += n;
            }
            return dArray;
        }
        if (n2 == 8 && bl2) {
            double[] dArray = new double[n3];
            int n12 = 0;
            int n13 = 0;
            while (n12 < n3) {
                dArray[n12] = DataTools.bytesToDouble((byte[])byArray, (int)n13, (int)n, (boolean)bl3);
                ++n12;
                n13 += n;
            }
            return dArray;
        }
        if (n2 == 8) {
            long[] lArray = new long[n3];
            int n14 = 0;
            int n15 = 0;
            while (n14 < n3) {
                lArray[n14] = DataTools.bytesToLong((byte[])byArray, (int)n15, (int)n, (boolean)bl3);
                ++n14;
                n15 += n;
            }
            return lArray;
        }
        return null;
    }

    private static double[] normalizedDataArray(byte[] byArray, int n, boolean bl, boolean bl2, int n2) {
        double[] dArray = new double[byArray.length / n];
        if (bl) {
            int n3;
            double d = Double.MAX_VALUE;
            double d2 = Double.MIN_VALUE;
            if (n == 4) {
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    dArray[n3] = DataTools.bytesToFloat((byte[])byArray, (int)(n3 * n), (int)n, (boolean)bl2);
                    if (dArray[n3] == Double.POSITIVE_INFINITY || dArray[n3] == Double.NEGATIVE_INFINITY) continue;
                    if (dArray[n3] < d) {
                        d = dArray[n3];
                    }
                    if (!(dArray[n3] > d2)) continue;
                    d2 = dArray[n3];
                }
            } else if (n == 8) {
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    dArray[n3] = DataTools.bytesToDouble((byte[])byArray, (int)(n3 * n), (int)n, (boolean)bl2);
                    if (dArray[n3] == Double.POSITIVE_INFINITY || dArray[n3] == Double.NEGATIVE_INFINITY) continue;
                    if (dArray[n3] < d) {
                        d = dArray[n3];
                    }
                    if (!(dArray[n3] > d2)) continue;
                    d2 = dArray[n3];
                }
            } else {
                return null;
            }
            double d3 = d2 - d;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = dArray[i] == Double.POSITIVE_INFINITY ? 1.0 : (dArray[i] == Double.NEGATIVE_INFINITY ? 0.0 : (dArray[i] - d) / d3);
            }
        } else {
            long[] lArray = FormatTools.defaultMinMax((int)n2);
            double d = lArray[0];
            double d4 = lArray[1];
            int n4 = ((CoreMetadata)RBioFormats.reader.getCoreMetadataList().get((int)RBioFormats.reader.getCoreIndex())).bitsPerPixel;
            if (!FormatTools.isSigned((int)n2) && n4 < FormatTools.getBytesPerPixel((int)n2) * 8) {
                d4 = Math.pow(2.0, n4) - 1.0;
            }
            double d5 = d4 - d;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((double)DataTools.bytesToLong((byte[])byArray, (int)(i * n), (int)n, (boolean)bl2) - d) / d5;
            }
        }
        return dArray;
    }

    public static void writePixels(int[] nArray, int n, String string, boolean bl) throws Exception {
        byte[] byArray;
        switch (FormatTools.pixelTypeFromString((String)string)) {
            case 0: 
            case 1: {
                byArray = new byte[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    byArray[i] = (byte)nArray[i];
                }
                break;
            }
            case 2: 
            case 3: {
                short[] sArray = new short[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    sArray[i] = (short)nArray[i];
                }
                byArray = DataTools.shortsToBytes((short[])sArray, (boolean)bl);
                break;
            }
            case 4: 
            case 5: {
                byArray = DataTools.intsToBytes((int[])nArray, (boolean)bl);
                break;
            }
            case 6: {
                float[] fArray = new float[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    fArray[i] = nArray[i];
                }
                byArray = DataTools.floatsToBytes((float[])fArray, (boolean)bl);
                break;
            }
            case 7: {
                double[] dArray = new double[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    dArray[i] = nArray[i];
                }
                byArray = DataTools.doublesToBytes((double[])dArray, (boolean)bl);
                break;
            }
            default: {
                byArray = null;
            }
        }
        RBioFormats.savePlanes(byArray, n);
    }

    public static void writePixels(double[] dArray, int n, String string, boolean bl) throws Exception {
        byte[] byArray;
        switch (FormatTools.pixelTypeFromString((String)string)) {
            case 0: 
            case 1: {
                byArray = new byte[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    byArray[i] = (byte)dArray[i];
                }
                break;
            }
            case 2: 
            case 3: {
                short[] sArray = new short[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    sArray[i] = (short)dArray[i];
                }
                byArray = DataTools.shortsToBytes((short[])sArray, (boolean)bl);
                break;
            }
            case 4: 
            case 5: {
                int[] nArray = new int[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    nArray[i] = (int)dArray[i];
                }
                byArray = DataTools.intsToBytes((int[])nArray, (boolean)bl);
                break;
            }
            case 6: {
                float[] fArray = new float[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    fArray[i] = (float)dArray[i];
                }
                byArray = DataTools.floatsToBytes((float[])fArray, (boolean)bl);
                break;
            }
            case 7: {
                byArray = DataTools.doublesToBytes((double[])dArray, (boolean)bl);
                break;
            }
            default: {
                byArray = null;
            }
        }
        RBioFormats.savePlanes(byArray, n);
    }

    public static void savePlanes(byte[] byArray, int n) throws Exception {
        int n2 = byArray.length / n;
        for (int i = 0; i < n; ++i) {
            writer.saveBytes(i, Arrays.copyOf(byArray, n2));
        }
    }

    public static void populateOriginalMetadata(Hashtable<String, Object> hashtable) throws Exception {
        ServiceFactory serviceFactory = new ServiceFactory();
        OMEXMLService oMEXMLService = (OMEXMLService)serviceFactory.getInstance(OMEXMLService.class);
        oMEXMLService.populateOriginalMetadata(meta, hashtable);
    }

    public static Hashtable<String, Object> getHashTable() {
        return new Hashtable<String, Object>();
    }

    public static void addMetaField(Hashtable<String, Object> hashtable, String string, boolean bl) {
        hashtable.put(string, bl);
    }

    public static void addMetaField(Hashtable<String, Object> hashtable, String string, int n) {
        hashtable.put(string, n);
    }

    public static void addMetaField(Hashtable<String, Object> hashtable, String string, double d) {
        hashtable.put(string, d);
    }

    public static void addMetaField(Hashtable<String, Object> hashtable, String string, String string2) {
        hashtable.put(string, string2);
    }

    static {
        dimensionOrder = "XYCZT";
        DebugTools.enableLogging((String)"ERROR");
    }
}

