## ----style, echo = FALSE, results = 'asis'------------------------------------
BiocStyle::markdown()

## ---- message = FALSE---------------------------------------------------------
library("MetaboCoreUtils")
ls(pos = "package:MetaboCoreUtils")

## -----------------------------------------------------------------------------
library(MetaboCoreUtils)

## -----------------------------------------------------------------------------
adductNames()

## -----------------------------------------------------------------------------
masses <- c(123, 842, 324)
mass2mz(masses, adduct = c("[M+H]+", "[M+Na]+"))

## -----------------------------------------------------------------------------
formula2mz(c("C6H12O6", "C8H10N4O2"), adduct = c("[M+H]+", "[M+Na]+"))

## -----------------------------------------------------------------------------
frml <- "Na3C4"
frml <- standardizeFormula(frml)
frml

## -----------------------------------------------------------------------------
frml <- addElements(frml, "H2O")
frml

## -----------------------------------------------------------------------------
frml <- subtractElements(frml, "H")
frml

## -----------------------------------------------------------------------------
countElements(frml)

## -----------------------------------------------------------------------------
adductFormula(c("C6H12O6", "C8H10N4O2"), adduct = c("[M+H]+", "[M+Na]+"))

## -----------------------------------------------------------------------------
lipid_masses <- c(760.5851, 762.6007, 762.5280)
calculateKmd(lipid_masses)

## -----------------------------------------------------------------------------
lipid_rkmd <- calculateRkmd(lipid_masses)
isRkmd(lipid_rkmd)

## -----------------------------------------------------------------------------
rti <- read.table(system.file("retentionIndex",
                              "rti.txt",
                              package = "MetaboCoreUtils"),
                  header = TRUE,
                  sep = "\t")

rtime <- read.table(system.file("retentionIndex",
                                "metabolites.txt",
                                package = "MetaboCoreUtils"),
                    header = TRUE,
                    sep = "\t")

## -----------------------------------------------------------------------------
head(rti)

## -----------------------------------------------------------------------------
rtime$rindex_r <- indexRtime(rtime$rtime, rti)

## -----------------------------------------------------------------------------
head(rtime)

## -----------------------------------------------------------------------------
ref <- data.frame(rindex = c(1709.8765, 553.7975),
                  refindex = c(1700, 550))

rtime$rindex_cor <- correctRindex(rtime$rindex_r, ref)

## ----sessioninfo, echo=FALSE--------------------------------------------------
sessionInfo()

