metadata <-
    data.frame(
        Title = c(
            "GTEX_data",
            "CCLE_data",
            "normal_tissues_multimapping_data",
            "DAC_treated_cells",
            "DAC_treated_cells_multimapping",
            "TCGA_TPM",
            "CT_methylation_in_tissues",
            "CT_mean_methylation_in_tissues",
            "TCGA_CT_methylation",
            "CT_genes",
            "CCLE_correlation_matrix"),
        Description = c(
            "Gene expression data in normal tissues from GTEx database",
            "Gene expression data in cancer cell lines from CCLE",
            "Gene expression values in normal tissues with or without allowing multimapping",
            "Gene expression values in a set of cell lines treated or not with 5-Aza-2'-Deoxycytidine (DAC), a demethylating agent",
            "Gene expression values (multimapping allowed) in a set of cell lines treated or not with 5-Aza-2'-Deoxycytidine (DAC)",
            "Gene expression data in TCGA samples",
            "Methylation values of CpGs located within Cancer-Testis promoters in a set of normal tissues",
            "Mean methylation values of all CpGs located within Cancer-Testis (CT) promoters in a set of normal tissues",
            "Methylation of CT promoters in TCGA samples",
            "Cancer-Testis (CT) genes description",
            "Gene correlations in CCLE cancer cell lines"),
        BiocVersion = c(
            "3.17",
            "3.17",
            "3.17",
            "3.17",
            "3.17",
            "3.17",
            "3.17",
            "3.17",
            "3.17",
            "3.17",
            "3.17"),
        Genome = "hg38",
        SourceType = c(
            "tab",
            "CSV",
            "FASTQ",
            "FASTQ",
            "FASTQ",
            "TSV",
            "BED",
            "BED",
            "TXT",
            "TSV",
            "CSV"),
        SourceUrl = c(
            "https://storage.googleapis.com/gtex_analysis_v8/rna_seq_data/GTEx_Analysis_2017-06-05_v8_RNASeQCv1.1.9_gene_median_tpm.gct.gz",
            "https://ndownloader.figshare.com/files/34989922, https://ndownloader.figshare.com/files/35020903",
            "https://www.encodeproject.org/",
            "https://www.encodeproject.org/",
            "https://www.encodeproject.org/",
            "https://portal.gdc.cancer.gov/",
            "https://www.encodeproject.org/",
            "https://www.encodeproject.org/",
            "https://portal.gdc.cancer.gov/",
            "https://zenodo.org/record/7537824/files/cancermine_collated.tsv?download=1",
            "https://ndownloader.figshare.com/files/34989922, https://ndownloader.figshare.com/files/35020903"),
        SourceVersion = c(
            "8",
            "22Q2",
            "5",
            "5",
            "5",
            "36.0",
            "5",
            "5",
            "36.0",
            "49",
            "22Q2"),
        Species = "Homo sapiens",
        TaxonomyId = "9606",
        Coordinate_1_based = "TRUE",
        DataProvider = c(
            "The Genotype-Tissue Expression",
            "Cancer Cell Line Encyclopedia",
            "ENCODE Project",
            "ENCODE Project",
            "ENCODE Project",
            "The Cancer Genome Atlas",
            "ENCODE Project",
            "ENCODE Project",
            "The Cancer Genome Atlas",
            "CancerMine",
            "Cancer Cell Line Encyclopedia"),
        Maintainer = "Axelle Loriot <axelle.loriot@uclouvain.be>",
        RDataClass = c(
            "SummarizedExperiment",
            "SummarizedExperiment",
            "SummarizedExperiment",
            "SummarizedExperiment",
            "SummarizedExperiment",
            "SummarizedExperiment",
            "RangedSummarizedExperiment",
            "SummarizedExperiment",
            "RangedSummarizedExperiment",
            "tibble",
            "matrix"),
        DispatchClass = "Rda",
        RDataPath = c(
            "CTdata/eh_data/GTEX_data.rda",
            "CTdata/eh_data/CCLE_data.rda",
            "CTdata/eh_data/normal_tissues_multimapping_data.rda",
            "CTdata/eh_data/DAC_treated_cells.rda",
            "CTdata/eh_data/DAC_treated_cells_multimapping.rda",
            "CTdata/eh_data/TCGA_TPM.rda",
            "CTdata/eh_data/CT_methylation_in_tissues.rda",
            "CTdata/eh_data/CT_mean_methylation_in_tissues.rda",
            "CTdata/eh_data/TCGA_CT_methylation.rda",
            "CTdata/eh_data/CT_genes.rda",
            "CTdata/eh_data/CCLE_correlation_matrix.rda"),
        Tags = c("GeneExpression:NormalTissues",
                 "GeneExpression:CancerData:CellLines",
                 "GeneExpression:NormalTissues:Multimapping",
                 "GeneExpression:CellLines:DemethylatingAgent",
                 "GeneExpression:CellLines:DemethylatingAgent:Multimapping",
                 "GeneExpression:CancerData:TumorSamples",
                 "MethylationData:CancerTestis:NormalTissues",
                 "MethylationData:CancerTestis:NormalTissues",
                 "MethylationData:CancerTestis:CancerData:TumorSamples",
                 "CancerTestis:MethylationData:GeneExpression:CancerData:NormalTissues:TumorSamples",
                 "CancerTestis:GeneExpression:CancerData:CellLines")
    )

## Add default tags
metadata$Tags <- CTdata:::makeTags(metadata$Tags)

write.csv(metadata, file = "../extdata/metadata.csv", row.names = FALSE)

pathToPkg <- "/data/cbio/Packages" ## change this accordingly

ExperimentHubData::makeExperimentHubMetadata(
                       pathToPackage = file.path(pathToPkg, "CTdata"),
                       fileName = "metadata.csv")
