## ----style, echo = FALSE, results = 'asis'------------------------------------
BiocStyle::markdown()

## ----data---------------------------------------------------------------------
library("CTdata")
DT::datatable(CTdata())

## ----install1, eval = FALSE---------------------------------------------------
#  if (!require("BiocManager"))
#      install.packages("CTdata")
#  
#  BiocManager::install("CTdata")

## ----install2, eval = FALSE---------------------------------------------------
#  if (!require("BiocManager"))
#      install.packages("BiocManager")
#  
#  BiocManager::install("UCLouvain-CBIO/CTdata")

## -----------------------------------------------------------------------------
GTEX_data()

## -----------------------------------------------------------------------------
CCLE_data()

## -----------------------------------------------------------------------------
normal_tissues_multimapping_data()

## -----------------------------------------------------------------------------
DAC_treated_cells()

## -----------------------------------------------------------------------------
DAC_treated_cells_multimapping()

## -----------------------------------------------------------------------------
TCGA_TPM()

## ---- echo = FALSE------------------------------------------------------------
ctgenes <- CT_genes()
n <- nrow(ctgenes)

## ---- echo=FALSE, fig.align='center', out.width = '100%'----------------------
knitr::include_graphics("CT_selection.svg")

## -----------------------------------------------------------------------------
CT_methylation_in_tissues()

## -----------------------------------------------------------------------------
CT_mean_methylation_in_tissues()

## -----------------------------------------------------------------------------
TCGA_CT_methylation()

## -----------------------------------------------------------------------------
dim(CCLE_correlation_matrix())
CCLE_correlation_matrix()[1:10, 1:5]

## -----------------------------------------------------------------------------
CT_genes()

## ----sessioninfo, echo=FALSE--------------------------------------------------
sessionInfo()

