## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    crop = NULL
    ## cf to https://stat.ethz.ch/pipermail/bioc-devel/2020-April/016656.html
)

## ---- fig.cap="The `scp` framework relies on `SingleCellExperiment` and `QFeatures` objects", echo=FALSE, out.width='100%', fig.align='center'----
knitr::include_graphics("./figures/SCP_framework.png")

## ---- message = FALSE---------------------------------------------------------
library(scp)
data("mqScpData")
dim(mqScpData)

## ---- echo=FALSE, out.width='60%', fig.cap="Conceptual representation of the input table", fig.align = 'center'----
knitr::include_graphics('figures/readSCP_inputTable.png')

## -----------------------------------------------------------------------------
(quantCols <- grep("Reporter.intensity.\\d", colnames(mqScpData),
                  value = TRUE))

## -----------------------------------------------------------------------------
head(mqScpData[, quantCols])

## -----------------------------------------------------------------------------
head(mqScpData[, c("Charge", "Score", "PEP", "Sequence", "Length",
                   "Retention.time", "Proteins")])

## -----------------------------------------------------------------------------
unique(mqScpData$Raw.file)

## -----------------------------------------------------------------------------
data("sampleAnnotation")
head(sampleAnnotation)

## ----echo=FALSE, out.width='60%', fig.cap="Conceptual representation of the sample table", fig.align = 'center'----
knitr::include_graphics('figures/readSCP_sampleTable.png')

## ----readSCP------------------------------------------------------------------
scp <- readSCP(featureData = mqScpData,
               colData = sampleAnnotation,
               batchCol = "Raw.file",
               channelCol = "Channel",
               suffix = paste0("_TMT", 1:16),
               removeEmptyCols = TRUE)
scp

## ----colData------------------------------------------------------------------
head(colData(scp))

## ----rowData------------------------------------------------------------------
head(rowData(scp[["190222S_LCA9_X_FP94BM"]]))[, 1:5]

## ----assay--------------------------------------------------------------------
head(assay(scp, "190222S_LCA9_X_FP94BM"))

## ----echo=FALSE, out.width='60%', fig.cap="Step1: Convert the input table to a `SingleCellExperiment` object", fig.align = 'center'----
knitr::include_graphics('figures/readSCP_step1.png')

## ----echo=FALSE, out.width='65%', fig.cap="Step2: Split by acquisition run", fig.align = 'center'----
knitr::include_graphics('figures/readSCP_step2.png')

## ----echo=FALSE, out.width='100%', fig.cap="Step3: Adding and matching the sample annotations", fig.align = 'center'----
knitr::include_graphics('figures/readSCP_step3.png')

## ----echo=FALSE, out.width='80%', fig.cap="Step4: Convert to a `QFeatures`", fig.align = 'center'----
knitr::include_graphics('figures/readSCP_step4.png')

## ----setup2, include = FALSE--------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "",
    crop = NULL
)

## ----sessioninfo, echo=FALSE--------------------------------------------------
sessionInfo()

