(function(){
  function show_loader(event){
    var id = event.target.id;
    if (id === undefined) {
      return;
    }
    $('#scRNAseqAppLoader-'+id).show();
  }
  function hide_loader(event){
    var id = event.target.id;
    if (id === undefined) {
      return;
    }
    $('#scRNAseqAppLoader-'+id).hide();
  }
  $(document).on('shiny:outputinvalidated', show_loader);
  $(document).on('shiny:bound', show_loader);
  $(document).on('shiny:value shiny:error', hide_loader);
  $(document).on('shiny:sessioninitialized', function(){
    $.getJSON("https://api.ipify.org/?format=json", function(e) {
      Shiny.setInputValue("remote_addr", e.ip);
    });
    Shiny.addCustomMessageHandler("save_key", function(value){
      let arr = value.split("|");
      localStorage.setItem(arr[0], arr[1]);
    });
    Shiny.addCustomMessageHandler("load_key", function(key){
      let value = localStorage.getItem(key);
      if(typeof(value)=="undefined") return false;
      if(value === null) return false;
      Shiny.setInputValue('default_'+key, value);
    });
    $('a[data-value="home"]').on("click", function(e) {
          e.preventDefault();
          $('a[data-value="about"]').trigger('click');
          return false;
        });
  });
}())
