## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)


## ---- eval=FALSE--------------------------------------------------------------
#  if (!require("BiocManager"))
#    install.packages("BiocManager")
#  BiocManager::install("glmSparseNet")

## ----packages, message=FALSE, warning=FALSE-----------------------------------
library(futile.logger)
library(ggplot2)
library(glmSparseNet)
library(survival)

# Some general options for futile.logger the debugging package
.Last.value <- flog.layout(layout.format('[~l] ~m'))
.Last.value <- glmSparseNet:::show.message(FALSE)
# Setting ggplot2 default theme as minimal
theme_set(ggplot2::theme_minimal())

## -----------------------------------------------------------------------------
data('cancer', package = 'survival')
xdata <- survival::ovarian[,c('age', 'resid.ds')]
ydata <- data.frame(
  time = survival::ovarian$futime,
  status = survival::ovarian$fustat
)

## -----------------------------------------------------------------------------
res.age <- separate2GroupsCox(c(age = 1, 0), xdata, ydata)

## ---- echo=FALSE--------------------------------------------------------------
res.age$km

## ---- echo=FALSE--------------------------------------------------------------
res.age$plot

## -----------------------------------------------------------------------------
res.age.40.60 <- 
  separate2GroupsCox(c(age = 1, 0), 
                     xdata, 
                     ydata, 
                     probs = c(.4, .6)
  )

## ---- echo=FALSE--------------------------------------------------------------
res.age.40.60$km

## ---- echo=FALSE--------------------------------------------------------------
res.age.40.60$plot

## -----------------------------------------------------------------------------
res.age.60.40 <- separate2GroupsCox(
  chosen.btas = c(age = 1, 0), 
  xdata, 
  ydata, 
  probs = c(.6, .4),
  stop.when.overlap = FALSE
)

## ---- echo=FALSE--------------------------------------------------------------
cat('Kaplan-Meier results','\n')
res.age.60.40$km

## ---- echo=FALSE--------------------------------------------------------------
res.age.60.40$plot

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

