/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.GenotypeEncoder;
import ciat.agrobio.core.Variant;
import ciat.agrobio.core.VariantManager;
import ciat.agrobio.io.VCFManager;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class VariantProcessor
implements Runnable {
    private static AtomicInteger variantCount = new AtomicInteger(0);
    private static AtomicInteger taskCount = new AtomicInteger(0);
    private final int id = taskCount.getAndIncrement();
    private VariantManager vm = null;
    private VCFManager vcfm = null;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;

    public static void resetCounters() {
        variantCount = new AtomicInteger(0);
        taskCount = new AtomicInteger(0);
    }

    public VariantProcessor(VariantManager vm, VCFManager vcfm, CountDownLatch startSignal, CountDownLatch doneSignal) {
        this.vm = vm;
        this.vcfm = vcfm;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
    }

    public static AtomicInteger getVariantCount() {
        return variantCount;
    }

    public void setStartSignal(CountDownLatch startSignal) {
        this.startSignal = startSignal;
    }

    public void setDoneSignal(CountDownLatch doneSignal) {
        this.doneSignal = doneSignal;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            this.startSignal.await();
            boolean done = false;
            while (!done) {
                Variant variant = this.vm.getNextVariantRaw();
                int numSamples = this.vm.getNumSamples();
                byte ploidy = this.vm.getPloidy();
                if (variant == null) {
                    if (this.vm.hasMoreRaw() || !this.vcfm.isDone()) continue;
                    done = true;
                    break;
                }
                int count = variantCount.incrementAndGet();
                if (count % 50000 == 0) {
                    System.err.println(GeneralTools.time() + " VariantProcessor: " + this.id + "\t" + count);
                }
                byte numAlleles = 0;
                int indexGT = Arrays.asList(variant.getFormat().split(":")).indexOf("GT");
                if (ploidy == 2) {
                    byte[][] variantDataRaw = variant.getDataRaw();
                    byte[] variantDataSamplesP1 = new byte[numSamples];
                    byte[] variantDataSamplesP2 = new byte[numSamples];
                    variant.setDataSamplesP1(variantDataSamplesP1);
                    variant.setDataSamplesP2(variantDataSamplesP2);
                    for (int i = 0; i < numSamples; ++i) {
                        String GT = new String(variantDataRaw[i + 9]).split(":")[indexGT];
                        byte[] GTCode = GenotypeEncoder.encodeGT(GT, ploidy);
                        variantDataSamplesP1[i] = GTCode[0];
                        variantDataSamplesP2[i] = GTCode[1];
                        if (GTCode[ploidy] <= numAlleles) continue;
                        numAlleles = GTCode[ploidy];
                    }
                } else {
                    System.err.println(" Ploidy " + ploidy + " is not yet supported.");
                    System.exit(ploidy);
                }
                variant.setNumAlleles(numAlleles);
                if (this.vm.isCleanVariantData()) {
                    variant.cleanDataRaw();
                }
                this.vm.putVariantQueue(variant);
            }
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

