/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.GeneralTools;
import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.map.hash.TLongIntHashMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;

public class Sequence {
    private final int sequenceId;
    private byte[] header;
    private byte[] seq;
    private byte[] qual;
    private String name;
    private String shortName;
    private int abundanceCluster = -1;
    private TLongIntHashMap kmerCounts;
    private int[] ranks = null;

    public Sequence(int sequenceId, byte[] header, byte[] seq) {
        this.sequenceId = sequenceId;
        this.header = header;
        this.seq = seq;
        this.kmerCounts = new TLongIntHashMap();
    }

    public Sequence(int sequenceId, byte[] header, byte[] seq, byte[] qual) {
        this.sequenceId = sequenceId;
        this.header = header;
        this.seq = seq;
        this.qual = qual;
        this.kmerCounts = new TLongIntHashMap();
    }

    public void initRanks(Map<Long, Integer> spaceRanks) {
        if (this.ranks == null) {
            long kmerCode;
            int spaceSize = spaceRanks.size();
            this.ranks = new int[spaceSize];
            TreeMap<Long, Integer> unsorted = new TreeMap<Long, Integer>();
            Object it = this.iteratorCounts();
            while (it.hasNext()) {
                it.advance();
                kmerCode = it.key();
                int kmerCount = it.value();
                unsorted.put(kmerCode, kmerCount);
            }
            it = spaceRanks.keySet().iterator();
            while (it.hasNext()) {
                kmerCode = (Long)it.next();
                if (unsorted.containsKey(kmerCode)) continue;
                unsorted.put(kmerCode, 0);
            }
            Map sorted = GeneralTools.sortByValue(unsorted);
            int current = 0;
            for (Map.Entry entry : sorted.entrySet()) {
                this.ranks[spaceRanks.get(entry.getKey()).intValue()] = current++;
            }
            unsorted.clear();
            sorted.clear();
            unsorted = null;
            sorted = null;
        }
    }

    public int[] getRanks() {
        return this.ranks;
    }

    public void insertKmerCount(long kmerCode, int count) {
        if (kmerCode < 0L) {
            return;
        }
        this.kmerCounts.adjustOrPutValue(kmerCode, count, count);
    }

    public int getCountForKmerCode(long kmerCode) {
        return this.kmerCounts.get(kmerCode);
    }

    public void clearHead() {
        this.header = null;
    }

    public void clearSeq() {
        this.seq = null;
        this.qual = null;
    }

    public void clearHeadSeq() {
        this.header = null;
        this.seq = null;
        this.qual = null;
    }

    public void clearVec() {
        if (this.kmerCounts != null) {
            this.kmerCounts.clear();
            this.kmerCounts = null;
        }
    }

    public void clearFull() {
        this.header = null;
        this.seq = null;
        this.qual = null;
        this.clearVec();
    }

    public Integer getSequenceId() {
        return this.sequenceId;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getSeq() {
        return this.seq;
    }

    public byte[] getQual() {
        return this.qual;
    }

    public String getName() {
        if (this.name == null) {
            try {
                this.name = new String(this.getHeader()).substring(1).replaceAll("[^A-Za-z0-9_\\.\\+\\-\\=\\|]", " ").replaceAll("\\s+", " ");
            }
            catch (Exception e) {
                this.name = null;
            }
        }
        return this.name;
    }

    public String getShortName() {
        if (this.shortName == null) {
            try {
                this.shortName = new String(this.getHeader()).split("\\s+")[0].substring(1).replaceAll("[^A-Za-z0-9_\\.\\+\\-\\=\\|]", " ").replaceAll("\\s+", " ");
            }
            catch (Exception e) {
                this.shortName = null;
            }
        }
        return this.shortName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.header != null) {
            sb.append(new String(this.header, StandardCharsets.UTF_8));
        }
        if (this.seq != null) {
            sb.append("\n" + new String(this.seq, StandardCharsets.UTF_8));
        }
        if (this.qual != null) {
            sb.append("\n+\n" + new String(this.qual, StandardCharsets.UTF_8));
        }
        return sb.toString();
    }

    public int getAbundanceCluster() {
        return this.abundanceCluster;
    }

    public void setAbundanceCluster(int abundanceCluster) {
        this.abundanceCluster = abundanceCluster;
    }

    public char charAt(int index) {
        return (char)(this.seq[index] & 0xFF);
    }

    public int getLength() {
        return this.seq == null ? 0 : this.seq.length;
    }

    public void addWith(Sequence other) {
        TLongIntIterator it = other.iteratorCounts();
        while (it.hasNext()) {
            it.advance();
            this.insertKmerCount(it.key(), it.value());
        }
    }

    public TLongIntIterator iteratorCounts() {
        return new MyIterator();
    }

    private class MyIterator
    implements TLongIntIterator {
        private final TLongIntIterator iterator;
        private int current;
        private boolean hasNext;

        MyIterator() {
            this.iterator = Sequence.this.kmerCounts.iterator();
            this.current = Sequence.this.kmerCounts.size();
        }

        public boolean hasNext() {
            this.hasNext = this.current > 0;
            return this.hasNext;
        }

        public void advance() {
            if (!this.hasNext) {
                return;
            }
            this.iterator.advance();
            --this.current;
        }

        public long key() {
            return this.iterator.key();
        }

        public int value() {
            return this.iterator.value();
        }

        public void remove() {
        }

        public int setValue(int arg0) {
            return 0;
        }
    }
}

