/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.GenotypeEncoder;
import ciat.agrobio.core.VariantManager;
import java.util.List;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

class CalculateDistancesChildTask
extends RecursiveAction {
    private static AtomicInteger sampleCounter = new AtomicInteger(0);
    private static AtomicInteger taskCount = new AtomicInteger(0);
    private final int id = taskCount.getAndIncrement();
    private List<String> sampleNames;
    private VariantManager vm;
    private boolean ignoreHets;
    private boolean onlyHets;
    private boolean ignoremissing;
    private double[][] distances;
    private int row;

    public static void resetCounters() {
        sampleCounter = new AtomicInteger(0);
        taskCount = new AtomicInteger(0);
    }

    public CalculateDistancesChildTask(List<String> sampleNames, VariantManager vm, boolean ignoreHets, boolean onlyHets, boolean ignoremissing, double[][] distances, int row) {
        this.sampleNames = sampleNames;
        this.vm = vm;
        this.ignoreHets = ignoreHets;
        this.onlyHets = onlyHets;
        this.ignoremissing = ignoremissing;
        this.distances = distances;
        this.row = row;
    }

    @Override
    protected void compute() {
        try {
            byte ploidy = this.vm.getPloidy();
            for (int column = this.sampleNames.size() - 1; column >= this.row; --column) {
                double distance;
                double cosine;
                double dot = 0.0;
                double notmissing = 0.0;
                double norm1 = 0.0;
                double norm2 = 0.0;
                int numVariants = this.vm.getNumVariants();
                if (ploidy != 2) continue;
                for (int i = 0; i < numVariants; ++i) {
                    byte dataS1P1 = this.vm.getSampleXvariantP1()[this.row][i];
                    byte dataS1P2 = this.vm.getSampleXvariantP2()[this.row][i];
                    byte dataS2P1 = this.vm.getSampleXvariantP1()[column][i];
                    byte dataS2P2 = this.vm.getSampleXvariantP2()[column][i];
                    if (GenotypeEncoder.isMis(dataS1P1, dataS1P2) && GenotypeEncoder.isMis(dataS2P1, dataS2P2) || this.ignoreHets && (GenotypeEncoder.isHet(dataS1P1, dataS1P2) || GenotypeEncoder.isHet(dataS2P1, dataS2P2)) || this.onlyHets && !GenotypeEncoder.isHet(dataS1P1, dataS1P2) && !GenotypeEncoder.isHet(dataS2P1, dataS2P2)) continue;
                    if (GenotypeEncoder.isMis(dataS1P1, dataS1P2)) {
                        norm2 += 1.0;
                        continue;
                    }
                    if (GenotypeEncoder.isMis(dataS2P1, dataS2P2)) {
                        norm1 += 1.0;
                        continue;
                    }
                    dot += ((dataS1P1 & dataS2P1) == 0 ? -0.5 : 0.5) + ((dataS1P2 & dataS2P2) == 0 ? -0.5 : 0.5);
                    norm1 += 1.0;
                    norm2 += 1.0;
                    notmissing += 1.0;
                }
                if (this.ignoremissing) {
                    cosine = dot / notmissing;
                    if (Double.isInfinite(cosine) || Double.isNaN(cosine)) {
                        cosine = -1.0;
                    }
                    if ((distance = (1.0 - cosine) / 2.0) < 0.0) {
                        distance = 0.0;
                    }
                    this.distances[this.row][column] = Double.parseDouble(GeneralTools.decimalFormat.format(distance));
                    this.distances[column][this.row] = this.distances[this.row][column];
                    continue;
                }
                cosine = dot / (Math.sqrt(norm1) * Math.sqrt(norm2));
                if (Double.isInfinite(cosine) || Double.isNaN(cosine)) {
                    cosine = -1.0;
                }
                if ((distance = (1.0 - cosine) / 2.0) < 0.0) {
                    distance = 0.0;
                }
                this.distances[this.row][column] = Double.parseDouble(GeneralTools.decimalFormat.format(distance));
                this.distances[column][this.row] = this.distances[this.row][column];
            }
            int count = sampleCounter.incrementAndGet();
            if (count % 50 == 0) {
                System.err.println(GeneralTools.time() + " CalculateDistancesChildTask(" + this.id + "): \t" + count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

