## ---- echo=FALSE--------------------------------------------------------------
library(BiocStyle)
self <- Githubpkg("ArtifactDB/alabaster.string")
knitr::opts_chunk$set(error=FALSE, warning=FALSE, message=FALSE)

## -----------------------------------------------------------------------------
library(Biostrings)
x <- DNAStringSet(c(seq1="CTCNACCAGTAT", seq2="TTGA", seq3="TACCTAGAG"))
mcols(x)$score <- runif(length(x))
x

library(alabaster.string)
tmp <- tempfile()
dir.create(tmp)
meta <- stageObject(x, tmp, "dna")
.writeMetadata(meta, tmp)

list.files(tmp, recursive=TRUE)

## -----------------------------------------------------------------------------
meta <- acquireMetadata(tmp, "dna/set.json")
roundtrip <- loadObject(meta, tmp)
class(roundtrip)

## -----------------------------------------------------------------------------
x <- DNAStringSet(c("TTGA", "CTCN"))
q <- PhredQuality(c("*+,-", "6789"))
y <- QualityScaledDNAStringSet(x, q)

library(alabaster.string)
tmp <- tempfile()
dir.create(tmp)
meta <- stageObject(y, tmp, "dna2")

roundtrip <- loadObject(meta, tmp)
class(roundtrip)

## -----------------------------------------------------------------------------
sessionInfo()

