## ---- echo=FALSE--------------------------------------------------------------
knitr::opts_chunk$set(error=FALSE, warning=FALSE, message=FALSE)
library(BiocStyle)
self <- Githubpkg("ArtifactDB/alabaster.spatial")

## -----------------------------------------------------------------------------
library(SpatialExperiment)
example(read10xVisium, echo=FALSE)

# Making the column names unique.
colnames(spe) <- make.unique(colnames(spe))

spe

## -----------------------------------------------------------------------------
library(alabaster.spatial)

tmp <- tempfile()
dir.create(tmp, showWarnings=FALSE)
meta <- stageObject(spe, dir=tmp, "spe", stage.only=TRUE)
.writeMetadata(meta, tmp)

list.files(tmp, recursive=TRUE)

## -----------------------------------------------------------------------------
remeta <- acquireMetadata(tmp, "spe/experiment.json")
roundtrip <- loadObject(remeta, tmp)
spe2
plot(imgRaster(getImg(spe2, "section1")))

## -----------------------------------------------------------------------------
sessionInfo()

