## ---- echo=FALSE--------------------------------------------------------------
library(BiocStyle)
self <- Githubpkg("ArtifactDB/alabaster.ranges")
knitr::opts_chunk$set(error=FALSE, warning=FALSE, message=FALSE)

## -----------------------------------------------------------------------------
library(GenomicRanges)
gr <- GRanges("chrA", IRanges(sample(100), width=sample(100)))
mcols(gr)$score <- runif(length(gr))
metadata(gr)$genome <- "Aaron"
seqlengths(gr) <- c(chrA=1000)

library(alabaster.ranges)
tmp <- tempfile()
dir.create(tmp)
meta <- stageObject(gr, tmp, "gr")
.writeMetadata(meta, tmp)

list.files(tmp, recursive=TRUE)

## -----------------------------------------------------------------------------
meta <- acquireMetadata(tmp, "gr/ranges.csv.gz")
roundtrip <- loadObject(meta, tmp)
class(roundtrip)

## -----------------------------------------------------------------------------
metadata(roundtrip)
mcols(roundtrip)
seqinfo(roundtrip)

## -----------------------------------------------------------------------------
sessionInfo()

