/*
 * Decompiled with CFR 0.152.
 */
package reder.application.io;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import reder.application.GraphTask;

public class ExportImage {
    private JPanel exportpanel = null;
    private static double scale;
    private String ioFileType;
    private String saveAddress;
    private String taskProgress;

    public ExportImage() {
        scale = 1.0;
        this.taskProgress = "running";
    }

    public String getProgress() {
        return this.taskProgress;
    }

    public void inputAndGo(GraphTask drawpanel, double scaleIn, String saveAddress, String ioFileType) throws IOException {
        this.exportpanel = drawpanel;
        scale = scaleIn;
        this.ioFileType = ioFileType;
        this.saveAddress = saveAddress;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals(this.ioFileType)) {
            this.saveAddress = saveAddress + "." + ioFileType;
        }
        try {
            this.printImage();
            this.taskProgress = "endload";
        }
        catch (IOException ex) {
            this.taskProgress = "halt";
        }
    }

    public void printImage() throws IOException {
        int scaleW = (int)((double)this.exportpanel.getWidth() * scale);
        int scaleH = (int)((double)this.exportpanel.getHeight() * scale);
        BufferedImage image = new BufferedImage(scaleW, scaleH, 4);
        Graphics2D g = image.createGraphics();
        g.scale(scale, scale);
        this.exportpanel.printAll(g);
        this.exportpanel.printComponents(g);
        g.dispose();
        switch (this.ioFileType) {
            case "bmp": {
                ImageIO.write((RenderedImage)image, "BMP", new File(this.saveAddress));
                break;
            }
            case "jpg": {
                ImageIO.write((RenderedImage)image, "JPEG", new File(this.saveAddress));
                break;
            }
            default: {
                ImageIO.write((RenderedImage)image, "PNG", new File(this.saveAddress));
            }
        }
    }
}

