/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reder.application.RederMainFrame;
import reder.application.graph.EdgeBank;
import reder.application.graph.NodeBank;

public class RedHandler {
    public int updateGraph() {
        RederMainFrame.updateGraph();
        return 1;
    }

    public int deSelectGraph() {
        this.deSelectNodes();
        this.deSelectEdges();
        return 1;
    }

    public int deSelectNodes() {
        RederMainFrame.methods.deSelectNodes();
        return 1;
    }

    public int deSelectEdges() {
        RederMainFrame.methods.deSelectEdges();
        return 1;
    }

    public int selectAllEdges() {
        RederMainFrame.methods.selectAllEdges();
        return 1;
    }

    public int selectAllNodes() {
        RederMainFrame.methods.selectAllNodes();
        return 1;
    }

    public int selectGraph() {
        RederMainFrame.methods.selectGraph();
        return 1;
    }

    public int selectEdges(String nodeA, String nodeB) {
        RederMainFrame.methods.selectEdge(nodeA, nodeB);
        return 1;
    }

    public int selectEdges(List<String> edges) {
        float t2;
        boolean c;
        float t1 = edges.size();
        boolean bl = c = t1 == (t2 = (float)Math.round(t1 / 2.0f)) * 2.0f;
        if (c) {
            for (int i = 0; i < edges.size(); i += 2) {
                String nodeA = edges.get(i);
                String nodeB = edges.get(i + 1);
                RederMainFrame.methods.selectEdge(nodeA, nodeB);
            }
        } else {
            return 0;
        }
        return 1;
    }

    public int selectNodeString(String nodeA, String anchor, String nt) {
        if (nt.equals("")) {
            nt = null;
        }
        RederMainFrame.methods.zoomNodeFilter(nodeA, nt);
        return 1;
    }

    public int selectNodeList(List<String> nodes, String anchor, String nt) {
        if (nt.equals("")) {
            nt = null;
        }
        int cont = 0;
        int sz = nodes.size();
        for (int i = 0; i < sz; ++i) {
            String strNodeID = nodes.get(i);
            int test = RederMainFrame.methods.selectNode(strNodeID, nt, anchor.equals("true"));
            if (test != 1) continue;
            ++cont;
        }
        RederMainFrame.methods.globalChangeOrder("forward");
        RederMainFrame.methods.taskHighlight();
        return cont;
    }

    public int addNodes(List<String> nodes) {
        int cont = 0;
        int sz = nodes.size();
        this.lockInteract();
        for (int i = 0; i < sz; ++i) {
            String strNodeID = nodes.get(i);
            boolean flag = false;
            for (NodeBank a : RederMainFrame.NodeList) {
                if (!a.getNodeID().equals(strNodeID)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            int intNodeID = RederMainFrame.NodeList.size();
            RederMainFrame.NodeList.add(new NodeBank(strNodeID, intNodeID));
            RederMainFrame.keyNodeHash.put(strNodeID, intNodeID);
            RederMainFrame.keyNodeArray.add(strNodeID);
            ++cont;
            Pattern pt = Pattern.compile("(.)*(\\<\\$\\$\\>)(.)*");
            Matcher mt = pt.matcher(strNodeID);
            if (!mt.matches()) continue;
            RederMainFrame.NodeList.get(RederMainFrame.NodeList.size() - 1).setAsMock();
        }
        this.unLockInteract();
        return cont;
    }

    public int addNodesNumeric(List<Double> nodes) {
        int cont = 0;
        int sz = nodes.size();
        this.lockInteract();
        for (int i = 0; i < sz; ++i) {
            String strNodeID = Double.toString(nodes.get(i));
            boolean flag = false;
            for (NodeBank a : RederMainFrame.NodeList) {
                if (!a.getNodeID().equals(strNodeID)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            int intNodeID = RederMainFrame.NodeList.size();
            RederMainFrame.NodeList.add(new NodeBank(strNodeID, intNodeID));
            RederMainFrame.keyNodeHash.put(strNodeID, intNodeID);
            RederMainFrame.keyNodeArray.add(strNodeID);
            ++cont;
        }
        this.unLockInteract();
        return cont;
    }

    public int addNodes(String node) {
        String strNodeID = node;
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(strNodeID)) continue;
            return 0;
        }
        int intNodeID = RederMainFrame.NodeList.size();
        RederMainFrame.NodeList.add(new NodeBank(strNodeID, intNodeID));
        RederMainFrame.keyNodeHash.put(strNodeID, intNodeID);
        RederMainFrame.keyNodeArray.add(strNodeID);
        return 1;
    }

    public int addNodesNumeric(double node) {
        String strNodeID = Double.toString(node);
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(strNodeID)) continue;
            return 0;
        }
        int intNodeID = RederMainFrame.NodeList.size();
        RederMainFrame.NodeList.add(new NodeBank(strNodeID, intNodeID));
        RederMainFrame.keyNodeHash.put(strNodeID, intNodeID);
        RederMainFrame.keyNodeArray.add(strNodeID);
        return 1;
    }

    public int assignTree() {
        RederMainFrame.methods.assignTreePermanently();
        return 1;
    }

    public String nestpackexpress(List<String> nodes, List<String> status, List<String> charAtt, List<Double> numAtt, List<Double> nestmap) {
        int v1 = 0;
        int v2 = 0;
        int v3 = 0;
        int v4 = 0;
        for (int i = 0; i < nestmap.size(); ++i) {
            int j;
            ArrayList<String> unpacknodes = new ArrayList<String>();
            ArrayList<String> unpackstatus = new ArrayList<String>();
            ArrayList<String> unpackcharAtt = new ArrayList<String>();
            ArrayList<Double> unpacknumAtt = new ArrayList<Double>();
            unpacknodes.clear();
            unpackstatus.clear();
            unpackcharAtt.clear();
            unpacknumAtt.clear();
            double nn = nestmap.get(i);
            for (j = 0; j < (int)nn; ++j) {
                unpacknodes.add(nodes.get(v1));
                ++v1;
            }
            for (j = 0; j < 3; ++j) {
                unpackstatus.add(status.get(v2));
                ++v2;
            }
            for (j = 0; j < 6; ++j) {
                unpackcharAtt.add(charAtt.get(v3));
                ++v3;
            }
            for (j = 0; j < 8; ++j) {
                unpacknumAtt.add(numAtt.get(v4));
                ++v4;
            }
            this.nestexpress(unpacknodes, unpackstatus, unpackcharAtt, unpacknumAtt);
        }
        return "Done!";
    }

    public String nestexpress(List<String> nodes, List<String> status, List<String> charAtt, List<Double> numAtt) {
        String status1 = status.get(0);
        String status2 = status.get(1);
        String status3 = status.get(2);
        String retorno = this.nestNodes(nodes, status1, status2, status3, charAtt, numAtt);
        return retorno;
    }

    public String nestNodes(List<String> nodes, String status1, String status2, String status3, List<String> charAtt, List<Double> numAtt) {
        String retorno;
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        RederMainFrame.methods.stopRelax();
        block16: for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < RederMainFrame.NodeList.size(); ++j) {
                NodeBank nodeAccount = RederMainFrame.NodeList.get(j);
                if (!nodeAccount.getNodeID().equals(nodes.get(i))) continue;
                listaMarcados.add(j);
                continue block16;
            }
        }
        if (listaMarcados.size() > 0) {
            boolean setHide = false;
            boolean setTransparency = false;
            boolean setAnchor = false;
            boolean setAssigned = false;
            if (status1 != null) {
                switch (status1) {
                    case "hide": {
                        setHide = true;
                        setAnchor = true;
                        break;
                    }
                    case "transparent": {
                        setTransparency = true;
                        break;
                    }
                    case "plain": {
                        setHide = false;
                        setTransparency = false;
                        break;
                    }
                }
            }
            if (status2 != null && status2.equals("anchor")) {
                setAnchor = true;
            }
            if (status3 != null && status3.equals("assign")) {
                setAssigned = true;
            }
            if (!(retorno = RederMainFrame.methods.aninhar(listaMarcados, RederMainFrame.methods.HexToColor("E6E6FFFF"), setHide, setTransparency, setAnchor, setAssigned)).contains("inconsistent")) {
                int cId = (Integer)RederMainFrame.keyNodeHash.get(retorno);
                NodeBank cAccount = RederMainFrame.NodeList.get(cId);
                for (int i = 0; i < charAtt.size(); ++i) {
                    Color attc2;
                    String att = charAtt.get(i);
                    if (att.contains("<$$>")) continue;
                    if (i == 0) {
                        cAccount.setAliases(att);
                    }
                    if (i == 1) {
                        cAccount.setNodeShape(att);
                    }
                    if (i == 2) {
                        cAccount.setNodeLineType(att);
                    }
                    if (i == 3) {
                        try {
                            attc2 = RederMainFrame.methods.HexToColor(att);
                            cAccount.setNodeColor(attc2);
                        }
                        catch (NumberFormatException attc2) {
                            // empty catch block
                        }
                    }
                    if (i == 4) {
                        try {
                            attc2 = RederMainFrame.methods.HexToColor(att);
                            cAccount.setNodeLineColor(attc2);
                        }
                        catch (NumberFormatException attc3) {
                            // empty catch block
                        }
                    }
                    if (i != 5) continue;
                    try {
                        attc2 = RederMainFrame.methods.HexToColor(att);
                        cAccount.setFontColor(attc2);
                        continue;
                    }
                    catch (NumberFormatException attc4) {
                        // empty catch block
                    }
                }
                double xtree = 909192.0;
                double ytree = 909192.0;
                for (int i = 0; i < numAtt.size(); ++i) {
                    int rt;
                    double natt = numAtt.get(i);
                    if (i == 0) {
                        cAccount.setFontOffsetX((float)natt);
                    }
                    if (i == 1) {
                        cAccount.setFontOffsetY((float)natt);
                    }
                    if (i == 2 && natt >= 0.0) {
                        cAccount.setFontSize((int)natt);
                    }
                    if (i == 3 && natt >= 0.0) {
                        cAccount.setNodeLineWidth((float)natt);
                    }
                    if (i == 4 && natt > 0.0) {
                        cAccount.setNodeSize((float)natt);
                        cAccount.updateContent();
                    } else if (i == 5 && natt > 0.0) {
                        rt = cAccount.getNestedAssignmentIndx();
                        if (rt >= 0) {
                            float rtsz = RederMainFrame.NodeList.get(rt).getNodeSizeScale();
                            natt = natt / 100.0 * (double)rtsz;
                            cAccount.setNodeSizeScale((float)natt);
                        } else {
                            double zz = RederMainFrame.getZoom();
                            double hh = RederMainFrame.getSmallViewArea().getHeight();
                            double ww = RederMainFrame.getSmallViewArea().getWidth();
                            float rtsz = (float)(Math.min(hh, ww) / 20.0 / zz);
                            natt = natt / 100.0 * (double)rtsz;
                            cAccount.setNodeSizeScale((float)natt);
                        }
                        cAccount.updateContent();
                    }
                    if (i == 6 && natt != 909192.0) {
                        double nw;
                        double nx;
                        rt = cAccount.getNestedAssignmentIndx();
                        if (rt >= 0) {
                            nx = RederMainFrame.NodeList.get(rt).getX();
                            nw = (double)RederMainFrame.NodeList.get(rt).getW() * RederMainFrame.getZoom();
                            xtree = nx - nw / 2.0 + natt / 100.0 * nw;
                        } else {
                            nx = RederMainFrame.getCentroX();
                            nw = RederMainFrame.drawpanel.getWidth();
                            xtree = nx - nw / 2.0 + natt / 100.0 * nw;
                        }
                    } else if (i == 7 && natt != 909192.0) {
                        double nh;
                        rt = cAccount.getNestedAssignmentIndx();
                        if (rt >= 0) {
                            double ny = RederMainFrame.NodeList.get(rt).getY();
                            nh = (double)RederMainFrame.NodeList.get(rt).getH() * RederMainFrame.getZoom();
                            ytree = ny - nh / 2.0 + natt / 100.0 * nh;
                        } else {
                            double ny = RederMainFrame.getCentroY();
                            nh = RederMainFrame.drawpanel.getHeight();
                            ytree = ny - nh / 2.0 + natt / 100.0 * nh;
                        }
                    }
                    if (xtree == 909192.0 || ytree == 909192.0) continue;
                    cAccount.moveTree((float)xtree, (float)ytree);
                }
            }
        } else {
            retorno = "Your request is inconsistent with the hierarchy (or null)!";
        }
        return retorno;
    }

    public int updateContainerSize() {
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            boolean c2;
            NodeBank nodeAccount = RederMainFrame.NodeList.get(i);
            boolean c1 = nodeAccount.isContainer();
            boolean bl = c2 = nodeAccount.getContainerComponents().size() > 0;
            if (!(c1 & c2)) continue;
            nodeAccount.updateContainer();
        }
        return 1;
    }

    public int mergeContainerOutEdges(List<String> containers, String rescale) {
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        block0: for (int i = 0; i < containers.size(); ++i) {
            for (int j = 0; j < RederMainFrame.NodeList.size(); ++j) {
                NodeBank containerAccount = RederMainFrame.NodeList.get(j);
                if (!containerAccount.isContainer() || !containerAccount.getNodeID().equals(containers.get(i))) continue;
                listaMarcados.add(j);
                continue block0;
            }
        }
        if (listaMarcados.size() > 0) {
            RederMainFrame.methods.mergeContainerOutEdges(listaMarcados);
            if (rescale.equals("true")) {
                RederMainFrame.methods.correctOutEdgeWidth(0.75);
            }
            return 1;
        }
        return 0;
    }

    public int mergeContainerOutEdges(String rescale, Double lb, Double ub) {
        boolean isCustomBT;
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            NodeBank nodeAccount = RederMainFrame.NodeList.get(i);
            if (!nodeAccount.isContainer()) continue;
            listaMarcados.add(i);
        }
        boolean bl = isCustomBT = lb >= 0.0 && lb < ub;
        if (listaMarcados.size() > 0) {
            RederMainFrame.methods.mergeContainerOutEdges(listaMarcados);
            if (rescale.equals("true") && !isCustomBT) {
                RederMainFrame.methods.correctOutEdgeWidth(0.75);
            } else if (isCustomBT) {
                RederMainFrame.methods.correctOutEdgeWidth(lb, ub);
            }
            this.updateGraph();
            return 1;
        }
        return 0;
    }

    public ArrayList<String> getContainerComponets(String ref) {
        ArrayList<String> array = new ArrayList<String>();
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(ref)) continue;
            for (Integer b : a.getContainerComponents()) {
                array.add(RederMainFrame.NodeList.get(b).getNodeID());
            }
            return array;
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public String mergeNodes(List<String> nodes) {
        for (NodeBank a : RederMainFrame.NodeList) {
            a.setDestaque(false);
        }
        ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
        listaMarcados.clear();
        boolean flag = false;
        String aviso = "Done!";
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < RederMainFrame.NodeList.size(); ++j) {
                NodeBank nodeAccount = RederMainFrame.NodeList.get(j);
                if (!nodeAccount.getNodeID().equals(nodes.get(i))) continue;
                if (!flag && (nodeAccount.isNodeNested() || nodeAccount.isContainer())) {
                    flag = true;
                    aviso = "Groups can no be created with nested objects!";
                    break;
                }
                listaMarcados.add(j);
                nodeAccount.setDestaque(true);
                break;
            }
            if (flag) break;
        }
        if (listaMarcados.size() > 1 && !flag) {
            RederMainFrame.methods.combinar(listaMarcados, new Color(255, 102, 102));
        }
        listaMarcados.clear();
        return aviso;
    }

    public int deleteNodes(List<String> nodes) {
        for (NodeBank a : RederMainFrame.NodeList) {
            a.setDestaque(false);
        }
        ArrayList listaMarcados = new ArrayList();
        listaMarcados.clear();
        int cont = 0;
        block1: for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < RederMainFrame.NodeList.size(); ++j) {
                NodeBank nodeAccount = RederMainFrame.NodeList.get(j);
                if (!nodeAccount.getNodeID().equals(nodes.get(i))) continue;
                nodeAccount.setDestaque(true);
                ++cont;
                continue block1;
            }
        }
        RederMainFrame.methods.globalActionDeleteNode();
        return cont;
    }

    public int deleteNodes(String node) {
        for (NodeBank a : RederMainFrame.NodeList) {
            a.setDestaque(false);
        }
        ArrayList listaMarcados = new ArrayList();
        listaMarcados.clear();
        int cont = 0;
        for (int j = 0; j < RederMainFrame.NodeList.size(); ++j) {
            NodeBank nodeAccount = RederMainFrame.NodeList.get(j);
            if (!nodeAccount.getNodeID().equals(node)) continue;
            nodeAccount.setDestaque(true);
            ++cont;
            break;
        }
        RederMainFrame.methods.globalActionDeleteNode();
        return cont;
    }

    public int deleteSelectedNodes() {
        RederMainFrame.methods.globalActionDeleteNode();
        return 1;
    }

    public double getPanelScale() {
        double hh = RederMainFrame.getSmallViewArea().getHeight();
        double ww = RederMainFrame.getSmallViewArea().getWidth();
        double scale = Math.min(hh, ww) / RederMainFrame.getZoom();
        return scale;
    }

    public double getZoom() {
        double scale = RederMainFrame.getZoom() * 100.0;
        return scale;
    }

    public Integer getNodeListSize() {
        return RederMainFrame.NodeList.size();
    }

    public Integer getEdgeListSize() {
        return RederMainFrame.EdgeList.size();
    }

    public ArrayList<String> getNodes(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getNodeID());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getNodeIDs(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getFinalID());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getNodeStackPosition(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            NodeBank nodeAccount = RederMainFrame.NodeList.get(i);
            if (!type.equals("node") ? type.equals("container") && !nodeAccount.isContainer() : nodeAccount.isContainer()) continue;
            if (status.equals("selected") ? !nodeAccount.getDestaque() : status.equals("nonselected") && nodeAccount.getDestaque()) continue;
            array.add(i);
        }
        return array;
    }

    public ArrayList<String> getNodeAliases(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getAliases());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeAlias(double id, String att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setAliases(att);
            return 1;
        }
        return 0;
    }

    public int setNodeAlias(String id, String att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setAliases(att);
            return 1;
        }
        return 0;
    }

    public int setNodeAlias(List<String> node, List<String> att) {
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeAlias(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeX(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        RederMainFrame.methods.zeraZoom();
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getXtoSave()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Double> getNodeY(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        RederMainFrame.methods.zeraZoom();
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getYtoSave()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeXY(String id, double x, double y) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNode((float)x, (float)y);
            return 1;
        }
        return 0;
    }

    public int setNodeXY(double id, double x, double y) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNode((float)x, (float)y);
            return 1;
        }
        return 0;
    }

    public int setNodeXY(List<String> node, List<Double> x, List<Double> y) {
        boolean c3;
        boolean c1 = node.size() != x.size();
        boolean c2 = node.size() != y.size();
        boolean bl = c3 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2 || c3) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeXY(node.get(i), (double)x.get(i), (double)y.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeW(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getW()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Double> getNodeH(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getH()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Double> getNodeBend(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getNodeBend()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeBend(double id, double att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeBend((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeBend(String id, double att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeBend((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeBend(List<String> node, List<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeBend(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeSize(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getNodeSize()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeSize(double id, double att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeSize((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeSize(String id, double att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeSize((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeSize(List<String> node, List<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeSize(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeShape(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getNodeShape());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeShape(double id, String att) {
        boolean b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", att);
        if (!b) {
            return 0;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeShape(att);
            return 1;
        }
        return 0;
    }

    public int setNodeShape(String id, String att) {
        boolean b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", att);
        if (!b) {
            return 0;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeShape(att);
            return 1;
        }
        return 0;
    }

    public int setNodeShape(List<String> node, List<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeShape(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeLineType(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getNodeLineType());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeLineType(double id, String att) {
        boolean b = Pattern.matches("SOLID|DASHED|LONG_DASH|DOTTED", att);
        if (!b) {
            return 0;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeLineType(att);
            return 1;
        }
        return 0;
    }

    public int setNodeLineType(String id, String att) {
        boolean b = Pattern.matches("SOLID|DASHED|LONG_DASH|DOTTED", att);
        if (!b) {
            return 0;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeLineType(att);
            return 1;
        }
        return 0;
    }

    public int setNodeLineType(List<String> node, List<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeLineType(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeColor(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            String s = String.format("#%06X", 0xFFFFFF & a.getFillColor().getRGB()).toUpperCase();
            array.add(s);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeColor(double id, String att) {
        Color attc = new Color(255, 102, 102);
        try {
            attc = RederMainFrame.methods.HexToColor(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeColor(String id, String att) {
        Color attc = new Color(255, 102, 102);
        try {
            attc = RederMainFrame.methods.HexToColor(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeColor(List<String> node, List<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeColor(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeLineWidth(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getNodeLineWidth()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeLineWidth(double id, double att) {
        if (att < 0.0) {
            return 0;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeLineWidth((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeLineWidth(String id, double att) {
        if (att < 0.0) {
            return 0;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeLineWidth((float)att);
            return 1;
        }
        return 0;
    }

    public int setNodeLineWidth(List<String> node, List<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            if (att.get(i) < 0.0) continue;
            this.setNodeLineWidth(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeLineColor(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            String s = String.format("#%06X", 0xFFFFFF & a.getNodeLineColor().getRGB()).toUpperCase();
            array.add(s);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeLineColor(double id, String att) {
        Color attc = new Color(255, 0, 0);
        try {
            attc = RederMainFrame.methods.HexToColor(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setNodeLineColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeLineColor(String id, String att) {
        Color attc = new Color(255, 0, 0);
        try {
            attc = RederMainFrame.methods.HexToColor(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeLineColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeLineColor(List<String> node, List<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeLineColor(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeFontName(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getFont().getFontName());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontName(double id, String att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            Font font = new Font(att, a.getFont().getStyle(), a.getFontSize());
            a.setFont(font);
            return 1;
        }
        return 0;
    }

    public int setNodeFontName(String id, String att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            Font font = new Font(att, a.getFont().getStyle(), a.getFontSize());
            a.setFont(font);
            return 1;
        }
        return 0;
    }

    public int setNodeFontName(List<String> node, List<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeFontName(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Integer> getNodeFontStyle(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getFont().getStyle());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontStyle(double id, double att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            Font font = new Font(a.getFont().getName(), (int)att, a.getFontSize());
            a.setFont(font);
            return 1;
        }
        return 0;
    }

    public int setNodeFontStyle(String id, double att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            Font font = new Font(a.getFont().getName(), (int)att, a.getFontSize());
            a.setFont(font);
            return 1;
        }
        return 0;
    }

    public int setNodeFontStyle(List<String> node, List<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeFontStyle(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<Integer> getNodeFontSize(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getFont().getSize());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontSize(double id, double att) {
        if (att < 0.0) {
            return 0;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setFontSize((int)att);
            return 1;
        }
        return 0;
    }

    public int setNodeFontSize(String id, double att) {
        if (att < 0.0) {
            return 0;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setFontSize((int)att);
            return 1;
        }
        return 0;
    }

    public int setNodeFontSize(List<String> node, List<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            if (att.get(i) < 0.0) continue;
            this.setNodeFontSize(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getNodeFontColor(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            String s = String.format("#%06X", 0xFFFFFF & a.getNodeFontColor().getRGB()).toUpperCase();
            array.add(s);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontColor(double id, String att) {
        Color attc = new Color(51, 51, 51);
        try {
            attc = RederMainFrame.methods.HexToColor(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != (int)id) continue;
            a.setFontColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeFontColor(String id, String att) {
        Color attc = new Color(51, 51, 51);
        try {
            attc = RederMainFrame.methods.HexToColor(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setFontColor(attc);
            return 1;
        }
        return 0;
    }

    public int setNodeFontColor(List<String> node, List<String> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeFontColor(node.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeFontX(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getFontOffsetX()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Double> getNodeFontY(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(Double.valueOf(a.getFontOffsetY()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeFontXY(int id, double x, double y) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != id) continue;
            a.setFontOffsetX((float)x);
            a.setFontOffsetY((float)y);
            return 1;
        }
        return 0;
    }

    public int setNodeFontXY(String id, double x, double y) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setFontOffsetX((float)x);
            a.setFontOffsetY((float)y);
            return 1;
        }
        return 0;
    }

    public int setNodeFontXY(List<String> node, List<Double> x, List<Double> y) {
        boolean c3;
        boolean c1 = node.size() != x.size();
        boolean c2 = node.size() != y.size();
        boolean bl = c3 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2 || c3) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeFontXY(node.get(i), (double)x.get(i), (double)y.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getNodeWeight(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isContainer() : a.isContainer()) continue;
            if (status.equals("selected") ? !a.getDestaque() : status.equals("nonselected") && a.getDestaque()) continue;
            array.add(a.getNodeWeight());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setNodeWeight(int id, double att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (a.getFinalID() != id) continue;
            a.setNodeWeight(att);
            return 1;
        }
        return 0;
    }

    public int setNodeWeight(String id, double att) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(id)) continue;
            a.setNodeWeight(att);
            return 1;
        }
        return 0;
    }

    public int setNodeWeight(List<String> node, List<Double> att) {
        boolean c2;
        boolean c1 = node.size() != att.size();
        boolean bl = c2 = node.size() > RederMainFrame.NodeList.size();
        if (c1 || c2) {
            return 0;
        }
        for (int i = 0; i < node.size(); ++i) {
            this.setNodeWeight(node.get(i), (double)att.get(i));
        }
        return 1;
    }

    public int addEdgesFastload(List<String> nodesA, List<String> nodesB) {
        boolean c = nodesA.size() == nodesB.size();
        this.lockInteract();
        if (c) {
            int size = nodesA.size();
            ArrayList<EdgeBank> localList = new ArrayList<EdgeBank>();
            int cont = 0;
            for (int i = 0; i < size; ++i) {
                int numeroB;
                String nodeA = nodesA.get(i);
                String nodeB = nodesB.get(i);
                int numeroA = (Integer)RederMainFrame.keyNodeHash.get(nodeA);
                if (numeroA == (numeroB = ((Integer)RederMainFrame.keyNodeHash.get(nodeB)).intValue())) continue;
                boolean flagFound = false;
                for (EdgeBank a : RederMainFrame.EdgeList) {
                    if ((a.getA() != numeroA || a.getB() != numeroB) && (a.getA() != numeroB || a.getB() != numeroA)) continue;
                    flagFound = true;
                    break;
                }
                if (flagFound) continue;
                int ordId = RederMainFrame.EdgeList.size() + localList.size();
                localList.add(new EdgeBank(numeroA, numeroB, ordId));
                ++cont;
            }
            if (cont > 0) {
                RederMainFrame.EdgeList.addAll(localList);
                RederMainFrame.methods.updateBanks();
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.unLockInteract();
        return 1;
    }

    public int addEdgesFastload(List<String> edges) {
        float t2;
        float t1 = edges.size();
        boolean c = t1 == (t2 = (float)Math.round(t1 / 2.0f)) * 2.0f;
        this.lockInteract();
        if (c) {
            ArrayList<EdgeBank> localList = new ArrayList<EdgeBank>();
            int cont = 0;
            for (int i = 0; i < edges.size(); i += 2) {
                int numeroB;
                String nodeA = edges.get(i);
                String nodeB = edges.get(i + 1);
                int numeroA = (Integer)RederMainFrame.keyNodeHash.get(nodeA);
                if (numeroA == (numeroB = ((Integer)RederMainFrame.keyNodeHash.get(nodeB)).intValue())) continue;
                boolean flagFound = false;
                for (EdgeBank a : RederMainFrame.EdgeList) {
                    if ((a.getA() != numeroA || a.getB() != numeroB) && (a.getA() != numeroB || a.getB() != numeroA)) continue;
                    flagFound = true;
                    break;
                }
                if (flagFound) continue;
                int ordId = RederMainFrame.EdgeList.size() + localList.size();
                localList.add(new EdgeBank(numeroA, numeroB, ordId));
                ++cont;
            }
            if (cont > 0) {
                RederMainFrame.EdgeList.addAll(localList);
                RederMainFrame.methods.updateBanks();
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.unLockInteract();
        return 1;
    }

    public int addEdges(List<String> edges) {
        float t2;
        float t1 = edges.size();
        boolean c = t1 == (t2 = (float)Math.round(t1 / 2.0f)) * 2.0f;
        this.lockInteract();
        if (c) {
            for (int i = 0; i < edges.size(); i += 2) {
                String nodeA = edges.get(i);
                String nodeB = edges.get(i + 1);
                RederMainFrame.methods.addEdgesAndNodes(nodeA, nodeB, true);
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.unLockInteract();
        return 1;
    }

    public int addEdges(String nodeA, String nodeB) {
        RederMainFrame.methods.addEdgesAndNodes(nodeA, nodeB, true);
        return 1;
    }

    public int addEdgesNumeric(double nodeA, double nodeB) {
        String na = Double.toString(nodeA);
        String nb = Double.toString(nodeB);
        RederMainFrame.methods.addEdgesAndNodes(na, nb, true);
        return 1;
    }

    public int addEdgesNumeric(List<Double> edges) {
        float t2;
        float t1 = edges.size();
        boolean c = t1 == (t2 = (float)Math.round(t1 / 2.0f)) * 2.0f;
        this.lockInteract();
        if (c) {
            for (int i = 0; i < edges.size(); i += 2) {
                String nodeA = Double.toString(edges.get(i));
                String nodeB = Double.toString(edges.get(i + 1));
                RederMainFrame.methods.addEdgesAndNodes(nodeA, nodeB, true);
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.unLockInteract();
        return 1;
    }

    public int addEdgeBetweenContainers(String containerA, String containerB) {
        boolean c1 = RederMainFrame.keyNodeHash.containsKey(containerA);
        boolean c2 = RederMainFrame.keyNodeHash.containsKey(containerB);
        if (c1 && c2) {
            RederMainFrame.methods.addEdgesAndNodes(containerA, containerB, false);
            return 1;
        }
        return 0;
    }

    public int deleteEdges(String nodeA, String nodeB) {
        RederMainFrame.methods.deSelectEdges();
        RederMainFrame.methods.selectEdge(nodeA, nodeB);
        this.deleteSelectedEdges();
        return 1;
    }

    public int deleteEdges(List<String> edges) {
        RederMainFrame.methods.deSelectEdges();
        float t1 = edges.size();
        float t2 = Math.round(t1 / 2.0f);
        boolean c = t1 == t2 * 2.0f;
        this.lockInteract();
        if (c) {
            for (int i = 0; i < edges.size(); i += 2) {
                String nodeA = edges.get(i);
                String nodeB = edges.get(i + 1);
                RederMainFrame.methods.selectEdge(nodeA, nodeB);
            }
        } else {
            this.unLockInteract();
            return 0;
        }
        this.deleteSelectedEdges();
        this.unLockInteract();
        return 1;
    }

    public int deleteSelectedEdges() {
        RederMainFrame.methods.deleteSelectedEdges();
        return 1;
    }

    public ArrayList<String> getEdges(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                boolean ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                boolean bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                boolean ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                boolean bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            String nodeA = RederMainFrame.NodeList.get(a.getA()).getNodeID();
            String nodeB = RederMainFrame.NodeList.get(a.getB()).getNodeID();
            array.add(nodeA);
            array.add(nodeB);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getEdgeIDs(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getA());
            array.add(a.getB());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<String> getSourceEdges(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                boolean ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                boolean ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            String nodeA = RederMainFrame.NodeList.get(a.getA()).getNodeID();
            array.add(nodeA);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getSourceEdgeIDs(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getA());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<String> getTargetEdges(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                boolean ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                boolean ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            String nodeB = RederMainFrame.NodeList.get(a.getB()).getNodeID();
            array.add(nodeB);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getTargetEdgeIDs(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getB());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public ArrayList<Integer> getArrowDirection(String type, String status) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getArrowDirection());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setArrowDirection(String nodeA, String nodeB, double att) {
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = RederMainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = RederMainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setArrowDirection((int)att);
            return 1;
        }
        return 0;
    }

    public int setArrowDirection(List<String> nodeA, List<String> nodeB, List<Double> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setArrowDirection(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getEdgeWidth(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(Double.valueOf(a.getWidth()));
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setEdgeWidth(String nodeA, String nodeB, double att) {
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = RederMainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = RederMainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setLineWidth((float)att);
            return 1;
        }
        return 0;
    }

    public int setEdgeWidth(List<String> nodeA, List<String> nodeB, List<Double> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setEdgeWidth(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getEdgeColor(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                boolean ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                boolean ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            String s = String.format("#%06X", 0xFFFFFF & a.getEdgeColor().getRGB()).toUpperCase();
            array.add(s);
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setEdgeColor(String nodeA, String nodeB, String att) {
        Color attc = new Color(153, 153, 255);
        try {
            attc = RederMainFrame.methods.HexToColor(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = RederMainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = RederMainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setEdgeColor(attc);
            return 1;
        }
        return 0;
    }

    public int setEdgeColor(List<String> nodeA, List<String> nodeB, List<String> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setEdgeColor(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<String> getEdgeType(String type, String status) {
        ArrayList<String> array = new ArrayList<String>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getType());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setEdgeType(String nodeA, String nodeB, String att) {
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = RederMainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = RederMainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setLineType(att);
            return 1;
        }
        return 0;
    }

    public int setEdgeType(List<String> nodeA, List<String> nodeB, List<String> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setEdgeType(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public ArrayList<Double> getEdgeWeight(String type, String status) {
        ArrayList<Double> array = new ArrayList<Double>();
        if (type == null || status == null) {
            return null;
        }
        if (!(type.equals("node") || type.equals("container") || type.equals("all"))) {
            return null;
        }
        if (!(status.equals("selected") || status.equals("nonselected") || status.equals("all"))) {
            return null;
        }
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean bb;
            boolean ba;
            if (!type.equals("node") ? type.equals("container") && !a.isAorBContainer() : a.isAorBContainer()) continue;
            if (status.equals("selected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (!ba || !bb) {
                    continue;
                }
            } else if (status.equals("nonselected")) {
                ba = RederMainFrame.NodeList.get(a.getA()).getDestaque();
                bb = RederMainFrame.NodeList.get(a.getB()).getDestaque();
                if (ba && bb) continue;
            }
            array.add(a.getMeanWeight());
        }
        if (array.isEmpty()) {
            return null;
        }
        return array;
    }

    public int setEdgeWeight(String nodeA, String nodeB, double att) {
        for (EdgeBank a : RederMainFrame.EdgeList) {
            boolean c2;
            NodeBank nodeAccoutA = RederMainFrame.NodeList.get(a.getA());
            NodeBank nodeAccoutB = RederMainFrame.NodeList.get(a.getB());
            boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
            boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
            if (!c1 && !c2) continue;
            a.setWeight(att);
            return 1;
        }
        return 0;
    }

    public int setEdgeWeight(List<String> nodeA, List<String> nodeB, List<Double> att) {
        boolean c;
        boolean bl = c = nodeA.size() == nodeB.size() && nodeA.size() == att.size();
        if (!c) {
            return 0;
        }
        int sz = nodeA.size();
        for (int i = 0; i < sz; ++i) {
            this.setEdgeWeight(nodeA.get(i), nodeB.get(i), att.get(i));
        }
        return 1;
    }

    public int setRelax(double edgeTarget, double stiffness, double repulsionFactor, double perimeterEffect, double nodeSpeedLimit, double repulsionRadius, double centralPull, double outedgeTarget, double outRepulsionFactor) {
        RederMainFrame.methods.setRelaxArgs(edgeTarget, stiffness, repulsionFactor, perimeterEffect, nodeSpeedLimit, repulsionRadius, centralPull, outedgeTarget, outRepulsionFactor);
        RederMainFrame.methods.resetCooling();
        RederMainFrame.methods.deSelectEdges();
        RederMainFrame.methods.startRelax();
        return 1;
    }

    public int stopPaint() {
        RederMainFrame.methods.stopPaint();
        return 1;
    }

    public int startPaint() {
        RederMainFrame.methods.startPaint();
        return 1;
    }

    public int isRelaxActive() {
        if (RederMainFrame.methods.isRelaxActive()) {
            return 1;
        }
        return 0;
    }

    public int stopRelax() {
        RederMainFrame.methods.stopRelax();
        return 1;
    }

    public int ping() {
        return 1;
    }

    public String version() {
        return "RedeR_Application_V3.0";
    }

    public String updateGraphMap(List<String> nodesA, List<String> nodesB, List<Double> arrowDirection, List<Double> edgeWeight, List<Double> edgeWidth, List<String> edgeColor, List<String> edgeType, List<Double> arrowLength, List<Double> arrowAngle, List<String> linkType, List<String> nodes, List<Double> x, List<Double> y, List<Double> nodeBend, List<Double> nodeSize, List<String> nodeShape, List<String> nodeColor, List<Double> nodeWeight, List<Double> nodeLineWidth, List<String> nodeLineColor, List<Double> nodeFontSize, List<String> nodeFontColor, List<String> nodeAlias, List<Double> numSupplements, List<String> charSupplements, List<String> np1, List<String> np2, List<String> np3, List<Double> np4, String isnp, String parentname, String ntransform) {
        if (ntransform.equals("true")) {
            ntransform = "yes";
        }
        this.updateNodeMap(nodes, x, y, nodeBend, nodeSize, nodeShape, nodeColor, nodeWeight, nodeLineWidth, nodeLineColor, nodeFontSize, nodeFontColor, nodeAlias, numSupplements, charSupplements, np1, np2, np3, np4, "no", ".$null", ntransform);
        this.updateEdgeMap(nodesA, nodesB, arrowDirection, edgeWeight, edgeWidth, edgeColor, edgeType, arrowLength, arrowAngle, linkType, charSupplements, ntransform);
        if (ntransform.equals("yes")) {
            this.doTransform(np2);
        }
        if (!parentname.equals(".$null")) {
            RederMainFrame.methods.reAssigments(parentname, nodes, true);
        }
        String retorno = "1";
        if (isnp.equals("true")) {
            retorno = this.nestexpress(np1, np2, np3, np4);
        }
        RederMainFrame.methods.bringToFront();
        return retorno;
    }

    public void doTransform(List<String> status) {
        String status1 = status.get(0);
        String status2 = status.get(1);
        String status3 = status.get(2);
        boolean setHide = false;
        boolean setTransparency = false;
        boolean setAnchor = false;
        boolean setAssigned = false;
        if (status1 != null) {
            switch (status1) {
                case "hide": {
                    setHide = true;
                    setAnchor = true;
                    break;
                }
                case "transparent": {
                    setTransparency = true;
                    break;
                }
                case "plain": {
                    setHide = false;
                    setTransparency = false;
                    break;
                }
            }
        }
        if (status2 != null && status2.equals("anchor")) {
            setAnchor = true;
        }
        if (status3 != null && status3.equals("assign")) {
            setAssigned = true;
        }
        RederMainFrame.methods.updateNodeTransform(setHide, setTransparency, setAnchor, setAssigned);
    }

    public String updateNodeMap(List<String> nodes, List<Double> x, List<Double> y, List<Double> nodeBend, List<Double> nodeSize, List<String> nodeShape, List<String> nodeColor, List<Double> nodeWeight, List<Double> nodeLineWidth, List<String> nodeLineColor, List<Double> nodeFontSize, List<String> nodeFontColor, List<String> nodeAlias, List<Double> numSupplements, List<String> charSupplements, List<String> np1, List<String> np2, List<String> np3, List<Double> np4, String isnp, String parentname, String ntransform) {
        int i;
        double gX = 0.0;
        double gY = 0.0;
        try {
            gX = numSupplements.get(0);
            gY = numSupplements.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String isCoordUpdate = "default";
        boolean isBrandNew = false;
        boolean layoutOldNodes = true;
        try {
            isCoordUpdate = charSupplements.get(0);
            if (charSupplements.get(1).equals("true")) {
                isBrandNew = true;
            }
            if (charSupplements.get(2).equals("false")) {
                layoutOldNodes = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Integer> nodeMap = new ArrayList<Integer>();
        nodeMap.clear();
        boolean isExhaustive = RederMainFrame.NodeList.size() > 0 && !isBrandNew;
        int sz = nodes.size();
        for (int i2 = 0; i2 < sz; ++i2) {
            String nd = nodes.get(i2);
            int nId = this.nodeMap(nd, isExhaustive);
            nodeMap.add(nId);
        }
        if (nodeMap.isEmpty() || nodeMap.size() != sz || nodeMap.size() > RederMainFrame.NodeList.size()) {
            return "0";
        }
        this.lockInteract();
        RederMainFrame.methods.stopRelax();
        boolean flagcoord = false;
        Point2D[] pontos = new Point2D[sz];
        if (x != null && y != null && isCoordUpdate.equals("default") && x.size() == sz && y.size() == sz) {
            for (i = 0; i < nodeMap.size(); ++i) {
                pontos[i] = new Point2D.Double(x.get(i), y.get(i));
            }
            pontos = RederMainFrame.methods.redoZoomScaleFromR(pontos);
            pontos = RederMainFrame.methods.setCenterFromR(pontos, gX, gY);
            this.deSelectGraph();
            flagcoord = true;
        }
        for (i = 0; i < nodeMap.size(); ++i) {
            double attin;
            double attin2;
            boolean flag;
            boolean b;
            double attin3;
            int id = (Integer)nodeMap.get(i);
            NodeBank nodeAccout = RederMainFrame.NodeList.get(id);
            if (ntransform.equals("true") || ntransform.equals("yes")) {
                nodeAccout.setTransformed(true);
            }
            if (flagcoord) {
                float xin = (float)pontos[i].getX();
                float yin = (float)pontos[i].getY();
                if (nodeAccout.isNewR() || layoutOldNodes) {
                    nodeAccout.setNode(xin, yin);
                    nodeAccout.setDestaque(true);
                    nodeAccout.setAsNewR(false);
                }
            }
            if (nodeBend != null && nodeBend.size() == sz && (attin3 = nodeBend.get(i).doubleValue()) >= 0.0 && attin3 <= 100.0) {
                nodeAccout.setNodeBend((float)attin3);
            }
            if (nodeSize != null && nodeSize.size() == sz && (attin = nodeSize.get(i).doubleValue()) >= 0.0) {
                nodeAccout.setNodeSize((float)attin);
            }
            if (nodeShape != null && nodeShape.size() == sz && (b = Pattern.matches("ELLIPSE|RECTANGLE|ROUNDED_RECTANGLE|TRIANGLE|DIAMOND", attin = nodeShape.get(i)))) {
                nodeAccout.setNodeShape(attin);
            }
            if (nodeColor != null && nodeColor.size() == sz) {
                String attin4 = nodeColor.get(i);
                Color attc = new Color(255, 102, 102);
                flag = true;
                try {
                    attc = RederMainFrame.methods.HexToColor(attin4);
                }
                catch (NumberFormatException ignore) {
                    flag = false;
                }
                if (flag) {
                    nodeAccout.setNodeColor(attc);
                }
            }
            if (nodeWeight != null && nodeWeight.size() == sz) {
                double attin5 = nodeWeight.get(i);
                nodeAccout.setWeight(attin5);
            }
            if (nodeLineWidth != null && nodeLineWidth.size() == sz && (attin2 = nodeLineWidth.get(i).doubleValue()) >= 0.0) {
                nodeAccout.setNodeLineWidth((float)attin2);
            }
            if (nodeLineColor != null && nodeLineColor.size() == sz) {
                String attin6 = nodeLineColor.get(i);
                Color attc = new Color(255, 0, 0);
                flag = true;
                try {
                    attc = RederMainFrame.methods.HexToColor(attin6);
                }
                catch (NumberFormatException ignore) {
                    flag = false;
                }
                if (flag) {
                    nodeAccout.setNodeLineColor(attc);
                }
            }
            if (nodeFontSize != null && nodeFontSize.size() == sz && (attin = nodeFontSize.get(i).doubleValue()) >= 0.0) {
                nodeAccout.setFontSize((int)attin);
            }
            if (nodeFontColor != null && nodeFontColor.size() == sz) {
                String attin7 = nodeFontColor.get(i);
                Color attc = new Color(51, 51, 51);
                flag = true;
                try {
                    attc = RederMainFrame.methods.HexToColor(attin7);
                }
                catch (NumberFormatException ignore) {
                    flag = false;
                }
                if (flag) {
                    nodeAccout.setFontColor(attc);
                }
            }
            if (nodeAlias == null || nodeAlias.size() != sz) continue;
            String attin8 = nodeAlias.get(i);
            nodeAccout.setAliases(attin8);
        }
        this.removeMockNodes();
        if (ntransform.equals("true")) {
            this.doTransform(np2);
        }
        if (!parentname.equals(".$null")) {
            RederMainFrame.methods.reAssigments(parentname, nodes, true);
        }
        String retorno = "1";
        if (isnp.equals("true")) {
            retorno = this.nestexpress(np1, np2, np3, np4);
        }
        this.unLockInteract();
        RederMainFrame.methods.bringToFront();
        return retorno;
    }

    private int nodeMap(String node, boolean isExhaustive) {
        NodeBank nd;
        if (isExhaustive) {
            int sz = RederMainFrame.NodeList.size();
            for (int i = 0; i < sz; ++i) {
                nd = RederMainFrame.NodeList.get(i);
                String nodex = nd.getNodeID();
                if (!nodex.equals(node)) continue;
                return i;
            }
        }
        int intNodeID = RederMainFrame.NodeList.size();
        RederMainFrame.NodeList.add(new NodeBank(node, intNodeID));
        RederMainFrame.keyNodeHash.put(node, intNodeID);
        RederMainFrame.keyNodeArray.add(node);
        int newnd = RederMainFrame.NodeList.size() - 1;
        nd = RederMainFrame.NodeList.get(newnd);
        nd.setAsNewR(true);
        Pattern pt = Pattern.compile("(.)*(\\<\\$\\$\\>)(.)*");
        Matcher mt = pt.matcher(node);
        if (mt.matches()) {
            nd.setAsMock();
        }
        return intNodeID;
    }

    private int removeMockNodes() {
        RederMainFrame.lockMouse = true;
        this.deSelectNodes();
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            NodeBank nodeAccount = RederMainFrame.NodeList.get(i);
            if (!nodeAccount.isMock() || !nodeAccount.getNodeID().startsWith("MM")) continue;
            nodeAccount.setDestaque(true);
        }
        RederMainFrame.methods.globalActionDeleteNode();
        RederMainFrame.lockMouse = false;
        return 1;
    }

    public String updateEdgeMap(List<String> nodesA, List<String> nodesB, List<Double> arrowDirection, List<Double> edgeWeight, List<Double> edgeWidth, List<String> edgeColor, List<String> edgeType, List<Double> arrowLength, List<Double> arrowAngle, List<String> linkType, List<String> charsuppl, String ntransform) {
        int i;
        boolean isBrandNew = false;
        try {
            if (charsuppl.get(1).equals("true")) {
                isBrandNew = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Integer> edgeMap = new ArrayList<Integer>();
        edgeMap.clear();
        if (nodesA.size() != nodesB.size()) {
            return "0";
        }
        boolean isExhaustive = RederMainFrame.EdgeList.size() > 0 && !isBrandNew;
        int sz = nodesA.size();
        if (sz == 2) {
            isExhaustive = true;
        }
        if (arrowDirection != null && arrowDirection.size() == sz && RederMainFrame.EdgeList.size() > 0) {
            isExhaustive = true;
        }
        boolean destacar = isExhaustive && RederMainFrame.EdgeList.size() != sz;
        for (i = 0; i < sz; ++i) {
            String ndA = nodesA.get(i);
            String ndB = nodesB.get(i);
            int edgeId = this.edgeMap(ndA, ndB, isExhaustive);
            edgeMap.add(edgeId);
        }
        if (edgeMap.size() != sz) {
            return "0";
        }
        this.lockInteract();
        for (i = 0; i < edgeMap.size(); ++i) {
            double attin;
            double attin2;
            int id = (Integer)edgeMap.get(i);
            EdgeBank edgeAccount = RederMainFrame.EdgeList.get(id);
            if (arrowDirection != null && arrowDirection.size() == sz) {
                double attin3 = arrowDirection.get(i);
                edgeAccount.setArrowDirection((int)attin3);
            }
            if (edgeWeight != null && edgeWeight.size() == sz) {
                double attin4 = edgeWeight.get(i);
                edgeAccount.setWeight(attin4);
            }
            if (destacar) {
                edgeAccount.setDestaque(true);
            }
            if (edgeWidth != null && edgeWidth.size() == sz && (attin2 = edgeWidth.get(i).doubleValue()) >= 0.0) {
                edgeAccount.setLineWidth((float)attin2);
            }
            if (edgeColor != null && edgeColor.size() == sz) {
                String attin5 = edgeColor.get(i);
                Color attc = new Color(153, 153, 255);
                boolean flag = true;
                try {
                    attc = RederMainFrame.methods.HexToColor(attin5);
                }
                catch (NumberFormatException ignore) {
                    flag = false;
                }
                if (flag) {
                    edgeAccount.setEdgeColor(attc);
                }
            }
            if (edgeType != null && edgeType.size() == sz) {
                String attin6 = edgeType.get(i);
                edgeAccount.setLineType(attin6);
            }
            if (arrowLength != null && arrowLength.size() == sz && (attin = arrowLength.get(i).doubleValue()) >= 0.0) {
                edgeAccount.setArrowLength((float)attin);
            }
            if (arrowAngle != null && arrowAngle.size() == sz && (attin = arrowAngle.get(i).doubleValue()) >= 0.0) {
                edgeAccount.setArrowAngle((float)attin);
            }
            if (linkType != null && linkType.size() == sz && !ntransform.equals("yes")) {
                String attin7 = linkType.get(i);
                if (attin7.equals("nested")) {
                    edgeAccount.setDefaultEdgeAssignment(true);
                } else if (attin7.equals("notnested")) {
                    edgeAccount.setDefaultEdgeAssignment(false);
                }
            }
            if (!ntransform.equals("yes")) continue;
            edgeAccount.setDefaultEdgeAssignment(false);
        }
        RederMainFrame.methods.updateBanks();
        this.unLockInteract();
        return "1";
    }

    private int edgeMap(String nodeA, String nodeB, boolean isExhaustive) {
        if (isExhaustive) {
            int sz = RederMainFrame.EdgeList.size();
            for (int i = 0; i < sz; ++i) {
                boolean c2;
                EdgeBank edgeid = RederMainFrame.EdgeList.get(i);
                NodeBank nodeAccoutA = RederMainFrame.NodeList.get(edgeid.getA());
                NodeBank nodeAccoutB = RederMainFrame.NodeList.get(edgeid.getB());
                boolean c1 = nodeAccoutA.getNodeID().equals(nodeA) && nodeAccoutB.getNodeID().equals(nodeB);
                boolean bl = c2 = nodeAccoutB.getNodeID().equals(nodeA) && nodeAccoutA.getNodeID().equals(nodeB);
                if (!c1 && !c2) continue;
                if (c2) {
                    if (nodeAccoutA.isContainer() || nodeAccoutB.isContainer()) {
                        if (!edgeid.isDefaultEdgeAssignmet()) {
                            int ida = edgeid.getA();
                            int idb = edgeid.getB();
                            edgeid.setA(idb);
                            edgeid.setB(ida);
                        }
                    } else {
                        int ida = edgeid.getA();
                        int idb = edgeid.getB();
                        edgeid.setA(idb);
                        edgeid.setB(ida);
                    }
                }
                return i;
            }
        }
        int nA = RederMainFrame.keyNodeArray.indexOf(nodeA);
        int nB = RederMainFrame.keyNodeArray.indexOf(nodeB);
        int intEdgeID = RederMainFrame.EdgeList.size();
        RederMainFrame.EdgeList.add(new EdgeBank(nA, nB, intEdgeID));
        return intEdgeID;
    }

    public int lockInteract() {
        RederMainFrame.lockMouse = true;
        return 1;
    }

    public int unLockInteract() {
        RederMainFrame.lockMouse = false;
        return 1;
    }

    public int lockDragAndZoom() {
        RederMainFrame.lockDragAndZoom = true;
        return 1;
    }

    public int unLockDragAndZoom() {
        RederMainFrame.lockDragAndZoom = false;
        return 1;
    }

    public String duplicateNetwork(String isToCopyEdges, String isDefaultCopy) {
        boolean b1 = true;
        boolean b2 = true;
        if (isToCopyEdges.equals("no")) {
            b1 = false;
        }
        if (isDefaultCopy.equals("no")) {
            b2 = false;
        }
        String newContainer = RederMainFrame.methods.duplicateNetwork(b1, b2);
        return newContainer;
    }

    public String duplicateSubNetwork(String isToCopyEdges, String isDefaultCopy, List<String> nodes) {
        RederMainFrame.lockMouse = true;
        this.deSelectNodes();
        RederMainFrame.lockMouse = true;
        this.selectNodeList(nodes, "", "");
        RederMainFrame.lockMouse = true;
        boolean b1 = true;
        boolean b2 = true;
        if (isToCopyEdges.equals("no")) {
            b1 = false;
        }
        if (isDefaultCopy.equals("no")) {
            b2 = false;
        }
        String newContainer = RederMainFrame.methods.duplicateNetwork(b1, b2);
        RederMainFrame.lockMouse = false;
        return newContainer;
    }

    public int setBackground(String att) {
        Color attc = new Color(255, 255, 255);
        try {
            attc = RederMainFrame.methods.HexToColor(att);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        RederMainFrame.methods.setBackground(attc);
        return 1;
    }

    public int setZoom(double att) {
        RederMainFrame.methods.setZoom(att);
        return 1;
    }

    public int fitToWindow() {
        RederMainFrame.methods.fitToWindow(0.92);
        return 1;
    }

    public int exit() {
        RederMainFrame.methods.exitred();
        return 1;
    }

    public int reset() {
        RederMainFrame.lockMouse = false;
        RederMainFrame.lockDragAndZoom = false;
        RederMainFrame.NodeList.clear();
        RederMainFrame.EdgeList.clear();
        RederMainFrame.LegendList.clear();
        RederMainFrame.keyNodeHash.clear();
        RederMainFrame.keyNodeArray.clear();
        RederMainFrame.setZoom(1.0);
        RederMainFrame.drawpanel.setZoom(1.0f);
        RederMainFrame.methods.setBackground(new Color(255, 255, 255));
        this.stopRelax();
        RederMainFrame.updateGraph();
        return 1;
    }

    public int addLegendSize(List<Double> sizevec, List<String> labvec, List<String> colvec, double interspace, double ftsize, String labx, double labxdist, String panelposition, double dxborder, double dyborder, String vertical, String legtype, double edgelen) {
        if (legtype.equals("null")) {
            RederMainFrame.methods.clearLegend("nodesize");
            RederMainFrame.methods.clearLegend("edgewidth");
            RederMainFrame.updateGraph();
            return 1;
        }
        boolean isVertical = false;
        if (vertical.equals("true")) {
            isVertical = true;
        }
        ArrayList<Color> cols = new ArrayList<Color>();
        for (int i = 0; i < colvec.size(); ++i) {
            Color attc = new Color(0, 0, 0);
            String att = colvec.get(i);
            try {
                attc = RederMainFrame.methods.HexToColor(att);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cols.add(attc);
        }
        ArrayList<Float> szvec = new ArrayList<Float>();
        for (int i = 0; i < sizevec.size(); ++i) {
            double sz = sizevec.get(i);
            szvec.add(Float.valueOf((float)sz));
        }
        RederMainFrame.methods.addLegendSize(szvec, labvec, cols, (float)interspace, (int)ftsize, labx, (float)labxdist, panelposition, (float)dxborder, (float)dyborder, isVertical, legtype, (float)edgelen);
        RederMainFrame.updateGraph();
        return 1;
    }

    public int addLegendColor(List<String> colvec, List<String> labvec, double size, double bend, double ftsize, String labx, double labxdist, String panelposition, double dxborder, double dyborder, String vertical, String legtype) {
        if (legtype.equals("null")) {
            RederMainFrame.methods.clearLegend("nodecolor");
            RederMainFrame.methods.clearLegend("edgecolor");
            RederMainFrame.updateGraph();
            return 1;
        }
        boolean isVertical = false;
        if (vertical.equals("true")) {
            isVertical = true;
        }
        ArrayList<Color> cols = new ArrayList<Color>();
        for (int i = 0; i < colvec.size(); ++i) {
            Color attc = new Color(0, 0, 0);
            String att = colvec.get(i);
            try {
                attc = RederMainFrame.methods.HexToColor(att);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cols.add(attc);
        }
        RederMainFrame.methods.addLegendColor(cols, labvec, (float)size, (float)bend, (int)ftsize, labx, (float)labxdist, panelposition, (float)dxborder, (float)dyborder, isVertical, legtype);
        RederMainFrame.updateGraph();
        return 1;
    }

    public int addLegendShape(List<String> shapevec, List<String> labvec, List<String> colvec, double size, double interspace, double ftsize, String labx, double labxdist, String panelposition, double dxborder, double dyborder, String vertical, String legtype) {
        if (legtype.equals("null")) {
            RederMainFrame.methods.clearLegend("nodeshape");
            RederMainFrame.methods.clearLegend("edgeshape");
            RederMainFrame.updateGraph();
            return 1;
        }
        boolean isVertical = false;
        if (vertical.equals("true")) {
            isVertical = true;
        }
        ArrayList<Color> cols = new ArrayList<Color>();
        for (int i = 0; i < colvec.size(); ++i) {
            Color attc = new Color(0, 0, 0);
            String att = colvec.get(i);
            try {
                attc = RederMainFrame.methods.HexToColor(att);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cols.add(attc);
        }
        RederMainFrame.methods.addLegendShape(shapevec, labvec, cols, (float)size, (float)interspace, (int)ftsize, labx, (float)labxdist, panelposition, (float)dxborder, (float)dyborder, isVertical, legtype);
        RederMainFrame.updateGraph();
        return 1;
    }
}

