/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;
import reder.application.RederMainFrame;
import reder.application.graph.EdgeBank;
import reder.application.graph.LegendBank;
import reder.application.graph.NodeBank;

public class GraphTask
extends JPanel {
    private NodeBank nodeAccount = null;
    private EdgeBank edgeAccount = null;
    private float zoomInOut = 1.0f;
    private Graphics2D g2;
    private final boolean nestOnBottom;
    private float xHead;
    private float yHead;

    public GraphTask() {
        this.nestOnBottom = true;
    }

    public void setZoom(float zoomInOut) {
        this.zoomInOut = zoomInOut;
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    @Override
    protected void paintComponent(Graphics g) {
        float yA;
        int i;
        super.paintComponent(g);
        this.g2 = (Graphics2D)g;
        if (!RederMainFrame.isOptimizeRendering()) {
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        this.g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Stroke line = new BasicStroke(1.0f);
        this.g2.setStroke(line);
        this.plotHorizontalLegends();
        this.plotVerticalLegends();
        if (this.nestOnBottom) {
            this.plotContainers();
        } else {
            this.loadBuffer();
        }
        Line2D.Float edgeline = new Line2D.Float();
        int size = RederMainFrame.EdgeList.size();
        for (i = 0; i < size && !RederMainFrame.lockMouse && !RederMainFrame.isToOverrideEdges(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            if (!this.edgeAccount.isDefaultEdgeAssignmet() && this.nestOnBottom) continue;
            int a = this.edgeAccount.getA();
            NodeBank nodeAccount1 = RederMainFrame.NodeList.get(a);
            if (!RederMainFrame.isToShowTree() && this.edgeAccount.getEdgeAssociationType().equals("edgeTree")) continue;
            float xA = nodeAccount1.getBufferX();
            float yA2 = nodeAccount1.getBufferY();
            int b = this.edgeAccount.getB();
            NodeBank nodeAccount2 = RederMainFrame.NodeList.get(b);
            float xB = nodeAccount2.getBufferX();
            float yB = nodeAccount2.getBufferY();
            float rz = (float)((nodeAccount1.getRelativeSize() + nodeAccount2.getRelativeSize()) / 2.0);
            if (!RederMainFrame.getViewArea().contains(xA, yA2) || !RederMainFrame.getViewArea().contains(xB, yB)) continue;
            this.g2.setColor(this.edgeAccount.getColor());
            this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut * rz));
            float xHeadA = xA;
            float yHeadA = yA2;
            float xHeadB = xB;
            float yHeadB = yB;
            if (RederMainFrame.isToShowDirection()) {
                switch (this.edgeAccount.getArrowDirection()) {
                    case 1: {
                        GeneralPath arrowB = this.setPositiveArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSizeScale(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount2.getNodeLineWidth());
                        this.g2.fill(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                    case -1: {
                        GeneralPath arrowB = this.setNegativeArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount2.getNodeLineWidth());
                        this.g2.draw(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                    case 2: {
                        GeneralPath arrowA = this.setPositiveArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSizeScale(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount1.getNodeLineWidth());
                        this.g2.fill(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        break;
                    }
                    case -2: {
                        GeneralPath arrowA = this.setNegativeArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount1.getNodeLineWidth());
                        this.g2.draw(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        break;
                    }
                    case 3: {
                        GeneralPath arrowA = this.setPositiveArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSizeScale(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount1.getNodeLineWidth());
                        this.g2.fill(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        GeneralPath arrowB = this.setPositiveArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSizeScale(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount2.getNodeLineWidth());
                        this.g2.fill(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                    case -3: {
                        GeneralPath arrowA = this.setNegativeArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount1.getNodeLineWidth());
                        this.g2.draw(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        GeneralPath arrowB = this.setNegativeArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount2.getNodeLineWidth());
                        this.g2.draw(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                    case 4: {
                        GeneralPath arrowB = this.setPositiveArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSizeScale(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount2.getNodeLineWidth());
                        this.g2.fill(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        GeneralPath arrowA = this.setNegativeArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount1.getNodeLineWidth());
                        this.g2.draw(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        break;
                    }
                    case -4: {
                        GeneralPath arrowA = this.setPositiveArrow(xA, yA2, xB, yB, nodeAccount1.getNodeSizeScale(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount1.getNodeLineWidth());
                        this.g2.fill(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        GeneralPath arrowB = this.setNegativeArrow(xB, yB, xA, yA2, nodeAccount2.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount2.getNodeLineWidth());
                        this.g2.draw(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                }
            }
            edgeline.setLine(xHeadA, yHeadA, xHeadB, yHeadB);
            line = this.setEdgeLineType(this.edgeAccount.getWidth(), this.edgeAccount.getType(), this.zoomInOut * rz, false);
            this.g2.setStroke(line);
            this.g2.draw(edgeline);
        }
        if (!this.nestOnBottom) {
            this.plotContainers();
        }
        for (i = 0; i < RederMainFrame.NodeList.size() && !RederMainFrame.lockMouse; ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            float rz = (float)this.nodeAccount.getRelativeSize();
            float xA = this.nodeAccount.getBufferX();
            yA = this.nodeAccount.getBufferY();
            int k = this.nodeAccount.getNumParceiros();
            if (this.nodeAccount.isContainer() || this.nodeAccount.isMock() || !RederMainFrame.getViewArea().contains(xA, yA)) continue;
            Shape node = this.getNode(this.nodeAccount.getNodeShape(), xA, yA, this.nodeAccount.getW(), this.nodeAccount.getH(), rz, this.zoomInOut);
            if (this.nodeAccount.isNodeGradient()) {
                if (this.nodeAccount.getNodeShape().equals("ELLIPSE") || this.nodeAccount.getNodeShape().equals("ROUNDED_RECTANGLE")) {
                    Point2D.Float center = new Point2D.Float(xA, yA);
                    float[] dist = new float[]{0.0f, 0.5f};
                    Color[] colors = new Color[]{Color.WHITE, this.nodeAccount.getFillColor()};
                    float radius = this.nodeAccount.getMaxDiameter() * this.zoomInOut;
                    float f = radius / 6.0f;
                    Point2D.Float focus = new Point2D.Float(xA - f, yA - f);
                    RadialGradientPaint whiteToColor = new RadialGradientPaint(center, radius, focus, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
                    this.g2.setPaint(whiteToColor);
                } else {
                    float macX = xA - this.nodeAccount.getW() / 2.0f * this.zoomInOut * rz;
                    float macY = yA - this.nodeAccount.getH() / 2.0f * this.zoomInOut * rz;
                    float macW = macX + this.nodeAccount.getW() * this.zoomInOut * rz;
                    float macH = macY + this.nodeAccount.getH() * this.zoomInOut * rz;
                    GradientPaint MACwhiteToColor = new GradientPaint(macX, macY, Color.WHITE, macW, macH, this.nodeAccount.getFillColor());
                    this.g2.setPaint(MACwhiteToColor);
                }
            } else {
                this.g2.setColor(this.nodeAccount.getFillColor());
            }
            this.g2.fill(node);
            this.g2.setColor(this.nodeAccount.getLineColor());
            if (!(this.nodeAccount.getNodeLineWidth() > 0.0f)) continue;
            float sz = this.nodeAccount.getNodeLineWidth() * this.zoomInOut * rz;
            line = this.setNodeContainerLineType(sz, this.nodeAccount.getNodeLineType());
            this.g2.setStroke(line);
            this.g2.draw(node);
        }
        for (i = 0; i < RederMainFrame.NodeList.size() && !RederMainFrame.lockMouse; ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            float rz = (float)this.nodeAccount.getRelativeSize();
            float xA = this.nodeAccount.getBufferX();
            yA = this.nodeAccount.getBufferY();
            int k = this.nodeAccount.getNumParceiros();
            if (this.nodeAccount.isContainer() || this.nodeAccount.isMock() || !RederMainFrame.getViewArea().contains(xA, yA) || !((double)((float)this.nodeAccount.getFont().getSize() * this.zoomInOut * rz) >= 3.5) || !this.nodeAccount.isLegendOn()) continue;
            this.g2.setColor(this.nodeAccount.getFontColor());
            this.g2.setFont(new Font(this.nodeAccount.getFont().getName(), this.nodeAccount.getFont().getStyle(), (int)((float)this.nodeAccount.getFont().getSize() * this.zoomInOut * rz)));
            this.g2.drawString(this.nodeAccount.getAliases(), xA + this.getLabelTextPositionX(Float.valueOf(this.zoomInOut * rz)), yA + this.getLabelTextPositionY(Float.valueOf(this.zoomInOut * rz)));
        }
        this.g2.setStroke(new BasicStroke(1.0f));
        if (RederMainFrame.getDragArea() != null) {
            Rectangle2D areaSelect = RederMainFrame.getDragArea();
            this.g2.setColor(new Color(255, 204, 0));
            this.g2.draw(areaSelect);
        }
    }

    private float getLabelTextPositionX(Float rz) {
        float x_adjust;
        float font_w = this.g2.getFontMetrics().stringWidth(this.nodeAccount.getAliases());
        float font_h = this.g2.getFontMetrics().getHeight();
        float node_w = this.nodeAccount.getW();
        float x_offset = this.nodeAccount.getFontOffsetX() / 10.0f;
        switch (this.nodeAccount.getFontPositionX()) {
            case "right": {
                x_offset = x_offset * node_w / 2.0f;
                x_adjust = x_offset * rz.floatValue() - font_h / 8.0f;
                break;
            }
            case "left": {
                x_offset = x_offset * node_w / 2.0f;
                x_adjust = -(font_w - x_offset * rz.floatValue()) + font_h / 8.0f;
                break;
            }
            case "center": {
                x_offset = x_offset * font_w / 2.0f;
                x_adjust = -(font_w / 2.0f - x_offset);
                break;
            }
            default: {
                x_adjust = 0.0f;
            }
        }
        return x_adjust;
    }

    private float getLabelTextPositionY(Float rz) {
        float y_adjust;
        float font_h = this.g2.getFontMetrics().getHeight();
        float nodeH = this.nodeAccount.getH();
        float y_offset = this.nodeAccount.getFontOffsetY();
        switch (this.nodeAccount.getFontPositionY()) {
            case "top": {
                y_adjust = -(nodeH / 2.0f * rz.floatValue() + y_offset * rz.floatValue() + 1.0f * rz.floatValue());
                break;
            }
            case "bottom": {
                y_adjust = nodeH / 2.0f * rz.floatValue() + font_h / 2.0f - y_offset * rz.floatValue() + font_h / 6.0f;
                break;
            }
            case "center": {
                y_adjust = font_h / 3.2f - y_offset * rz.floatValue();
                break;
            }
            default: {
                y_adjust = 0.0f;
            }
        }
        return y_adjust;
    }

    private void loadBuffer() {
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            RederMainFrame.NodeList.get(i).loadBuffer();
        }
    }

    private void plotHorizontalLegends() {
        for (int i = 0; i < RederMainFrame.LegendList.size() && !RederMainFrame.lockMouse; ++i) {
            float mb;
            float offsetY;
            float offsetX;
            float theta;
            LegendBank legAccount = RederMainFrame.LegendList.get(i);
            if (legAccount.isVertical()) continue;
            float rz = (float)legAccount.getRelativeSize();
            float legzoom = legAccount.getLegZoom();
            FontMetrics fm = this.g2.getFontMetrics(legAccount.getFont());
            float labLength = fm.stringWidth(legAccount.getAliases());
            float labHeight = fm.getHeight();
            float maxLabLength = legAccount.getMaxLabLength().floatValue() * (float)fm.stringWidth("0") + (float)(fm.getHeight() / 3);
            float legTitleH = legAccount.getTitleHeight();
            float legTitleW = legAccount.getTitleWidth();
            if (legAccount.getMembership() == 0) {
                this.g2.setFont(legAccount.getTitleFont());
                theta = 0.0f;
                float dx = -(legTitleW / 2.0f);
                float dy = legAccount.getPanelSideTB().equals("top") ? legTitleH : -maxLabLength;
                float tx = legAccount.getTitleX() + dx;
                float ty = legAccount.getTitleY() + dy;
                if (tx < 0.0f) {
                    tx = 0.0f;
                }
                if (ty < 0.0f) {
                    ty = 0.0f;
                }
                this.g2.setColor(legAccount.getNodeFontColor());
                this.g2.rotate(-Math.toRadians(theta), tx, ty);
                this.g2.drawString(legAccount.getLabx(), tx, ty);
                this.g2.rotate(Math.toRadians(theta), tx, ty);
            }
            float xC = legAccount.getX();
            float yC = legAccount.getY();
            if (legAccount.getPanelSideTB().equals("top")) {
                offsetX = 0.0f;
                offsetY = legTitleH + 5.0f;
            } else {
                yC -= maxLabLength;
                offsetX = 0.0f;
                offsetY = 0.0f;
            }
            if (legAccount.isEdgeType()) {
                float xA = xC;
                float yA = yC;
                float xB = xC;
                float yB = yC;
                yA = yA - legAccount.getLegH() / 2.0f * legzoom + offsetY;
                yB = yB + legAccount.getLegH() / 2.0f * legzoom + offsetY;
                this.g2.setColor(legAccount.getNodeLineColor());
                Line2D.Float edgeline = new Line2D.Float();
                edgeline.setLine(xA, yA, xB, yB);
                Stroke line = this.setEdgeLineType(legAccount.getLegW(), legAccount.getLegShape(), legzoom, legAccount.getLegType().equals("edgewidth"));
                this.g2.setStroke(line);
                this.g2.draw(edgeline);
            } else {
                Shape node = this.getNode(legAccount.getLegShape(), xC + offsetX, yC + offsetY, legAccount.getLegW(), legAccount.getLegH(), rz, legzoom);
                this.g2.setColor(legAccount.getNodeFillColor());
                this.g2.fill(node);
            }
            if (legAccount.isSizeWidthType() && (float)legAccount.getFont().getSize() * legzoom * rz < 15.0f && (mb = (float)(legAccount.getMembership() + 1) / 2.0f) > (float)((int)mb)) continue;
            this.g2.setFont(legAccount.getFont());
            this.g2.setColor(legAccount.getFontColor());
            float ft_adjust = maxLabLength - labLength;
            theta = 90.0f;
            offsetY = -(offsetY + maxLabLength + labHeight / 2.0f) + ft_adjust + 5.0f;
            offsetX = labHeight / 3.0f;
            this.g2.rotate(-Math.toRadians(theta), xC, yC);
            this.g2.drawString(legAccount.getAliases(), xC + offsetY + legAccount.getFontOffsetX(), yC + offsetX + legAccount.getFontOffsetY());
            this.g2.rotate(Math.toRadians(theta), xC, yC);
        }
    }

    private void plotVerticalLegends() {
        for (int i = 0; i < RederMainFrame.LegendList.size() && !RederMainFrame.lockMouse; ++i) {
            float mb;
            float theta;
            LegendBank legAccount = RederMainFrame.LegendList.get(i);
            if (!legAccount.isVertical()) continue;
            float rz = (float)legAccount.getRelativeSize();
            float legzoom = legAccount.getLegZoom();
            FontMetrics fm = this.g2.getFontMetrics(legAccount.getFont());
            float labLength = fm.stringWidth(legAccount.getAliases());
            float labHeight = fm.getHeight();
            float maxLabLength = legAccount.getMaxLabLength().floatValue() * (float)fm.stringWidth("0") + (float)(fm.getHeight() / 3);
            float legTitleH = legAccount.getTitleHeight();
            float legTitleW = legAccount.getTitleWidth();
            if (legAccount.getMembership() == 0) {
                this.g2.setFont(legAccount.getTitleFont());
                theta = 90.0f;
                float dx = legAccount.getPanelSideRL().equals("left") ? legTitleH / 1.5f + maxLabLength : -maxLabLength;
                float dy = legAccount.getPanelSideTB().equals("top") ? legTitleW / 2.0f : 0.0f;
                float tx = legAccount.getTitleX() + dx;
                float ty = legAccount.getTitleY() + dy;
                if (tx < 0.0f) {
                    tx = 0.0f;
                }
                if (ty < 0.0f) {
                    ty = 0.0f;
                }
                this.g2.setColor(legAccount.getNodeFontColor());
                this.g2.rotate(-Math.toRadians(theta), tx, ty);
                this.g2.drawString(legAccount.getLabx(), tx, ty);
                this.g2.rotate(Math.toRadians(theta), tx, ty);
            }
            float xC = legAccount.getX();
            float yC = legAccount.getY();
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            if (legAccount.isEdgeType()) {
                if (legAccount.getPanelSideRL().equals("right") && legAccount.getLegType().equals("edgeshape")) {
                    offsetX = 5.0f * legzoom;
                }
                float xA = xC;
                float yA = yC;
                float xB = xC;
                float yB = yC;
                xA = xA - legAccount.getLegW() / 2.0f * legzoom + offsetX;
                xB = xB + legAccount.getLegW() / 2.0f * legzoom + offsetX;
                this.g2.setColor(legAccount.getNodeLineColor());
                Line2D.Float edgeline = new Line2D.Float();
                edgeline.setLine(xA, yA, xB, yB);
                Stroke line = this.setEdgeLineType(legAccount.getLegH(), legAccount.getLegShape(), legzoom, legAccount.getLegType().equals("edgewidth"));
                this.g2.setStroke(line);
                this.g2.draw(edgeline);
            } else {
                Shape node = this.getNode(legAccount.getLegShape(), xC + offsetX, yC + offsetY, legAccount.getLegW(), legAccount.getLegH(), rz, legzoom);
                this.g2.setColor(legAccount.getNodeFillColor());
                this.g2.fill(node);
            }
            if (legAccount.isSizeWidthType() && (float)legAccount.getFont().getSize() * legzoom * rz < 15.0f && (mb = (float)(legAccount.getMembership() + 1) / 2.0f) > (float)((int)mb)) continue;
            theta = 0.0f;
            this.g2.setFont(legAccount.getFont());
            this.g2.setColor(legAccount.getFontColor());
            float ft_adjust = maxLabLength - labLength;
            offsetX = legAccount.getPanelSideRL().equals("left") ? labHeight / 4.0f : -maxLabLength + ft_adjust;
            offsetY = labHeight / 3.0f;
            this.g2.rotate(-Math.toRadians(theta), xC, yC);
            this.g2.drawString(legAccount.getAliases(), xC + offsetX + legAccount.getFontOffsetX(), yC + offsetY + legAccount.getFontOffsetY());
            this.g2.rotate(Math.toRadians(theta), xC, yC);
        }
    }

    private void plotContainers() {
        for (int i = 0; i < RederMainFrame.NodeList.size() && !RederMainFrame.lockMouse; ++i) {
            float zoom_ct = this.zoomInOut;
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (this.nodeAccount.isSpot()) {
                zoom_ct = 1.0f;
            }
            if (this.nestOnBottom) {
                this.nodeAccount.loadBuffer();
            }
            if (!this.nodeAccount.isContainer() || this.nodeAccount.isContainerHided() || !RederMainFrame.isToShowContainers() && !this.nodeAccount.isSpot()) continue;
            float rz = (float)this.nodeAccount.getRelativeSize();
            float xA = this.nodeAccount.getBufferX();
            float yA = this.nodeAccount.getBufferY();
            if (RederMainFrame.getViewArea().contains(xA, yA)) {
                if (this.nestOnBottom) {
                    this.plotContainerEdge(this.nodeAccount);
                }
                Shape node = this.getNode(this.nodeAccount.getNodeShape(), xA, yA, this.nodeAccount.getW(), this.nodeAccount.getH(), rz, zoom_ct);
                if (this.nodeAccount.isNodeGradient()) {
                    float macX = xA - this.nodeAccount.getW() / 2.0f * zoom_ct * rz;
                    float macY = yA - this.nodeAccount.getH() / 2.0f * zoom_ct * rz;
                    float macW = macX + this.nodeAccount.getW() * zoom_ct * rz;
                    float macH = macY + this.nodeAccount.getH() * zoom_ct * rz;
                    GradientPaint MACwhiteToColor = new GradientPaint(macX, macY, Color.WHITE, macW, macH, this.nodeAccount.getFillColor());
                    MACwhiteToColor.getTransparency();
                    this.g2.setPaint(MACwhiteToColor);
                } else {
                    this.g2.setColor(this.nodeAccount.getFillColor());
                }
                if (this.nodeAccount.isContainerTransparent()) {
                    this.g2.setComposite(this.makeComposite(0.5f));
                }
                this.g2.fill(node);
                this.g2.setColor(this.nodeAccount.getLineColor());
                float lw = this.nodeAccount.getNodeLineWidth();
                if (this.nodeAccount.getDestaque() && !this.nodeAccount.isSpot()) {
                    lw = this.nodeAccount.getNodeLineType().equals("SOLID") ? (lw *= 3.0f) : (lw *= 1.5f);
                }
                this.g2.setStroke(new BasicStroke(lw * zoom_ct * rz));
                Stroke line = this.setNodeContainerLineType(lw * zoom_ct * rz, this.nodeAccount.getNodeLineType());
                this.g2.setStroke(line);
                this.g2.draw(node);
                this.g2.setStroke(new BasicStroke(this.nodeAccount.getNodeLineWidth() * zoom_ct * rz));
                if ((float)this.nodeAccount.getFont().getSize() * zoom_ct * rz >= 4.0f && this.nodeAccount.isLegendOn()) {
                    this.g2.setColor(this.nodeAccount.getFontColor());
                    this.g2.setFont(new Font(this.nodeAccount.getFont().getName(), this.nodeAccount.getFont().getStyle(), (int)((float)this.nodeAccount.getFont().getSize() * zoom_ct * rz)));
                    this.g2.drawString(this.nodeAccount.getAliases(), xA + this.getLabelTextPositionX(Float.valueOf(zoom_ct * rz)), yA + this.getLabelTextPositionY(Float.valueOf(zoom_ct * rz)));
                }
            }
            if (!this.nodeAccount.isContainerTransparent()) continue;
            this.g2.setComposite(this.makeComposite(1.0f));
        }
    }

    private void plotContainerEdge(NodeBank containerAccount) {
        Line2D.Float edgeline = new Line2D.Float();
        int size = containerAccount.getContainerEdgeMapUnique().size();
        for (int i = 0; i < size; ++i) {
            int a;
            NodeBank nodeAccount1;
            int link = containerAccount.getContainerEdgeMapUnique().get(i);
            this.edgeAccount = RederMainFrame.EdgeList.get(link);
            if (this.edgeAccount.isDefaultEdgeAssignmet() || (nodeAccount1 = RederMainFrame.NodeList.get(a = this.edgeAccount.getA())).isContainerHided() || nodeAccount1.isContainerTransparent()) continue;
            float xA = nodeAccount1.getX();
            float yA = nodeAccount1.getY();
            int b = this.edgeAccount.getB();
            NodeBank nodeAccount2 = RederMainFrame.NodeList.get(b);
            if (nodeAccount2.isContainerHided() || nodeAccount2.isContainerTransparent()) continue;
            float xB = nodeAccount2.getX();
            float yB = nodeAccount2.getY();
            if (!RederMainFrame.getViewArea().contains(xA, yA) || !RederMainFrame.getViewArea().contains(xB, yB)) continue;
            this.g2.setColor(this.edgeAccount.getColor());
            this.g2.setStroke(new BasicStroke(this.edgeAccount.getWidth() / 1.5f * this.zoomInOut));
            float xHeadA = xA;
            float yHeadA = yA;
            float xHeadB = xB;
            float yHeadB = yB;
            if (RederMainFrame.isToShowDirection()) {
                switch (this.edgeAccount.getArrowDirection()) {
                    case 1: {
                        GeneralPath arrowB = this.setPositiveArrow(xB, yB, xA, yA, nodeAccount2.getNodeSizeScale(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount2.getNodeLineWidth());
                        this.g2.fill(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                    case -1: {
                        GeneralPath arrowB = this.setNegativeArrow(xB, yB, xA, yA, nodeAccount2.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount2.getNodeLineWidth());
                        this.g2.draw(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                    case 2: {
                        GeneralPath arrowA = this.setPositiveArrow(xA, yA, xB, yB, nodeAccount1.getNodeSizeScale(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount1.getNodeLineWidth());
                        this.g2.fill(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        break;
                    }
                    case -2: {
                        GeneralPath arrowA = this.setNegativeArrow(xA, yA, xB, yB, nodeAccount1.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount1.getNodeLineWidth());
                        this.g2.draw(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        break;
                    }
                    case 3: {
                        GeneralPath arrowA = this.setPositiveArrow(xA, yA, xB, yB, nodeAccount1.getNodeSizeScale(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount1.getNodeLineWidth());
                        this.g2.fill(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        GeneralPath arrowB = this.setPositiveArrow(xB, yB, xA, yA, nodeAccount2.getNodeSizeScale(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount2.getNodeLineWidth());
                        this.g2.fill(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                    case -3: {
                        GeneralPath arrowA = this.setNegativeArrow(xA, yA, xB, yB, nodeAccount1.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount1.getNodeLineWidth());
                        this.g2.draw(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        GeneralPath arrowB = this.setNegativeArrow(xB, yB, xA, yA, nodeAccount2.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount2.getNodeLineWidth());
                        this.g2.draw(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                    case 4: {
                        GeneralPath arrowB = this.setPositiveArrow(xB, yB, xA, yA, nodeAccount2.getNodeSizeScale(), nodeAccount2.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount2.getNodeLineWidth());
                        this.g2.fill(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        GeneralPath arrowA = this.setNegativeArrow(xA, yA, xB, yB, nodeAccount1.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount1.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount1.getNodeLineWidth());
                        this.g2.draw(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        break;
                    }
                    case -4: {
                        GeneralPath arrowA = this.setPositiveArrow(xA, yA, xB, yB, nodeAccount1.getNodeSizeScale(), nodeAccount1.getNodeShape(), this.edgeAccount.getArrowLength(), this.edgeAccount.getArrowAngle(), nodeAccount1.getNodeLineWidth());
                        this.g2.fill(arrowA);
                        xHeadA = this.xHead;
                        yHeadA = this.yHead;
                        GeneralPath arrowB = this.setNegativeArrow(xB, yB, xA, yA, nodeAccount2.getNodeSizeScale(), this.edgeAccount.getWidth(), nodeAccount2.getNodeShape(), (double)this.edgeAccount.getArrowLength() * 0.5, nodeAccount2.getNodeLineWidth());
                        this.g2.draw(arrowB);
                        xHeadB = this.xHead;
                        yHeadB = this.yHead;
                        break;
                    }
                }
            }
            edgeline.setLine(xHeadA, yHeadA, xHeadB, yHeadB);
            Stroke line = this.setEdgeLineType(this.edgeAccount.getWidth(), this.edgeAccount.getType(), this.zoomInOut, false);
            this.g2.setStroke(line);
            this.g2.draw(edgeline);
        }
    }

    private GeneralPath setPositiveArrow(float xHead, float yHead, float xTail, float yTail, float nodeSize, String nodeType, double arrowLength, double arrowAngle, float edgeNodeWidth) {
        arrowLength *= (double)this.zoomInOut;
        double offsetLength = (double)nodeSize * 20.0 / 2.0 * (double)this.zoomInOut + (double)(edgeNodeWidth / 2.0f * this.zoomInOut);
        if (nodeType.equals("RECTANGLE") || nodeType.equals("ROUNDED_RECTANGLE") || nodeType.equals("TRIANGLE")) {
            offsetLength = (double)nodeSize * 20.0 * Math.sqrt(2.0) / 2.0 * (double)this.zoomInOut + (double)(edgeNodeWidth / 2.0f * this.zoomInOut);
        }
        double dx = (double)xHead - (double)xTail;
        double dy = (double)yHead - (double)yTail;
        double h = Math.sqrt(dx * dx + dy * dy);
        double ddx = offsetLength * Math.abs(dx / h);
        double ddy = offsetLength * Math.abs(dy / h);
        double xCap = arrowLength * Math.abs(dx / h);
        double yCap = arrowLength * Math.abs(dy / h);
        if (xHead > xTail && yHead > yTail) {
            xCap = (dx -= ddx) - xCap;
            yCap = (dy -= ddy) - yCap;
        } else if (xHead < xTail && yHead < yTail) {
            xCap = (dx += ddx) + xCap;
            yCap = (dy += ddy) + yCap;
        } else if (xHead < xTail && yHead > yTail) {
            xCap = (dx += ddx) + xCap;
            yCap = (dy -= ddy) - yCap;
        } else if (xHead > xTail && yHead < yTail) {
            xCap = (dx -= ddx) - xCap;
            yCap = (dy += ddy) + yCap;
        } else if (xHead == xTail && yHead > yTail) {
            yCap = (dy -= ddy) - yCap;
        } else if (xHead == xTail && yHead < yTail) {
            yCap = (dy += ddy) + yCap;
        } else if (yHead == yTail && xHead > xTail) {
            xCap = (dx -= ddx) - xCap;
        } else if (yHead == yTail && xHead < xTail) {
            xCap = (dx += ddx) + xCap;
        }
        xHead = xTail + (float)dx;
        yHead = yTail + (float)dy;
        this.xHead = xTail + (float)xCap;
        this.yHead = yTail + (float)yCap;
        double edgeAngle = Math.atan2(dy, dx);
        GeneralPath arrow = this.createPositiveArrow(arrowLength, arrowAngle, edgeAngle, xHead, yHead);
        return arrow;
    }

    private GeneralPath createPositiveArrow(double arrowLength, double arrowAngle, double edgeAngle, double xHead, double yHead) {
        double h_ang = 180.0 - (arrowAngle / 2.0 + 90.0);
        h_ang = Math.PI * h_ang / 180.0;
        arrowAngle = Math.PI * arrowAngle / 360.0;
        float x1 = (float)(xHead - (arrowLength /= Math.sin(h_ang)) * Math.cos(edgeAngle - arrowAngle));
        float y1 = (float)(yHead - arrowLength * Math.sin(edgeAngle - arrowAngle));
        float x2 = (float)(xHead - arrowLength * Math.cos(edgeAngle + arrowAngle));
        float y2 = (float)(yHead - arrowLength * Math.sin(edgeAngle + arrowAngle));
        GeneralPath arrow = new GeneralPath();
        arrow.moveTo(x1, y1);
        arrow.lineTo((float)xHead, (float)yHead);
        arrow.lineTo(x2, y2);
        arrow.closePath();
        return arrow;
    }

    private GeneralPath setNegativeArrow(float xHead, float yHead, float xTail, float yTail, float nodeSize, float edgeWidth, String nodeType, double arrowLength, float edgeNodeWidth) {
        arrowLength *= (double)this.zoomInOut;
        double offsetLength = (double)nodeSize * 20.0 / 2.0 * (double)this.zoomInOut + (double)(edgeNodeWidth / 2.0f * this.zoomInOut);
        if (nodeType.equals("RECTANGLE") || nodeType.equals("ROUNDED_RECTANGLE") || nodeType.equals("TRIANGLE")) {
            offsetLength = (double)nodeSize * 20.0 * Math.sqrt(2.0) / 2.0 * (double)this.zoomInOut + (double)(edgeNodeWidth / 2.0f * this.zoomInOut);
        }
        double edgeTipPosition = nodeSize * this.zoomInOut + edgeWidth / 2.0f * this.zoomInOut;
        double dx = (double)xHead - (double)xTail;
        double dy = (double)yHead - (double)yTail;
        double h = Math.sqrt(dx * dx + dy * dy);
        double ddx = offsetLength * Math.abs(dx / h);
        double ddy = offsetLength * Math.abs(dy / h);
        double xCap = edgeTipPosition * Math.abs(dx / h);
        double yCap = edgeTipPosition * Math.abs(dy / h);
        if (xHead > xTail && yHead > yTail) {
            xCap = (dx -= ddx) - xCap;
            yCap = (dy -= ddy) - yCap;
        } else if (xHead < xTail && yHead < yTail) {
            xCap = (dx += ddx) + xCap;
            yCap = (dy += ddy) + yCap;
        } else if (xHead < xTail && yHead > yTail) {
            xCap = (dx += ddx) + xCap;
            yCap = (dy -= ddy) - yCap;
        } else if (xHead > xTail && yHead < yTail) {
            xCap = (dx -= ddx) - xCap;
            yCap = (dy += ddy) + yCap;
        } else if (xHead == xTail && yHead > yTail) {
            yCap = (dy -= ddy) - yCap;
        } else if (xHead == xTail && yHead < yTail) {
            yCap = (dy += ddy) + yCap;
        } else if (yHead == yTail && xHead > xTail) {
            xCap = (dx -= ddx) - xCap;
        } else if (yHead == yTail && xHead < xTail) {
            xCap = (dx += ddx) + xCap;
        }
        xHead = xTail + (float)xCap;
        yHead = yTail + (float)yCap;
        this.xHead = xHead;
        this.yHead = yHead;
        double edgeAngle = Math.atan2(dy, dx);
        GeneralPath arrow = this.createNegativeArrow(arrowLength, edgeAngle, xHead, yHead);
        return arrow;
    }

    private GeneralPath createNegativeArrow(double arrowLength, double edgeAngle, double xHead, double yHead) {
        double arrowAngle = 1.5707963267948966;
        float x1 = (float)(xHead - arrowLength * Math.cos(edgeAngle - arrowAngle));
        float y1 = (float)(yHead - arrowLength * Math.sin(edgeAngle - arrowAngle));
        float x2 = (float)(xHead - arrowLength * Math.cos(edgeAngle + arrowAngle));
        float y2 = (float)(yHead - arrowLength * Math.sin(edgeAngle + arrowAngle));
        GeneralPath arrow = new GeneralPath();
        arrow.moveTo(x1, y1);
        arrow.lineTo(x2, y2);
        arrow.closePath();
        return arrow;
    }

    private Stroke setEdgeLineType(float lineWidth, String type, float zoom, boolean isLegend) {
        BasicStroke line;
        int join;
        int cap;
        float size = lineWidth * zoom;
        if (isLegend) {
            cap = 0;
            join = 2;
        } else {
            cap = 0;
            join = 2;
        }
        switch (type) {
            case "SOLID": {
                line = new BasicStroke(size, cap, join);
                break;
            }
            case "DOTTED": {
                float[] dot = new float[]{size * 0.1f, size * 2.0f};
                line = new BasicStroke(size, 1, join, 0.0f, dot, 0.0f);
                break;
            }
            case "DASHED": {
                float[] dot = new float[]{size * 1.8f, size * 2.0f};
                line = new BasicStroke(size, cap, join, 0.0f, dot, 0.0f);
                break;
            }
            case "LONG_DASH": {
                float[] dot = new float[]{size * 3.0f, size * 1.8f};
                line = new BasicStroke(size, cap, join, 0.0f, dot, 0.0f);
                break;
            }
            default: {
                line = new BasicStroke(size, cap, join);
            }
        }
        return line;
    }

    private Stroke setNodeContainerLineType(float lineWidth, String linetype) {
        BasicStroke line;
        int cap = 2;
        int join = 1;
        switch (linetype) {
            case "SOLID": {
                line = new BasicStroke(lineWidth, cap, join);
                break;
            }
            case "DOTTED": {
                float[] dot = new float[]{lineWidth * 0.1f, lineWidth * 2.0f};
                line = new BasicStroke(lineWidth, cap, join, 0.0f, dot, 0.0f);
                break;
            }
            case "DASHED": {
                float[] dot = new float[]{lineWidth * 1.75f, lineWidth * 2.0f};
                line = new BasicStroke(lineWidth, cap, join, 0.0f, dot, 0.0f);
                break;
            }
            case "LONG_DASH": {
                float[] dot = new float[]{lineWidth * 3.0f, lineWidth * 1.75f};
                line = new BasicStroke(lineWidth, cap, join, 0.0f, dot, 0.0f);
                break;
            }
            default: {
                line = new BasicStroke(lineWidth, cap, join);
            }
        }
        return line;
    }

    public Shape getNode(String nodeType, float x, float y, float w, float h, float rz, float zoom) {
        Shape node;
        w = w * zoom * rz;
        h = h * zoom * rz;
        switch (nodeType) {
            case "ELLIPSE": {
                node = this.circleRectangle(x, y, w, h, 1.0f);
                break;
            }
            case "RECTANGLE": {
                node = this.circleRectangle(x, y, w, h, 0.0f);
                break;
            }
            case "ROUNDED_RECTANGLE": {
                node = this.circleRectangle(x, y, w, h, 0.7f);
                break;
            }
            case "TRIANGLE": {
                node = this.triangle(x, y, w, h);
                break;
            }
            case "DIAMOND": {
                node = this.diamond(x, y, w, h);
                break;
            }
            default: {
                node = this.circleRectangle(x, y, w, h, 1.0f);
            }
        }
        return node;
    }

    private Shape triangle(float x, float y, float w, float h) {
        GeneralPath p0 = new GeneralPath(1);
        p0.moveTo(x - w / 2.0f, y + h / 2.0f);
        p0.lineTo(x, y - h / 2.0f);
        p0.lineTo(x + w / 2.0f, y + h / 2.0f);
        p0.closePath();
        return p0;
    }

    private Shape diamond(float x, float y, float w, float h) {
        GeneralPath p0 = new GeneralPath(1);
        p0.moveTo(x - w / 2.0f, y);
        p0.lineTo(x, y + h / 2.0f);
        p0.lineTo(x + w / 2.0f, y);
        p0.lineTo(x, y - h / 2.0f);
        p0.closePath();
        return p0;
    }

    private Shape circleRectangle(float x, float y, float w, float h, float arc) {
        RoundRectangle2D.Float node = new RoundRectangle2D.Float(x - w / 2.0f, y - h / 2.0f, w, h, w * arc, h * arc);
        return node;
    }
}

