/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.shading;

import org.jfree.pdf.function.Function;
import org.jfree.pdf.shading.Shading;
import org.jfree.pdf.shading.ShadingType;
import org.jfree.pdf.util.Args;
import org.jfree.pdf.util.PDFUtils;

public final class AxialShading
extends Shading {
    private double[] coords;
    private Function function;
    private double[] domain;
    private boolean[] extend;

    public AxialShading(int number, double[] coords, Function function) {
        super(number, ShadingType.AXIAL);
        Args.arrayMustHaveLength(4, coords, "coords");
        Args.nullNotPermitted(function, "function");
        this.dictionary.put("/ColorSpace", "/DeviceRGB");
        this.setCoords(coords);
        this.setFunction(function);
        this.setExtend(new boolean[]{true, true});
        this.domain = new double[]{0.0, 1.0};
    }

    public double[] getCoords() {
        return (double[])this.coords.clone();
    }

    public void setCoords(double[] coords) {
        Args.arrayMustHaveLength(4, coords, "coords");
        this.coords = (double[])coords.clone();
        this.dictionary.put("/Coords", PDFUtils.toPDFArray(this.coords));
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        Args.nullNotPermitted(function, "function");
        this.function = function;
        this.dictionary.put("/Function", this.function);
    }

    public double[] getDomain() {
        return (double[])this.domain.clone();
    }

    public void setDomain(double[] domain) {
        Args.arrayMustHaveLength(2, domain, "domain");
        this.domain = (double[])domain.clone();
        this.dictionary.put("/Domain", PDFUtils.toPDFArray(this.domain));
    }

    public boolean[] getExtend() {
        return (boolean[])this.extend.clone();
    }

    public void setExtend(boolean[] extend) {
        Args.arrayMustHaveLength(2, extend, "extend");
        this.extend = (boolean[])extend.clone();
        this.dictionary.put("/Extend", PDFUtils.toPDFArray(this.extend));
    }
}

