/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf;

import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import org.jfree.pdf.PDFGraphicsDevice;

public class PDFGraphicsConfiguration
extends GraphicsConfiguration {
    private GraphicsDevice device;
    private int width;
    private int height;
    private BufferedImage img = new BufferedImage(10, 10, 2);

    public PDFGraphicsConfiguration(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public GraphicsDevice getDevice() {
        if (this.device == null) {
            this.device = new PDFGraphicsDevice("JFreePDF-GraphicsDevice", this);
        }
        return this.device;
    }

    @Override
    public ColorModel getColorModel() {
        return this.getColorModel(3);
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        if (transparency == 3) {
            return ColorModel.getRGBdefault();
        }
        if (transparency == 1) {
            return new DirectColorModel(32, 0xFF0000, 65280, 255);
        }
        return null;
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int width, int height, ImageCapabilities caps, int transparency) throws AWTException {
        return this.img.createGraphics().getDeviceConfiguration().createCompatibleVolatileImage(width, height, caps, transparency);
    }
}

