## ----eval=FALSE---------------------------------------------------------------
#  if (!require("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("INTACT")

## -----------------------------------------------------------------------------
library(INTACT)
data(simdat)

rst <- INTACT::intact(GLCP_vec=simdat$GLCP, 
                      z_vec=simdat$TWAS_z)

## -----------------------------------------------------------------------------
rst1 <- INTACT::intact(GLCP_vec=simdat$GLCP, 
                       prior_fun=INTACT::expit, 
                       z_vec = simdat$TWAS_z,
                       t = 0.02,D = 0.09)
rst2 <- INTACT::intact(GLCP_vec=simdat$GLCP, 
                       prior_fun=INTACT::step, 
                       z_vec = simdat$TWAS_z,
                       t = 0.49)
rst3 <- INTACT::intact(GLCP_vec=simdat$GLCP, 
                       prior_fun=INTACT::hybrid, 
                       z_vec = simdat$TWAS_z,
                       t = 0.49,D = 0.05)

## -----------------------------------------------------------------------------
fdr_example <- fdr_rst(rst1, alpha = 0.05)
head(fdr_example)

## -----------------------------------------------------------------------------
data(gene_set_list)
INTACT::intactGSE(gene_data = simdat,gene_sets = gene_set_list)

## -----------------------------------------------------------------------------
INTACT::intactGSE(gene_data = simdat,prior_fun = INTACT::step,
                  t = 0.45,gene_sets = gene_set_list)
INTACT::intactGSE(gene_data = simdat,prior_fun = INTACT::expit,
                  t = 0.08,D = 0.08, gene_sets = gene_set_list)
INTACT::intactGSE(gene_data = simdat,prior_fun = INTACT::hybrid,
                  t = 0.08,D = 0.08, gene_sets = gene_set_list)

## -----------------------------------------------------------------------------
sessionInfo()

