/*!
 * This file is part of cytoscape.js 2.2.1.
 * 
 * Cytoscape.js is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * Cytoscape.js is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with
 * cytoscape.js. If not, see <http://www.gnu.org/licenses/>.
 */
var cytoscape;!function(e){"use strict";var t=cytoscape=function(){return cytoscape.init.apply(cytoscape,arguments)};t.init=function(e){return void 0===e&&(e={}),t.is.plainObject(e)?new t.Core(e):t.is.string(e)?t.extension.apply(t.extension,arguments):void 0},t.fn={},"undefined"!=typeof exports&&(exports=module.exports=cytoscape),"undefined"!=typeof define&&define("cytoscape",function(){return cytoscape}),e&&(e.cytoscape=cytoscape)}("undefined"==typeof window?null:window),function(e,t){"use strict";e.is={string:function(e){return null!=e&&"string"==typeof e},fn:function(e){return null!=e&&"function"==typeof e},array:function(e){return null!=e&&e instanceof Array},plainObject:function(t){return null!=t&&typeof t==typeof{}&&!e.is.array(t)&&t.constructor===Object},number:function(e){return null!=e&&"number"==typeof e&&!isNaN(e)},integer:function(t){return e.is.number(t)&&Math.floor(t)===t},color:function(e){return null!=e&&"string"==typeof e&&""!==$.Color(e).toString()},bool:function(e){return null!=e&&typeof e==typeof!0},elementOrCollection:function(t){return e.is.element(t)||e.is.collection(t)},element:function(t){return t instanceof e.Element&&t._private.single},collection:function(t){return t instanceof e.Collection&&!t._private.single},core:function(t){return t instanceof e.Core},style:function(t){return t instanceof e.Style},stylesheet:function(t){return t instanceof e.Stylesheet},event:function(t){return t instanceof e.Event},emptyString:function(t){return t?e.is.string(t)&&(""===t||t.match(/^\s+$/))?!0:!1:!0},nonemptyString:function(t){return t&&e.is.string(t)&&""!==t&&!t.match(/^\s+$/)?!0:!1},domElement:function(e){return"undefined"==typeof HTMLElement?!1:e instanceof HTMLElement},touch:function(){return t&&("ontouchstart"in t||t.DocumentTouch&&document instanceof DocumentTouch)}}}(cytoscape,"undefined"==typeof window?null:window),function(e){"use strict";e.util={extend:function(){var t,r,i,n,a,o,s=arguments[0]||{},l=1,c=arguments.length,u=!1;for("boolean"==typeof s&&(u=s,s=arguments[1]||{},l=2),"object"==typeof s||e.is.fn(s)||(s={}),c===l&&(s=this,--l);c>l;l++)if(null!=(t=arguments[l]))for(r in t)i=s[r],n=t[r],s!==n&&(u&&n&&(e.is.plainObject(n)||(a=e.is.array(n)))?(a?(a=!1,o=i&&e.is.array(i)?i:[]):o=i&&e.is.plainObject(i)?i:{},s[r]=e.util.extend(u,o,n)):void 0!==n&&(s[r]=n));return s},throttle:function(t,r,i){var n=!0,a=!0;return i===!1?n=!1:e.is.plainObject(i)&&(n="leading"in i?i.leading:n,a="trailing"in i?i.trailing:a),i=i||{},i.leading=n,i.maxWait=r,i.trailing=a,e.util.debounce(t,r,i)},debounce:function(t,r,i){var n,a,o,s,l,c,u,p=0,d=!1,h=!0;if(r=Math.max(0,r)||0,i===!0){var g=!0;h=!1}else e.is.plainObject(i)&&(g=i.leading,d="maxWait"in i&&(Math.max(r,i.maxWait)||0),h="trailing"in i?i.trailing:h);var v=function(){var e=r-(+new Date-s);if(0>=e){a&&clearTimeout(a);var i=u;a=c=u=void 0,i&&(p=+new Date,o=t.apply(l,n),c||a||(n=l=null))}else c=setTimeout(v,e)},f=function(){c&&clearTimeout(c),a=c=u=void 0,(h||d!==r)&&(p=+new Date,o=t.apply(l,n),c||a||(n=l=null))};return function(){if(n=arguments,s=+new Date,l=this,u=h&&(c||!g),d===!1)var e=g&&!c;else{a||g||(p=s);var i=d-(s-p),y=0>=i;y?(a&&(a=clearTimeout(a)),p=s,o=t.apply(l,n)):a||(a=setTimeout(f,i))}return y&&c?c=clearTimeout(c):c||r===d||(c=setTimeout(v,r)),e&&(y=!0,o=t.apply(l,n)),!y||c||a||(n=l=null),o}},error:function(e){if(!console)throw e;if(console.error)console.error(e);else{if(!console.log)throw e;console.log(e)}},clone:function(e){var t={};for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r]);return t},copy:function(t){return null==t?t:e.is.array(t)?t.slice():e.is.plainObject(t)?e.util.clone(t):t},mapEmpty:function(e){var t=!0;if(null!=e)for(var r in e){t=!1;break}return t},pushMap:function(t){var r=e.util.getMap(t);null==r?e.util.setMap($.extend({},t,{value:[t.value]})):r.push(t.value)},setMap:function(t){for(var r,i=t.map,n=t.keys,a=n.length,o=0;a>o;o++){var r=n[o];e.is.plainObject(r)&&e.util.error("Tried to set map with object key"),o<n.length-1?(null==i[r]&&(i[r]={}),i=i[r]):i[r]=t.value}},getMap:function(t){for(var r=t.map,i=t.keys,n=i.length,a=0;n>a;a++){var o=i[a];if(e.is.plainObject(o)&&e.util.error("Tried to get map with object key"),r=r[o],null==r)return r}return r},deleteMap:function(t){for(var r=t.map,i=t.keys,n=i.length,a=t.keepChildren,o=0;n>o;o++){var s=i[o];e.is.plainObject(s)&&e.util.error("Tried to delete map with object key");var l=o===t.keys.length-1;if(l)if(a)for(var c in r)a[c]||delete r[c];else delete r[s];else r=r[s]}},capitalize:function(t){return e.is.emptyString(t)?t:t.charAt(0).toUpperCase()+t.substring(1)},camel2dash:function(e){for(var t=[],r=0;r<e.length;r++){var i=e[r],n=i.toLowerCase(),a=i!==n;a?(t.push("-"),t.push(n)):t.push(i)}var o=t.length===e.length;return o?e:t.join("")},dash2camel:function(e){for(var t=[],r=!1,i=0;i<e.length;i++){var n=e[i],a="-"===n;a?r=!0:(t.push(r?n.toUpperCase():n),r=!1)}return t.join("")},trim:function(e){var t,r;for(t=0;t<e.length&&" "===e[t];t++);for(r=e.length-1;r>t&&" "===e[r];r--);return e.substring(t,r+1)},hex2tuple:function(e){if((4===e.length||7===e.length)&&"#"===e[0]){var t,r,i,n=4===e.length,a=16;return n?(t=parseInt(e[1]+e[1],a),r=parseInt(e[2]+e[2],a),i=parseInt(e[3]+e[3],a)):(t=parseInt(e[1]+e[2],a),r=parseInt(e[3]+e[4],a),i=parseInt(e[5]+e[6],a)),[t,r,i]}},hsl2tuple:function(t){function r(e,t,r){return 0>r&&(r+=1),r>1&&(r-=1),1/6>r?e+6*(t-e)*r:.5>r?t:2/3>r?e+(t-e)*(2/3-r)*6:e}var i,n,a,o,s,l,c,u,p=(e.util.regex.number,new RegExp("^"+e.util.regex.hsla+"$").exec(t));if(p){if(n=parseInt(p[1]),0>n?n=(360- -1*n%360)%360:n>360&&(n%=360),n/=360,a=parseFloat(p[2]),0>a||a>100)return;if(a/=100,o=parseFloat(p[3]),0>o||o>100)return;if(o/=100,s=p[4],void 0!==s&&(s=parseFloat(s),0>s||s>1))return;if(0===a)l=c=u=Math.round(255*o);else{var d=.5>o?o*(1+a):o+a-o*a,h=2*o-d;l=Math.round(255*r(h,d,n+1/3)),c=Math.round(255*r(h,d,n)),u=Math.round(255*r(h,d,n-1/3))}i=[l,c,u,s]}return i},rgb2tuple:function(t){var r,i=(e.util.regex.number,new RegExp("^"+e.util.regex.rgba+"$").exec(t));if(i){r=[];for(var n=[],a=1;3>=a;a++){var o=i[a];if("%"===o[o.length-1]&&(n[a]=!0),o=parseFloat(o),n[a]&&(o=o/100*255),0>o||o>255)return;r.push(Math.floor(o))}var s=n[1]||n[2]||n[3],l=n[1]&&n[2]&&n[3];if(s&&!l)return;var c=i[4];if(void 0!==c){if(c=parseFloat(c),0>c||c>1)return;r.push(c)}}return r},colorname2tuple:function(t){return e.util.colors[t.toLowerCase()]},color2tuple:function(t){return e.util.colorname2tuple(t)||e.util.hex2tuple(t)||e.util.rgb2tuple(t)||e.util.hsl2tuple(t)},tuple2hex:function(e){function t(e){var t=e.toString(16);return 1===t.length&&(t="0"+t),t}var r=e[0],i=e[1],n=e[2];return"#"+t(r)+t(i)+t(n)},colors:{transparent:[0,0,0,0],aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],grey:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},e.util.regex={},e.util.regex.number="(?:[-]?\\d*\\.\\d+|[-]?\\d+|[-]?\\d*\\.\\d+[eE]\\d+)",e.util.regex.rgba="rgb[a]?\\(("+e.util.regex.number+"[%]?)\\s*,\\s*("+e.util.regex.number+"[%]?)\\s*,\\s*("+e.util.regex.number+"[%]?)(?:\\s*,\\s*("+e.util.regex.number+"))?\\)",e.util.regex.rgbaNoBackRefs="rgb[a]?\\((?:"+e.util.regex.number+"[%]?)\\s*,\\s*(?:"+e.util.regex.number+"[%]?)\\s*,\\s*(?:"+e.util.regex.number+"[%]?)(?:\\s*,\\s*(?:"+e.util.regex.number+"))?\\)",e.util.regex.hsla="hsl[a]?\\(("+e.util.regex.number+")\\s*,\\s*("+e.util.regex.number+"[%])\\s*,\\s*("+e.util.regex.number+"[%])(?:\\s*,\\s*("+e.util.regex.number+"))?\\)",e.util.regex.hslaNoBackRefs="hsl[a]?\\((?:"+e.util.regex.number+")\\s*,\\s*(?:"+e.util.regex.number+"[%])\\s*,\\s*(?:"+e.util.regex.number+"[%])(?:\\s*,\\s*(?:"+e.util.regex.number+"))?\\)",e.util.regex.hex3="\\#[0-9a-fA-F]{3}",e.util.regex.hex6="\\#[0-9a-fA-F]{6}";var t="undefined"==typeof window?function(e){e&&e()}:window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame;e.util.requestAnimationFrame=function(e){t(e)}}(cytoscape),function(e){"use strict";e.math={},e.math.signum=function(e){return e>0?1:0>e?-1:0},e.math.distance=function(e,t){var r=t.x-e.x,i=t.y-e.y;return Math.sqrt(r*r+i*i)},e.math.qbezierAt=function(e,t,r,i){return(1-i)*(1-i)*e+2*(1-i)*i*t+i*i*r},e.math.qbezierPtAt=function(t,r,i,n){return{x:e.math.qbezierAt(t.x,r.x,i.x,n),y:e.math.qbezierAt(t.y,r.y,i.y,n)}},e.math.roundRectangleIntersectLine=function(e,t,r,i,n,a,o){var s,l=this.getRoundRectangleRadius(n,a),c=n/2,u=a/2,p=r-c+l-o,d=i-u-o,h=r+c-l+o,g=d;if(s=this.finiteLinesIntersect(e,t,r,i,p,d,h,g,!1),s.length>0)return s;var v=r+c+o,f=i-u+l-o,y=v,m=i+u-l+o;if(s=this.finiteLinesIntersect(e,t,r,i,v,f,y,m,!1),s.length>0)return s;var b=r-c+l-o,x=i+u+o,w=r+c-l+o,_=x;if(s=this.finiteLinesIntersect(e,t,r,i,b,x,w,_,!1),s.length>0)return s;var E=r-c-o,S=i-u+l-o,P=E,k=i+u-l+o;if(s=this.finiteLinesIntersect(e,t,r,i,E,S,P,k,!1),s.length>0)return s;var M,N=r-c+l,C=i-u+l;if(M=this.intersectLineCircle(e,t,r,i,N,C,l+o),M.length>0&&M[0]<=N&&M[1]<=C)return[M[0],M[1]];var D=r+c-l,T=i-u+l;if(M=this.intersectLineCircle(e,t,r,i,D,T,l+o),M.length>0&&M[0]>=D&&M[1]<=T)return[M[0],M[1]];var I=r+c-l,z=i+u-l;if(M=this.intersectLineCircle(e,t,r,i,I,z,l+o),M.length>0&&M[0]>=I&&M[1]>=z)return[M[0],M[1]];var B=r-c+l,R=i+u-l;return M=this.intersectLineCircle(e,t,r,i,B,R,l+o),M.length>0&&M[0]<=B&&M[1]>=R?[M[0],M[1]]:[]},e.math.roundRectangleIntersectBox=function(e,t,r,i,n,a,o,s,l){var c=this.getRoundRectangleRadius(n,a),u=o-n/2-l,p=s-a/2+c-l,d=o+n/2+l,h=s+a/2-c+l,g=o-n/2+c-l,v=s-a/2-l,f=o+n/2-c+l,y=s+a/2+l,m=Math.min(e,r),b=Math.max(e,r),x=Math.min(t,i),w=Math.max(t,i);return u>b?!1:m>d?!1:v>w?!1:x>y?!1:u>=m&&b>=u&&p>=x&&w>=p?!0:d>=m&&b>=d&&p>=x&&w>=p?!0:d>=m&&b>=d&&h>=x&&w>=h?!0:u>=m&&b>=u&&h>=x&&w>=h?!0:m>=u&&d>=m&&x>=p&&h>=x?!0:b>=u&&d>=b&&x>=p&&h>=x?!0:b>=u&&d>=b&&w>=p&&h>=w?!0:m>=u&&d>=m&&w>=p&&h>=w?!0:g>=m&&b>=g&&v>=x&&w>=v?!0:f>=m&&b>=f&&v>=x&&w>=v?!0:f>=m&&b>=f&&y>=x&&w>=y?!0:g>=m&&b>=g&&y>=x&&w>=y?!0:m>=g&&f>=m&&x>=v&&y>=x?!0:b>=g&&f>=b&&x>=v&&y>=x?!0:b>=g&&f>=b&&w>=v&&y>=w?!0:m>=g&&f>=m&&w>=v&&y>=w?!0:this.boxIntersectEllipse(m,x,b,w,l,2*c,2*c,g+l,p+l)?!0:this.boxIntersectEllipse(m,x,b,w,l,2*c,2*c,f-l,p+l)?!0:this.boxIntersectEllipse(m,x,b,w,l,2*c,2*c,f-l,h-l)?!0:this.boxIntersectEllipse(m,x,b,w,l,2*c,2*c,g+l,h-l)?!0:!1},e.math.checkInBoundingCircle=function(e,t,r,i,n,a,o,s){return e=(e-o)/(n+i),t=(t-s)/(a+i),r>=e*e+t*t},e.math.checkInBoundingBox=function(e,t,r,i,n,a,o,s){for(var l=r[0],c=r[1],u=r[0],p=r[1],d=1;d<r.length/2;d++)r[2*d]<l?l=r[2*d]:r[2*d]>u&&(u=r[2*d]),r[2*d+1]<c?c=r[2*d+1]:r[2*d+1]>p&&(p=r[2*d+1]);return e-=o,t-=s,e/=n,t/=a,l>e?!1:e>u?!1:c>t?!1:t>p?!1:!0},e.math.boxInBezierVicinity=function(e,t,r,i,n,a,o,s,l,c,u){var p=.25*n+.5*o+.25*l,d=.25*a+.5*s+.25*c,h=Math.min(e,r)-u,g=Math.min(t,i)-u,v=Math.max(e,r)+u,f=Math.max(t,i)+u;if(n>=h&&v>=n&&a>=g&&f>=a)return 1;if(l>=h&&v>=l&&c>=g&&f>=c)return 1;if(p>=h&&v>=p&&d>=g&&f>=d)return 1;if(o>=h&&v>=o&&s>=g&&f>=s)return 1;var y=Math.min(n,p,l),m=Math.min(a,d,c),b=Math.max(n,p,l),x=Math.max(a,d,c);return y>v||h>b||m>f||g>x?0:1},e.math.checkBezierInBox=function(t,r,i,n,a,o,s,l,c,u){function p(p){var d=e.math.qbezierAt(a,s,c,p),h=e.math.qbezierAt(o,l,u,p);return d>=t&&i>=d&&h>=r&&n>=h}for(var d=0;1>=d;d+=.25)if(!p(d))return!1;return!0},e.math.checkStraightEdgeInBox=function(e,t,r,i,n,a,o,s){return n>=e&&r>=n&&o>=e&&r>=o&&a>=t&&i>=a&&s>=t&&i>=s},e.math.checkStraightEdgeCrossesBox=function(e,t,r,i,n,a,o,s,l){var c,u,p=Math.min(e,r)-l,d=Math.min(t,i)-l,h=Math.max(e,r)+l,g=Math.max(t,i)+l,v=o-n,f=n,y=s-a,m=a;if(Math.abs(v)<1e-4)return n>=p&&h>=n&&Math.min(a,s)<=d&&Math.max(a,s)>=g;var b=(p-f)/v;if(b>0&&1>=b&&(c=y*b+m,c>=d&&g>=c))return!0;var x=(h-f)/v;if(x>0&&1>=x&&(c=y*x+m,c>=d&&g>=c))return!0;var w=(d-m)/y;if(w>0&&1>=w&&(u=v*w+f,u>=p&&h>=u))return!0;var _=(g-m)/y;return _>0&&1>=_&&(u=v*_+f,u>=p&&h>=u)?!0:!1},e.math.checkBezierCrossesBox=function(e,t,r,i,n,a,o,s,l,c,u){var p=Math.min(e,r)-u,d=Math.min(t,i)-u,h=Math.max(e,r)+u,g=Math.max(t,i)+u;if(n>=p&&h>=n&&a>=d&&g>=a)return!0;if(l>=p&&h>=l&&c>=d&&g>=c)return!0;var v=n-2*o+l,f=-2*n+2*o,y=n,m=[];if(Math.abs(v)<1e-4){var b=(p-n)/f,x=(h-n)/f;m.push(b,x)}else{var w,_,E=f*f-4*v*(y-p);if(E>0){var S=Math.sqrt(E);w=(-f+S)/(2*v),_=(-f-S)/(2*v),m.push(w,_)}var P,k,M=f*f-4*v*(y-h);if(M>0){var S=Math.sqrt(M);P=(-f+S)/(2*v),k=(-f-S)/(2*v),m.push(P,k)}}m.sort(function(e,t){return e-t});var N=a-2*s+c,C=-2*a+2*s,D=a,T=[];if(Math.abs(N)<1e-4){var I=(d-a)/C,z=(g-a)/C;T.push(I,z)}else{var B,R,X=C*C-4*N*(D-d);if(X>0){var S=Math.sqrt(X);B=(-C+S)/(2*N),R=(-C-S)/(2*N),T.push(B,R)}var Y,V,L=C*C-4*N*(D-g);if(L>0){var S=Math.sqrt(L);Y=(-C+S)/(2*N),V=(-C-S)/(2*N),T.push(Y,V)}}T.sort(function(e,t){return e-t});for(var A=0;A<m.length;A+=2)for(var O=1;O<T.length;O+=2)if(m[A]<T[O]&&T[O]>=0&&m[A]<=1&&m[A+1]>T[O-1]&&T[O-1]<=1&&m[A+1]>=0)return!0;return!1},e.math.inLineVicinity=function(e,t,r,i,n,a,o){var s=o,l=Math.min(r,n),c=Math.max(r,n),u=Math.min(i,a),p=Math.max(i,a);return e>=l-s&&c+s>=e&&t>=u-s&&p+s>=t},e.math.inBezierVicinity=function(e,t,r,i,n,a,o,s,l){var c={x1:Math.min(r,o,n),x2:Math.max(r,o,n),y1:Math.min(i,s,a),y2:Math.max(i,s,a)};return e<c.x1||e>c.x2||t<c.y1||t>c.y2?!1:!0;var c},e.math.solveCubic=function(e,t,r,i,n){t/=e,r/=e,i/=e;var a,o,s,l,c,u,p,d;return o=(3*r-t*t)/9,s=-(27*i)+t*(9*r-2*t*t),s/=54,a=o*o*o+s*s,n[1]=0,p=t/3,a>0?(c=s+Math.sqrt(a),c=0>c?-Math.pow(-c,1/3):Math.pow(c,1/3),u=s-Math.sqrt(a),u=0>u?-Math.pow(-u,1/3):Math.pow(u,1/3),n[0]=-p+c+u,p+=(c+u)/2,n[4]=n[2]=-p,p=Math.sqrt(3)*(-u+c)/2,n[3]=p,void(n[5]=-p)):(n[5]=n[3]=0,0==a?(d=0>s?-Math.pow(-s,1/3):Math.pow(s,1/3),n[0]=-p+2*d,void(n[4]=n[2]=-(d+p))):(o=-o,l=o*o*o,l=Math.acos(s/Math.sqrt(l)),d=2*Math.sqrt(o),n[0]=-p+d*Math.cos(l/3),n[2]=-p+d*Math.cos((l+2*Math.PI)/3),void(n[4]=-p+d*Math.cos((l+4*Math.PI)/3))))},e.math.sqDistanceToQuadraticBezier=function(e,t,r,i,n,a,o,s){var l=1*r*r-4*r*n+2*r*o+4*n*n-4*n*o+o*o+i*i-4*i*a+2*i*s+4*a*a-4*a*s+s*s,c=9*r*n-3*r*r-3*r*o-6*n*n+3*n*o+9*i*a-3*i*i-3*i*s-6*a*a+3*a*s,u=3*r*r-6*r*n+r*o-r*e+2*n*n+2*n*e-o*e+3*i*i-6*i*a+i*s-i*t+2*a*a+2*a*t-s*t,p=1*r*n-r*r+r*e-n*e+i*a-i*i+i*t-a*t,d=[];this.solveCubic(l,c,u,p,d);for(var h=1e-7,g=[],v=0;6>v;v+=2)Math.abs(d[v+1])<h&&d[v]>=0&&d[v]<=1&&g.push(d[v]);g.push(1),g.push(0);for(var f,y,m,b,x=-1,w=0;w<g.length;w++)y=Math.pow(1-g[w],2)*r+2*(1-g[w])*g[w]*n+g[w]*g[w]*o,m=Math.pow(1-g[w],2)*i+2*(1-g[w])*g[w]*a+g[w]*g[w]*s,b=Math.pow(y-e,2)+Math.pow(m-t,2),x>=0?x>b&&(x=b,f=g[w]):(x=b,f=g[w]);return x},e.math.sqDistanceToFiniteLine=function(e,t,r,i,n,a){var o=[e-r,t-i],s=[n-r,a-i],l=s[0]*s[0]+s[1]*s[1],c=o[0]*o[0]+o[1]*o[1],u=o[0]*s[0]+o[1]*s[1],p=u*u/l;return 0>u?c:p>l?(e-n)*(e-n)+(t-a)*(t-a):c-p},e.math.pointInsidePolygon=function(e,t,r,i,n,a,o,s,l){var c=new Array(r.length),u=Math.asin(s[1]/Math.sqrt(s[0]*s[0]+s[1]*s[1]));s[0]<0?u+=Math.PI/2:u=-u-Math.PI/2;for(var p=Math.cos(-u),d=Math.sin(-u),h=0;h<c.length/2;h++)c[2*h]=a/2*(r[2*h]*p-r[2*h+1]*d),c[2*h+1]=o/2*(r[2*h+1]*p+r[2*h]*d),c[2*h]+=i,c[2*h+1]+=n;var g;if(l>0){var v=this.expandPolygon(c,-l);g=this.joinLines(v)}else g=c;for(var f,y,m,b,x,w=0,_=0,h=0;h<g.length/2;h++)if(f=g[2*h],y=g[2*h+1],h+1<g.length/2?(m=g[2*(h+1)],b=g[2*(h+1)+1]):(m=g[2*(h+1-g.length/2)],b=g[2*(h+1-g.length/2)+1]),f==e&&m==e);else{if(!(f>=e&&e>=m||e>=f&&m>=e))continue;x=(e-f)/(m-f)*(b-y)+y,x>t&&w++,t>x&&_++}return w%2==0?!1:!0},e.math.joinLines=function(e){for(var t,r,i,n,a,o,s,l,c=new Array(e.length/2),u=0;u<e.length/4;u++){t=e[4*u],r=e[4*u+1],i=e[4*u+2],n=e[4*u+3],u<e.length/4-1?(a=e[4*(u+1)],o=e[4*(u+1)+1],s=e[4*(u+1)+2],l=e[4*(u+1)+3]):(a=e[0],o=e[1],s=e[2],l=e[3]);var p=this.finiteLinesIntersect(t,r,i,n,a,o,s,l,!0);c[2*u]=p[0],c[2*u+1]=p[1]}return c},e.math.expandPolygon=function(e,t){for(var r,i,n,a,o=new Array(2*e.length),s=0;s<e.length/2;s++){r=e[2*s],i=e[2*s+1],s<e.length/2-1?(n=e[2*(s+1)],a=e[2*(s+1)+1]):(n=e[0],a=e[1]);var l=a-i,c=-(n-r),u=Math.sqrt(l*l+c*c),p=l/u,d=c/u;o[4*s]=r+p*t,o[4*s+1]=i+d*t,o[4*s+2]=n+p*t,o[4*s+3]=a+d*t}return o},e.math.intersectLineEllipse=function(e,t,r,i,n,a){var o=r-e,s=i-t;o/=n,s/=a;var l=Math.sqrt(o*o+s*s),c=l-1;if(0>c)return[];var u=c/l;return[(r-e)*u+e,(i-t)*u+t]},e.math.dotProduct=function(e,t){if(2!=e.length||2!=t.length)throw"dot product: arguments are not vectors";return e[0]*t[0]+e[1]*t[1]},e.math.intersectLineCircle=function(e,t,r,i,n,a,o){var s=[r-e,i-t],l=[n,a],c=[e-n,t-a],u=s[0]*s[0]+s[1]*s[1],p=2*(c[0]*s[0]+c[1]*s[1]),l=c[0]*c[0]+c[1]*c[1]-o*o,d=p*p-4*u*l;if(0>d)return[];var h=(-p+Math.sqrt(d))/(2*u),g=(-p-Math.sqrt(d))/(2*u),v=Math.min(h,g),f=Math.max(h,g),y=[];if(v>=0&&1>=v&&y.push(v),f>=0&&1>=f&&y.push(f),0==y.length)return[];var m=y[0]*s[0]+e,b=y[0]*s[1]+t;if(y.length>1){if(y[0]==y[1])return[m,b];var x=y[1]*s[0]+e,w=y[1]*s[1]+t;return[m,b,x,w]}return[m,b]},e.math.findCircleNearPoint=function(e,t,r,i,n){var a=i-e,o=n-t,s=Math.sqrt(a*a+o*o),l=a/s,c=o/s;return[e+l*r,t+c*r]},e.math.findMaxSqDistanceToOrigin=function(e){for(var t,r=1e-6,i=0;i<e.length/2;i++)t=e[2*i]*e[2*i]+e[2*i+1]*e[2*i+1],t>r&&(r=t);return r},e.math.finiteLinesIntersect=function(e,t,r,i,n,a,o,s,l){var c=(o-n)*(t-a)-(s-a)*(e-n),u=(r-e)*(t-a)-(i-t)*(e-n),p=(s-a)*(r-e)-(o-n)*(i-t);if(0!=p){var d=c/p,h=u/p;return d>=0&&1>=d&&h>=0&&1>=h?[e+d*(r-e),t+d*(i-t)]:l?[e+d*(r-e),t+d*(i-t)]:[]}return 0==c||0==u?[e,r,o].sort()[1]==o?[o,s]:[e,r,n].sort()[1]==n?[n,a]:[n,o,r].sort()[1]==r?[r,i]:[]:[]},e.math.boxIntersectEllipse=function(e,t,r,i,n,a,o,s,l){if(e>r){var c=e;e=r,r=c}if(t>i){var u=t;t=i,i=u}var p=[s-a/2-n,l],d=[s+a/2+n,l],h=[s,l-o/2-n],g=[s,l+o/2+n];return r<p[0]?!1:e>d[0]?!1:t>g[1]?!1:i<h[1]?!1:e<=d[0]&&d[0]<=r&&t<=d[1]&&d[1]<=i?!0:e<=p[0]&&p[0]<=r&&t<=p[1]&&p[1]<=i?!0:e<=h[0]&&h[0]<=r&&t<=h[1]&&h[1]<=i?!0:e<=g[0]&&g[0]<=r&&t<=g[1]&&g[1]<=i?!0:(e=(e-s)/(a/2+n),r=(r-s)/(a/2+n),t=(t-l)/(o/2+n),i=(i-l)/(o/2+n),1>=e*e+t*t?!0:1>=r*r+t*t?!0:1>=r*r+i*i?!0:1>=e*e+i*i?!0:!1)},e.math.boxIntersectPolygon=function(t,r,i,n,a,o,s,l,c,u,p){if(t>i){var d=t;t=i,i=d}if(r>n){var h=r;r=n,n=h}var g=new Array(a.length),v=Math.asin(u[1]/Math.sqrt(u[0]*u[0]+u[1]*u[1]));u[0]<0?v+=Math.PI/2:v=-v-Math.PI/2;for(var f=Math.cos(-v),y=Math.sin(-v),m=0;m<g.length/2;m++)g[2*m]=o/2*(a[2*m]*f-a[2*m+1]*y),g[2*m+1]=s/2*(a[2*m+1]*f+a[2*m]*y),g[2*m]+=l,g[2*m+1]+=c;for(var b=g[0],x=g[0],w=g[1],_=g[1],m=1;m<g.length/2;m++)g[2*m]>x&&(x=g[2*m]),g[2*m]<b&&(b=g[2*m]),g[2*m+1]>_&&(_=g[2*m+1]),g[2*m+1]<w&&(w=g[2*m+1]);if(b-p>i)return!1;if(t>x+p)return!1;if(w-p>n)return!1;if(r>_+p)return!1;var E;if(p>0){var S=e.math.expandPolygon(g,-p);E=e.math.joinLines(S)}else E=g;for(var m=0;m<g.length/2;m++)if(t<=g[2*m]&&g[2*m]<=i&&r<=g[2*m+1]&&g[2*m+1]<=n)return!0;for(var m=0;m<E.length/2;m++){var P,k,M=E[2*m],N=E[2*m+1];if(m<E.length/2-1?(P=E[2*(m+1)],k=E[2*(m+1)+1]):(P=E[0],k=E[1]),e.math.finiteLinesIntersect(M,N,P,k,t,r,i,r,!1).length>0)return!0;if(e.math.finiteLinesIntersect(M,N,P,k,t,n,i,n,!1).length>0)return!0;if(e.math.finiteLinesIntersect(M,N,P,k,t,r,t,n,!1).length>0)return!0;if(e.math.finiteLinesIntersect(M,N,P,k,i,r,i,n,!1).length>0)return!0}return!1},e.math.polygonIntersectLine=function(t,r,i,n,a,o,s,l){for(var c,u=[],p=new Array(i.length),d=0;d<p.length/2;d++)p[2*d]=i[2*d]*o+n,p[2*d+1]=i[2*d+1]*s+a;var h;if(l>0){var g=e.math.expandPolygon(p,-l);h=e.math.joinLines(g)}else h=p;for(var v,f,y,m,d=0;d<h.length/2;d++)v=h[2*d],f=h[2*d+1],d<h.length/2-1?(y=h[2*(d+1)],m=h[2*(d+1)+1]):(y=h[0],m=h[1]),c=this.finiteLinesIntersect(t,r,n,a,v,f,y,m),0!=c.length&&u.push(c[0],c[1]);return u},e.math.shortenIntersection=function(e,t,r){var i=[e[0]-t[0],e[1]-t[1]],n=Math.sqrt(i[0]*i[0]+i[1]*i[1]),a=(n-r)/n;return 0>a&&(a=1e-5),[t[0]+a*i[0],t[1]+a*i[1]]},e.math.generateUnitNgonPointsFitToSquare=function(t,r){var i=e.math.generateUnitNgonPoints(t,r);return i=e.math.fitPolygonToSquare(i)},e.math.fitPolygonToSquare=function(e){for(var t,r,i=e.length/2,n=1/0,a=1/0,o=-1/0,s=-1/0,l=0;i>l;l++)t=e[2*l],r=e[2*l+1],n=Math.min(n,t),o=Math.max(o,t),a=Math.min(a,r),s=Math.max(s,r);for(var c=2/(o-n),u=2/(s-a),l=0;i>l;l++)t=e[2*l]=e[2*l]*c,r=e[2*l+1]=e[2*l+1]*u,n=Math.min(n,t),o=Math.max(o,t),a=Math.min(a,r),s=Math.max(s,r);if(-1>a)for(var l=0;i>l;l++)r=e[2*l+1]=e[2*l+1]+(-1-a);return e},e.math.generateUnitNgonPoints=function(e,t){var r=1/e*2*Math.PI,i=e%2==0?Math.PI/2+r/2:Math.PI/2;i+=t;for(var n,a,o,s=new Array(2*e),l=0;e>l;l++)n=l*r+i,a=s[2*l]=Math.cos(n),o=s[2*l+1]=Math.sin(-n);return s},e.math.getRoundRectangleRadius=function(e,t){return Math.min(e/2,t/2,10)}}(cytoscape),function(e){"use strict";e.instances=[],e.instanceCounter=0,e.lastInstanceTime,e.registerInstance=function(t,r){var i;e.is.core(t)?i=t:e.is.domElement(t)&&(r=t);var n=e.getRegistrationForInstance(t,r);if(n)return n.cy?e.util.error("Tried to register on a pre-existing registration"):(n.cy=t,n.domElement=r),n;var a,o=+new Date;e.lastInstanceTime&&e.lastInstanceTime!==o?++e.instanceCounter:e.instanceCounter=0,e.lastInstanceTime=o,a=e.instanceCounter;var s="cy-"+o+"-"+a,l={id:s,cy:i,domElement:r,readies:[]};return e.instances.push(l),e.instances[s]=l,l},e.removeRegistrationForInstance=function(t,r){var i;if(e.is.core(t)?i=t:e.is.domElement(t)&&(r=t),e.is.core(i)){var n=i._private.instanceId;delete e.instances[n],e.instances.splice(n,1)}else if(e.is.domElement(r))for(var a=0;a<e.instances.length;a++){var o=e.instances[a];o.domElement===r&&(delete e.instances[o.id],e.instances.splice(a,1),a--)}},e.getRegistrationForInstance=function(t,r){var i;if(e.is.core(t)?t.registered()&&(i=t):e.is.domElement(t)&&(r=t),e.is.core(i)){var n=i._private.instanceId;return e.instances[n]}if(e.is.domElement(r))for(var a=e.instances.length-1;a>=0;a--){var o=e.instances[a];if(o.domElement===r)return o}}}(cytoscape),function(e){"use strict";function t(t,r,i){var n={};switch(n[r]=i,t){case"core":case"collection":e.fn[t](n)}return e.util.setMap({map:a,keys:[t,r],value:i})}function r(t,r){return e.util.getMap({map:a,keys:[t,r]})}function i(t,r,i,n,a){return e.util.setMap({map:o,keys:[t,r,i,n],value:a})}function n(t,r,i,n){return e.util.getMap({map:o,keys:[t,r,i,n]})}var a={};e.extensions=a;var o={};e.modules=o,e.extension=function(){return 2==arguments.length?r.apply(this,arguments):3==arguments.length?t.apply(this,arguments):4==arguments.length?n.apply(this,arguments):5==arguments.length?i.apply(this,arguments):void $.error("Invalid extension access syntax")}}(cytoscape),function(e,t){"use strict";e&&(e.fn.cytoscape=function(r){var i=e(this);if("get"===r){var n=t.getRegistrationForInstance(i[0]);return n.cy}if(!t.is.fn(r)){if(t.is.plainObject(r))return i.each(function(){var t=e.extend({},r,{container:e(this)[0]});cytoscape(t)});for(var a=i[0],o=[],s=[],l=1;l<arguments.length;l++)s[l-1]=arguments[l];return i.each(function(){var e=t.getRegistrationForInstance(a),i=e.cy,n=r;if(i&&t.is.fn(i[n])){var l=i[n].apply(i,s);o.push(l)}}),1===o.length?o=o[0]:0==o.length&&(o=e(this)),o}var c=r,a=i[0],n=t.getRegistrationForInstance(a);n||(n=t.registerInstance(a)),n&&n.cy&&n.cy.ready()?n.cy.trigger("ready",[],c):n.readies.push(c)},e.cytoscape=cytoscape,null==e.fn.cy&&null==e.cy&&(e.fn.cy=e.fn.cytoscape,e.cy=e.cytoscape))}("undefined"!=typeof jQuery?jQuery:null,cytoscape),function(e){"use strict";function t(){return!1}function r(){return!0}e.Event=function(i,n){return this instanceof e.Event?(i&&i.type?(this.originalEvent=i,this.type=i.type,this.isDefaultPrevented=i.defaultPrevented||i.getPreventDefault&&i.getPreventDefault()?r:t):this.type=i,n&&e.util.extend(this,n),void(this.timeStamp=i&&i.timeStamp||+new Date)):new e.Event(i,n)},e.Event.prototype={preventDefault:function(){this.isDefaultPrevented=r;var e=this.originalEvent;e&&e.preventDefault&&e.preventDefault()},stopPropagation:function(){this.isPropagationStopped=r;var e=this.originalEvent;e&&e.stopPropagation&&e.stopPropagation()},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=r,this.stopPropagation()},isDefaultPrevented:t,isPropagationStopped:t,isImmediatePropagationStopped:t}}(cytoscape),function(e){"use strict";e.define={data:function(t){var r={field:"data",bindingEvent:"data",allowBinding:!1,allowSetting:!1,allowGetting:!1,settingEvent:"data",settingTriggersEvent:!1,triggerFnName:"trigger",immutableKeys:{},updateMappers:!1,onSet:function(){},canSet:function(){return!0}};return t=e.util.extend({},r,t),function(r,i){var n=t,a=this,o=void 0!==a.length,s=o?a:[a],l=o?a[0]:a;if(e.is.string(r)){if(n.allowGetting&&void 0===i){var c;return l&&(c=l._private[n.field][r]),c}if(n.allowSetting&&void 0!==i){var u=!n.immutableKeys[r];if(u){for(var p=0,d=s.length;d>p;p++)n.canSet(s[p])&&(s[p]._private[n.field][r]=i);n.updateMappers&&a.updateMappers(),n.onSet(a),n.settingTriggersEvent&&a[n.triggerFnName](n.settingEvent)}}}else if(n.allowSetting&&e.is.plainObject(r)){var h,g,v=r;for(h in v){g=v[h];var u=!n.immutableKeys[h];if(u)for(var p=0,d=s.length;d>p;p++)n.canSet(s[p])&&(s[p]._private[n.field][h]=g)}n.updateMappers&&a.updateMappers(),n.onSet(a),n.settingTriggersEvent&&a[n.triggerFnName](n.settingEvent)}else if(n.allowBinding&&e.is.fn(r)){var f=r;a.bind(n.bindingEvent,f)}else if(n.allowGetting&&void 0===r){var c;return l&&(c=l._private[n.field]),c}return a}},batchData:function(t){var r={field:"data",event:"data",triggerFnName:"trigger",immutableKeys:{},updateMappers:!1},i=t=e.util.extend({},r,t);return function(t){var r=this,n=void 0!==r.length,a=n?r:r._private.elements;if(0===a.length)return r;for(var o=n?a[0]._private.cy:r,s=0;s<a.length;s++){var l=a[s],c=l._private.data.id,u=t[c];if(void 0!==u&&null!==u){var p,d,h=u;for(p in h){d=h[p];var g=!i.immutableKeys[p];g&&(l._private[i.field][p]=d)}}}var v=new e.Collection(o,a);return i.updateMappers&&v.updateMappers(),v[i.triggerFnName](i.event),r}},removeData:function(t){var r={field:"data",event:"data",triggerFnName:"trigger",triggerEvent:!1,immutableKeys:{}};return t=e.util.extend({},r,t),function(r){{var i=t,n=this,a=void 0!==n.length,o=a?n:[n];a?n[0]:n}if(e.is.string(r)){for(var s=r.split(/\s+/),l=s.length,c=0;l>c;c++){var u=s[c];if(!e.is.emptyString(u)){var p=!i.immutableKeys[u];if(p)for(var d=0,h=o.length;h>d;d++)delete o[d]._private[i.field][u]}}i.triggerEvent&&n[i.triggerFnName](i.event)}else if(void 0===r){for(var d=0,h=o.length;h>d;d++){var g=o[d]._private[i.field];for(var u in g){var v=!i.immutableKeys[u];v&&delete g[u]}}i.triggerEvent&&n[i.triggerFnName](i.event)}return n}},event:{regex:/(\w+)(\.\w+)?/,optionalTypeRegex:/(\w+)?(\.\w+)?/,falseCallback:function(){return!1}},on:function(t){var r={unbindSelfOnTrigger:!1,unbindAllBindersOnTrigger:!1};return t=e.util.extend({},r,t),function(r,i,n,a){var o=this,s=void 0!==o.length,l=s?o:[o],c=(s?o[0]:o,e.is.string(r)),u=t;if(e.is.plainObject(i)?(a=n,n=i,i=void 0):(e.is.fn(i)||i===!1)&&(a=i,n=void 0,i=void 0),(e.is.fn(n)||n===!1)&&(a=n,n=void 0),!e.is.fn(a)&&a!==!1&&c)return o;if(c){var p={};p[r]=a,r=p}for(var d in r)if(a=r[d],a===!1&&(a=e.define.event.falseCallback),e.is.fn(a)){d=d.split(/\s+/);for(var h=0;h<d.length;h++){var g=d[h];if(!e.is.emptyString(g)){var v=g.match(e.define.event.regex);if(v)for(var f=v[1],y=v[2]?v[2]:void 0,m={callback:a,data:n,delegated:i?!0:!1,selector:i,selObj:new e.Selector(i),type:f,namespace:y,unbindSelfOnTrigger:u.unbindSelfOnTrigger,unbindAllBindersOnTrigger:u.unbindAllBindersOnTrigger,binders:l},b=0;b<l.length;b++)l[b]._private.listeners.push(m)}}}return o}},off:function(t){var r={};return t=e.util.extend({},r,t),function(t,r,i){var n=this,a=void 0!==n.length,o=a?n:[n],s=(a?n[0]:n,e.is.string(t));if(0===arguments.length){for(var l=0;l<o.length;l++)o[l]._private.listeners=[];return n}if((e.is.fn(r)||r===!1)&&(i=r,r=void 0),s){var c={};c[t]=i,t=c}for(var u in t){i=t[u],i===!1&&(i=e.define.event.falseCallback),u=u.split(/\s+/);for(var p=0;p<u.length;p++){var d=u[p];if(!e.is.emptyString(d)){var h=d.match(e.define.event.optionalTypeRegex);if(h)for(var g=h[1]?h[1]:void 0,v=h[2]?h[2]:void 0,l=0;l<o.length;l++)for(var f=o[l]._private.listeners,y=0;y<f.length;y++){var m=f[y],b=!v||v===m.namespace,x=!g||m.type===g,w=!i||i===m.callback,_=b&&x&&w;_&&(f.splice(y,1),y--)}}}}return n}},trigger:function(t){var r={};return t=e.util.extend({},r,t),function(t,r,i){var n=this,a=void 0!==n.length,o=a?n:[n],s=(a?n[0]:n,e.is.string(t)),l=e.is.plainObject(t),c=e.is.event(t),u=this._private.cy||this;if(s){var p=t.split(/\s+/);t=[];for(var d=0;d<p.length;d++){var h=p[d];if(!e.is.emptyString(h)){var g=h.match(e.define.event.regex),v=g[1],f=g[2]?g[2]:void 0;t.push({type:v,namespace:f})}}}else if(l){var y=t;t=[y]}r?e.is.array(r)||(r=[r]):r=[];for(var d=0;d<t.length;d++)for(var m=t[d],b=0;b<o.length;b++){var h,x=o[b],w=x._private.listeners,_=e.is.element(x),E=_;if(c?(h=m,h.cyTarget=h.cyTarget||x,h.cy=h.cy||u,h.namespace=h.namespace||m.namespace):h=new e.Event(m,{cyTarget:x,cy:u,namespace:m.namespace}),h.cyPosition){var S=h.cyPosition,P=u.zoom(),k=u.pan();h.cyRenderedPosition={x:S.x*P+k.x,y:S.y*P+k.y}}i&&(w=[{namespace:h.namespace,type:h.type,callback:i}]);
for(var M=0;M<w.length;M++){var N=w[M],C=!N.namespace||N.namespace===h.namespace,D=N.type===h.type,T=N.delegated?x!==h.cyTarget&&e.is.element(h.cyTarget)&&N.selObj.filter(h.cyTarget).length>0:!0,I=C&&D&&T;if(I){var z=[h];if(z=z.concat(r),h.data=N.data?N.data:void 0,(N.unbindSelfOnTrigger||N.unbindAllBindersOnTrigger)&&(w.splice(M,1),M--),N.unbindAllBindersOnTrigger)for(var B=N.binders,R=0;R<B.length;R++){var X=B[R];if(X&&X!==x)for(var Y=X._private.listeners,V=0;V<Y.length;V++){var L=Y[V];L===N&&(Y.splice(V,1),V--)}}var A=N.delegated?h.cyTarget:x,O=N.callback.apply(A,z);(O===!1||h.isPropagationStopped())&&(E=!1,O===!1&&(h.stopPropagation(),h.preventDefault()))}}if(E){var F=x.parent(),q=0!==F.length;q?(F=F[0],F.trigger(h)):u.trigger(h)}}return n}}}}(cytoscape),function(e){"use strict";e.fn.selector=function(t){for(var r in t){var i=t[r];e.Selector.prototype[r]=i}},e.Selector=function(t,r){if(!(this instanceof e.Selector))return new e.Selector(t,r);void 0===r&&void 0!==t&&(r=t,t=void 0);var i=this;if(i._private={selectorText:null,invalid:!0},!r||e.is.string(r)&&r.match(/^\s*$/))null==t?i.length=0:(i[0]=o(),i[0].group=t,i.length=1);else if(e.is.element(r)){var n=new e.Collection(i.cy(),[r]);i[0]=o(),i[0].collection=n,i.length=1}else if(e.is.collection(r))i[0]=o(),i[0].collection=r,i.length=1;else if(e.is.fn(r))i[0]=o(),i[0].filter=r,i.length=1;else{if(!e.is.string(r))return void e.util.error("A selector must be created from a string; found "+r);var a=null,o=function(){return{classes:[],colonSelectors:[],data:[],group:null,ids:[],meta:[],collection:null,filter:null,parent:null,ancestor:null,subject:null,child:null,descendant:null}},s={metaChar:"[\\!\\\"\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\.\\/\\:\\;\\<\\=\\>\\?\\@\\[\\]\\^\\`\\{\\|\\}\\~]",variable:'(?:[\\w-]|(?:\\\\"+ metaChar +"))+',comparatorOp:"=|\\!=|>|>=|<|<=|\\$=|\\^=|\\*=",boolOp:"\\?|\\!|\\^",string:'"(?:\\\\"|[^"])+"|'+"'(?:\\\\'|[^'])+'",number:e.util.regex.number,meta:"degree|indegree|outdegree",separator:"\\s*,\\s*",descendant:"\\s+",child:"\\s+>\\s+",subject:"\\$"};s.value=s.string+"|"+s.number,s.className=s.variable,s.id=s.variable;for(var l=function(e){return e.replace(new RegExp("\\\\("+s.metaChar+")","g"),function(e,t){return t})},c=s.comparatorOp.split("|"),u=0;u<c.length;u++){var p=c[u];s.comparatorOp+="|@"+p}var d={group:{query:!0,regex:"(node|edge|\\*)",populate:function(e){this.group="*"==e?e:e+"s"}},state:{query:!0,regex:"(:selected|:unselected|:locked|:unlocked|:visible|:hidden|:transparent|:grabbed|:free|:removed|:inside|:grabbable|:ungrabbable|:animated|:unanimated|:selectable|:unselectable|:parent|:child|:loop|:simple|:active|:inactive|:touch)",populate:function(e){this.colonSelectors.push(e)}},id:{query:!0,regex:"\\#("+s.id+")",populate:function(e){this.ids.push(l(e))}},className:{query:!0,regex:"\\.("+s.className+")",populate:function(e){this.classes.push(l(e))}},dataExists:{query:!0,regex:"\\[\\s*("+s.variable+")\\s*\\]",populate:function(e){this.data.push({field:l(e)})}},dataCompare:{query:!0,regex:"\\[\\s*("+s.variable+")\\s*("+s.comparatorOp+")\\s*("+s.value+")\\s*\\]",populate:function(e,t,r){var i=null!=new RegExp("^"+s.string+"$").exec(r);r=i?r.substring(1,r.length-1):parseFloat(r),this.data.push({field:l(e),operator:t,value:r})}},dataBool:{query:!0,regex:"\\[\\s*("+s.boolOp+")\\s*("+s.variable+")\\s*\\]",populate:function(e,t){this.data.push({field:l(t),operator:e})}},metaCompare:{query:!0,regex:"\\[\\[\\s*("+s.meta+")\\s*("+s.comparatorOp+")\\s*("+s.number+")\\s*\\]\\]",populate:function(e,t,r){this.meta.push({field:l(e),operator:t,value:parseFloat(r)})}},nextQuery:{separator:!0,regex:s.separator,populate:function(){i[++u]=o(),a=null}},child:{separator:!0,regex:s.child,populate:function(){var e=o();e.parent=this,e.subject=a,i[u]=e}},descendant:{separator:!0,regex:s.descendant,populate:function(){var e=o();e.ancestor=this,e.subject=a,i[u]=e}},subject:{modifier:!0,regex:s.subject,populate:function(){return null!=a&&this.subject!=this?(e.util.error("Redefinition of subject in selector `"+r+"`"),!1):(a=this,void(this.subject=this))}}},h=0;for(var g in d)d[h]=d[g],d[h].name=g,h++;d.length=h,i._private.selectorText=r;var v=r,u=0,f=function(t){for(var r,i,n,a=0;a<d.length;a++){var o=d[a],s=o.name;if(!e.is.fn(t)||t(s,o)){var l=v.match(new RegExp("^"+o.regex));if(null!=l){i=l,r=o,n=s;var c=l[0];v=v.substring(c.length);break}}}return{expr:r,match:i,name:n}},y=function(){var e=v.match(/^\s+/);if(e){var t=e[0];v=v.substring(t.length)}};for(i[0]=o(),y();;){var m=f();if(null==m.expr)return void e.util.error("The selector `"+r+"`is invalid");for(var b=[],h=1;h<m.match.length;h++)b.push(m.match[h]);var x=m.expr.populate.apply(i[u],b);if(x===!1)return;if(v.match(/^\s*$/))break}for(i.length=u+1,h=0;h<i.length;h++){var w=i[h];if(null!=w.subject){for(;w.subject!=w;)if(null!=w.parent){var _=w.parent,E=w;E.parent=null,_.child=E,w=_}else{if(null==w.ancestor){e.util.error("When adjusting references for the selector `"+w+"`, neither parent nor ancestor was found");break}var S=w.ancestor,P=w;P.ancestor=null,S.descendant=P,w=S}i[h]=w.subject}}if(null!=t)for(var h=0;h<i.length;h++){if(null!=i[h].group&&i[h].group!=t)return void e.util.error("Group `"+i[h].group+"` conflicts with implicit group `"+t+"` in selector `"+r+"`");i[h].group=t}}i._private.invalid=!1},e.selfn=e.Selector.prototype,e.selfn.size=function(){return this.length},e.selfn.eq=function(e){return this[e]},e.selfn.find=function(){},e.selfn.filter=function(t){var r=this,i=t.cy();if(r._private.invalid)return new e.Collection(i);var n=function(t,r){if(null!=t.group&&"*"!=t.group&&t.group!=r._private.group)return!1;for(var i=!0,a=0;a<t.colonSelectors.length;a++){var o=t.colonSelectors[a];switch(o){case":selected":i=r.selected();break;case":unselected":i=!r.selected();break;case":selectable":i=r.selectable();break;case":unselectable":i=!r.selectable();break;case":locked":i=r.locked();break;case":unlocked":i=!r.locked();break;case":visible":i=r.visible();break;case":hidden":i=!r.visible();break;case":transparent":i=r.transparent();break;case":grabbed":i=r.grabbed();break;case":free":i=!r.grabbed();break;case":removed":i=r.removed();break;case":inside":i=!r.removed();break;case":grabbable":i=r.grabbable();break;case":ungrabbable":i=!r.grabbable();break;case":animated":i=r.animated();break;case":unanimated":i=!r.animated();break;case":parent":i=r.children().nonempty();break;case":child":i=r.parent().nonempty();break;case":loop":i=r.isEdge()&&r.data("source")===r.data("target");break;case":simple":i=r.isEdge()&&r.data("source")!==r.data("target");break;case":active":i=r.active();break;case":inactive":i=!r.active();break;case":touch":i=window&&document&&("ontouchstart"in window||window.DocumentTouch&&document instanceof DocumentTouch)}if(!i)break}if(!i)return!1;for(var s=!0,a=0;a<t.ids.length;a++){var l=t.ids[a],c=r._private.data.id;if(s=s&&l==c,!s)break}if(!s)return!1;for(var u=!0,a=0;a<t.classes.length;a++){var p=t.classes[a];if(u=u&&r.hasClass(p),!u)break}if(!u)return!1;var d=function(r){for(var i=!0,n=0;n<t[r.name].length;n++){var a,o=t[r.name][n],s=o.operator,l=o.value,c=o.field;if(null!=s&&null!=l){var u=r.fieldValue(c),p=e.is.string(u)||e.is.number(u)?""+u:"",d=""+l,h=!1;switch("@"==s.charAt(0)&&(p=p.toLowerCase(),d=d.toLowerCase(),s=s.substring(1),h=!0),h&&(l=d.toLowerCase(),u=p.toLowerCase()),s){case"*=":a=p.search(d)>=0;break;case"$=":a=null!=new RegExp(d+"$").exec(p);break;case"^=":a=null!=new RegExp("^"+d).exec(p);break;case"=":a=u===l;break;case"!=":a=u!==l;break;case">":a=u>l;break;case">=":a=u>=l;break;case"<":a=l>u;break;case"<=":a=l>=u;break;default:a=!1}}else if(null!=s)switch(s){case"?":a=r.fieldTruthy(c);break;case"!":a=!r.fieldTruthy(c);break;case"^":a=r.fieldUndefined(c)}else a=!r.fieldUndefined(c);if(!a){i=!1;break}}return i},h=d({name:"data",fieldValue:function(e){return r._private.data[e]},fieldRef:function(e){return"element._private.data."+e},fieldUndefined:function(e){return void 0===r._private.data[e]},fieldTruthy:function(e){return r._private.data[e]?!0:!1}});if(!h)return!1;var g=d({name:"meta",fieldValue:function(e){return r[e]()},fieldRef:function(e){return"element."+e+"()"},fieldUndefined:function(e){return void 0==r[e]()},fieldTruthy:function(e){return r[e]()?!0:!1}});if(!g)return!1;if(null!=t.collection){var v=null!=t.collection._private.ids[r.id()];if(!v)return!1}if(null!=t.filter&&0==r.collection().filter(t.filter).size())return!1;var f=function(e,t){if(null!=e){var r=!1;t=t();for(var i=0;i<t.size();i++)if(n(e,t.eq(i))){r=!0;break}return r}return!0};return f(t.parent,function(){return r.parent()})&&f(t.ancestor,function(){return r.parents()})&&f(t.child,function(){return r.children()})&&f(t.descendant,function(){return r.descendants()})?!0:!1},a=function(e,t){for(var i=0;i<r.length;i++){var a=r[i];if(n(a,t))return!0}return!1};null==r._private.selectorText&&(a=function(){return!0});var o=t.filter(a);return o},e.selfn.toString=e.selfn.selector=function(){for(var t="",r=function(t){return e.is.string(t)?t:""},i=function(e){var t="",a=r(e.group);t+=a.substring(0,a.length-1);for(var o=0;o<e.data.length;o++){var s=e.data[o];t+=s.value?"["+s.field+r(s.operator)+r(s.value)+"]":"["+r(s.operator)+s.field+"]"}for(var o=0;o<e.meta.length;o++){var l=e.meta[o];t+="[["+l.field+r(l.operator)+r(l.value)+"]]"}for(var o=0;o<e.colonSelectors.length;o++){var c=e.colonSelectors[n];t+=c}for(var o=0;o<e.ids.length;o++){var c="#"+e.ids[n];t+=c}for(var o=0;o<e.classes.length;o++){var c="."+e.classes[n];t+=c}return null!=e.parent&&(t=i(e.parent)+" > "+t),null!=e.ancestor&&(t=i(e.ancestor)+" "+t),null!=e.child&&(t+=" > "+i(e.child)),null!=e.descendant&&(t+=" "+i(e.descendant)),t},n=0;n<this.length;n++){var a=this[n];t+=i(a),this.length>1&&n<this.length-1&&(t+=", ")}return t}}(cytoscape),function(e){"use strict";e.Style=function(t){return this instanceof e.Style?e.is.core(t)?(this._private={cy:t,coreStyle:{}},this.length=0,void this.addDefaultStylesheet()):void e.util.error("A style must have a core reference"):new e.Style(t)},e.style=e.Style,e.styfn=e.Style.prototype,e.fn.style=function(t){for(var r in t){var i=t[r];e.Style.prototype=i}},function(){var t=e.util.regex.number,r=e.util.regex.rgbaNoBackRefs,i=e.util.regex.hslaNoBackRefs,n=e.util.regex.hex3,a=e.util.regex.hex6,o=function(e){return"^"+e+"\\s*\\(\\s*([\\w\\.]+)\\s*\\)$"},s=function(e){return"^"+e+"\\s*\\(([\\w\\.]+)\\s*\\,\\s*("+t+")\\s*\\,\\s*("+t+")\\s*,\\s*("+t+"|\\w+|"+r+"|"+i+"|"+n+"|"+a+")\\s*\\,\\s*("+t+"|\\w+|"+r+"|"+i+"|"+n+"|"+a+")\\)$"};e.style.types={time:{number:!0,min:0,units:"s"},percent:{number:!0,min:0,max:100,units:"%"},zeroOneNumber:{number:!0,min:0,max:1,unitless:!0},nOneOneNumber:{number:!0,min:-1,max:1,unitless:!0},nonNegativeInt:{number:!0,min:0,integer:!0,unitless:!0},size:{number:!0,min:0,enums:["auto"]},bgSize:{number:!0,min:0,allowPercent:!0},bgPos:{number:!0,allowPercent:!0},bgRepeat:{enums:["repeat","repeat-x","repeat-y","no-repeat"]},bgFit:{enums:["none","contain","cover"]},color:{color:!0},lineStyle:{enums:["solid","dotted","dashed"]},curveStyle:{enums:["bezier","haystack"]},fontFamily:{regex:"^([\\w- ]+(?:\\s*,\\s*[\\w- ]+)*)$"},fontVariant:{enums:["small-caps","normal"]},fontStyle:{enums:["italic","normal","oblique"]},fontWeight:{enums:["normal","bold","bolder","lighter","100","200","300","400","500","600","800","900",100,200,300,400,500,600,700,800,900]},textDecoration:{enums:["none","underline","overline","line-through"]},textTransform:{enums:["none","capitalize","uppercase","lowercase"]},nodeShape:{enums:["rectangle","roundrectangle","ellipse","triangle","square","pentagon","hexagon","heptagon","octagon","star"]},arrowShape:{enums:["tee","triangle","square","circle","diamond","none"]},arrowFill:{enums:["filled","hollow"]},display:{enums:["element","none"]},visibility:{enums:["hidden","visible"]},valign:{enums:["top","center","bottom"]},halign:{enums:["left","center","right"]},cursor:{enums:["auto","crosshair","default","e-resize","n-resize","ne-resize","nw-resize","pointer","progress","s-resize","sw-resize","text","w-resize","wait","grab","grabbing"]},text:{string:!0},data:{mapping:!0,regex:o("data")},layoutData:{mapping:!0,regex:o("layoutData")},mapData:{mapping:!0,regex:s("mapData")},mapLayoutData:{mapping:!0,regex:s("mapLayoutData")},url:{regex:"^url\\s*\\(\\s*([^\\s]+)\\s*\\s*\\)|none|(.+)$"},propList:{propList:!0}};var l=e.style.types;e.style.properties=[{name:"text-valign",type:l.valign},{name:"text-halign",type:l.halign},{name:"color",type:l.color},{name:"content",type:l.text},{name:"text-outline-color",type:l.color},{name:"text-outline-width",type:l.size},{name:"text-outline-opacity",type:l.zeroOneNumber},{name:"text-opacity",type:l.zeroOneNumber},{name:"text-decoration",type:l.textDecoration},{name:"text-transform",type:l.textTransform},{name:"font-family",type:l.fontFamily},{name:"font-style",type:l.fontStyle},{name:"font-variant",type:l.fontVariant},{name:"font-weight",type:l.fontWeight},{name:"font-size",type:l.size},{name:"min-zoomed-font-size",type:l.size},{name:"display",type:l.display},{name:"visibility",type:l.visibility},{name:"opacity",type:l.zeroOneNumber},{name:"z-index",type:l.nonNegativeInt},{name:"overlay-padding",type:l.size},{name:"overlay-color",type:l.color},{name:"overlay-opacity",type:l.zeroOneNumber},{name:"transition-property",type:l.propList},{name:"transition-duration",type:l.time},{name:"transition-delay",type:l.time},{name:"background-blacken",type:l.nOneOneNumber},{name:"background-color",type:l.color},{name:"background-opacity",type:l.zeroOneNumber},{name:"background-image",type:l.url},{name:"background-position-x",type:l.bgPos},{name:"background-position-y",type:l.bgPos},{name:"background-repeat",type:l.bgRepeat},{name:"background-fit",type:l.bgFit},{name:"pie-size",type:l.bgSize},{name:"pie-1-background-color",type:l.color},{name:"pie-2-background-color",type:l.color},{name:"pie-3-background-color",type:l.color},{name:"pie-4-background-color",type:l.color},{name:"pie-5-background-color",type:l.color},{name:"pie-6-background-color",type:l.color},{name:"pie-7-background-color",type:l.color},{name:"pie-8-background-color",type:l.color},{name:"pie-9-background-color",type:l.color},{name:"pie-10-background-color",type:l.color},{name:"pie-11-background-color",type:l.color},{name:"pie-12-background-color",type:l.color},{name:"pie-13-background-color",type:l.color},{name:"pie-14-background-color",type:l.color},{name:"pie-15-background-color",type:l.color},{name:"pie-16-background-color",type:l.color},{name:"pie-1-background-size",type:l.percent},{name:"pie-2-background-size",type:l.percent},{name:"pie-3-background-size",type:l.percent},{name:"pie-4-background-size",type:l.percent},{name:"pie-5-background-size",type:l.percent},{name:"pie-6-background-size",type:l.percent},{name:"pie-7-background-size",type:l.percent},{name:"pie-8-background-size",type:l.percent},{name:"pie-9-background-size",type:l.percent},{name:"pie-10-background-size",type:l.percent},{name:"pie-11-background-size",type:l.percent},{name:"pie-12-background-size",type:l.percent},{name:"pie-13-background-size",type:l.percent},{name:"pie-14-background-size",type:l.percent},{name:"pie-15-background-size",type:l.percent},{name:"pie-16-background-size",type:l.percent},{name:"border-color",type:l.color},{name:"border-opacity",type:l.zeroOneNumber},{name:"border-width",type:l.size},{name:"border-style",type:l.lineStyle},{name:"height",type:l.size},{name:"width",type:l.size},{name:"padding-left",type:l.size},{name:"padding-right",type:l.size},{name:"padding-top",type:l.size},{name:"padding-bottom",type:l.size},{name:"shape",type:l.nodeShape},{name:"source-arrow-shape",type:l.arrowShape},{name:"target-arrow-shape",type:l.arrowShape},{name:"source-arrow-color",type:l.color},{name:"target-arrow-color",type:l.color},{name:"source-arrow-fill",type:l.arrowFill},{name:"target-arrow-fill",type:l.arrowFill},{name:"line-style",type:l.lineStyle},{name:"line-color",type:l.color},{name:"control-point-step-size",type:l.size},{name:"control-point-distance",type:l.size},{name:"control-point-weight",type:l.zeroOneNumber},{name:"curve-style",type:l.curveStyle},{name:"selection-box-color",type:l.color},{name:"selection-box-opacity",type:l.zeroOneNumber},{name:"selection-box-border-color",type:l.color},{name:"selection-box-border-width",type:l.size},{name:"panning-cursor",type:l.cursor},{name:"active-bg-color",type:l.color},{name:"active-bg-opacity",type:l.zeroOneNumber},{name:"active-bg-size",type:l.size}];for(var c=e.style.properties,u=0;u<c.length;u++){var p=c[u];c[p.name]=p}e.style.pieBackgroundN=16}(),e.styfn.addDefaultStylesheet=function(){var t="Helvetica",r="normal",i="normal",n="normal",a="#000",o="none",s=16;this.selector("node, edge").css({"text-valign":"top","text-halign":"center",color:a,"text-outline-color":"#000","text-outline-width":0,"text-outline-opacity":1,"text-opacity":1,"text-decoration":"none","text-transform":o,"font-family":t,"font-style":r,"font-variant":i,"font-weight":n,"font-size":s,"min-zoomed-font-size":0,visibility:"visible",display:"element",opacity:1,"z-index":0,content:"","overlay-opacity":0,"overlay-color":"#000","overlay-padding":10,"transition-property":"none","transition-duration":0,"transition-delay":0,"background-blacken":0,"background-color":"#888","background-opacity":1,"background-image":"none","background-position-x":"50%","background-position-y":"50%","background-repeat":"no-repeat","background-fit":"none","border-color":"#000","border-opacity":1,"border-width":0,"border-style":"solid",height:30,width:30,"padding-top":0,"padding-bottom":0,"padding-left":0,"padding-right":0,shape:"ellipse","pie-size":"100%","pie-1-background-color":"black","pie-1-background-size":"0%","pie-2-background-color":"black","pie-2-background-size":"0%","pie-3-background-color":"black","pie-3-background-size":"0%","pie-4-background-color":"black","pie-4-background-size":"0%","pie-5-background-color":"black","pie-5-background-size":"0%","pie-6-background-color":"black","pie-6-background-size":"0%","pie-7-background-color":"black","pie-7-background-size":"0%","pie-8-background-color":"black","pie-8-background-size":"0%","pie-9-background-color":"black","pie-9-background-size":"0%","pie-10-background-color":"black","pie-10-background-size":"0%","pie-11-background-color":"black","pie-11-background-size":"0%","pie-12-background-color":"black","pie-12-background-size":"0%","pie-13-background-color":"black","pie-13-background-size":"0%","pie-14-background-color":"black","pie-14-background-size":"0%","pie-15-background-color":"black","pie-15-background-size":"0%","pie-16-background-color":"black","pie-16-background-size":"0%","source-arrow-shape":"none","target-arrow-shape":"none","source-arrow-color":"#bbb","target-arrow-color":"#bbb","source-arrow-fill":"filled","target-arrow-fill":"filled","line-style":"solid","line-color":"#bbb","control-point-step-size":40,"control-point-weight":.5,"curve-style":"bezier"}).selector("$node > node").css({width:"auto",height:"auto",shape:"rectangle","background-opacity":.5,"padding-top":10,"padding-right":10,"padding-left":10,"padding-bottom":10}).selector("edge").css({width:1}).selector(":active").css({"overlay-color":"black","overlay-padding":10,"overlay-opacity":.25}).selector("core").css({"selection-box-color":"#ddd","selection-box-opacity":.65,"selection-box-border-color":"#aaa","selection-box-border-width":1,"panning-cursor":"grabbing","active-bg-color":"black","active-bg-opacity":.15,"active-bg-size":e.is.touch()?40:15})},e.styfn.clear=function(){this._private.newStyle=!0;for(var e=0;e<this.length;e++)delete this[e];return this.length=0,this},e.styfn.resetToDefault=function(){return this.clear(),this.addDefaultStylesheet(),this},e.styfn.core=function(){return this._private.coreStyle},e.styfn.parse=function(t,r,i){t=e.util.camel2dash(t);var n=e.style.properties[t],a=r;if(!n)return null;if(void 0===r||null===r)return null;var o=e.is.string(r);o&&(r=e.util.trim(r));var s=n.type;if(!s)return null;if(i&&(""===r||null===r))return{name:t,value:r,bypass:!0,deleteBypass:!0};var l,c,u,p;if(o){if((l=new RegExp(e.style.types.data.regex).exec(r))||(u=new RegExp(e.style.types.layoutData.regex).exec(r))){var d=void 0!==u;return l=l||u,{name:t,value:l,strValue:""+r,mapped:d?e.style.types.layoutData:e.style.types.data,field:l[1],bypass:i}}if((c=new RegExp(e.style.types.mapData.regex).exec(r))||(p=new RegExp(e.style.types.mapLayoutData.regex).exec(r))){var d=void 0!==p;if(c=c||p,!s.color&&!s.number)return!1;var h=this.parse(t,c[4]);if(!h||h.mapped)return!1;var g=this.parse(t,c[5]);if(!g||g.mapped)return!1;if(h.value===g.value)return!1;if(s.color){var v=h.value,f=g.value,y=!(v[0]!==f[0]||v[1]!==f[1]||v[2]!==f[2]||v[3]!==f[3]&&(null!=v[3]&&1!==v[3]||null!=f[3]&&1!==f[3]));if(y)return!1}return{name:t,value:c,strValue:""+r,mapped:d?e.style.types.mapLayoutData:e.style.types.mapData,field:c[1],fieldMin:parseFloat(c[2]),fieldMax:parseFloat(c[3]),valueMin:h.value,valueMax:g.value,bypass:i}}}else;if(s.number){var m,b="px";if(s.units&&(m=s.units),!s.unitless)if(o){var x="px|em"+(s.allowPercent?"|\\%":"");m&&(x=m);var w=r.match("^("+e.util.regex.number+")("+x+")?$");w&&(r=w[1],m=w[2]||b)}else m||(m=b);if(r=parseFloat(r),isNaN(r)&&void 0===s.enums)return null;if(isNaN(r)&&void 0!==s.enums){r=a;for(var _=0;_<s.enums.length;_++){var E=s.enums[_];if(E===r)return{name:t,value:r,strValue:""+r,bypass:i}}return null}if(s.integer&&!e.is.integer(r))return null;if(void 0!==s.min&&r<s.min||void 0!==s.max&&r>s.max)return null;var S={name:t,value:r,strValue:""+r+(m?m:""),units:m,bypass:i};return s.unitless||"px"!==m&&"em"!==m||(S.pxValue="px"!==m&&m?this.getEmSizeInPixels()*r:r),S}if(s.propList){var P=[],k=""+r;if("none"===k);else{for(var M=k.split(","),_=0;_<M.length;_++){var N=e.util.trim(M[_]);e.style.properties[N]&&P.push(N)}if(0===P.length)return null}return{name:t,value:P,strValue:0===P.length?"none":P.join(", "),bypass:i}}if(s.color){var C=e.util.color2tuple(r);return C?{name:t,value:C,strValue:""+r,bypass:i}:null}if(s.enums){for(var _=0;_<s.enums.length;_++){var E=s.enums[_];if(E===r)return{name:t,value:r,strValue:""+r,bypass:i}}return null}if(s.regex){var D=new RegExp(s.regex),T=D.exec(r);return T?{name:t,value:T,strValue:""+r,bypass:i}:null}return s.string?{name:t,value:r,strValue:""+r,bypass:i}:null},e.styfn.selector=function(t){var r="core"===t?null:new e.Selector(t),i=this.length++;return this[i]={selector:r,properties:[]},this},e.styfn.css=function(){var t=arguments;switch(t.length){case 1:for(var r=t[0],i=0;i<e.style.properties.length;i++){var n=e.style.properties[i],a=r[n.name];void 0===a&&(a=r[e.util.dash2camel(n.name)]),void 0!==a&&this.cssRule(n.name,a)}break;case 2:this.cssRule(t[0],t[1])}return this},e.styfn.cssRule=function(e,t){var r=this.parse(e,t);if(r){var i=this.length-1;this[i].properties.push(r);var n=!this[i].selector;n&&(this._private.coreStyle[r.name]=r)}return this}}(cytoscape),function(e){"use strict";e.styfn.apply=function(e){for(var t=this,r=0;r<e.length;r++){var i=e[r],n=[],a=[];t._private.newStyle&&(i._private.styleCxts=[],i._private.style={});for(var o=0;o<this.length;o++){var s=this[o],l=s.selector&&s.selector.filter(i).length>0,c=s.properties,u=!i._private.styleCxts[o];if(l){for(var p=0;p<c.length;p++){var d=c[p],h=i._private.style[d.name],g=h&&h.context===s,v=d.mapped&&g;(u||v)&&this.applyParsedProperty(i,d,s)}i._private.styleCxts[o]=s,t._private.newStyle===!1&&u&&n.push(s)}else i._private.styleCxts[o]&&(this.rollBackContext(i,s),a.push(s)),delete i._private.styleCxts[o]}(n.length>0||a.length>0)&&this.updateTransitions(i,n,a)}t._private.newStyle=!1},e.styfn.rollBackContext=function(e,t){for(var r=0;r<t.properties.length;r++){var i=t.properties[r],n=e._private.style[i.name];n.bypassed&&(n=n.bypassed);for(var a,o=!0,s=0;n.prev;){var l=n.prev;n.context===t&&(o?e._private.style[i.name]=l:a&&(a.prev=l)),a=n,n=l,o=!1,s++}}},e.styfn.applyParsedProperty=function(t,r,i){r=e.util.clone(r);var n,a,o=r,s=t._private.style,l=e.style.properties[o.name].type,c=o.bypass,u=s[o.name],p=u&&u.bypass;if(("height"===r.name||"width"===r.name)&&"auto"===r.value&&t.isNode()&&!t.isParent())return!1;if(c&&o.deleteBypass){var d=s[o.name];return d?d.bypass&&d.bypassed?(s[o.name]=d.bypassed,!0):!1:!0}switch(o.mapped){case e.style.types.mapData:case e.style.types.mapLayoutData:for(var h=o.mapped===e.style.types.mapLayoutData,g=o.field.split("."),n=h?t._private.layoutData:t._private.data,v=0;v<g.length&&n;v++){var f=g[v];n=n[f]}var y;if(y=e.is.number(n)?(n-o.fieldMin)/(o.fieldMax-o.fieldMin):0,l.color){var m=o.valueMin[0],b=o.valueMax[0],x=o.valueMin[1],w=o.valueMax[1],_=o.valueMin[2],E=o.valueMax[2],S=null==o.valueMin[3]?1:o.valueMin[3],P=null==o.valueMax[3]?1:o.valueMax[3],k=[Math.round(m+(b-m)*y),Math.round(x+(w-x)*y),Math.round(_+(E-_)*y),Math.round(S+(P-S)*y)];a={bypass:o.bypass,name:o.name,value:k,strValue:["rgba(",k[0],", ",k[1],", ",k[2],", ",k[3],")"].join("")}}else{if(!l.number)return!1;var M=o.valueMin+(o.valueMax-o.valueMin)*y;a=this.parse(o.name,M,o.bypass)}a||(a=this.parse(o.name,u.strValue,o.bypass)),a.mapping=o,o=a;break;case e.style.types.data:case e.style.types.layoutData:for(var h=o.mapped===e.style.types.layoutData,g=o.field.split("."),n=h?t._private.layoutData:t._private.data,v=0;v<g.length&&n;v++){var f=g[v];n=n[f]}a=this.parse(o.name,n,o.bypass),a||(a=this.parse(o.name,u.strValue,o.bypass)),a.mapping=o,o=a;break;case void 0:break;default:return!1}if(c)o.bypassed=p?u.bypassed:u,s[o.name]=o;else{var N;p?(N=u.bypassed,u.bypassed=o):(N=s[o.name],s[o.name]=o),N&&N.mapping&&o.mapping&&N.context===i&&(N=N.prev),N&&N!==o&&(o.prev=N)}return o.context=i,!0},e.styfn.update=function(){var e=this._private.cy,t=e.elements();t.updateStyle()},e.styfn.updateMappers=function(t){for(var r=0;r<t.length;r++)for(var i=t[r],n=i._private.style,a=0;a<e.style.properties.length;a++){var o=e.style.properties[a],s=n[o.name];if(s&&s.mapping){var l=s.mapping;this.applyParsedProperty(i,l)}}},e.styfn.updateTransitions=function(t,r,i){var n=this,a=t._private.style,o=a["transition-property"].value,s=1e3*a["transition-duration"].value,l=1e3*a["transition-delay"].value,c={};if(o.length>0&&s>0){for(var u=!1,p=0;p<o.length;p++){for(var d=o[p],h=a[d],g=h.prev,v=a[d],f=!1,y=!1,m=!1,b=0;b<r.length;b++){var x=r[b];if(x===v.context){y=!0;break}}for(var b=i.length-1;b>=0;b--){for(var x=i[b],w=0;w<x.properties.length;w++){var _=x.properties[w];if(_.name===d){m=!0,g=_;break}}if(m)break}(y||m)&&(e.is.number(g.pxValue)&&e.is.number(v.pxValue)?f=g.pxValue!==v.pxValue:e.is.number(g.value)&&e.is.number(v.value)?f=g.value!==v.value:e.is.array(g.value)&&e.is.array(v.value)&&(f=g.value[0]!==v.value[0]||g.value[1]!==v.value[1]||g.value[2]!==v.value[2]),f&&(c[d]=v.strValue,this.applyBypass(t,d,g.strValue),u=!0))}if(!u)return;t._private.transitioning=!0,t.stop(),l>0&&t.delay(l),t.animate({css:c},{duration:s,queue:!1,complete:function(){n.removeAllBypasses(t),t._private.transitioning=!1}})}else t._private.transitioning&&(t.stop(),this.removeAllBypasses(t),t._private.transitioning=!1)}}(cytoscape),function(e){"use strict";e.styfn.applyBypass=function(t,r,i){var n=[];if("*"===r||"**"===r){if(void 0!==i)for(var a=0;a<e.style.properties.length;a++){var o=e.style.properties[a],r=o.name,s=this.parse(r,i,!0);s&&n.push(s)}}else if(e.is.string(r)){var s=this.parse(r,i,!0);s&&n.push(s)}else{if(!e.is.plainObject(r))return!1;for(var l=r,a=0;a<e.style.properties.length;a++){var o=e.style.properties[a],r=o.name,i=l[r];if(void 0===i&&(i=l[e.util.dash2camel(r)]),void 0!==i){var s=this.parse(r,i,!0);s&&n.push(s)}}}if(0===n.length)return!1;for(var c=!1,a=0;a<t.length;a++)for(var u=t[a],p=0;p<n.length;p++){var o=n[p];c=this.applyParsedProperty(u,o)||c}return c},e.styfn.removeAllBypasses=function(t){for(var r=0;r<e.style.properties.length;r++)for(var i=e.style.properties[r],n=i.name,a="",o=this.parse(n,a,!0),s=0;s<t.length;s++){var l=t[s];this.applyParsedProperty(l,o)}}}(cytoscape),function(e,t){"use strict";e.styfn.getEmSizeInPixels=function(){var e=this._private.cy,r=e.container();if(t&&r&&t.getComputedStyle){var i=t.getComputedStyle(r).getPropertyValue("font-size"),n=parseFloat(i);return n}return 1},e.styfn.containerCss=function(e){var r=this._private.cy,i=r.container();return t&&i&&t.getComputedStyle?t.getComputedStyle(i).getPropertyValue(e):void 0},e.styfn.containerProperty=function(e){var t=this.containerCss(e),r=this.parse(e,t);return r},e.styfn.containerPropertyAsString=function(e){var t=this.containerProperty(e);return t?t.strValue:void 0}}(cytoscape,"undefined"==typeof window?null:window),function(e){"use strict";e.styfn.getRenderedStyle=function(t){var t=t[0];if(t){for(var r={},i=t._private.style,n=this._private.cy,a=n.zoom(),o=0;o<e.style.properties.length;o++){var s=e.style.properties[o],l=i[s.name];if(l){var c=l.unitless?l.strValue:l.pxValue*a+"px";r[s.name]=c,r[e.util.dash2camel(s.name)]=c}}return r}},e.styfn.getRawStyle=function(t){var t=t[0];if(t){for(var r={},i=t._private.style,n=0;n<e.style.properties.length;n++){var a=e.style.properties[n],o=i[a.name];o&&(r[a.name]=o.strValue,r[e.util.dash2camel(a.name)]=o.strValue)}return r}},e.styfn.getValueStyle=function(t){var r,i;if(e.is.element(t)?(r={},i=t._private.style):(r={},i=t),i)for(var n=0;n<e.style.properties.length;n++){var a=e.style.properties[n],o=i[a.name]||i[e.util.dash2camel(a.name)];if(void 0===o||e.is.plainObject(o)||(o=this.parse(a.name,o)),o){var s=void 0===o.value?o:o.value;r[a.name]=s,r[e.util.dash2camel(a.name)]=s}}return r}}(cytoscape),function(e){"use strict";e.style.applyFromJson=function(e,t){for(var r=0;r<t.length;r++){var i=t[r],n=i.selector,a=i.css;e.selector(n);for(var o in a){var s=a[o];e.css(o,s)}}return e},e.style.fromJson=function(t,r){var i=new e.Style(t);return e.style.applyFromJson(i,r),i},e.styfn.fromJson=function(t){var r=this;return r.resetToDefault(),e.style.applyFromJson(r,t),r},e.styfn.json=function(){for(var e=[],t=0;t<this.length;t++){for(var r=this[t],i=r.selector,n=r.properties,a={},o=0;o<n.length;o++){var s=n[o];a[s.name]=s.strValue}e.push({selector:i?i.toString():"core",css:a})}return e}}(cytoscape),function(e){"use strict";e.style.applyFromString=function(t,r){function i(){l=l.length>a.length?l.substr(a.length):""}function n(){o=o.length>s.length?o.substr(s.length):""}var a,o,s,l=""+r;for(l=l.replace(/[/][*](\s|.)+?[*][/]/g,"");;){var c=l.match(/^\s*$/);if(c)break;var u=l.match(/^\s*((?:.|\s)+?)\s*\{((?:.|\s)+?)\}/);if(!u){e.util.error("Halting stylesheet parsing: String stylesheet contains more to parse but no selector and block found in: "+l);break}a=u[0];var p=u[1],d=new e.Selector(p);if(d._private.invalid)e.util.error("Skipping parsing of block: Invalid selector found in string stylesheet: "+p),i();else{var h=u[2],g=!1;o=h;for(var v=[];;){var c=o.match(/^\s*$/);if(c)break;var f=o.match(/^\s*(.+?)\s*:\s*(.+?)\s*;/);if(!f){e.util.error("Skipping parsing of block: Invalid formatting of style property and value definitions found in:"+h),g=!0;break}s=f[0];var y=f[1],m=f[2],b=e.style.properties[y];if(b){var x=t.parse(y,m);x?(v.push({name:y,val:m}),n()):(e.util.error("Skipping property: Invalid property definition in: "+s),n())}else e.util.error("Skipping property: Invalid property name in: "+s),n()}if(g){i();break}t.selector(p);for(var w=0;w<v.length;w++){var b=v[w];t.css(b.name,b.val)}i()}}return t},e.style.fromString=function(t,r){var i=new e.Style(t);return e.style.applyFromString(i,r),i},e.styfn.fromString=function(t){var r=this;return r.resetToDefault(),e.style.applyFromString(r,t),r}}(cytoscape),function(e){"use strict";e.stylesheet=e.Stylesheet=function(){return this instanceof e.Stylesheet?void(this.length=0):new e.Stylesheet},e.Stylesheet.prototype.selector=function(e){var t=this.length++;return this[t]={selector:e,properties:[]},this},e.Stylesheet.prototype.css=function(t,r){var i=this.length-1;if(e.is.string(t))this[i].properties.push({name:t,value:r});else if(e.is.plainObject(t))for(var n=t,a=0;a<e.style.properties.length;a++){var o=e.style.properties[a],s=n[o.name];
if(void 0===s&&(s=n[e.util.dash2camel(o.name)]),void 0!==s){var t=o.name,r=s;this[i].properties.push({name:t,value:r})}}return this},e.Stylesheet.prototype.generateStyle=function(t){for(var r=new e.Style(t),i=0;i<this.length;i++){var n=this[i],a=n.selector,o=n.properties;r.selector(a);for(var s=0;s<o.length;s++){var l=o[s];r.css(l.name,l.value)}}return r}}(cytoscape),function(e,t){"use strict";var r=e.is.touch(),i={hideEdgesOnViewport:!1},n=e.util.copy(i);e.defaults=function(t){i=e.util.extend({},n,t)},e.fn.core=function(t){for(var r in t){var i=t[r];e.Core.prototype[r]=i}},e.Core=function(n){if(!(this instanceof e.Core))return new e.Core(n);var a=this;n=e.util.extend({},i,n);var o=n.container,s=e.getRegistrationForInstance(a,o);s&&s.cy&&(s.domElement.innerHTML="",s.cy.notify({type:"destroy"}),e.removeRegistrationForInstance(s.cy,s.domElement)),s=e.registerInstance(a,o);var l=s.readies,c=n;c.layout=e.util.extend({name:t&&o?"grid":"null"},c.layout),c.renderer=e.util.extend({name:t&&o?"canvas":"null"},c.renderer);var u=this._private={ready:!1,initrender:!1,instanceId:s.id,options:c,elements:[],id2index:{},listeners:[],aniEles:[],scratch:{},layout:null,renderer:null,notificationsEnabled:!0,minZoom:1e-50,maxZoom:1e50,zoomingEnabled:void 0===c.zoomingEnabled?!0:c.zoomingEnabled,userZoomingEnabled:void 0===c.userZoomingEnabled?!0:c.userZoomingEnabled,panningEnabled:void 0===c.panningEnabled?!0:c.panningEnabled,userPanningEnabled:void 0===c.userPanningEnabled?!0:c.userPanningEnabled,boxSelectionEnabled:void 0===c.boxSelectionEnabled?!0:c.boxSelectionEnabled,zoom:e.is.number(c.zoom)?c.zoom:1,pan:{x:e.is.plainObject(c.pan)&&e.is.number(c.pan.x)?c.pan.x:0,y:e.is.plainObject(c.pan)&&e.is.number(c.pan.y)?c.pan.y:0},hasCompoundNodes:!1},p=c.selectionType;u.selectionType=void 0===p||"additive"!==p&&"single"!==p?r?"additive":"single":p,e.is.number(c.minZoom)&&e.is.number(c.maxZoom)&&c.minZoom<c.maxZoom?(u.minZoom=c.minZoom,u.maxZoom=c.maxZoom):e.is.number(c.minZoom)&&void 0===c.maxZoom?u.minZoom=c.minZoom:e.is.number(c.maxZoom)&&void 0===c.minZoom&&(u.maxZoom=c.maxZoom),u.style=e.is.stylesheet(c.style)?c.style.generateStyle(this):e.is.array(c.style)?e.style.fromJson(this,c.style):e.is.string(c.style)?e.style.fromString(this,c.style):new e.Style(a),a.initRenderer(e.util.extend({hideEdgesOnViewport:c.hideEdgesOnViewport},c.renderer)),c.initrender&&(a.on("initrender",c.initrender),a.on("initrender",function(){a._private.initrender=!0})),a.load(c.elements,function(){a.startAnimationLoop(),a._private.ready=!0,e.is.fn(c.ready)&&a.bind("ready",c.ready);for(var t=0;t<l.length;t++){var r=l[t];a.bind("ready",r)}s.readies=[],a.trigger("ready")},c.done)},e.corefn=e.Core.prototype,e.fn.core({ready:function(){return this._private.ready},initrender:function(){return this._private.initrender},registered:function(){return this._private&&null!=this._private.instanceId?!0:!1},registeredId:function(){return this._private.instanceId},getElementById:function(t){var r=this._private.id2index[t];return void 0!==r?this._private.elements[r]:new e.Collection(this)},selectionType:function(){return this._private.selectionType},hasCompoundNodes:function(){return this._private.hasCompoundNodes},addToPool:function(e){for(var t=this._private.elements,r=this._private.id2index,i=0;i<e.length;i++){var n=e[i],a=n._private.data.id,o=r[a],s=void 0!==o;s||(o=t.length,t.push(n),r[a]=o,n._private.index=o)}return this},removeFromPool:function(e){for(var t=this._private.elements,r=this._private.id2index,i=0;i<e.length;i++){var n=e[i],a=n._private.data.id,o=r[a],s=void 0!==o;if(s){delete this._private.id2index[a],t.splice(o,1);for(var l=o;l<t.length;l++){var c=t[l]._private.data.id;r[c]--}}}},container:function(){return this._private.options.container},options:function(){return e.util.copy(this._private.options)},json:function(){var e={},t=this;return e.elements={},t.elements().each(function(t,r){var i=r.group();e.elements[i]||(e.elements[i]=[]),e.elements[i].push(r.json())}),e.style=t.style().json(),e.scratch=t.scratch(),e.zoomingEnabled=t._private.zoomingEnabled,e.userZoomingEnabled=t._private.userZoomingEnabled,e.zoom=t._private.zoom,e.minZoom=t._private.minZoom,e.maxZoom=t._private.maxZoom,e.panningEnabled=t._private.panningEnabled,e.userPanningEnabled=t._private.userPanningEnabled,e.pan=t._private.pan,e.boxSelectionEnabled=t._private.boxSelectionEnabled,e.layout=t._private.options.layout,e.renderer=t._private.options.renderer,e.hideEdgesOnViewport=t._private.options.hideEdgesOnViewport,e}})}(cytoscape,"undefined"==typeof window?null:window),function(e,t){"use strict";function r(e){var t=!document||"interactive"!==document.readyState&&"complete"!==document.readyState?r:e;setTimeout(t,9,e)}e.fn.core({add:function(t){var r,i=this;if(e.is.elementOrCollection(t)){var n=t;if(n._private.cy===i)r=n.restore();else{for(var a=[],o=0;o<n.length;o++){var s=n[o];a.push(s.json())}r=new e.Collection(i,a)}}else if(e.is.array(t)){var a=t;r=new e.Collection(i,a)}else if(e.is.plainObject(t)&&(e.is.array(t.nodes)||e.is.array(t.edges))){for(var l=t,a=[],c=["nodes","edges"],o=0,u=c.length;u>o;o++){var p=c[o],d=l[p];if(e.is.array(d))for(var h=0,g=d.length;g>h;h++){var v=d[h],f=e.util.extend({},v,{group:p});a.push(f)}}r=new e.Collection(i,a)}else{var v=t;r=new e.Element(i,v).collection()}return r},remove:function(t){if(e.is.elementOrCollection(t))t=t;else if(e.is.string(t)){var r=t;t=this.$(r)}return t.remove()},load:function(i,n,a){function o(){s.one("layoutready",function(e){s.notifications(!0),s.trigger(e),s.notify({type:"load",collection:s.elements()}),s.one("load",n),s.trigger("load")}).one("layoutstop",function(){s.one("done",a),s.trigger("done")}),s.layout(s._private.options.layout)}var s=this,l=s.elements();return l.length>0&&l.remove(),s.notifications(!1),null!=i&&(e.is.plainObject(i)||e.is.array(i))&&s.add(i),t?r(o):o(),this}})}(cytoscape,"undefined"==typeof window?null:window),function(e,t){"use strict";e.fn.core({addToAnimationPool:function(e){for(var t=this,r=t._private.aniEles,i=[],n=0;n<r.length;n++){var a=r[n]._private.data.id;i[a]=!0}for(var n=0;n<e.length;n++){var o=e[n],a=o._private.data.id;i[a]||r.push(o)}},startAnimationLoop:function(){function r(){function e(){p(function(e){i(e),r()},d)}c?setTimeout(function(){e()},l):e()}function i(t){t=+new Date;for(var r=s._private.aniEles,i=0;i<r.length;i++){var a=r[i],o=a._private.animation.current,l=a._private.animation.queue;if(0===o.length){var c=l,u=c.length>0?c.shift():null;null!=u&&(u.callTime=+new Date,o.push(u))}for(var p=[],d=0;d<o.length;d++){var h=o[d];n(a,h,t),o[d].done&&(p.push(h),o.splice(d,1),d--)}for(var d=0;d<p.length;d++){var h=p[d],g=h.params.complete;e.is.fn(g)&&g.apply(a,[t])}}r.length>0&&s.notify({type:"draw",collection:r});for(var d=0;d<r.length;d++){var a=r[d],l=a._private.animation.queue,o=a._private.animation.current,v=o.length>0||l.length>0;v||(r.splice(d,1),d--)}}function n(t,r,i){var n,l=s._private.style,c=r.properties,u=r.params,p=r.callTime;if(n=0===r.duration?1:Math.min(1,(i-p)/r.duration),0>n?n=0:n>1&&(n=1),null==c.delay){var d=r.startPosition,h=c.position,g=t._private.position;if(h&&(a(d.x,h.x)&&(g.x=o(d.x,h.x,n)),a(d.y,h.y)&&(g.y=o(d.y,h.y,n))),c.css)for(var v=e.style.properties,f=0;f<v.length;f++){var y=v[f].name,m=c.css[y];if(void 0!==m){var b=r.startStyle[y],x=o(b,m,n);l.applyBypass(t,y,x)}}}return e.is.fn(u.step)&&u.step.apply(t,[i]),n>=1&&(r.done=!0),n}function a(t,r){return null==t||null==r?!1:e.is.number(t)&&e.is.number(r)?!0:t&&r?!0:!1}function o(t,r,i){if(0>i?i=0:i>1&&(i=1),e.is.number(t)&&e.is.number(r))return t+(r-t)*i;if(e.is.number(t[0])&&e.is.number(r[0])){var n=t,a=r,o=function(e,t){var r=t-e,n=e;return Math.round(i*r+n)},s=o(n[0],a[0]),l=o(n[1],a[1]),c=o(n[2],a[2]);return"rgb("+s+", "+l+", "+c+")"}return void 0}var s=this,l=1e3/60,c=!1,u=!0;if(t){s._private.aniEles=[];var p=e.util.requestAnimationFrame;null!=p&&u||(p=function(e){t.setTimeout(function(){e(+new Date)},l)});var d=s.container();r()}}})}(cytoscape,"undefined"==typeof window?null:window),function(e){"use strict";e.fn.core({data:e.define.data({field:"data",bindingEvent:"data",allowBinding:!0,allowSetting:!0,settingEvent:"data",settingTriggersEvent:!0,triggerFnName:"trigger",allowGetting:!0}),removeData:e.define.removeData({field:"data",event:"data",triggerFnName:"trigger",triggerEvent:!0}),batchData:e.define.batchData({field:"data",event:"data",triggerFnName:"trigger",immutableKeys:{id:!0,source:!0,target:!0,parent:!0},updateMappers:!0}),scratch:e.define.data({field:"scratch",allowBinding:!1,allowSetting:!0,settingTriggersEvent:!1,allowGetting:!0}),removeScratch:e.define.removeData({field:"scratch",triggerEvent:!1})})}(cytoscape),function(e){"use strict";e.fn.core({on:e.define.on(),one:e.define.on({unbindSelfOnTrigger:!0}),once:e.define.on({unbindAllBindersOnTrigger:!0}),off:e.define.off(),trigger:e.define.trigger()}),e.corefn.bind=e.corefn.on,e.corefn.unbind=e.corefn.off}(cytoscape),function(e){"use strict";e.fn.core({png:function(e){var t=this._private.renderer;return e=e||{},t.png(e)}})}(cytoscape),function(e){"use strict";e.fn.core({layout:function(e){var t=this;return this._private.layoutRunning?this:(null==e&&(e=this._private.options.layout),this.initLayout(e),t.trigger("layoutstart"),this._private.layoutRunning=!0,this.one("layoutstop",function(){t._private.layoutRunning=!1}),this._private.layout.run(),this)},initLayout:function(t){if(null==t)return void e.util.error("Layout options must be specified to run a layout");if(null==t.name)return void e.util.error("A `name` must be specified to run a layout");var r=t.name,i=e.extension("layout",r);return null==i?void e.util.error("Can not apply layout: No such layout `%s` found; did you include its JS file?",r):(this._private.layout=new i(e.util.extend({},t,{renderer:this._private.renderer,cy:this})),void(this._private.options.layout=t))}})}(cytoscape),function(e){"use strict";e.fn.core({notify:function(t){if(this._private.notificationsEnabled){var r=this.renderer(),i=this;if(e.is.element(t.collection)){var n=t.collection;t.collection=new e.Collection(i,[n])}else if(e.is.array(t.collection)){var a=t.collection;t.collection=new e.Collection(i,a)}r.notify(t)}},notifications:function(e){var t=this._private;return void 0===e?t.notificationsEnabled:void(t.notificationsEnabled=e?!0:!1)},noNotifications:function(e){this.notifications(!1),e(),this.notifications(!0)}})}(cytoscape),function(e){"use strict";e.fn.core({renderTo:function(e,t,r,i){var n=this._private.renderer;return n.renderTo(e,t,r,i),this},renderer:function(){return this._private.renderer},forceRender:function(){return this.notify({type:"draw"}),this},initRenderer:function(t){var r=this,i=e.extension("renderer",t.name);return null==i?void e.util.error("Can not initialise: No such renderer `%s` found; did you include its JS file?",t.name):void(this._private.renderer=new i(e.util.extend({},t,{cy:r,style:r._private.style})))},recalculateRenderedStyle:function(){var e=this.renderer();e.recalculateRenderedStyle&&e.recalculateRenderedStyle()}})}(cytoscape),function(e){"use strict";e.fn.core({collection:function(t){return e.is.string(t)?this.$(t):e.is.elementOrCollection(t)?t.collection():new e.Collection(this)},nodes:function(e){var t=this.$("node");return e?t.filter(e):t},edges:function(e){var t=this.$("edge");return e?t.filter(e):t},$:function(t){var r=new e.Collection(this,this._private.elements);return t?r.filter(t):r}}),e.corefn.elements=e.corefn.filter=e.corefn.$}(cytoscape),function(e){"use strict";e.fn.core({style:function(){return this._private.style}})}(cytoscape),function(e){"use strict";e.fn.core({panningEnabled:function(e){return void 0===e?this._private.panningEnabled:(this._private.panningEnabled=e?!0:!1,this)},userPanningEnabled:function(e){return void 0===e?this._private.userPanningEnabled:(this._private.userPanningEnabled=e?!0:!1,this)},zoomingEnabled:function(e){return void 0===e?this._private.zoomingEnabled:(this._private.zoomingEnabled=e?!0:!1,this)},userZoomingEnabled:function(e){return void 0===e?this._private.userZoomingEnabled:(this._private.userZoomingEnabled=e?!0:!1,this)},boxSelectionEnabled:function(e){return void 0===e?this._private.boxSelectionEnabled:(this._private.boxSelectionEnabled=e?!0:!1,this)},pan:function(){var t,r,i,n,a,o=arguments,s=this._private.pan;switch(o.length){case 0:return s;case 1:if(!this._private.panningEnabled)return this;if(e.is.string(o[0]))return t=o[0],s[t];e.is.plainObject(o[0])&&(i=o[0],n=i.x,a=i.y,e.is.number(n)&&(s.x=n),e.is.number(a)&&(s.y=a),this.trigger("pan"));break;case 2:if(!this._private.panningEnabled)return this;t=o[0],r=o[1],"x"!==t&&"y"!==t||!e.is.number(r)||(s[t]=r),this.trigger("pan")}return this.notify({type:"viewport"}),this},panBy:function(){var t,r,i,n,a,o=arguments,s=this._private.pan;if(!this._private.panningEnabled)return this;switch(o.length){case 1:e.is.plainObject(o[0])&&(i=o[0],n=i.x,a=i.y,e.is.number(n)&&(s.x+=n),e.is.number(a)&&(s.y+=a),this.trigger("pan"));break;case 2:t=o[0],r=o[1],"x"!==t&&"y"!==t||!e.is.number(r)||(s[t]+=r),this.trigger("pan")}return this.notify({type:"viewport"}),this},fit:function(t,r){if(e.is.number(t)&&void 0===r&&(r=t,t=void 0),!this._private.panningEnabled||!this._private.zoomingEnabled)return this;if(e.is.string(t)){var i=t;t=this.$(i)}else e.is.elementOrCollection(t)||(t=this.elements());var n,a=t.boundingBox(),o=this.style(),s=parseFloat(o.containerCss("width")),l=parseFloat(o.containerCss("height"));return r=e.is.number(r)?r:0,!isNaN(s)&&!isNaN(l)&&t.length>0&&(n=this._private.zoom=Math.min((s-2*r)/a.w,(l-2*r)/a.h),n=n>this._private.maxZoom?this._private.maxZoom:n,n=n<this._private.minZoom?this._private.minZoom:n,this._private.pan={x:(s-n*(a.x1+a.x2))/2,y:(l-n*(a.y1+a.y2))/2},this.trigger("pan zoom"),this.notify({type:"viewport"})),this},minZoom:function(t){return void 0===t?this._private.minZoom:(e.is.number(t)&&(this._private.minZoom=t),this)},maxZoom:function(t){return void 0===t?this._private.maxZoom:(e.is.number(t)&&(this._private.maxZoom=t),this)},zoom:function(t){var r,i;if(void 0===t)return this._private.zoom;if(e.is.number(t))i=t;else if(e.is.plainObject(t)){if(i=t.level,t.position){var n=t.position,a=this._private.pan,o=this._private.zoom;r={x:n.x*o+a.x,y:n.y*o+a.y}}else t.renderedPosition&&(r=t.renderedPosition);if(r&&!this._private.panningEnabled)return this}if(!this._private.zoomingEnabled)return this;if(!e.is.number(i)||r&&(!e.is.number(r.x)||!e.is.number(r.y)))return this;if(i=i>this._private.maxZoom?this._private.maxZoom:i,i=i<this._private.minZoom?this._private.minZoom:i,r){var s=this._private.pan,l=this._private.zoom,c=i,u={x:-c/l*(r.x-s.x)+r.x,y:-c/l*(r.y-s.y)+r.y};this._private.zoom=i,this._private.pan=u;var p=s.x!==u.x||s.y!==u.y;this.trigger("zoom"+(p?" pan":""))}else this._private.zoom=i,this.trigger("zoom");return this.notify({type:"viewport"}),this},boundingBox:function(e){var t=this.$(e);return t.boundingBox()},renderedBoundingBox:function(e){var t=this.$(e);return t.renderedBoundingBox()},center:function(t){if(!this._private.panningEnabled||!this._private.zoomingEnabled)return this;if(e.is.string(t)){var r=t;t=cy.elements(r)}else e.is.elementOrCollection(t)||(t=cy.elements());var i=t.boundingBox(),n=this.style(),a=parseFloat(n.containerCss("width")),o=parseFloat(n.containerCss("height")),s=this._private.zoom;return this.pan({x:(a-s*(i.x1+i.x2))/2,y:(o-s*(i.y1+i.y2))/2}),this.trigger("pan"),this.notify({type:"viewport"}),this},reset:function(){return this._private.panningEnabled&&this._private.zoomingEnabled?(this.pan({x:0,y:0}),this._private.maxZoom>1&&this._private.minZoom<1&&this.zoom(1),this.notify({type:"viewport"}),this):this}})}(cytoscape),function(e){"use strict";e.fn.collection=e.fn.eles=function(t){for(var r in t){var i=t[r];e.Collection.prototype[r]=i}};var t={prefix:{nodes:"n",edges:"e"},id:{nodes:0,edges:0},generate:function(t,r,i){var n=e.is.element(r)?r._private:r,a=n.group,o=null!=i?i:this.prefix[a]+this.id[a];if(t.getElementById(o).empty())this.id[a]++;else for(;!t.getElementById(o).empty();)o=this.prefix[a]+ ++this.id[a];return o}};e.Element=function(t,r,i){if(!(this instanceof e.Element))return new e.Element(t,r,i);var n=this;if(i=void 0===i||i?!0:!1,void 0===t||void 0===r||!e.is.core(t))return void e.util.error("An element must have a core reference and parameters set");if("nodes"!==r.group&&"edges"!==r.group)return void e.util.error("An element must be of type `nodes` or `edges`; you specified `"+r.group+"`");if(this.length=1,this[0]=this,this._private={cy:t,single:!0,data:r.data||{},layoutData:{},position:r.position||{},autoWidth:void 0,autoHeight:void 0,listeners:[],group:r.group,style:{},rstyle:{},styleCxts:[],removed:!0,selected:r.selected?!0:!1,selectable:void 0===r.selectable?!0:r.selectable?!0:!1,locked:r.locked?!0:!1,grabbed:!1,grabbable:void 0===r.grabbable?!0:r.grabbable?!0:!1,active:!1,classes:{},animation:{current:[],queue:[]},rscratch:{},scratch:{},edges:[],children:[]},r.renderedPosition){var a=r.renderedPosition,o=t.pan(),s=t.zoom();this._private.position={x:(a.x-o.x)/s,y:(a.y-o.y)/s}}if(e.is.string(r.classes))for(var l=r.classes.split(/\s+/),c=0,u=l.length;u>c;c++){var p=l[c];p&&""!==p&&(n._private.classes[p]=!0)}r.css&&t.style().applyBypass(this,r.css),(void 0===i||i)&&this.restore()},e.Collection=function(r,i){if(!(this instanceof e.Collection))return new e.Collection(r,i);if(void 0===r||!e.is.core(r))return void e.util.error("A collection must have a reference to the core");var n={},a=[],o=!1;if(i){if(i.length>0&&e.is.plainObject(i[0])&&!e.is.element(i[0])){o=!0;for(var s=[],l={},c=0,u=i.length;u>c;c++){var p=i[c];null==p.data&&(p.data={});var d=p.data;if(null==d.id)d.id=t.generate(r,p);else if(0!=r.getElementById(d.id).length||l[d.id])continue;var h=new e.Element(r,p,!1);s.push(h),l[d.id]=!0}i=s}}else i=[];for(var c=0,u=i.length;u>c;c++){var g=i[c];if(g){var v=g._private.data.id;n[v]||(n[v]=g,a.push(g))}}for(var c=0,u=a.length;u>c;c++)this[c]=a[c];this.length=a.length,this._private={cy:r,ids:n},o&&this.restore()},e.elefn=e.elesfn=e.Element.prototype=e.Collection.prototype,e.elesfn.cy=function(){return this._private.cy},e.elesfn.element=function(){return this[0]},e.elesfn.collection=function(){return e.is.collection(this)?this:new e.Collection(this._private.cy,[this])},e.elesfn.json=function(){var t=this.element();if(null==t)return void 0;var r=t._private,i=e.util.copy({data:r.data,position:r.position,group:r.group,bypass:r.bypass,removed:r.removed,selected:r.selected,selectable:r.selectable,locked:r.locked,grabbed:r.grabbed,grabbable:r.grabbable,classes:""}),n=[];for(var a in r.classes)n.push(a);for(var o=0;o<n.length;o++){var a=n[o];i.classes+=a+(o<n.length-1?" ":"")}return i},e.elesfn.jsons=function(){for(var e=[],t=0;t<this.length;t++){var r=this[t],i=r.json();e.push(i)}return e},e.elesfn.restore=function(r){var i=this,n=[],a=i.cy();void 0===r&&(r=!0);for(var o=[],s=[],l=[],c=0,u=0,p=0,d=i.length;d>p;p++){var h=i[p];h.isNode()?(s.push(h),c++):(l.push(h),u++)}o=s.concat(l);for(var p=0,d=o.length;d>p;p++){var h=o[p];if(h.removed()){var g=h._private,v=g.data;if(void 0===v.id)v.id=t.generate(a,h);else{if(e.is.emptyString(v.id)||!e.is.string(v.id)){e.util.error("Can not create element with invalid string ID `"+v.id+"`");continue}if(0!=a.getElementById(v.id).length){e.util.error("Can not create second element with ID `"+v.id+"`");continue}}{v.id}if(h.isEdge()){for(var f=h,y=["source","target"],m=y.length,b=!1,x=0;m>x;x++){var w=y[x],_=v[w];null==_||""===_?(e.util.error("Can not create edge `"+v.id+"` with unspecified "+w),b=!0):a.getElementById(_).empty()&&(e.util.error("Can not create edge `"+v.id+"` with nonexistant "+w+" `"+_+"`"),b=!0)}if(b)continue;var E=a.getElementById(v.source),S=a.getElementById(v.target);E._private.edges.push(f),S._private.edges.push(f),f._private.source=E,f._private.target=S}g.ids={},g.ids[v.id]=h,g.removed=!1,a.addToPool(h),n.push(h)}}for(var p=0;c>p;p++){var P=o[p],v=P._private.data,k=(v.id,P._private.data.parent),M=null!=k;if(M){var N=a.getElementById(k);if(N.empty())delete v.parent;else{for(var C=!1,D=N;!D.empty();){if(P.same(D)){C=!0,delete v.parent;break}D=D.parent()}C||(N[0]._private.children.push(P),a._private.hasCompoundNodes=!0)}}}if(n=new e.Collection(a,n),n.length>0){var T=n.add(n.connectedNodes()).add(n.parent());T.updateStyle(r),r?n.rtrigger("add"):n.trigger("add")}return i},e.elesfn.removed=function(){var e=this[0];return e&&e._private.removed},e.elesfn.inside=function(){var e=this[0];return e&&!e._private.removed},e.elesfn.remove=function(t){function r(e){for(var t=e._private.edges,r=0;r<t.length;r++)n(t[r])}function i(e){for(var t=e._private.children,r=0;r<t.length;r++)n(t[r])}function n(e){var t=u[e.id()];t||(u[e.id()]=!0,e.isNode()?(c.push(e),r(e),i(e)):c.unshift(e))}function a(e,t){for(var r=e._private.edges,i=0;i<r.length;i++){var n=r[i];if(t===n){r.splice(i,1);break}}}function o(e,t){t=t[0],e=e[0];for(var r=e._private.children,i=0;i<r.length;i++)if(r[i][0]===t[0]){r.splice(i,1);break}}var s=this,l=[],c=[],u={},p=s._private.cy;void 0===t&&(t=!0);for(var d=0,h=s.length;h>d;d++){var g=s[d];n(g)}for(var d=0;d<c.length;d++){var g=c[d];if(g._private.removed=!0,p.removeFromPool(g),l.push(g),g.isEdge()){var v=g.source()[0],f=g.target()[0];a(v,g),a(f,g)}else{var y=g.parent();0!==y.length&&o(y,g)}}var m=p._private.elements;p._private.hasCompoundNodes=!1;for(var d=0;d<m.length;d++){var g=m[d];if(g.isParent()){p._private.hasCompoundNodes=!0;break}}var b=new e.Collection(this.cy(),l);b.size()>0&&(t&&this.cy().notify({type:"remove",collection:b}),b.trigger("remove"));for(var x={},d=0;d<c.length;d++){var g=c[d],w="nodes"===g._private.group,_=g._private.data.parent;if(w&&void 0!==_&&!x[_]){x[_]=!0;var y=p.getElementById(_);y&&0!==y.length&&!y._private.removed&&0===y.children().length&&y.updateStyle()}}return this}}(cytoscape),function(e){"use strict";e.fn.eles({breadthFirstSearch:function(t,r,i){i=1!==arguments.length||e.is.fn(r)?i:r,r=e.is.fn(r)?r:function(){};for(var n,a=this._private.cy,o=e.is.string(t)?this.filter(t):t,s=[],l=[],c={},u={},p=0,d=this.nodes(),h=this.edges(),g=0;g<o.length;g++)o[g].isNode()&&(s.unshift(o[g]),u[o[g].id()]=!0,l.push(o[g]),c[o[g].id()]=0);for(;0!==s.length;){var o=s.shift(),v=c[o.id()],f=r.call(o,p++,v);if(f===!0){n=o;break}if(f===!1)break;for(var y=o.connectedEdges(i?'[source = "'+o.id()+'"]':void 0).intersect(h),g=0;g<y.length;g++){var m=y[g],b=m.connectedNodes('[id != "'+o.id()+'"]').intersect(d);0===b.length||u[b.id()]||(b=b[0],s.push(b),u[b.id()]=!0,c[b.id()]=c[o.id()]+1,l.push(b),l.push(m))}}return{path:new e.Collection(a,l),found:new e.Collection(a,n)}},depthFirstSearch:function(t,r,i){i=1!==arguments.length||e.is.fn(r)?i:r,r=e.is.fn(r)?r:function(){};for(var n,a=this._private.cy,o=e.is.string(t)?this.filter(t):t,s=[],l=[],c={},u={},p={},d=0,h=this.edges(),g=this.nodes(),v=0;v<o.length;v++)o[v].isNode()&&(s.push(o[v]),l.push(o[v]),u[o[v].id()]=0);for(;0!==s.length;){var o=s.pop();if(!p[o.id()]){p[o.id()]=!0;var f=u[o.id()],y=r.call(o,d++,f);if(y===!0){n=o;break}if(y===!1)break;for(var m=o.connectedEdges(i?'[source = "'+o.id()+'"]':void 0).intersect(h),v=0;v<m.length;v++){var b=m[v],x=b.connectedNodes('[id != "'+o.id()+'"]').intersect(g);0===x.length||p[x.id()]||(x=x[0],s.push(x),u[x.id()]=u[o.id()]+1,l.push(x),c[x.id()]=b)}}}for(var w=[],v=0;v<l.length;v++){var _=l[v],E=c[_.id()];E&&w.push(E),w.push(_)}return{path:new e.Collection(a,w),found:new e.Collection(a,n)}},kruskal:function(t){function r(e){for(var t=0;t<n.length;t++){var r=n[t];if(r.anySame(e))return{eles:r,index:t}}}t=e.is.fn(t)?t:function(){return 1};for(var i=new e.Collection(this._private.cy,[]),n=[],a=this.nodes(),o=0;o<a.length;o++)n.push(a[o].collection());for(var s=this.edges(),l=s.toArray().sort(function(e,r){var i=t.call(e),n=t.call(r);return i-n}),o=0;o<l.length;o++){var c=l[o],u=c.source()[0],p=c.target()[0],d=r(u),h=r(p);d.index!==h.index&&(i=i.add(c),n[d.index]=d.eles.add(h.eles),n.splice(h.index,1))}return a.add(i)},dijkstra:function(t,r,i){var n=this._private.cy;i=e.is.fn(r)?i:r,r=e.is.fn(r)?r:function(){return 1};for(var a=e.is.string(t)?this.filter(t)[0]:t[0],o={},s={},l={},c=this.edges().not(":loop"),u=this.nodes(),p=[],d=0;d<u.length;d++)o[u[d].id()]=u[d].id()===a.id()?0:1/0,p.push(u[d]);var h=function(e){return o[e.id()]};p=new e.Collection(n,p);for(var g=e.Minheap(n,p,h),v=function(e,t){for(var n,a=(i?e.edgesTo(t):e.edgesWith(t)).intersect(c),o=1/0,s=0;s<a.length;s++){var l=a[s],u=r.call(l);(o>u||!n)&&(o=u,n=l)}return{edge:n,dist:o}};g.size()>0;){var f=g.pop(),y=f.value,m=f.id,b=n.getElementById(m);if(l[m]=y,y===Math.Infinite)break;for(var x=b.neighborhood().intersect(u),d=0;d<x.length;d++){var w=x[d],_=w.id(),E=v(b,w),S=y+E.dist;S<g.getValueById(_)&&(g.edit(_,S),s[_]={node:b,edge:E.edge})}}return{distanceTo:function(t){var r=e.is.string(t)?u.filter(t)[0]:t[0];return l[r.id()]},pathTo:function(t){var r=e.is.string(t)?u.filter(t)[0]:t[0],i=[],a=r;for(i.unshift(r);s[a.id()];){var o=s[a.id()];i.unshift(o.edge),i.unshift(o.node),a=o.node}return new e.Collection(n,i)}}}}),e.elesfn.bfs=e.elesfn.breadthFirstSearch,e.elesfn.dfs=e.elesfn.depthFirstSearch}(cytoscape),function(e){"use strict";e.fn.eles({animated:function(){var e=this[0];return e?e._private.animation.current.length>0:void 0},clearQueue:function(){for(var e=0;e<this.length;e++){var t=this[e];t._private.animation.queue=[]}return this},delay:function(e,t){return this.animate({delay:e},{duration:e,complete:t}),this},animate:function(e,t){var r,i=+new Date,n=this._private.cy,a=n.style();switch(void 0===t&&(t={}),void 0===t.duration&&(t.duration=400),t.duration){case"slow":t.duration=600;break;case"fast":t.duration=200}if(null==e||null==e.position&&null==e.renderedPosition&&null==e.css&&null==e.delay)return this;if(e.css&&(e.css=a.getValueStyle(e.css)),e.renderedPosition){var o=e.renderedPosition,s=n.pan(),l=n.zoom();e.position={x:(o.x-s.x)/l,y:(o.y-s.y)/l}}for(var c=0;c<this.length;c++){var u=this[c],p=u._private.position,d={x:p.x,y:p.y},h=a.getValueStyle(u);r=u.animated()&&(void 0===t.queue||t.queue)?u._private.animation.queue:u._private.animation.current,r.push({properties:e,duration:t.duration,params:t,callTime:i,startPosition:d,startStyle:h})}return n.addToAnimationPool(this),this},stop:function(e,t){for(var r=0;r<this.length;r++){for(var i=this[r],n=i._private.animation.current,a=0;a<n.length;a++){var o=n[a];t&&(o.duration=0)}e&&(i._private.animation.queue=[]),t||(i._private.animation.current=[])}return this.cy().notify({collection:this,type:"draw"}),this}})}(cytoscape),function(e){"use strict";e.fn.eles({addClass:function(t){t=t.split(/\s+/);for(var r=this,i=[],n=0;n<t.length;n++){var a=t[n];if(!e.is.emptyString(a))for(var o=0;o<r.length;o++){var s=r[o],l=s._private.classes[a];s._private.classes[a]=!0,l||i.push(s)}}return i.length>0&&new e.Collection(this._private.cy,i).updateStyle(),r.trigger("class"),r},hasClass:function(e){var t=this[0];return null!=t&&t._private.classes[e]?!0:!1},toggleClass:function(t,r){for(var i=t.split(/\s+/),n=this,a=[],o=0,s=n.length;s>o;o++)for(var l=n[o],c=0;c<i.length;c++){var u=i[c];if(!e.is.emptyString(u)){var p=l._private.classes[u],d=r||void 0===r&&!p;d?(l._private.classes[u]=!0,p||a.push(l)):(l._private.classes[u]=!1,p&&a.push(l))}}return a.length>0&&new e.Collection(this._private.cy,a).updateStyle(),n.trigger("class"),n},removeClass:function(t){t=t.split(/\s+/);for(var r=this,i=[],n=0;n<r.length;n++)for(var a=r[n],o=0;o<t.length;o++){var s=t[o];if(s&&""!==s){var l=a._private.classes[s];delete a._private.classes[s],l&&i.push(a)}}return i.length>0&&new e.Collection(r._private.cy,i).updateStyle(),r.trigger("class"),r}})}(cytoscape),function(e){"use strict";e.fn.eles({allAre:function(e){return this.filter(e).length===this.length},is:function(e){return this.filter(e).length>0},same:function(e){return e=this.cy().collection(e),this.length!==e.length?!1:this.intersect(e).length===this.length},anySame:function(e){return e=this.cy().collection(e),this.intersect(e).length>0},allAreNeighbors:function(e){return e=this.cy().collection(e),this.neighborhood().intersect(e).length===e.length}})}(cytoscape),function(e){"use strict";e.fn.eles({parent:function(t){for(var r=[],i=this._private.cy,n=0;n<this.length;n++){var a=this[n],o=i.getElementById(a._private.data.parent);o.size()>0&&r.push(o)}return new e.Collection(i,r).filter(t)},parents:function(t){for(var r=[],i=this.parent();i.nonempty();){for(var n=0;n<i.length;n++){var a=i[n];r.push(a)}i=i.parent()}return new e.Collection(this.cy(),r).filter(t)},children:function(t){for(var r=[],i=0;i<this.length;i++){var n=this[i];r=r.concat(n._private.children)}return new e.Collection(this.cy(),r).filter(t)},siblings:function(e){return this.parent().children().not(this).filter(e)},isParent:function(){var e=this[0];return e?0!==e._private.children.length:void 0},isChild:function(){var e=this[0];return e?void 0!==e._private.data.parent&&0!==e.parent().length:void 0},descendants:function(t){function r(e){for(var t=0;t<e.length;t++){var n=e[t];i.push(n),n.children().nonempty()&&r(n.children())}}var i=[];return r(this.children()),new e.Collection(this.cy(),i).filter(t)}}),e.fn.eles.ancestors=e.fn.eles.parents}(cytoscape),function(e){"use strict";var t=1,r=0;e.fn.eles({data:e.define.data({field:"data",bindingEvent:"data",allowBinding:!0,allowSetting:!0,settingEvent:"data",settingTriggersEvent:!0,triggerFnName:"trigger",allowGetting:!0,immutableKeys:{id:!0,source:!0,target:!0,parent:!0},updateMappers:!0}),removeData:e.define.removeData({field:"data",event:"data",triggerFnName:"trigger",triggerEvent:!0,immutableKeys:{id:!0,source:!0,target:!0,parent:!0},updateMappers:!0}),batchData:e.define.batchData({field:"data",event:"data",triggerFnName:"trigger",immutableKeys:{id:!0,source:!0,target:!0,parent:!0},updateMappers:!0}),scratch:e.define.data({field:"scratch",allowBinding:!1,allowSetting:!0,settingTriggersEvent:!1,allowGetting:!0}),removeScratch:e.define.removeData({field:"scratch",triggerEvent:!1}),rscratch:e.define.data({field:"rscratch",allowBinding:!1,allowSetting:!0,settingTriggersEvent:!1,allowGetting:!0}),removeRscratch:e.define.removeData({field:"rscratch",triggerEvent:!1}),id:function(){var e=this[0];return e?e._private.data.id:void 0},position:e.define.data({field:"position",bindingEvent:"position",allowBinding:!0,allowSetting:!0,settingEvent:"position",settingTriggersEvent:!0,triggerFnName:"rtrigger",allowGetting:!0,validKeys:["x","y"],onSet:function(e){var t=e.updateCompoundBounds();t.rtrigger("position")},canSet:function(e){return!e.locked()}}),silentPosition:e.define.data({field:"position",bindingEvent:"position",allowBinding:!1,allowSetting:!0,settingEvent:"position",settingTriggersEvent:!1,triggerFnName:"trigger",allowGetting:!0,validKeys:["x","y"],onSet:function(e){e.updateCompoundBounds()},canSet:function(e){return!e.locked()}}),positions:function(t){if(e.is.plainObject(t))this.position(t);else if(e.is.fn(t)){for(var r=t,i=0;i<this.length;i++){var n=this[i],t=r.apply(n,[i,n]);if(t&&!n.locked()){var a=n._private.position;a.x=t.x,a.y=t.y}}var o=this.updateCompoundBounds();this.add(o).rtrigger("position")}return this},updateCompoundBounds:function(){function t(e){var t=e.children(),r=e._private.style,n=t.boundingBox({includeLabels:!1,includeEdges:!1}),a={top:r["padding-top"].pxValue,bottom:r["padding-bottom"].pxValue,left:r["padding-left"].pxValue,right:r["padding-right"].pxValue},o=e._private.position,s=!1;"auto"===r.width.value&&(e._private.autoWidth=n.w+a.left+a.right,o.x=(n.x1+n.x2-a.left+a.right)/2,s=!0),"auto"===r.height.value&&(e._private.autoHeight=n.h+a.top+a.bottom,o.y=(n.y1+n.y2-a.top+a.bottom)/2,s=!0),s&&i.push(e)}var r=this.cy();if(!r.hasCompoundNodes())return r.collection();for(var i=[],n=this.parent();n.nonempty();){for(var a=0;a<n.length;a++){var o=n[a];t(o)}n=n.parent()}return new e.Collection(r,i)},renderedPosition:function(t,r){var i=this[0],n=this.cy(),a=n.zoom(),o=n.pan(),s=e.is.plainObject(t)?t:void 0,l=void 0!==s||void 0!==r&&e.is.string(t);
if(i&&i.isNode()){if(!l){var c=i._private.position;return s={x:c.x*a+o.x,y:c.y*a+o.y},void 0===t?s:s[t]}for(var u=0;u<this.length;u++){var i=this[u];void 0!==r?i._private.position[t]=(r-o[t])/a:void 0!==s&&(i._private.position={x:(s.x-o.x)/a,y:(s.y-o.y)/a})}this.rtrigger("position")}else if(!l)return void 0;return this},width:function(){var e=this[0];if(e){var t=e._private.style.width;return"auto"===t.strValue?e._private.autoWidth:t.pxValue}},outerWidth:function(){var e=this[0];if(e){var i=e._private.style,n="auto"===i.width.strValue?e._private.autoWidth:i.width.pxValue,a=i["border-width"]?i["border-width"].pxValue*t+r:0;return n+a}},renderedWidth:function(){var e=this[0];if(e){var t=e.width();return t*this.cy().zoom()}},renderedOuterWidth:function(){var e=this[0];if(e){var t=e.outerWidth();return t*this.cy().zoom()}},height:function(){var e=this[0];if(e&&e.isNode()){var t=e._private.style.height;return"auto"===t.strValue?e._private.autoHeight:t.pxValue}},outerHeight:function(){var e=this[0];if(e){var i=e._private.style,n="auto"===i.height.strValue?e._private.autoHeight:i.height.pxValue,a=i["border-width"]?i["border-width"].pxValue*t+r:0;return n+a}},renderedHeight:function(){var e=this[0];if(e){var t=e.height();return t*this.cy().zoom()}},renderedOuterHeight:function(){var e=this[0];if(e){var t=e.outerHeight();return t*this.cy().zoom()}},renderedBoundingBox:function(e){var t=this.boundingBox(e),r=this.cy(),i=r.zoom(),n=r.pan(),a=t.x1*i+n.x,o=t.x2*i+n.x,s=t.y1*i+n.y,l=t.y2*i+n.y;return{x1:a,x2:o,y1:s,y2:l,w:o-a,h:l-s}},boundingBox:function(t){var r=this;t=e.util.extend({includeNodes:!0,includeEdges:!0,includeLabels:!0},t),this.cy().recalculateRenderedStyle();for(var i=1/0,n=-1/0,a=1/0,o=-1/0,s=0;s<r.length;s++){var l,c,u,p,d,h,g=r[s],v=!1;if("none"!==g.css("display")){if(g.isNode()&&t.includeNodes){v=!0;var f=g._private.position;d=f.x,h=f.y;var y=g.outerWidth(),m=y/2,b=g.outerHeight(),x=b/2;l=d-m,c=d+m,u=h-x,p=h+x,i=i>l?l:i,n=c>n?c:n,a=a>u?u:a,o=p>o?p:o}else if(g.isEdge()&&t.includeEdges){v=!0;var w=g.source()[0]._private.position,_=g.target()[0]._private.position,E=g._private.rstyle||{};if(l=w.x,c=_.x,u=w.y,p=_.y,l>c){var S=l;l=c,c=S}if(u>p){var S=u;u=p,p=S}i=i>l?l:i,n=c>n?c:n,a=a>u?u:a,o=p>o?p:o;for(var P=E.bezierPts||[],y=g._private.style.width.pxValue,k=0;k<P.length;k++){var M=P[k];i=M.x-y<i?M.x-y:i,n=M.x+y>n?M.x+y:n,a=M.y-y<a?M.y-y:a,o=M.y+y>o?M.y+y:o}}var N=g._private.style,E=g._private.rstyle,C=N.content.strValue,D=N["font-size"],T=N["text-halign"],I=N["text-valign"],z=E.labelWidth,B=E.labelHeight,R=E.labelX,X=E.labelY;if(v&&t.includeLabels&&C&&D&&void 0!=B&&void 0!=z&&void 0!=R&&void 0!=X&&T&&I){var Y,V,L,A,O=B,F=z;if(g.isEdge())Y=R-F/2,V=R+F/2,L=X-O/2,A=X+O/2;else{switch(T.value){case"left":Y=R-F,V=R;break;case"center":Y=R-F/2,V=R+F/2;break;case"right":Y=R,V=R+F}switch(I.value){case"top":L=X-O,A=X;break;case"center":L=X-O/2,A=X+O/2;break;case"bottom":L=X,A=X+O}}i=i>Y?Y:i,n=V>n?V:n,a=a>L?L:a,o=A>o?A:o}}}return{x1:i,x2:n,y1:a,y2:o,w:n-i,h:o-a}}})}(cytoscape),function(e){"use strict";function t(e){return function(t){var r=this;if(void 0===t&&(t=!0),0!==r.length&&r.isNode()&&!r.removed()){for(var i=0,n=r[0],a=n._private.edges,o=0;o<a.length;o++){var s=a[o];(t||!s.isLoop())&&(i+=e(n,s))}return i}}}function r(e,t){return function(r){for(var i=void 0,n=this.nodes(),a=0;a<n.length;a++){var o=n[a],s=o[e](r);void 0===s||void 0!==i&&!t(s,i)||(i=s)}return i}}e.fn.eles({degree:t(function(e,t){return t.source().same(t.target())?2:1}),indegree:t(function(e,t){return t.target().same(e)?1:0}),outdegree:t(function(e,t){return t.source().same(e)?1:0})}),e.fn.eles({minDegree:r("degree",function(e,t){return t>e}),maxDegree:r("degree",function(e,t){return e>t}),minIndegree:r("indegree",function(e,t){return t>e}),maxIndegree:r("indegree",function(e,t){return e>t}),minOutdegree:r("outdegree",function(e,t){return t>e}),maxOutdegree:r("outdegree",function(e,t){return e>t})}),e.fn.eles({totalDegree:function(e){for(var t=0,r=this.nodes(),i=0;i<r.length;i++)t+=r[i].degree(e);return t}})}(cytoscape),function(e){"use strict";e.fn.eles({on:e.define.on(),one:e.define.on({unbindSelfOnTrigger:!0}),once:e.define.on({unbindAllBindersOnTrigger:!0}),off:e.define.off(),trigger:e.define.trigger(),rtrigger:function(e,t){return 0!==this.length?(this.cy().notify({type:e,collection:this.filter(function(){return!this.removed()})}),this.trigger(e,t),this):void 0}}),e.elesfn.bind=e.elesfn.on,e.elesfn.unbind=e.elesfn.off}(cytoscape),function(e){"use strict";e.fn.eles({nodes:function(e){return this.filter(function(e,t){return t.isNode()}).filter(e)},edges:function(e){return this.filter(function(e,t){return t.isEdge()}).filter(e)},filter:function(t){var r=this._private.cy;if(e.is.fn(t)){for(var i=[],n=0;n<this.length;n++){var a=this[n];t.apply(a,[n,a])&&i.push(a)}return new e.Collection(r,i)}return e.is.string(t)||e.is.elementOrCollection(t)?new e.Selector(t).filter(this):void 0===t?this:new e.Collection(r)},not:function(t){var r=this._private.cy;if(t){e.is.string(t)&&(t=this.filter(t));for(var i=[],n=0;n<this.length;n++){var a=this[n],o=t._private.ids[a.id()];o||i.push(a)}return new e.Collection(r,i)}return this},intersect:function(t){var r=this._private.cy;if(e.is.string(t)){var i=t;return this.filter(i)}var n=[],a=this,o=t,s=this.length<t.length,l=s?a._private.ids:o._private.ids,c=s?o._private.ids:a._private.ids;for(var u in l){var p=c[u];p&&n.push(p)}return new e.Collection(r,n)},add:function(t){var r=this._private.cy;if(!t)return this;if(e.is.string(t)){var i=t;t=r.elements(i)}for(var n=[],a=0;a<this.length;a++)n.push(this[a]);for(var a=0;a<t.length;a++){var o=!this._private.ids[t[a].id()];o&&n.push(t[a])}return new e.Collection(r,n)}})}(cytoscape),function(e){"use strict";e.fn.eles({isNode:function(){return"nodes"===this.group()},isEdge:function(){return"edges"===this.group()},isLoop:function(){return this.isEdge()&&this.source().id()===this.target().id()},group:function(){var e=this[0];return e?e._private.group:void 0}})}(cytoscape),function(e){"use strict";e.fn.eles({each:function(t){if(e.is.fn(t))for(var r=0;r<this.length;r++){var i=this[r],n=t.apply(i,[r,i]);if(n===!1)break}return this},toArray:function(){for(var e=[],t=0;t<this.length;t++)e.push(this[t]);return e},slice:function(t,r){var i=[],n=this.length;null==r&&(r=n),null==t&&(t=0),0>t&&(t=n+t),0>r&&(r=n+r);for(var a=t;a>=0&&r>a&&n>a;a++)i.push(this[a]);return new e.Collection(this.cy(),i)},size:function(){return this.length},eq:function(e){return this[e]},empty:function(){return 0===this.length},nonempty:function(){return!this.empty()},sort:function(t){if(!e.is.fn(t))return this;var r=this.cy(),i=(new e.Collection(r),this.toArray().sort(t));return new e.Collection(r,i)},sortByZIndex:function(){return this.sort(e.Collection.zIndexSort)}}),e.Collection.zIndexSort=function(e,t){var r=function(e){return"nodes"==e._private.group?e.parents().size():"edges"==e._private.group?Math.max(e.source()[0].parents().size(),e.target()[0].parents().size()):0},i=e._private.style["z-index"].value-t._private.style["z-index"].value,n=0,a=0;return e.cy().hasCompoundNodes()&&(n=r(e),a=r(t)),n-a===0?"nodes"===e._private.group&&"edges"===t._private.group?1:"edges"===e._private.group&&"nodes"===t._private.group?-1:0===i?e._private.index-t._private.index:i:n-a}}(cytoscape),function(e){"use strict";e.fn.eles({updateStyle:function(e){var t=this._private.cy,r=t.style();e=e||void 0===e?!0:!1,r.apply(this);var i=this.updateCompoundBounds();return e?this.add(i).rtrigger("style"):this.add(i).trigger("style"),this},updateMappers:function(e){var t=this._private.cy,r=t.style();e=e||void 0===e?!0:!1,r.updateMappers(this);var i=this.updateCompoundBounds();return e?this.add(i).rtrigger("style"):this.add(i).trigger("style"),this},renderedCss:function(e){var t=this[0];if(t){var r=t.cy().style().getRenderedStyle(t);return void 0===e?r:r[e]}},css:function(t,r){var i=this.cy().style();if(e.is.plainObject(t)){var n=t;i.applyBypass(this,n);var a=this.updateCompoundBounds();this.add(a).rtrigger("style")}else if(e.is.string(t)){if(void 0===r){var o=this[0];return o?o._private.style[t].strValue:void 0}i.applyBypass(this,t,r);var a=this.updateCompoundBounds();this.add(a).rtrigger("style")}else if(void 0===t){var o=this[0];return o?i.getRawStyle(o):void 0}return this},removeCss:function(){for(var e=this.cy().style(),t=this,r=0;r<t.length;r++){var i=t[r];e.removeAllBypasses(i)}var n=this.updateCompoundBounds();this.add(n).rtrigger("style")},show:function(){return this.css("display","element"),this},hide:function(){return this.css("display","none"),this},visible:function(){var e=this[0];if(e){if("visible"!==e.css("visibility")||"element"!==e.css("display"))return!1;if(e.isNode()){for(var t=e.parents(),r=0;r<t.length;r++){{var i=t[r],n=i.css("visibility"),a=i.css("display");parseFloat(i.css("opacity"))}if("visible"!==n||"element"!==a)return!1}return!0}if(e.isEdge()){var o=e.source(),s=e.target();return o.visible()&&s.visible()}}},hidden:function(){var e=this[0];return e?!e.visible():void 0},effectiveOpacity:function(){var e=this[0];if(e){for(var t=e._private.style.opacity.value,r=e.parents(),i=0;i<r.length;i++){var n=r[i],a=n._private.style.opacity.value;t=a*t}return t}},transparent:function(){var e=this[0];return e?0===e.effectiveOpacity():void 0},isFullAutoParent:function(){var e=this[0];if(e){var t="auto"===e._private.style.width.value,r="auto"===e._private.style.height.value;return e.isParent()&&t&&r}}}),e.elesfn.style=e.elesfn.css,e.elesfn.renderedStyle=e.elesfn.renderedCss,e.elesfn.removeStyle=e.elesfn.removeCss}(cytoscape),function(e){"use strict";function t(e){return function(){var t=arguments;if(2===t.length){var r=t[0],i=t[1];this.bind(e.event,r,i)}else if(1===t.length){var i=t[0];this.bind(e.event,i)}else if(0===t.length){for(var n=0;n<this.length;n++){var a=this[n];(!e.ableField||a._private[e.ableField])&&(a._private[e.field]=e.value)}this.updateStyle(),this.trigger(e.event)}return this}}function r(r){e.elesfn[r.field]=function(){var e=this[0];return e?e._private[r.field]:void 0},e.elesfn[r.on]=t({event:r.on,field:r.field,ableField:r.ableField,value:!0}),e.elesfn[r.off]=t({event:r.off,field:r.field,ableField:r.ableField,value:!1})}r({field:"locked",on:"lock",off:"unlock"}),r({field:"grabbable",on:"grabify",off:"ungrabify"}),r({field:"selected",ableField:"selectable",on:"select",off:"unselect"}),r({field:"selectable",on:"selectify",off:"unselectify"}),e.elesfn.grabbed=function(){var e=this[0];return e?e._private.grabbed:void 0},r({field:"active",on:"activate",off:"unactivate"}),e.elesfn.inactive=function(){var e=this[0];return e?!e._private.active:void 0}}(cytoscape),function(e){"use strict";function t(t){return function(r){for(var i=[],n=this._private.cy,a=0;a<this.length;a++){var o=this[a],s=o._private[t.attr];s&&i.push(s)}return new e.Collection(n,i).filter(r)}}function r(t){return function(r){var i=[],n=this._private.cy,a=t||{};e.is.string(r)&&(r=n.$(r));for(var o=r.connectedEdges(),s=this._private.ids,l=0;l<o.length;l++){var c,u=o[l],p=u._private.data;if(a.thisIs){var d=p[a.thisIs];c=s[d]}else c=s[p.source]||s[p.target];c&&i.push(u)}return new e.Collection(n,i)}}function i(t){var r={codirected:!1};return t=e.util.extend({},r,t),function(r){for(var i=this._private.cy,n=[],a=this.edges(),o=t,s=0;s<a.length;s++)for(var l=a[s],c=l.source()[0],u=c.id(),p=l.target()[0],d=p.id(),h=c._private.edges,g=0;g<h.length;g++){var v=h[g],f=v._private.data,y=f.target,m=f.source,b=y===d&&m===u,x=u===y&&d===m;(o.codirected&&b||!o.codirected&&(b||x))&&n.push(v)}return new e.Collection(i,n).filter(r)}}e.fn.eles({roots:function(t){for(var r=this,i=[],n=0;n<r.length;n++){var a=r[n];if(a.isNode()){var o=a.connectedEdges('[target = "'+a.id()+'"][source != "'+a.id()+'"]').length>0;o||i.push(a)}}return new e.Collection(this._private.cy,i).filter(t)},forwardNodes:function(t){for(var r=this,i=[],n=0;n<r.length;n++){var a=r[n],o=a.id();if(a.isNode())for(var s=a._private.edges,l=0;l<s.length;l++){var c=s[l],u=c._private.data.source,p=c._private.data.target;u===o&&p!==o&&i.push(c.target()[0])}}return new e.Collection(this._private.cy,i).filter(t)},backwardNodes:function(t){for(var r=this,i=[],n=0;n<r.length;n++){var a=r[n],o=a.id();if(a.isNode())for(var s=a._private.edges,l=0;l<s.length;l++){var c=s[l],u=c._private.data.source,p=c._private.data.target;p===o&&u!==o&&i.push(c.source()[0])}}return new e.Collection(this._private.cy,i).filter(t)}}),e.fn.eles({neighborhood:function(t){for(var r=[],i=this._private.cy,n=this.nodes(),a=0;a<n.length;a++)for(var o=n[a],s=o.connectedEdges(),l=0;l<s.length;l++){var c=s[l],u=c.connectedNodes().not(o);u.length>0&&r.push(u[0]),r.push(c[0])}return new e.Collection(i,r).filter(t)},closedNeighborhood:function(e){return this.neighborhood().add(this).filter(e)},openNeighborhood:function(e){return this.neighborhood(e)}}),e.fn.eles({source:function(t){var r,i=this[0];return i&&(r=i._private.source),new e.Collection(this.cy(),r).filter(t)},target:function(t){var r,i=this[0];return i&&(r=i._private.target),new e.Collection(this.cy(),r).filter(t)},sources:t({attr:"source"}),targets:t({attr:"target"})}),e.fn.eles({edgesWith:r(),edgesTo:r({thisIs:"source"})}),e.fn.eles({connectedEdges:function(t){for(var r=[],i=this._private.cy,n=this,a=0;a<n.length;a++){var o=n[a];if(o.isNode())for(var s=o._private.edges,l=0;l<s.length;l++){var c=s[l];r.push(c)}}return new e.Collection(i,r).filter(t)},connectedNodes:function(t){for(var r=[],i=this._private.cy,n=this,a=0;a<n.length;a++){var o=n[a];o.isEdge()&&(r.push(o.source()[0]),r.push(o.target()[0]))}return new e.Collection(i,r).filter(t)},parallelEdges:i(),codirectedEdges:i({codirected:!0})})}(cytoscape),function(e){"use strict";e.Minheap=function(t,r,i){return new e.Heap(t,r,e.Heap.minHeapComparator,i)},e.Maxheap=function(t,r,i){return new e.Heap(t,r,e.Heap.maxHeapComparator,i)},e.Heap=function(t,r,i,n){if("undefined"!=typeof i&&"undefined"!=typeof r){"undefined"==typeof n&&(n=e.Heap.idFn);var a,o,s,l=[],c={},u=[],p=0;for(r=this.getArgumentAsCollection(r,t),s=r.length,p=0;s>p;p+=1){if(l.push(n.call(t,r[p],p,r)),a=r[p].id(),c.hasOwnProperty(a))throw"ERROR: Multiple items with the same id found: "+a;c[a]=p,u.push(a)}for(this._private={cy:t,heap:l,pointers:c,elements:u,comparator:i,extractor:n,length:s},p=Math.floor(s/2);p>=0;p-=1)o=this.heapify(p);return o}},e.Heap.idFn=function(e){return e.id()},e.Heap.minHeapComparator=function(e,t){return e>=t},e.Heap.maxHeapComparator=function(e,t){return t>=e},e.Heap.prototype.size=function(){return this._private.length},e.Heap.prototype.getArgumentAsCollection=function(t,r){var i;if("undefined"==typeof r&&(r=this._private.cy),e.is.elementOrCollection(t))i=t;else{for(var n=[],a=[].concat.apply([],[t]),o=0;o<a.length;o++){var s=a[o],l=r.getElementById(s);l.length>0&&n.push(l)}i=new e.Collection(r,n)}return i},e.Heap.prototype.isHeap=function(){var e,t,r,i,n,a=this._private.heap,o=a.length,s=this._private.comparator;for(e=0;o>e;e+=1)if(t=2*e+1,r=t+1,i=o>t?s(a[t],a[e]):!0,n=o>r?s(a[r],a[e]):!0,!i||!n)return!1;return!0},e.Heap.prototype.heapSwap=function(e,t){var r=this._private.heap,i=this._private.pointers,n=this._private.elements,a=r[e],o=n[e],s=n[e],l=n[t];r[e]=r[t],n[e]=n[t],i[s]=t,i[l]=e,r[t]=a,n[t]=o},e.Heap.prototype.heapify=function(e,t){var r,i,n,a,o,s,l,c=0,u=!1;for("undefined"==typeof t&&(t=!0),r=this._private.heap,c=r.length,s=this._private.comparator,i=e;!u;)t?(n=2*i+1,a=n+1,o=i,c>n&&!s(r[n],r[o])&&(o=n),c>a&&!s(r[a],r[o])&&(o=a),u=o===i,u||(this.heapSwap(o,i),i=o)):(l=Math.floor((i-1)/2),o=i,u=0>l||s(r[o],r[l]),u||(this.heapSwap(o,l),i=l))},e.Heap.prototype.insert=function(e){var t,r,i,n,a,o=this.getArgumentAsCollection(e),s=o.length;for(a=0;s>a;a+=1){if(t=o[a],r=this._private.heap.length,i=this._private.extractor(t),n=t.id(),this._private.pointers.hasOwnProperty(n))throw"ERROR: Multiple items with the same id found: "+n;this._private.heap.push(i),this._private.elements.push(n),this._private.pointers[n]=r,this.heapify(r,!1)}this._private.length=this._private.heap.length},e.Heap.prototype.getValueById=function(e){if(this._private.pointers.hasOwnProperty(e)){var t=this._private.pointers[e];return this._private.heap[t]}},e.Heap.prototype.contains=function(e){for(var t=this.getArgumentAsCollection(e),r=0;r<t.length;r+=1){var i=t[r].id();if(!this._private.pointers.hasOwnProperty(i))return!1}return!0},e.Heap.prototype.top=function(){return this._private.length>0?{value:this._private.heap[0],id:this._private.elements[0]}:void 0},e.Heap.prototype.pop=function(){if(this._private.length>0){var e,t,r,i=this.top(),n=this._private.length-1;return this.heapSwap(0,n),e=this._private.elements[n],t=this._private.heap[n],r=e,this._private.heap.pop(),this._private.elements.pop(),this._private.length=this._private.heap.length,delete this._private.pointers[r],this.heapify(0),i}},e.Heap.prototype.findDirectionHeapify=function(e){var t=Math.floor((e-1)/2),r=this._private.heap,i=0>t||this._private.comparator(r[e],r[t]);this.heapify(e,i)},e.Heap.prototype.edit=function(t,r){for(var i=this.getArgumentAsCollection(t),n=0;n<i.length;n+=1){var a=i[n].id(),o=this._private.pointers[a],s=this._private.heap[o];e.is.number(r)?this._private.heap[o]=r:e.is.fn(r)&&(this._private.heap[o]=r.call(this._private.cy,s,o)),this.findDirectionHeapify(o)}},e.Heap.prototype.delete=function(e){for(var t=this.getArgumentAsCollection(e),r=0;r<t.length;r+=1){var i,n,a,o=t[r].id(),s=this._private.pointers[o],l=this._private.length-1;s!==l&&this.heapSwap(s,l),i=this._private.elements[l],n=this._private.heap[l],a=i,this._private.heap.pop(),this._private.elements.pop(),this._private.length=this._private.heap.length,delete this._private.pointers[a],this.findDirectionHeapify(s)}return n}}(cytoscape),function(e){"use strict";function t(e){t.CANVAS_LAYERS=5,t.SELECT_BOX=0,t.DRAG=2,t.NODE=4,t.BUFFER_COUNT=2,this.options=e,this.data={select:[void 0,void 0,void 0,void 0,0],renderer:this,cy:e.cy,container:e.cy.container(),canvases:new Array(t.CANVAS_LAYERS),canvasNeedsRedraw:new Array(t.CANVAS_LAYERS),bufferCanvases:new Array(t.BUFFER_COUNT)},this.hoverData={down:null,last:null,downTime:null,triggerMode:null,dragging:!1,initialPan:[null,null],capture:!1},this.timeoutData={panTimeout:null},this.dragData={possibleDragElements:[]},this.touchData={start:null,capture:!1,startPosition:[null,null,null,null,null,null],singleTouchStartTime:null,singleTouchMoved:!0,now:[null,null,null,null,null,null],earlier:[null,null,null,null,null,null]},this.zoomData={freeToZoom:!1,lastPointerX:null},this.redraws=0,this.bindings=[],this.data.canvasContainer=document.createElement("div");var r=this.data.canvasContainer.style;r.position="absolute",r.zIndex="0",this.data.container.appendChild(this.data.canvasContainer);for(var i=0;i<t.CANVAS_LAYERS;i++)this.data.canvases[i]=document.createElement("canvas"),this.data.canvases[i].style.position="absolute",this.data.canvases[i].setAttribute("data-id","layer"+i),this.data.canvases[i].style.zIndex=String(t.CANVAS_LAYERS-i),this.data.canvasContainer.appendChild(this.data.canvases[i]),this.data.canvasNeedsRedraw[i]=!1;this.data.canvases[t.NODE].setAttribute("data-id","layer"+t.NODE+"-node"),this.data.canvases[t.SELECT_BOX].setAttribute("data-id","layer"+t.SELECT_BOX+"-selectbox"),this.data.canvases[t.DRAG].setAttribute("data-id","layer"+t.DRAG+"-drag");for(var i=0;i<t.BUFFER_COUNT;i++)this.data.bufferCanvases[i]=document.createElement("canvas"),this.data.bufferCanvases[i].style.position="absolute",this.data.bufferCanvases[i].setAttribute("data-id","buffer"+i),this.data.bufferCanvases[i].style.zIndex=String(-i-1),this.data.bufferCanvases[i].style.visibility="hidden",this.data.canvasContainer.appendChild(this.data.bufferCanvases[i]);this.hideEdgesOnViewport=e.hideEdgesOnViewport,this.load()}t.panOrBoxSelectDelay=400,t.isTouch=e.is.touch(),t.prototype.notify=function(e){switch(e.type){case"destroy":return void this.destroy();case"add":case"remove":case"load":this.updateNodesCache(),this.updateEdgesCache();break;case"viewport":this.data.canvasNeedsRedraw[t.SELECT_BOX]=!0;break;case"style":this.updateCachedZSortedEles()}this.data.canvasNeedsRedraw[t.DRAG]=!0,this.data.canvasNeedsRedraw[t.NODE]=!0,this.redraw()},t.prototype.destroy=function(){this.destroyed=!0;for(var e=0;e<this.bindings.length;e++){var t=this.bindings[e],r=t;r.target.removeEventListener(r.event,r.handler,r.useCapture)}};for(var r in e.math)t.prototype[r]=e.math[r];e("renderer","canvas",t)}(cytoscape),function(e){"use strict";var t=e("renderer","canvas"),r=t.prototype,i=t.arrowShapes={};t.arrowShapeHeight=.3;var n=function(e,t,r,i,n,a){var o=r-n/2,s=r+n/2,l=i-a/2,c=i+a/2;return e>=o&&s>=e&&t>=l&&c>=t};i.arrow={_points:[-.15,-.3,0,0,.15,-.3],collide:function(t,r,n,a,o,s,l,c){var u=i.arrow._points;return e.math.pointInsidePolygon(t,r,u,n,a,o,s,l,c)},roughCollide:n,draw:function(e){for(var t=i.arrow._points,r=0;r<t.length/2;r++)e.lineTo(t[2*r],t[2*r+1])},spacing:function(){return 0},gap:function(e){return 2*e._private.style.width.pxValue}},i.triangle=i.arrow,i.none={collide:function(){return!1},roughCollide:function(){return!1},draw:function(){},spacing:function(){return 0},gap:function(){return 0}},i.circle={_baseRadius:.15,collide:function(e,t,r,n,a,o,s,l){if(a!=o){var c=Math.asin(s[1]/Math.sqrt(s[0]*s[0]+s[1]*s[1])),u=(Math.cos(-c),Math.sin(-c),(o+l)/(a+l));return t/=u,n/=u,Math.pow(r-e,2)+Math.pow(n-t,2)<=Math.pow((a+l)*i.circle._baseRadius,2)}return Math.pow(r-e,2)+Math.pow(n-t,2)<=Math.pow((a+l)*i.circle._baseRadius,2)},roughCollide:n,draw:function(e){e.arc(0,0,i.circle._baseRadius,0,2*Math.PI,!1)},spacing:function(e){return r.getArrowWidth(e._private.style.width.pxValue)*i.circle._baseRadius},gap:function(e){return 2*e._private.style.width.pxValue}},i.inhibitor={_points:[-.25,0,-.25,-.1,.25,-.1,.25,0],collide:function(t,r,n,a,o,s,l,c){var u=i.inhibitor._points;return e.math.pointInsidePolygon(t,r,u,n,a,o,s,l,c)},roughCollide:n,draw:function(e){for(var t=i.inhibitor._points,r=0;r<t.length/2;r++)e.lineTo(t[2*r],t[2*r+1])},spacing:function(){return 4},gap:function(){return 4}},i.tee=i.inhibitor,i.square={_points:[-.12,0,.12,0,.12,-.24,-.12,-.24],collide:function(t,r,n,a,o,s,l,c){var u=i.square._points;return e.math.pointInsidePolygon(t,r,u,n,a,o,s,l,c)},roughCollide:n,draw:function(e){for(var t=i.square._points,r=0;r<t.length/2;r++)e.lineTo(t[2*r],t[2*r+1])},spacing:function(){return 0},gap:function(e){return 2*e._private.style.width.pxValue}},i.diamond={_points:[-.14,-.14,0,-.28,.14,-.14,0,0],collide:function(t,r,n,a,o,s,l,c){var u=i.diamond._points;return e.math.pointInsidePolygon(t,r,u,n,a,o,s,l,c)},roughCollide:n,draw:function(e){e.lineTo(-.14,-.14),e.lineTo(0,-.28),e.lineTo(.14,-.14),e.lineTo(0,0)},spacing:function(){return 0},gap:function(e){return 2*e._private.style.width.pxValue}}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.getCachedNodes=function(){var e=this.data,t=this.data.cy;return void 0==e.cache&&(e.cache={}),void 0==e.cache.cachedNodes&&(e.cache.cachedNodes=t.nodes()),e.cache.cachedNodes},t.prototype.updateNodesCache=function(){var e=this.data,t=this.data.cy;void 0==e.cache&&(e.cache={}),e.cache.cachedNodes=t.nodes()},t.prototype.getCachedEdges=function(){var e=this.data,t=this.data.cy;return void 0==e.cache&&(e.cache={}),void 0==e.cache.cachedEdges&&(e.cache.cachedEdges=t.edges()),e.cache.cachedEdges},t.prototype.updateEdgesCache=function(){var e=this.data,t=this.data.cy;void 0==e.cache&&(e.cache={}),e.cache.cachedEdges=t.edges()}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.projectIntoViewport=function(e,t){var r=(this.data.container,this.findContainerPageCoords()),i=r[0],n=r[1],a=e-i,o=t-n;return a-=this.data.cy.pan().x,o-=this.data.cy.pan().y,a/=this.data.cy.zoom(),o/=this.data.cy.zoom(),[a,o]},t.prototype.findContainerPageCoords=function(){for(var e=0,t=0,r=this.data.container,i=r;null!=i;){var n=window.getComputedStyle(i);if("number"==typeof i.offsetLeft){var a=n.getPropertyValue("position").toLowerCase(),o=parseFloat(n.getPropertyValue("border-left-width")),s=parseFloat(n.getPropertyValue("border-top-width"));if(e+=i.offsetLeft,t+=i.offsetTop,("static"!==a||i===r)&&(e+=o,t+=s),"fixed"===a){e+=window.scrollX,t+=window.scrollY;break}if(i==document.body||i==document.header)break}i&&(i=i.offsetParent)}return[e,t]},t.prototype.findNearestElement=function(r,i,n){for(var a=this.data,o=this.getCachedNodes(),s=this.getCachedEdges(),l=[],c=t.isTouch,u=this.data.cy.zoom(),p=(c?256:32)/u,d=(c?16:0)/u,h=0;h<o.length;h++)t.nodeShapes[this.getNodeShape(o[h])].checkPointRough(r,i,o[h]._private.style["border-width"].pxValue/2,this.getNodeWidth(o[h])+d,this.getNodeHeight(o[h])+d,o[h]._private.position.x,o[h]._private.position.y)&&t.nodeShapes[this.getNodeShape(o[h])].checkPoint(r,i,o[h]._private.style["border-width"].pxValue/2,this.getNodeWidth(o[h])+d,this.getNodeHeight(o[h])+d,o[h]._private.position.x,o[h]._private.position.y)&&(n?0!=o[h]._private.style.opacity.value&&"visible"==o[h]._private.style.visibility.value&&"element"==o[h]._private.style.display.value&&l.push(o[h]):l.push(o[h]));for(var g,h=0;h<s.length;h++){var v=s[h],f=v._private.rscratch;if(g=!1,"self"==f.edgeType)(e.math.inBezierVicinity(r,i,f.startX,f.startY,f.cp2ax,f.cp2ay,f.selfEdgeMidX,f.selfEdgeMidY,Math.pow(v._private.style.width.pxValue/2,2))&&Math.pow(s[h]._private.style.width.pxValue/2,2)+p>e.math.sqDistanceToQuadraticBezier(r,i,f.startX,f.startY,f.cp2ax,f.cp2ay,f.selfEdgeMidX,f.selfEdgeMidY)||e.math.inBezierVicinity(r,i,f.selfEdgeMidX,f.selfEdgeMidY,f.cp2cx,f.cp2cy,f.endX,f.endY,Math.pow(s[h]._private.style.width.pxValue/2,2))&&Math.pow(s[h]._private.style.width.pxValue/2,2)+p>e.math.sqDistanceToQuadraticBezier(r,i,f.selfEdgeMidX,f.selfEdgeMidY,f.cp2cx,f.cp2cy,f.endX,f.endY))&&(g=!0);else if("haystack"==f.edgeType){var y=s[h].target()[0],m=y.position(),b=s[h].source()[0],x=b.position(),w=x.x+f.source.x,_=x.y+f.source.y,E=m.x+f.target.x,S=m.y+f.target.y;e.math.inLineVicinity(r,i,w,_,E,S,2*s[h]._private.style.width.pxValue)&&Math.pow(s[h]._private.style.width.pxValue/2,2)+p>e.math.sqDistanceToFiniteLine(r,i,w,_,E,S)&&(g=!0)}else"straight"==f.edgeType?e.math.inLineVicinity(r,i,f.startX,f.startY,f.endX,f.endY,2*s[h]._private.style.width.pxValue)&&Math.pow(s[h]._private.style.width.pxValue/2,2)+p>e.math.sqDistanceToFiniteLine(r,i,f.startX,f.startY,f.endX,f.endY)&&(g=!0):"bezier"==f.edgeType&&e.math.inBezierVicinity(r,i,f.startX,f.startY,f.cp2x,f.cp2y,f.endX,f.endY,Math.pow(s[h]._private.style.width.pxValue/2,2))&&Math.pow(s[h]._private.style.width.pxValue/2,2)+p>e.math.sqDistanceToQuadraticBezier(r,i,f.startX,f.startY,f.cp2x,f.cp2y,f.endX,f.endY)&&(g=!0);if(l.length&&l[l.length-1]==s[h]||(t.arrowShapes[s[h]._private.style["source-arrow-shape"].value].roughCollide(r,i,s[h]._private.rscratch.arrowStartX,s[h]._private.rscratch.arrowStartY,this.getArrowWidth(s[h]._private.style.width.pxValue),this.getArrowHeight(s[h]._private.style.width.pxValue),[s[h]._private.rscratch.arrowStartX-s[h].source()[0]._private.position.x,s[h]._private.rscratch.arrowStartY-s[h].source()[0]._private.position.y],0)&&t.arrowShapes[s[h]._private.style["source-arrow-shape"].value].collide(r,i,s[h]._private.rscratch.arrowStartX,s[h]._private.rscratch.arrowStartY,this.getArrowWidth(s[h]._private.style.width.pxValue),this.getArrowHeight(s[h]._private.style.width.pxValue),[s[h]._private.rscratch.arrowStartX-s[h].source()[0]._private.position.x,s[h]._private.rscratch.arrowStartY-s[h].source()[0]._private.position.y],0)||t.arrowShapes[s[h]._private.style["target-arrow-shape"].value].roughCollide(r,i,s[h]._private.rscratch.arrowEndX,s[h]._private.rscratch.arrowEndY,this.getArrowWidth(s[h]._private.style.width.pxValue),this.getArrowHeight(s[h]._private.style.width.pxValue),[s[h]._private.rscratch.arrowEndX-s[h].target()[0]._private.position.x,s[h]._private.rscratch.arrowEndY-s[h].target()[0]._private.position.y],0)&&t.arrowShapes[s[h]._private.style["target-arrow-shape"].value].collide(r,i,s[h]._private.rscratch.arrowEndX,s[h]._private.rscratch.arrowEndY,this.getArrowWidth(s[h]._private.style.width.pxValue),this.getArrowHeight(s[h]._private.style.width.pxValue),[s[h]._private.rscratch.arrowEndX-s[h].target()[0]._private.position.x,s[h]._private.rscratch.arrowEndY-s[h].target()[0]._private.position.y],0))&&(g=!0),g)if(n){var P=a.cy.getElementById(s[h]._private.data.source),k=a.cy.getElementById(s[h]._private.data.target);0!=s[h]._private.style.opacity.value&&"visible"==s[h]._private.style.visibility.value&&"element"==s[h]._private.style.display.value&&0!=P._private.style.opacity.value&&"visible"==P._private.style.visibility.value&&"element"==P._private.style.display.value&&0!=k._private.style.opacity.value&&"visible"==k._private.style.visibility.value&&"element"==k._private.style.display.value&&l.push(s[h])}else l.push(s[h])}return l.sort(this.zOrderSort),l.length>0?l[l.length-1]:null},t.prototype.getAllInBox=function(r,i,n,a){var o=(this.data,this.getCachedNodes()),s=this.getCachedEdges(),l=[],c=Math.min(r,n),u=Math.max(r,n),p=Math.min(i,a),d=Math.max(i,a);r=c,n=u,i=p,a=d;for(var h,g=0;g<o.length;g++){var v=o[g]._private.position,f=this.getNodeShape(o[g]),y=this.getNodeWidth(o[g]),m=this.getNodeHeight(o[g]),b=o[g]._private.style["border-width"].pxValue/2,x=t.nodeShapes[f];x.intersectBox(r,i,n,a,y,m,v.x,v.y,b)&&l.push(o[g])}for(var g=0;g<s.length;g++){var w=s[g]._private.rscratch;if("self"==s[g]._private.rscratch.edgeType&&((h=e.math.boxInBezierVicinity(r,i,n,a,w.startX,w.startY,w.cp2ax,w.cp2ay,w.endX,w.endY,s[g]._private.style.width.pxValue))&&(2==h||1==h&&e.math.checkBezierInBox(r,i,n,a,w.startX,w.startY,w.cp2ax,w.cp2ay,w.endX,w.endY,s[g]._private.style.width.pxValue))||(h=e.math.boxInBezierVicinity(r,i,n,a,w.startX,w.startY,w.cp2cx,w.cp2cy,w.endX,w.endY,s[g]._private.style.width.pxValue))&&(2==h||1==h&&e.math.checkBezierInBox(r,i,n,a,w.startX,w.startY,w.cp2cx,w.cp2cy,w.endX,w.endY,s[g]._private.style.width.pxValue)))&&l.push(s[g]),"bezier"==w.edgeType&&(h=e.math.boxInBezierVicinity(r,i,n,a,w.startX,w.startY,w.cp2x,w.cp2y,w.endX,w.endY,s[g]._private.style.width.pxValue))&&(2==h||1==h&&e.math.checkBezierInBox(r,i,n,a,w.startX,w.startY,w.cp2x,w.cp2y,w.endX,w.endY,s[g]._private.style.width.pxValue))&&l.push(s[g]),"straight"==w.edgeType&&(h=e.math.boxInBezierVicinity(r,i,n,a,w.startX,w.startY,.5*w.startX+.5*w.endX,.5*w.startY+.5*w.endY,w.endX,w.endY,s[g]._private.style.width.pxValue))&&(2==h||1==h&&e.math.checkStraightEdgeInBox(r,i,n,a,w.startX,w.startY,w.endX,w.endY,s[g]._private.style.width.pxValue))&&l.push(s[g]),"haystack"==w.edgeType){var _=s[g].target()[0],E=_.position(),S=s[g].source()[0],P=S.position(),k=P.x+w.source.x,M=P.y+w.source.y,N=E.x+w.target.x,C=E.y+w.target.y,D=k>=r&&n>=k&&M>=i&&a>=M,T=N>=r&&n>=N&&C>=i&&a>=C;D&&T&&l.push(s[g])}}return l},t.prototype.getNodeWidth=function(e){return e.width()},t.prototype.getNodeHeight=function(e){return e.height()},t.prototype.getNodeShape=function(e){var t=e._private.style.shape.value;return e.isParent()?"rectangle"===t||"roundrectangle"===t?t:"rectangle":t},t.prototype.getNodePadding=function(e){var t=e._private.style["padding-left"].pxValue,r=e._private.style["padding-right"].pxValue,i=e._private.style["padding-top"].pxValue,n=e._private.style["padding-bottom"].pxValue;return isNaN(t)&&(t=0),isNaN(r)&&(r=0),isNaN(i)&&(i=0),isNaN(n)&&(n=0),{left:t,right:r,top:i,bottom:n}},t.prototype.zOrderSort=e.Collection.zIndexSort,t.prototype.updateCachedZSortedEles=function(){this.getCachedZSortedEles(!0)},t.prototype.getCachedZSortedEles=function(e){var t=this.lastZOrderCachedNodes,r=this.lastZOrderCachedEdges,i=this.getCachedNodes(),n=this.getCachedEdges(),a=[];if(!e&&t&&r&&t===i&&r===n)a=this.cachedZSortedEles;else{for(var o=0;o<i.length;o++)a.push(i[o]);for(var o=0;o<n.length;o++)a.push(n[o]);a.sort(this.zOrderSort),this.cachedZSortedEles=a}return this.lastZOrderCachedNodes=i,this.lastZOrderCachedEdges=n,a},t.prototype.projectBezier=function(t){function r(e){a.push({x:i(e[0],e[2],e[4],.05),y:i(e[1],e[3],e[5],.05)}),a.push({x:i(e[0],e[2],e[4],.25),y:i(e[1],e[3],e[5],.25)}),a.push({x:i(e[0],e[2],e[4],.4),y:i(e[1],e[3],e[5],.4)}),a.push({x:i(e[0],e[2],e[4],.5),y:i(e[1],e[3],e[5],.5)}),a.push({x:i(e[0],e[2],e[4],.6),y:i(e[1],e[3],e[5],.6)}),a.push({x:i(e[0],e[2],e[4],.75),y:i(e[1],e[3],e[5],.75)}),a.push({x:i(e[0],e[2],e[4],.95),y:i(e[1],e[3],e[5],.95)})
}var i=e.math.qbezierAt,n=t._private.rscratch,a=t._private.rstyle.bezierPts=[];"self"===n.edgeType?(r([n.startX,n.startY,n.cp2ax,n.cp2ay,n.selfEdgeMidX,n.selfEdgeMidY]),r([n.selfEdgeMidX,n.selfEdgeMidY,n.cp2cx,n.cp2cy,n.endX,n.endY])):"bezier"===n.edgeType&&r([n.startX,n.startY,n.cp2x,n.cp2y,n.endX,n.endY])},t.prototype.recalculateNodeLabelProjection=function(e){var t=e._private.style.content.strValue;if(t&&!t.match(/^\s+$/)){var r,i,n=e.outerWidth(),a=e.outerHeight(),o=e._private.position,s=e._private.style["text-halign"].strValue,l=e._private.style["text-valign"].strValue,c=e._private.rscratch,u=e._private.rstyle;switch(s){case"left":r=o.x-n/2;break;case"right":r=o.x+n/2;break;case"center":default:r=o.x}switch(l){case"top":i=o.y-a/2;break;case"bottom":i=o.y+a/2;break;case"middle":default:i=o.y}c.labelX=r,c.labelY=i,u.labelX=r,u.labelY=i,this.applyLabelDimensions(e)}},t.prototype.recalculateEdgeLabelProjection=function(t){var r=t._private.style.content.strValue;if(r&&!r.match(/^\s+$/)){var i,n,a,o,s=t._private.rscratch,l=t._private.rstyle;if("self"==s.edgeType)a=s.selfEdgeMidX,o=s.selfEdgeMidY;else if("straight"==s.edgeType)a=(s.startX+s.endX)/2,o=(s.startY+s.endY)/2;else if("bezier"==s.edgeType)a=e.math.qbezierAt(s.startX,s.cp2x,s.endX,.5),o=e.math.qbezierAt(s.startY,s.cp2y,s.endY,.5);else if("haystack"==s.edgeType){var c=t.source().position(),u=t.target().position();a=(c.x+s.source.x+u.x+s.target.x)/2,o=(c.y+s.source.y+u.y+s.target.y)/2}i=a,n=o,s.labelX=i,s.labelY=n,l.labelX=i,l.labelY=n,this.applyLabelDimensions(t)}},t.prototype.applyLabelDimensions=function(e){var t=e._private.rscratch,r=e._private.rstyle,i=this.getLabelText(e),n=this.calculateLabelDimensions(e,i);r.labelWidth=n.width,t.labelWidth=n.width,r.labelHeight=n.height,t.labelHeight=n.height},t.prototype.getLabelText=function(e){var t=e._private.style,r=e._private.style.content.strValue,i=t["text-transform"].value;return"none"==i||("uppercase"==i?r=r.toUpperCase():"lowercase"==i&&(r=r.toLowerCase())),r},t.prototype.calculateLabelDimensions=function(e,t){var r=e._private.style,i=r["font-style"].strValue,n=r["font-size"].pxValue+"px",a=r["font-family"].strValue,o=r["font-variant"].strValue,s=r["font-weight"].strValue,l=e._private.rscratch,c=[i,n,a,o,s].join("$$$"),u=l.labelDimCache||(l.labelDimCache={});if(u[c])return u[c];var p=this.labelCalcDiv;p||(p=this.labelCalcDiv=document.createElement("div"),document.body.appendChild(p));var d=p.style;return d.fontFamily=a,d.fontStyle=i,d.fontSize=n,d.fontVariant=o,d.fontWeight=s,d.position="absolute",d.left="-9999px",d.top="-9999px",d.zIndex="-1",d.visibility="hidden",d.padding="0",d.lineHeight="1",p.innerText=t,u[c]={width:p.clientWidth,height:p.clientHeight}},t.prototype.recalculateRenderedStyle=function(){this.recalculateEdgeProjections(),this.recalculateLabelProjections()},t.prototype.recalculateLabelProjections=function(){for(var e=this.getCachedNodes(),t=0;t<e.length;t++)this.recalculateNodeLabelProjection(e[t]);for(var r=this.getCachedEdges(),t=0;t<r.length;t++)this.recalculateEdgeLabelProjection(r[t])},t.prototype.recalculateEdgeProjections=function(){var e=this.getCachedEdges();this.findEdgeControlPoints(e)},t.prototype.findEdgeControlPoints=function(r){for(var i,n={},a=this.data.cy,o=[],s=[],l=0;l<r.length;l++){var c=r[l],u=c._private.style;if("none"!==u.display.value)if("haystack"!==u["curve-style"].value){var p=c._private.data.source,d=c._private.data.target;i=p>d?d+"-"+p:p+"-"+d,void 0==n[i]&&(n[i]=[]),n[i].push(c),o.push(i)}else s.push(c)}for(var h,g,v,f,y,m,b,x,w,_,E,S,P,k,M=0;M<o.length;M++){if(i=o[M],h=a.getElementById(n[i][0]._private.data.source),g=a.getElementById(n[i][0]._private.data.target),v=h._private.position,f=g._private.position,y=this.getNodeWidth(h),m=this.getNodeHeight(h),b=this.getNodeWidth(g),x=this.getNodeHeight(g),w=t.nodeShapes[this.getNodeShape(h)],_=t.nodeShapes[this.getNodeShape(g)],E=h._private.style["border-width"].pxValue,S=g._private.style["border-width"].pxValue,k=!1,n[i].length>1&&h!==g){var N=w.intersectLine(v.x,v.y,y,m,f.x,f.y,E/2),C=_.intersectLine(f.x,f.y,b,x,v.x,v.y,S/2),D=({x:(N[0]+C[0])/2,y:(N[1]+C[1])/2},{x1:N[0],x2:C[0],y1:N[1],y2:C[1]}),T=C[1]-N[1],I=C[0]-N[0],z=Math.sqrt(I*I+T*T),B={x:I,y:T},R={x:B.x/z,y:B.y/z};P={x:-R.y,y:R.x},(_.checkPoint(N[0],N[1],S/2,b,x,f.x,f.y)||w.checkPoint(C[0],C[1],E/2,y,m,v.x,v.y))&&(P={},k=!0)}for(var c,X,l=0;l<n[i].length;l++){c=n[i][l],X=c._private.rscratch;var Y=X.lastEdgeIndex,V=l,L=X.lastNumEdges,A=n[i].length,O=X.lastSrcCtlPtX,F=v.x,q=X.lastSrcCtlPtY,j=v.y,H=X.lastSrcCtlPtW,W=h.outerWidth(),Z=X.lastSrcCtlPtH,$=h.outerHeight(),G=X.lastTgtCtlPtX,U=f.x,K=X.lastTgtCtlPtY,J=f.y,Q=X.lastTgtCtlPtW,et=g.outerWidth(),tt=X.lastTgtCtlPtH,rt=g.outerHeight();if(X.badBezier=k?!0:!1,O!==F||q!==j||H!==W||Z!==$||G!==U||K!==J||Q!==et||tt!==rt||Y!==V||L!==A){X.lastSrcCtlPtX=F,X.lastSrcCtlPtY=j,X.lastSrcCtlPtW=W,X.lastSrcCtlPtH=$,X.lastTgtCtlPtX=U,X.lastTgtCtlPtY=J,X.lastTgtCtlPtW=et,X.lastTgtCtlPtH=rt,X.lastEdgeIndex=V,X.lastNumEdges=A;var it=c._private.style,nt=it["control-point-step-size"].pxValue,at=void 0!==it["control-point-distance"]?it["control-point-distance"].pxValue:void 0,ot=it["control-point-weight"].value;if(h.id()==g.id())X.edgeType="self",X.cp2ax=v.x,X.cp2ay=v.y-(1+Math.pow(m,1.12)/100)*nt*(l/3+1),X.cp2cx=h._private.position.x-(1+Math.pow(y,1.12)/100)*nt*(l/3+1),X.cp2cy=v.y,X.selfEdgeMidX=(X.cp2ax+X.cp2cx)/2,X.selfEdgeMidY=(X.cp2ay+X.cp2cy)/2;else if(n[i].length%2==1&&l==Math.floor(n[i].length/2))X.edgeType="straight";else{var st=(.5-n[i].length/2+l)*nt,lt=void 0!==at?e.math.signum(st)*at:void 0,ct=void 0!==lt?lt:st,ut={x:D.x1*(1-ot)+D.x2*ot,y:D.y1*(1-ot)+D.y2*ot};X.edgeType="bezier",X.cp2x=ut.x+P.x*ct,X.cp2y=ut.y+P.y*ct}this.findEndpoints(c);var pt=!e.is.number(X.startX)||!e.is.number(X.startY),dt=!e.is.number(X.arrowStartX)||!e.is.number(X.arrowStartY),ht=!e.is.number(X.endX)||!e.is.number(X.endY),gt=!e.is.number(X.arrowEndX)||!e.is.number(X.arrowEndY),vt=3,ft=this.getArrowWidth(c._private.style.width.pxValue)*t.arrowShapeHeight,yt=vt*ft,mt=e.math.distance({x:X.cp2x,y:X.cp2y},{x:X.startX,y:X.startY}),bt=yt>mt,xt=e.math.distance({x:X.cp2x,y:X.cp2y},{x:X.endX,y:X.endY}),wt=yt>xt;if("bezier"===X.edgeType){var _t=!1;if(pt||dt||bt){_t=!0;var Et={x:X.cp2x-v.x,y:X.cp2y-v.y},St=Math.sqrt(Et.x*Et.x+Et.y*Et.y),Pt={x:Et.x/St,y:Et.y/St},kt=Math.max(y,m),Mt={x:X.cp2x+2*Pt.x*kt,y:X.cp2y+2*Pt.y*kt},Nt=w.intersectLine(v.x,v.y,y,m,Mt.x,Mt.y,E/2);bt?(X.cp2x=X.cp2x+Pt.x*(yt-mt),X.cp2y=X.cp2y+Pt.y*(yt-mt)):(X.cp2x=Nt[0]+Pt.x*yt,X.cp2y=Nt[1]+Pt.y*yt)}if(ht||gt||wt){_t=!0;var Et={x:X.cp2x-f.x,y:X.cp2y-f.y},St=Math.sqrt(Et.x*Et.x+Et.y*Et.y),Pt={x:Et.x/St,y:Et.y/St},kt=Math.max(y,m),Mt={x:X.cp2x+2*Pt.x*kt,y:X.cp2y+2*Pt.y*kt},Ct=_.intersectLine(f.x,f.y,b,x,Mt.x,Mt.y,S/2);wt?(X.cp2x=X.cp2x+Pt.x*(yt-xt),X.cp2y=X.cp2y+Pt.y*(yt-xt)):(X.cp2x=Ct[0]+Pt.x*yt,X.cp2y=Ct[1]+Pt.y*yt)}_t&&this.findEndpoints(c)}this.projectBezier(c)}}}for(var l=0;l<s.length;l++){var c=s[l],Dt=c._private.rscratch,Tt=.8;if(!Dt.haystack){var h=c.source()[0],v=h.position(),y=h.width(),m=h.height(),It=Math.min(y,m)*Tt*.5,zt=2*Math.random()*Math.PI;Dt.source={x:Math.round(It*Math.cos(zt)),y:Math.round(It*Math.sin(zt))};var g=c.target()[0],f=g.position(),b=g.width(),x=g.height(),Bt=Math.min(b,x)*Tt*.5,zt=2*Math.random()*Math.PI;Dt.target={x:Math.round(Bt*Math.cos(zt)),y:Math.round(Bt*Math.sin(zt))},Dt.edgeType="haystack",Dt.haystack=!0}}return n},t.prototype.findEndpoints=function(r){var i,n=r.source()[0],a=r.target()[0],o=(n._private.position,a._private.position,r._private.style["target-arrow-shape"].value),s=r._private.style["source-arrow-shape"].value,l=a._private.style["border-width"].pxValue,c=n._private.style["border-width"].pxValue,u=r._private.rscratch;if("self"==r._private.rscratch.edgeType){var p=[u.cp2cx,u.cp2cy];i=t.nodeShapes[this.getNodeShape(a)].intersectLine(a._private.position.x,a._private.position.y,this.getNodeWidth(a),this.getNodeHeight(a),p[0],p[1],l/2);var d=e.math.shortenIntersection(i,p,t.arrowShapes[o].spacing(r)),h=e.math.shortenIntersection(i,p,t.arrowShapes[o].gap(r));u.endX=h[0],u.endY=h[1],u.arrowEndX=d[0],u.arrowEndY=d[1];var p=[u.cp2ax,u.cp2ay];i=t.nodeShapes[this.getNodeShape(n)].intersectLine(n._private.position.x,n._private.position.y,this.getNodeWidth(n),this.getNodeHeight(n),p[0],p[1],c/2);var g=e.math.shortenIntersection(i,p,t.arrowShapes[s].spacing(r)),v=e.math.shortenIntersection(i,p,t.arrowShapes[s].gap(r));u.startX=v[0],u.startY=v[1],u.arrowStartX=g[0],u.arrowStartY=g[1]}else if("straight"==u.edgeType){i=t.nodeShapes[this.getNodeShape(a)].intersectLine(a._private.position.x,a._private.position.y,this.getNodeWidth(a),this.getNodeHeight(a),n.position().x,n.position().y,l/2),u.noArrowPlacement=0==i.length?!0:!1;var d=e.math.shortenIntersection(i,[n.position().x,n.position().y],t.arrowShapes[o].spacing(r)),h=e.math.shortenIntersection(i,[n.position().x,n.position().y],t.arrowShapes[o].gap(r));u.endX=h[0],u.endY=h[1],u.arrowEndX=d[0],u.arrowEndY=d[1],i=t.nodeShapes[this.getNodeShape(n)].intersectLine(n._private.position.x,n._private.position.y,this.getNodeWidth(n),this.getNodeHeight(n),a.position().x,a.position().y,c/2),u.noArrowPlacement=0==i.length?!0:!1;var g=e.math.shortenIntersection(i,[a.position().x,a.position().y],t.arrowShapes[s].spacing(r)),v=e.math.shortenIntersection(i,[a.position().x,a.position().y],t.arrowShapes[s].gap(r));u.startX=v[0],u.startY=v[1],u.arrowStartX=g[0],u.arrowStartY=g[1]}else if("bezier"==u.edgeType){var p=[u.cp2x,u.cp2y];i=t.nodeShapes[this.getNodeShape(a)].intersectLine(a._private.position.x,a._private.position.y,this.getNodeWidth(a),this.getNodeHeight(a),p[0],p[1],l/2);var d=e.math.shortenIntersection(i,p,t.arrowShapes[o].spacing(r)),h=e.math.shortenIntersection(i,p,t.arrowShapes[o].gap(r));u.endX=h[0],u.endY=h[1],u.arrowEndX=d[0],u.arrowEndY=d[1],i=t.nodeShapes[this.getNodeShape(n)].intersectLine(n._private.position.x,n._private.position.y,this.getNodeWidth(n),this.getNodeHeight(n),p[0],p[1],c/2);var g=e.math.shortenIntersection(i,p,t.arrowShapes[s].spacing(r)),v=e.math.shortenIntersection(i,p,t.arrowShapes[s].gap(r));u.startX=v[0],u.startY=v[1],u.arrowStartX=g[0],u.arrowStartY=g[1]}else if(u.isArcEdge)return},t.prototype.findEdges=function(e){for(var t=this.getCachedEdges(),r={},i=[],n=0;n<e.length;n++)r[e[n]._private.data.id]=e[n];for(var n=0;n<t.length;n++)(r[t[n]._private.data.source]||r[t[n]._private.data.target])&&i.push(t[n]);return i},t.prototype.getArrowWidth=function(e){return Math.max(Math.pow(13.37*e,.9),29)},t.prototype.getArrowHeight=function(e){return Math.max(Math.pow(13.37*e,.9),29)}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.drawEdge=function(e,t,r){if(t.visible()){var i=t._private.rscratch;if(!i.badBezier){var n,a,o,s;o=n=t.source()[0],s=a=t.target()[0];var l=s.position(),c=o.position();if("visible"==t._private.style.visibility.value&&"element"==t._private.style.display.value&&"visible"==n._private.style.visibility.value&&"element"==n._private.style.display.value&&"visible"==a._private.style.visibility.value&&"element"==a._private.style.display.value){var u=t._private.style["overlay-padding"].pxValue,p=t._private.style["overlay-opacity"].value,d=t._private.style["overlay-color"].value;if(r?(e.strokeStyle="rgba( "+d[0]+", "+d[1]+", "+d[2]+", "+p+" )",e.lineCap="round","self"==t._private.rscratch.edgeType&&(e.lineCap="butt")):(e.strokeStyle="rgba("+t._private.style["line-color"].value[0]+","+t._private.style["line-color"].value[1]+","+t._private.style["line-color"].value[2]+","+t._private.style.opacity.value+")",e.lineCap="butt"),!(t._private.style.width.pxValue<=0)){var h=t._private.style.width.pxValue+(r?2*u:0),g=r?"solid":t._private.style["line-style"].value;if(e.lineWidth=h,this.findEndpoints(t),"haystack"==i.edgeType)this.drawStyledEdge(t,e,[i.source.x+c.x,i.source.y+c.y,i.target.x+l.x,i.target.y+l.y],g,h);else if("self"==i.edgeType){var v=t._private.rscratch;this.drawStyledEdge(t,e,[v.startX,v.startY,v.cp2ax,v.cp2ay,v.selfEdgeMidX,v.selfEdgeMidY],g,h),this.drawStyledEdge(t,e,[v.selfEdgeMidX,v.selfEdgeMidY,v.cp2cx,v.cp2cy,v.endX,v.endY],g,h)}else if("straight"==i.edgeType){var f=a._private.position.x-n._private.position.x,y=a._private.position.y-n._private.position.y,m=t._private.rscratch.endX-t._private.rscratch.startX,b=t._private.rscratch.endY-t._private.rscratch.startY;if(0>f*m+y*b)t._private.rscratch.straightEdgeTooShort=!0;else{var v=t._private.rscratch;this.drawStyledEdge(t,e,[v.startX,v.startY,v.endX,v.endY],g,h),t._private.rscratch.straightEdgeTooShort=!1}}else{var v=t._private.rscratch;this.drawStyledEdge(t,e,[v.startX,v.startY,v.cp2x,v.cp2y,v.endX,v.endY],g,h)}t._private.rscratch.noArrowPlacement!==!0&&void 0!==t._private.rscratch.startX&&this.drawArrowheads(e,t,r)}}}}};var r=function(e,t){var r=Math.sqrt(Math.pow(e[4]-e[0],2)+Math.pow(e[5]-e[1],2));r+=Math.sqrt(Math.pow((e[4]+e[0])/2-e[2],2)+Math.pow((e[5]+e[1])/2-e[3],2));var i,n=Math.ceil(r/t);if(!(n>0))return null;i=new Array(2*n);for(var a=0;n>a;a++){var o=a/n;i[2*a]=e[0]*(1-o)*(1-o)+2*e[2]*(1-o)*o+e[4]*o*o,i[2*a+1]=e[1]*(1-o)*(1-o)+2*e[3]*(1-o)*o+e[5]*o*o}return i},i=function(e,t){var r,i=Math.sqrt(Math.pow(e[2]-e[0],2)+Math.pow(e[3]-e[1],2)),n=Math.ceil(i/t);if(!(n>0))return null;r=new Array(2*n);for(var a=[e[2]-e[0],e[3]-e[1]],o=0;n>o;o++){var s=o/n;r[2*o]=a[0]*s+e[0],r[2*o+1]=a[1]*s+e[1]}return r};t.prototype.drawStyledEdge=function(e,t,n,a,o){var s=this.data.cy,l=s.zoom();if("solid"==a)t.beginPath(),t.moveTo(n[0],n[1]),6==n.length?t.quadraticCurveTo(n[2],n[3],n[4],n[5]):t.lineTo(n[2],n[3]),t.stroke();else if("dotted"==a){var c;if(c=6==n.length?r(n,16,!0):i(n,16,!0),!c)return;var u=Math.max(1.6*o,3.4)*l,p=2*u,d=2*u;p=Math.max(p,1),d=Math.max(d,1);var h=this.createBuffer(p,d),g=h[1];g.setTransform(1,0,0,1,0,0),g.clearRect(0,0,p,d),g.fillStyle=t.strokeStyle,g.beginPath(),g.arc(p/2,d/2,.5*u,0,2*Math.PI,!1),g.fill(),t.beginPath();for(var v=0;v<c.length/2;v++)t.drawImage(h[0],c[2*v]-p/2/l,c[2*v+1]-d/2/l,p/l,d/l)}else if("dashed"==a){var c;if(c=6==n.length?r(n,14,!0):i(n,14,!0),!c)return;var p=2*o*l,d=7.8*l;p=Math.max(p,1),d=Math.max(d,1);var h=this.createBuffer(p,d),g=h[1];g.setTransform(1,0,0,1,0,0),g.clearRect(0,0,p,d),t.strokeStyle&&(g.strokeStyle=t.strokeStyle),g.lineWidth=o*s.zoom(),g.beginPath(),g.moveTo(p/2,.2*d),g.lineTo(p/2,.8*d),g.stroke();var f,y,m=!1;4==n.length?(f=[n[2]-n[0],n[3]-c[1]],y=Math.acos((0*f[0]+-1*f[1])/Math.sqrt(f[0]*f[0]+f[1]*f[1])),f[0]<0&&(y=-y+2*Math.PI)):6==n.length&&(m=!0);for(var v=0;v<c.length/2;v++){var b=v/Math.max(c.length/2-1,1);m&&(f=[2*(1-b)*(n[2]-n[0])+2*b*(n[4]-n[2]),2*(1-b)*(n[3]-n[1])+2*b*(n[5]-n[3])],y=Math.acos((0*f[0]+-1*f[1])/Math.sqrt(f[0]*f[0]+f[1]*f[1])),f[0]<0&&(y=-y+2*Math.PI)),t.translate(c[2*v],c[2*v+1]),t.rotate(y),t.translate(-p/2/l,-d/2/l),t.drawImage(h[0],0,0,p/l,d/l),t.translate(p/2/l,d/2/l),t.rotate(-y),t.translate(-c[2*v],-c[2*v+1])}}else this.drawStyledEdge(e,t,n,"solid",o)},t.prototype.drawArrowheads=function(e,t,r){if(!r){var i,n,a=t._private.rscratch.arrowStartX,o=t._private.rscratch.arrowStartY,s=t._private.style,l=t.source().position();if(i=a-l.x,n=o-l.y,!(isNaN(a)||isNaN(o)||isNaN(i)||isNaN(n))){var c=e.globalCompositeOperation;e.globalCompositeOperation="destination-out",e.fillStyle="white",this.drawArrowShape(e,"filled",s["source-arrow-shape"].value,a,o,i,n),e.globalCompositeOperation=c,e.fillStyle="rgba("+s["source-arrow-color"].value[0]+","+s["source-arrow-color"].value[1]+","+s["source-arrow-color"].value[2]+","+s.opacity.value+")",this.drawArrowShape(e,s["source-arrow-fill"].value,s["source-arrow-shape"].value,a,o,i,n)}var u=t._private.rscratch.arrowEndX,p=t._private.rscratch.arrowEndY,d=t.target().position();if(i=u-d.x,n=p-d.y,!(isNaN(u)||isNaN(p)||isNaN(i)||isNaN(n))){var c=e.globalCompositeOperation;e.globalCompositeOperation="destination-out",e.fillStyle="white",this.drawArrowShape(e,"filled",s["target-arrow-shape"].value,u,p,i,n),e.globalCompositeOperation=c,e.fillStyle="rgba("+s["target-arrow-color"].value[0]+","+s["target-arrow-color"].value[1]+","+s["target-arrow-color"].value[2]+","+s.opacity.value+")",this.drawArrowShape(e,s["target-arrow-fill"].value,s["target-arrow-shape"].value,u,p,i,n)}}},t.prototype.drawArrowShape=function(e,r,i,n,a,o,s){var l=Math.asin(s/Math.sqrt(o*o+s*s));0>o?l+=Math.PI/2:l=-(Math.PI/2+l),e.translate(n,a),e.moveTo(0,0),e.rotate(-l);var c=this.getArrowWidth(e.lineWidth);e.scale(c,c),e.beginPath(),t.arrowShapes[i].draw(e),e.closePath(),"hollow"===r?(e.lineWidth=1/c,e.stroke()):e.fill(),e.scale(1/c,1/c),e.rotate(l),e.translate(-n,-a)}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas"),r={};t.prototype.getCachedImage=function(e,t){if(r[e]&&r[e].image)return r[e].image;var i=r[e];return void 0==i&&(r[e]=new Object,r[e].image=new Image,r[e].image.onload=t,r[e].image.src=e,i=r[e]),i.image},t.prototype.swapCachedImage=function(e){if(r[e]){if(r[e].image&&r[e].image.complete){var t=r[e].image,i=document.createElement("canvas");return i.width=t.width,i.height=t.height,i.getContext("2d").drawImage(t,0,0),r[e].image=i,r[e].swappedWithCanvas=!0,i}return null}return null},t.prototype.updateImageCaches=function(){},t.prototype.drawInscribedImage=function(e,r,i){var n=this,a=(this.data.cy._private.zoom,i._private.position.x),o=i._private.position.y,s=i._private.style,l=s["background-fit"].value,c=s["background-position-x"],u=s["background-position-y"],p=s["background-repeat"].value,d=this.getNodeWidth(i),h=this.getNodeHeight(i);e.save(),t.nodeShapes[n.getNodeShape(i)].drawPath(e,a,o,d,h),e.clip();var g=r.width,v=r.height;if("contain"===l){var f=Math.min(d/g,h/v);g*=f,v*=f}else if("cover"===l){var f=Math.max(d/g,h/v);g*=f,v*=f}var y=a-d/2;y+="%"===c.units?(d-g)*c.value/100:c.pxValue;var m=o-h/2;if(m+="%"===u.units?(h-v)*u.value/100:u.pxValue,"repeat-x"===p||"repeat-y"===p||"repeat"===p){var b=e.createPattern(r,p);y=Math.min(y,a+d/2),y=Math.max(y,a-d/2),m=Math.min(m,o+o/2),m=Math.max(m,o-o/2),e.fillStyle=b,e.translate(y,m),"repeat-x"===p?e.fillRect(-d,0,2*d,h):"repeat-y"===p?e.fillRect(0,-h,d,2*h):e.fill()}else e.drawImage(r,y,m,g,v);e.restore()}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.drawEdgeText=function(e,t){var r=t._private.style.content.strValue;if(t.visible()&&r&&!r.match(/^\s+$/)&&(!this.hideEdgesOnViewport||!(this.dragData.didDrag||this.pinching||this.hoverData.dragging||this.data.wheel||this.swipePanning))){var i=t._private.style["font-size"].pxValue*t.cy().zoom(),n=t._private.style["min-zoomed-font-size"].pxValue;if(!(n>i)){e.textAlign="center",e.textBaseline="middle",this.recalculateEdgeLabelProjection(t);var a=t._private.rscratch;this.drawText(e,t,a.labelX,a.labelY)}}},t.prototype.drawNodeText=function(e,t){var r=t._private.style.content.strValue;if(t.visible()&&r&&!r.match(/^\s+$/)){var i=t._private.style["font-size"].pxValue*t.cy().zoom(),n=t._private.style["min-zoomed-font-size"].pxValue;if(!(n>i)){this.recalculateNodeLabelProjection(t);var a=t._private.style["text-halign"].strValue,o=t._private.style["text-valign"].strValue,s=t._private.rscratch;switch(a){case"left":e.textAlign="right";break;case"right":e.textAlign="left";break;case"center":default:e.textAlign="center"}switch(o){case"top":e.textBaseline="bottom";break;case"bottom":e.textBaseline="top";break;case"center":default:e.textBaseline="middle"}this.drawText(e,t,s.labelX,s.labelY)}}},t.prototype.setupTextStyle=function(e,t){var r=t.effectiveOpacity(),i=t._private.style,n=i["font-style"].strValue,a=i["font-size"].pxValue+"px",o=i["font-family"].strValue,s=(i["font-variant"].strValue,i["font-weight"].strValue);e.font=n+" "+s+" "+a+" "+o;var l=String(i.content.value),c=i["text-transform"].value;return"none"==c||("uppercase"==c?l=l.toUpperCase():"lowercase"==c&&(l=l.toLowerCase())),e.lineJoin="round",e.fillStyle="rgba("+i.color.value[0]+","+i.color.value[1]+","+i.color.value[2]+","+i["text-opacity"].value*i.opacity.value*r+")",e.strokeStyle="rgba("+i["text-outline-color"].value[0]+","+i["text-outline-color"].value[1]+","+i["text-outline-color"].value[2]+","+i["text-opacity"].value*i.opacity.value*r+")",l},t.prototype.drawText=function(e,t,r,i){var n=t._private.style,a=t.effectiveOpacity();if(0!==a){var o=this.setupTextStyle(e,t);if(void 0!=o&&!isNaN(r)&&!isNaN(i)){var s=2*n["text-outline-width"].value;s>0&&(e.lineWidth=s,e.strokeText(o,r,i)),e.fillText(""+o,r,i)}}}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.drawNode=function(e,r,i){var n,a,o=r._private.style;if(r.visible()){var s=r.effectiveOpacity();if(0!==s)if(n=this.getNodeWidth(r),a=this.getNodeHeight(r),e.lineWidth=o["border-width"].pxValue,void 0!==i&&i){var l=o["overlay-padding"].pxValue,c=o["overlay-opacity"].value,u=o["overlay-color"].value;c>0&&(e.fillStyle="rgba( "+u[0]+", "+u[1]+", "+u[2]+", "+c+" )",t.nodeShapes.roundrectangle.draw(e,r._private.position.x,r._private.position.y,n+2*l,a+2*l))}else{e.fillStyle="rgba("+o["background-color"].value[0]+","+o["background-color"].value[1]+","+o["background-color"].value[2]+","+o["background-opacity"].value*o.opacity.value*s+")",e.strokeStyle="rgba("+o["border-color"].value[0]+","+o["border-color"].value[1]+","+o["border-color"].value[2]+","+o["border-opacity"].value*o.opacity.value*s+")",e.lineJoin="miter";var p=o["background-image"].value[2]||o["background-image"].value[1];if(t.nodeShapes[this.getNodeShape(r)].draw(e,r._private.position.x,r._private.position.y,n,a),void 0!=p){var d=this,h=this.getCachedImage(p,function(){d.data.canvasNeedsRedraw[t.NODE]=!0,d.data.canvasNeedsRedraw[t.DRAG]=!0,d.swapCachedImage(p),d.redraw()});0==h.complete||this.drawInscribedImage(e,h,r)}this.hasPie(r)&&(this.drawPie(e,r),t.nodeShapes[this.getNodeShape(r)].drawPath(e,r._private.position.x,r._private.position.y,n,a));var g=o["background-blacken"].value;g>0?(e.fillStyle="rgba(0, 0, 0, "+g+")",e.fill()):0>g&&(e.fillStyle="rgba(255, 255, 255, "+Math.abs(g)+")",e.fill()),o["border-width"].pxValue>0&&e.stroke()}}},t.prototype.hasPie=function(t){t=t[0];for(var r=1;r<=e.style.pieBackgroundN;r++){var i=t._private.style["pie-"+r+"-background-size"].value;if(i>0)return!0}return!1},t.prototype.drawPie=function(t,r){if(r=r[0],this.hasPie(r)){var i=r._private.style["pie-size"],n=this.getNodeWidth(r),a=this.getNodeHeight(r),o=r._private.position.x,s=r._private.position.y,l=Math.min(n,a)/2,c=0;"%"===i.units?l=l*i.value/100:void 0!==i.pxValue&&(l=i.pxValue/2);for(var u=1;u<=e.style.pieBackgroundN;u++){{var p=r._private.style["pie-"+u+"-background-size"].value,d=r._private.style["pie-"+u+"-background-color"],h=p/100,g=1.5*Math.PI+2*Math.PI*c,v=2*Math.PI*h,f=g+v;o+l*Math.cos(g),s+l*Math.sin(g)}0===p||c>=1||c+h>1||(t.beginPath(),t.moveTo(o,s),t.arc(o,s,l,g,f),t.closePath(),t.fillStyle="rgb("+d.value[0]+","+d.value[1]+","+d.value[2]+")",t.fill(),c+=h)}t.restore()}}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.getPixelRatio=function(){var e=this.data.canvases[0],t=e.getContext("2d"),r=t.backingStorePixelRatio||t.webkitBackingStorePixelRatio||t.mozBackingStorePixelRatio||t.msBackingStorePixelRatio||t.oBackingStorePixelRatio||t.backingStorePixelRatio||1,i="undefined"!=typeof InstallTrigger;return i?1:(window.devicePixelRatio||1)/r},t.prototype.matchCanvasSize=function(e){var r,i=this.data,n=e.clientWidth,a=e.clientHeight,o=n,s=a,l=this.getPixelRatio();o*=l,s*=l;var c=i.canvasContainer;c.style.width=n+"px",c.style.height=a+"px";for(var u=0;u<t.CANVAS_LAYERS;u++)r=i.canvases[u],(r.width!==o||r.height!==s)&&(r.width=o,r.height=s,r.style.width=n+"px",r.style.height=a+"px");for(var u=0;u<t.BUFFER_COUNT;u++)r=i.bufferCanvases[u],(r.width!==o||r.height!==s)&&(r.width=o,r.height=s)},t.prototype.renderTo=function(e,t,r,i){this.redraw({forcedContext:e,forcedZoom:t,forcedPan:r,drawAllLayers:!0,forcedPxRatio:i})},t.prototype.redraw=function(r){function i(){function e(e){e.setTransform(1,0,0,1,0,0),!n&&e.clearRect(0,0,e.canvas.width,e.canvas.height),a||(e.translate(v.x,v.y),e.scale(h,h)),s&&e.translate(s.x,s.y),o&&e.scale(o,o)}function r(e,t){for(var r=[],i=[],n=0;n<e.length;n++)a=e[n],a.isNode()?i.push(a):a.isEdge()&&!w&&(l.drawEdge(t,a),r.push(a));for(var n=0;n<r.length&&!w;n++)a=r[n],l.drawEdgeText(t,a),l.drawEdge(t,a,!0);for(var n=0;n<i.length;n++){var a=i[n];l.drawNode(t,a),l.drawNodeText(t,a),l.drawNode(t,a,!0)}}var i=(l.getCachedNodes(),l.getCachedEdges());n||l.matchCanvasSize(p.container);var d=u.zoom(),h=void 0!==o?o:d,g=u.pan(),v={x:g.x,y:g.y};s&&(v=s),h*=c,v.x*=c,v.y*=c;var f,y,b,x;if(p.canvasNeedsRedraw[t.DRAG]||p.canvasNeedsRedraw[t.NODE]||a){var w=l.hideEdgesOnViewport&&(l.pinching||l.hoverData.dragging||l.swipePanning||l.data.wheelZooming||l.hoverData.draggingEles);w||l.findEdgeControlPoints(i),f=l.getCachedZSortedEles(),y=[],b=[];for(var _=0;_<f.length;_++)x=f[_],x._private.rscratch.inDragLayer?y.push(x):b.push(x)}if(p.canvasNeedsRedraw[t.NODE]||a){var E=n||p.canvases[t.NODE].getContext("2d");e(E),r(b,E),a||(p.canvasNeedsRedraw[t.NODE]=!1)}if(p.canvasNeedsRedraw[t.DRAG]||a){var E=n||p.canvases[t.DRAG].getContext("2d");e(E),r(y,E),a||(p.canvasNeedsRedraw[t.DRAG]=!1)}if(p.canvasNeedsRedraw[t.SELECT_BOX]&&!a){var E=n||p.canvases[t.SELECT_BOX].getContext("2d");e(E);var S=u.style()._private.coreStyle;if(1==p.select[4]){var d=p.cy.zoom(),P=S["selection-box-border-width"].value/d;E.lineWidth=P,E.fillStyle="rgba("+S["selection-box-color"].value[0]+","+S["selection-box-color"].value[1]+","+S["selection-box-color"].value[2]+","+S["selection-box-opacity"].value+")",E.fillRect(p.select[0],p.select[1],p.select[2]-p.select[0],p.select[3]-p.select[1]),P>0&&(E.strokeStyle="rgba("+S["selection-box-border-color"].value[0]+","+S["selection-box-border-color"].value[1]+","+S["selection-box-border-color"].value[2]+","+S["selection-box-opacity"].value+")",E.strokeRect(p.select[0],p.select[1],p.select[2]-p.select[0],p.select[3]-p.select[1]))}if(p.bgActivePosistion){var d=p.cy.zoom(),k=p.bgActivePosistion;E.fillStyle="rgba("+S["active-bg-color"].value[0]+","+S["active-bg-color"].value[1]+","+S["active-bg-color"].value[2]+","+S["active-bg-opacity"].value+")",E.beginPath(),E.arc(k.x,k.y,S["active-bg-size"].pxValue/d,0,2*Math.PI),E.fill()}a||(p.canvasNeedsRedraw[t.SELECT_BOX]=!1)}var M=+new Date;void 0===l.averageRedrawTime&&(l.averageRedrawTime=M-m),l.averageRedrawTime=l.averageRedrawTime/2+(M-m)/2}r=r||{};var n=r.forcedContext,a=r.drawAllLayers,o=r.forcedZoom,s=r.forcedPan,l=this,c=void 0===r.forcedPxRatio?this.getPixelRatio():r.forcedPxRatio,u=l.data.cy,p=l.data;clearTimeout(this.redrawTimeout),void 0===this.averageRedrawTime&&(this.averageRedrawTime=0);var d=1e3/60,h=1e3,g=this.averageRedrawTime;g=Math.max(d,g),g=Math.min(g,h),void 0===this.lastDrawTime&&(this.lastDrawTime=0);var v=+new Date,f=v-this.lastDrawTime,y=f>=g;if(!n){if(!y)return clearTimeout(this.redrawTimeout),void(this.redrawTimeout=setTimeout(function(){l.redraw()},g));this.lastDrawTime=v}var m=v;n?i():e.util.requestAnimationFrame(i),n||l.initrender||(l.initrender=!0,u.trigger("initrender"))}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.drawPolygonPath=function(e,t,r,i,n,a){e.translate(t,r),e.scale(i/2,n/2),e.beginPath(),e.moveTo(a[0],a[1]);for(var o=1;o<a.length/2;o++)e.lineTo(a[2*o],a[2*o+1]);e.closePath(),e.scale(2/i,2/n),e.translate(-t,-r)},t.prototype.drawPolygon=function(e,t,r,i,n,a){this.drawPolygonPath(e,t,r,i,n,a),e.fill()},t.prototype.drawRoundRectanglePath=function(t,r,i,n,a){var o=n/2,s=a/2,l=e.math.getRoundRectangleRadius(n,a);t.translate(r,i),t.beginPath(),t.moveTo(0,-s),t.arcTo(o,-s,o,0,l),t.arcTo(o,s,0,s,l),t.arcTo(-o,s,-o,0,l),t.arcTo(-o,-s,0,-s,l),t.lineTo(0,-s),t.closePath(),t.translate(-r,-i)},t.prototype.drawRoundRectangle=function(e,t,r,i,n,a){this.drawRoundRectanglePath(e,t,r,i,n,a),e.fill()}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.createBuffer=function(e,t){var r=document.createElement("canvas");return r.width=e,r.height=t,[r,r.getContext("2d")]},t.prototype.png=function(e){var t=this.data,r=t.cy,i=r.boundingBox(),n=e.full?Math.ceil(i.w):this.data.container.clientWidth,a=e.full?Math.ceil(i.h):this.data.container.clientHeight,o=document.createElement("canvas");o.width=n,o.height=a,o.style.width=n+"px",o.style.height=a+"px";var s=o.getContext("2d");return n>0&&a>0&&(s.clearRect(0,0,n,a),e.bg&&(s.fillStyle=e.bg,s.rect(0,0,n,a),s.fill()),s.globalCompositeOperation="source-over",this.redraw(e.full?{forcedContext:s,drawAllLayers:!0,forcedZoom:1,forcedPan:{x:-i.x1,y:-i.y1}}:{forcedContext:s,drawAllLayers:!0})),o.toDataURL("image/png")}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas");t.prototype.registerBinding=function(e,t,r,i){this.bindings.push({target:e,event:t,handler:r,useCapture:i}),e.addEventListener(t,r,i)},t.prototype.load=function(){var r=this,i=function(e,t,r){if(!t)for(var i=e.parents(),n=0;n<i.size();n++)if(i[n]._private.selected)return;for(var a=e.descendants(),n=0;n<a.size();n++)if(t||!a[n]._private.selected){a[n]._private.rscratch.inDragLayer=!0,r.push(a[n]);for(var o=0;o<a[n]._private.edges.length;o++)a[n]._private.edges[o]._private.rscratch.inDragLayer=!0}},n=function(e,t){e._private.grabbed=!0,e._private.rscratch.inDragLayer=!0,t.push(e);for(var r=0;r<e._private.edges.length;r++)e._private.edges[r]._private.rscratch.inDragLayer=!0},a=function(e,t){for(var r=e;r.parent().nonempty();)r=r.parent()[0];if(r!=e||!t)for(var i=r.descendants().add(r),n=0;n<i.size();n++){i[n]._private.rscratch.inDragLayer=t;for(var a=0;a<i[n]._private.edges.length;a++)i[n]._private.edges[a]._private.rscratch.inDragLayer=t}};t.prototype.nodeIsDraggable=function(e){return 0!=e._private.style.opacity.value&&"visible"==e._private.style.visibility.value&&"element"==e._private.style.display.value&&!e._private.locked&&e._private.grabbable?!0:!1},r.registerBinding(window,"resize",function(){r.data.canvasNeedsRedraw[t.NODE]=!0,r.redraw()},!0),r.registerBinding(r.data.container,"contextmenu",function(e){e.preventDefault()});var o=function(){return 0!==r.data.select[4]};r.registerBinding(r.data.container,"mousedown",function(o){o.preventDefault(),r.hoverData.capture=!0,r.hoverData.which=o.which;var s=r.data.cy,l=r.projectIntoViewport(o.pageX,o.pageY),c=r.data.select,u=r.findNearestElement(l[0],l[1],!0),p=(r.hoverData.down,r.dragData.possibleDragElements),d=new e.Event("grab");if(3==o.which)r.hoverData.cxtStarted=!0,u&&(u.activate(),u.trigger(new e.Event(o,{type:"cxttapstart",cyPosition:{x:l[0],y:l[1]}})),r.hoverData.down=u),s.trigger(new e.Event(o,{type:"cxttapstart",cyPosition:{x:l[0],y:l[1]}})),r.hoverData.downTime=(new Date).getTime(),r.hoverData.cxtDragged=!1;else if(1==o.which){if(u&&u.activate(),null!=u&&r.nodeIsDraggable(u)){if("nodes"==u._private.group&&0==u._private.selected&&(p=r.dragData.possibleDragElements=[],n(u,p),u.trigger(d),("auto"==u._private.style.width.value||"auto"==u._private.style.height.value)&&i(u,!0,p),a(u,!0)),"nodes"==u._private.group&&1==u._private.selected){p=r.dragData.possibleDragElements=[];for(var h=!1,g=s.$("node:selected"),v=0;v<g.length;v++)r.nodeIsDraggable(g[v])&&(n(g[v],p),h||(u.trigger(d),h=!0),("auto"==g[v]._private.style.width.value||"auto"==g[v]._private.style.height.value)&&i(g[v],!1,p),a(g[v],!0))}u.trigger(new e.Event(o,{type:"mousedown",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(o,{type:"tapstart",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(o,{type:"vmousedown",cyPosition:{x:l[0],y:l[1]}}))}else null==u&&s.trigger(new e.Event(o,{type:"mousedown",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(o,{type:"tapstart",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(o,{type:"vmousedown",cyPosition:{x:l[0],y:l[1]}}));if(r.hoverData.down=u,r.hoverData.downTime=(new Date).getTime(),null==u||u.isEdge()){c[4]=1;var f=Math.max(0,t.panOrBoxSelectDelay-(+new Date-r.hoverData.downTime));clearTimeout(r.bgActiveTimeout),r.bgActiveTimeout=setTimeout(function(){u&&u.unactivate(),r.data.bgActivePosistion={x:l[0],y:l[1]},r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0,r.redraw()
},f)}}c[0]=c[2]=l[0],c[1]=c[3]=l[1]},!1),r.registerBinding(window,"mousemove",e.util.throttle(function(i){var n=!1,a=r.hoverData.capture;if(!a){var o=r.findContainerPageCoords();if(!(i.pageX>o[0]&&i.pageX<o[0]+r.data.container.clientWidth&&i.pageY>o[1]&&i.pageY<o[1]+r.data.container.clientHeight))return}{var s=r.data.cy,l=r.projectIntoViewport(i.pageX,i.pageY),c=r.data.select,u=r.findNearestElement(l[0],l[1],!0),p=r.hoverData.last,d=r.hoverData.down,h=[l[0]-c[2],l[1]-c[3]],g=(r.getCachedNodes(),r.getCachedEdges(),r.dragData.possibleDragElements);i.shiftKey}if(n=!0,null!=u?u.trigger(new e.Event(i,{type:"mousemove",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"vmousemove",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"tapdrag",cyPosition:{x:l[0],y:l[1]}})):null==u&&s.trigger(new e.Event(i,{type:"mousemove",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"vmousemove",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"tapdrag",cyPosition:{x:l[0],y:l[1]}})),3===r.hoverData.which){var v=new e.Event(i,{type:"cxtdrag",cyPosition:{x:l[0],y:l[1]}});d?d.trigger(v):s.trigger(v),r.hoverData.cxtDragged=!0}else if(r.hoverData.dragging){if(n=!0,s.panningEnabled()&&s.userPanningEnabled()){var f={x:h[0]*s.zoom(),y:h[1]*s.zoom()};s.panBy(f)}l=r.projectIntoViewport(i.pageX,i.pageY)}else if(1==c[4]&&(null==d||d.isEdge())&&(!s.boxSelectionEnabled()||+new Date-r.hoverData.downTime>=t.panOrBoxSelectDelay)&&Math.abs(c[3]-c[1])+Math.abs(c[2]-c[0])<4&&s.panningEnabled()&&s.userPanningEnabled())r.hoverData.dragging=!0,c[4]=0;else{if(s.boxSelectionEnabled()&&Math.pow(c[2]-c[0],2)+Math.pow(c[3]-c[1],2)>7&&c[4]&&(clearTimeout(r.bgActiveTimeout),r.data.bgActivePosistion=void 0,r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0,r.redraw()),d&&d.isEdge()&&d.active()&&d.unactivate(),u!=p&&(p&&p.trigger(new e.Event(i,{type:"mouseout",cyPosition:{x:l[0],y:l[1]}})),u&&u.trigger(new e.Event(i,{type:"mouseover",cyPosition:{x:l[0],y:l[1]}})),r.hoverData.last=u),d&&d.isNode()&&r.nodeIsDraggable(d)){r.dragData.didDrag=!0,r.hoverData.draggingEles=!0;var y=[];new e.Collection(s,g).positions(function(e,t){if(t.isNode()&&r.nodeIsDraggable(t)){var i=t.position();return{x:i.x+h[0],y:i.y+h[1]}}}),new e.Collection(s,y).trigger("drag"),c[2]==c[0]&&c[3]==c[1]&&(r.data.canvasNeedsRedraw[t.NODE]=!0),r.data.canvasNeedsRedraw[t.DRAG]=!0}n=!0}return c[2]=l[0],c[3]=l[1],n?(i.stopPropagation&&i.stopPropagation(),i.preventDefault&&i.preventDefault(),!1):void 0},1e3/30),!1),r.registerBinding(window,"mouseup",function(i){var n=r.hoverData.capture;if(n){r.hoverData.capture=!1;var o=r.data.cy,s=r.projectIntoViewport(i.pageX,i.pageY),l=r.data.select,c=r.findNearestElement(s[0],s[1],!0),u=(r.getCachedNodes(),r.getCachedEdges(),r.dragData.possibleDragElements),p=r.hoverData.down,d=i.shiftKey;if(r.data.bgActivePosistion=void 0,clearTimeout(r.bgActiveTimeout),r.hoverData.cxtStarted=!1,r.hoverData.draggingEles=!1,p&&p.unactivate(),3===r.hoverData.which){var h=new e.Event(i,{type:"cxttapend",cyPosition:{x:s[0],y:s[1]}});if(p?p.trigger(h):o.trigger(h),!r.hoverData.cxtDragged){var g=new e.Event(i,{type:"cxttap",cyPosition:{x:s[0],y:s[1]}});p?p.trigger(g):o.trigger(g)}r.hoverData.cxtDragged=!1,r.hoverData.which=null}else{if(null!=p||r.dragData.didDrag||Math.pow(l[2]-l[0],2)+Math.pow(l[3]-l[1],2)>7&&l[4]||r.hoverData.dragging||(o.$(":selected").unselect(),u.length>0&&(r.data.canvasNeedsRedraw[t.NODE]=!0),r.dragData.possibleDragElements=u=[]),null!=c?c.trigger(new e.Event(i,{type:"mouseup",cyPosition:{x:s[0],y:s[1]}})).trigger(new e.Event(i,{type:"tapend",cyPosition:{x:s[0],y:s[1]}})).trigger(new e.Event(i,{type:"vmouseup",cyPosition:{x:s[0],y:s[1]}})):null==c&&o.trigger(new e.Event(i,{type:"mouseup",cyPosition:{x:s[0],y:s[1]}})).trigger(new e.Event(i,{type:"tapend",cyPosition:{x:s[0],y:s[1]}})).trigger(new e.Event(i,{type:"vmouseup",cyPosition:{x:s[0],y:s[1]}})),Math.pow(l[2]-l[0],2)+Math.pow(l[3]-l[1],2)==0&&(null!=c?c.trigger(new e.Event(i,{type:"click",cyPosition:{x:s[0],y:s[1]}})).trigger(new e.Event(i,{type:"tap",cyPosition:{x:s[0],y:s[1]}})).trigger(new e.Event(i,{type:"vclick",cyPosition:{x:s[0],y:s[1]}})):null==c&&o.trigger(new e.Event(i,{type:"click",cyPosition:{x:s[0],y:s[1]}})).trigger(new e.Event(i,{type:"tap",cyPosition:{x:s[0],y:s[1]}})).trigger(new e.Event(i,{type:"vclick",cyPosition:{x:s[0],y:s[1]}}))),c!=p||r.dragData.didDrag){if(c==p&&null!=c&&c._private.grabbed){for(var v=o.$(":grabbed"),f=0;f<v.length;f++){var y=v[f];y._private.grabbed=!1;for(var m=y._private.edges,b=0;b<m.length;b++)m[b]._private.rscratch.inDragLayer=!1;a(y,!1)}v.trigger("free")}}else null!=c&&c._private.selectable&&("additive"===o.selectionType()||d?c.selected()?c.unselect():c.select():d||(o.$(":selected").not(c).unselect(),c.select()),a(c,!1),r.data.canvasNeedsRedraw[t.NODE]=!0);if(o.boxSelectionEnabled()&&Math.pow(l[2]-l[0],2)+Math.pow(l[3]-l[1],2)>7&&l[4]){var x=[],w=r.getAllInBox(l[0],l[1],l[2],l[3]);r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0,w.length>0&&(r.data.canvasNeedsRedraw[t.NODE]=!0);for(var f=(new e.Event(i,{type:"select"}),0);f<w.length;f++)w[f]._private.selectable&&(u.push(w[f]),x.push(w[f]));var _=new e.Collection(o,x);"additive"===o.selectionType()?_.select():(d||o.$(":selected").not(_).unselect(),_.select()),0===w.length&&r.redraw()}if(r.hoverData.dragging&&(r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0,r.redraw()),r.hoverData.dragging=!1,!l[4]){r.data.canvasNeedsRedraw[t.DRAG]=!0,r.data.canvasNeedsRedraw[t.NODE]=!0;for(var f=0;f<u.length;f++)if("nodes"==u[f]._private.group){u[f]._private.rscratch.inDragLayer=!1;for(var m=u[f]._private.edges,b=0;b<m.length;b++)m[b]._private.rscratch.inDragLayer=!1;a(u[f],!1)}else"edges"==u[f]._private.group&&(u[f]._private.rscratch.inDragLayer=!1);p&&p.trigger("free")}}l[4]=0,r.hoverData.down=null,r.dragData.didDrag=!1}},!1);var s=function(e){var i=r.data.cy,n=r.projectIntoViewport(e.pageX,e.pageY),a=[n[0]*i.zoom()+i.pan().x,n[1]*i.zoom()+i.pan().y];if(r.hoverData.draggingEles||r.hoverData.dragging||r.hoverData.cxtStarted||o())return void e.preventDefault();if(i.panningEnabled()&&i.userPanningEnabled()&&i.zoomingEnabled()&&i.userZoomingEnabled()){e.preventDefault(),r.data.wheelZooming=!0,clearTimeout(r.data.wheelTimeout),r.data.wheelTimeout=setTimeout(function(){r.data.wheelZooming=!1,r.data.canvasNeedsRedraw[t.NODE]=!0,r.redraw()},150);var s=e.wheelDeltaY/1e3||e.wheelDelta/1e3||e.detail/-32||-e.deltaY/500;i.zoom({level:i.zoom()*Math.pow(10,s),renderedPosition:{x:a[0],y:a[1]}})}};r.registerBinding(r.data.container,"wheel",s,!0),r.registerBinding(r.data.container,"mousewheel",s,!0),r.registerBinding(r.data.container,"DOMMouseScroll",s,!0),r.registerBinding(r.data.container,"MozMousePixelScroll",function(){},!1),r.registerBinding(r.data.container,"mouseout",function(t){var i=r.projectIntoViewport(t.pageX,t.pageY);r.data.cy.trigger(new e.Event(t,{type:"mouseout",cyPosition:{x:i[0],y:i[1]}}))},!1),r.registerBinding(r.data.container,"mouseover",function(t){var i=r.projectIntoViewport(t.pageX,t.pageY);r.data.cy.trigger(new e.Event(t,{type:"mouseover",cyPosition:{x:i[0],y:i[1]}}))},!1);var l,c,u,p,d,h,g,v,f,y,m=r.data.container.clientWidth,b=r.data.container.clientHeight,x=function(e,t,r,i){return Math.sqrt((r-e)*(r-e)+(i-t)*(i-t))};r.registerBinding(r.data.container,"touchstart",function(o){clearTimeout(this.threeFingerSelectTimeout),o.target!==r.data.link&&o.preventDefault(),r.touchData.capture=!0,r.data.bgActivePosistion=void 0;var s=r.data.cy,w=r.getCachedNodes(),_=r.getCachedEdges(),E=r.touchData.now,S=r.touchData.earlier;if(o.touches[0]){var P=r.projectIntoViewport(o.touches[0].pageX,o.touches[0].pageY);E[0]=P[0],E[1]=P[1]}if(o.touches[1]){var P=r.projectIntoViewport(o.touches[1].pageX,o.touches[1].pageY);E[2]=P[0],E[3]=P[1]}if(o.touches[2]){var P=r.projectIntoViewport(o.touches[2].pageX,o.touches[2].pageY);E[4]=P[0],E[5]=P[1]}if(o.touches[1]){var k=function(e){for(var t=0;t<e.length;t++)e[t]._private.grabbed=!1,e[t]._private.rscratch.inDragLayer=!1,e[t].active()&&e[t].unactivate()};k(w),k(_);var M=r.findContainerPageCoords();f=M[1],v=M[0],l=o.touches[0].pageX-v,c=o.touches[0].pageY-f,u=o.touches[1].pageX-v,p=o.touches[1].pageY-f,y=l>=0&&m>=l&&u>=0&&m>=u&&c>=0&&b>=c&&p>=0&&b>=p;var N=s.pan(),C=s.zoom();if(d=x(l,c,u,p),h=[(l+u)/2,(c+p)/2],g=[(h[0]-N.x)/C,(h[1]-N.y)/C],100>d){var D=r.findNearestElement(E[0],E[1],!0),T=r.findNearestElement(E[2],E[3],!0);return D&&D.isNode()?(D.activate().trigger(new e.Event(o,{type:"cxttapstart",cyPosition:{x:E[0],y:E[1]}})),r.touchData.start=D):T&&T.isNode()?(T.activate().trigger(new e.Event(o,{type:"cxttapstart",cyPosition:{x:E[0],y:E[1]}})),r.touchData.start=T):(s.trigger(new e.Event(o,{type:"cxttapstart",cyPosition:{x:E[0],y:E[1]}})),r.touchData.start=null),r.touchData.start&&(r.touchData.start._private.grabbed=!1),r.touchData.cxt=!0,r.touchData.cxtDragged=!1,r.data.bgActivePosistion=void 0,void r.redraw()}}if(o.touches[2]);else if(o.touches[1]);else if(o.touches[0]){var I=r.findNearestElement(E[0],E[1],!0);if(null!=I){if(I.activate(),r.touchData.start=I,"nodes"==I._private.group&&r.nodeIsDraggable(I)){var z=r.dragData.touchDragEles=[];if(n(I,z),I.trigger("grab"),I.selected()){z=r.dragData.touchDragEles=[];for(var B=s.$("node:selected"),R=0;R<B.length;R++){var X=B[R];if(r.nodeIsDraggable(X)){z.push(X),X._private.rscratch.inDragLayer=!0;for(var Y=X._private.edges,V=0;V<Y.length;V++)Y[V]._private.rscratch.inDragLayer=!0;("auto"==X._private.style.width.value||"auto"==X._private.style.height.value)&&i(X,!1,z),a(X,!0)}}}else("auto"==I._private.style.width.value||"auto"==I._private.style.height.value)&&i(I,!0,z),a(I,!0)}I.trigger(new e.Event(o,{type:"touchstart",cyPosition:{x:E[0],y:E[1]}})).trigger(new e.Event(o,{type:"tapstart",cyPosition:{x:E[0],y:E[1]}})).trigger(new e.Event(o,{type:"vmousdown",cyPosition:{x:E[0],y:E[1]}}))}null==I&&(s.trigger(new e.Event(o,{type:"touchstart",cyPosition:{x:E[0],y:E[1]}})).trigger(new e.Event(o,{type:"tapstart",cyPosition:{x:E[0],y:E[1]}})).trigger(new e.Event(o,{type:"vmousedown",cyPosition:{x:E[0],y:E[1]}})),r.data.bgActivePosistion={x:P[0],y:P[1]},r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0,r.redraw());for(var L=0;L<E.length;L++)S[L]=E[L],r.touchData.startPosition[L]=E[L];r.touchData.singleTouchMoved=!1,r.touchData.singleTouchStartTime=+new Date;{setTimeout(function(){0==r.touchData.singleTouchMoved&&+new Date-r.touchData.singleTouchStartTime>250&&(r.touchData.start?r.touchData.start.trigger(new e.Event(o,{type:"taphold",cyPosition:{x:E[0],y:E[1]}})):(r.data.cy.trigger(new e.Event(o,{type:"taphold",cyPosition:{x:E[0],y:E[1]}})),s.$(":selected").unselect()))},1e3)}}},!1),r.registerBinding(window,"touchmove",e.util.throttle(function(i){var n=r.data.select,a=r.touchData.capture;a&&i.preventDefault();var o=r.data.cy,s=(r.getCachedNodes(),r.getCachedEdges(),r.touchData.now),h=r.touchData.earlier;if(i.touches[0]){var m=r.projectIntoViewport(i.touches[0].pageX,i.touches[0].pageY);s[0]=m[0],s[1]=m[1]}if(i.touches[1]){var m=r.projectIntoViewport(i.touches[1].pageX,i.touches[1].pageY);s[2]=m[0],s[3]=m[1]}if(i.touches[2]){var m=r.projectIntoViewport(i.touches[2].pageX,i.touches[2].pageY);s[4]=m[0],s[5]=m[1]}for(var b=[],w=0;w<s.length;w++)b[w]=s[w]-h[w];if(a&&r.touchData.cxt){var _=i.touches[0].pageX-v,E=i.touches[0].pageY-f,S=i.touches[1].pageX-v,P=i.touches[1].pageY-f,k=x(_,E,S,P),M=k/d;if(M>=1.5||k>=150){r.touchData.cxt=!1,r.touchData.start&&(r.touchData.start.unactivate(),r.touchData.start=null),r.data.bgActivePosistion=void 0,r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0;var N=new e.Event(i,{type:"cxttapend",cyPosition:{x:s[0],y:s[1]}});r.touchData.start?r.touchData.start.trigger(N):o.trigger(N)}}if(a&&r.touchData.cxt){var N=new e.Event(i,{type:"cxtdrag",cyPosition:{x:s[0],y:s[1]}});r.data.bgActivePosistion=void 0,r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0,r.touchData.start?r.touchData.start.trigger(N):o.trigger(N),r.touchData.start&&(r.touchData.start._private.grabbed=!1),r.touchData.cxtDragged=!0}else if(a&&i.touches[2]&&o.boxSelectionEnabled())r.data.bgActivePosistion=void 0,clearTimeout(this.threeFingerSelectTimeout),this.lastThreeTouch=+new Date,r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0,n&&0!==n.length&&void 0!==n[0]?(n[2]=(s[0]+s[2]+s[4])/3,n[3]=(s[1]+s[3]+s[5])/3):(n[0]=(s[0]+s[2]+s[4])/3,n[1]=(s[1]+s[3]+s[5])/3,n[2]=(s[0]+s[2]+s[4])/3+1,n[3]=(s[1]+s[3]+s[5])/3+1),n[4]=1,r.redraw();else if(a&&i.touches[1]&&o.zoomingEnabled()&&o.panningEnabled()&&o.userZoomingEnabled()&&o.userPanningEnabled()){r.data.bgActivePosistion=void 0,r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0;var _=i.touches[0].pageX-v,E=i.touches[0].pageY-f,S=i.touches[1].pageX-v,P=i.touches[1].pageY-f,k=x(_,E,S,P),M=k/d;if(1!=M&&y){var C=_-l,D=E-c,T=S-u,I=P-p,z=(C+T)/2,B=(D+I)/2,R=o.zoom(),X=R*M,Y=o.pan(),V=g[0]*R+Y.x,L=g[1]*R+Y.y,A={x:-X/R*(V-Y.x-z)+V,y:-X/R*(L-Y.y-B)+L};o._private.zoom=X,o._private.pan=A,o.trigger("pan zoom").notify("viewport"),d=k,l=_,c=E,u=S,p=P,r.pinching=!0}if(i.touches[0]){var m=r.projectIntoViewport(i.touches[0].pageX,i.touches[0].pageY);s[0]=m[0],s[1]=m[1]}if(i.touches[1]){var m=r.projectIntoViewport(i.touches[1].pageX,i.touches[1].pageY);s[2]=m[0],s[3]=m[1]}if(i.touches[2]){var m=r.projectIntoViewport(i.touches[2].pageX,i.touches[2].pageY);s[4]=m[0],s[5]=m[1]}}else if(i.touches[0]){{var O=r.touchData.start;r.touchData.last}if(null!=O&&"nodes"==O._private.group&&r.nodeIsDraggable(O)){var F=r.dragData.touchDragEles,q=new e.Collection(o,F).positions(function(e,t){if(r.nodeIsDraggable(t)){r.dragData.didDrag=!0;var i=t.position();return{x:i.x+b[0],y:i.y+b[1]}}});q.trigger("drag"),r.hoverData.draggingEles=!0,r.data.canvasNeedsRedraw[t.DRAG]=!0,r.touchData.startPosition[0]==h[0]&&r.touchData.startPosition[1]==h[1]&&(r.data.canvasNeedsRedraw[t.NODE]=!0)}if(null!=O&&(O.trigger(new e.Event(i,{type:"touchmove",cyPosition:{x:s[0],y:s[1]}})),O.trigger(new e.Event(i,{type:"tapdrag",cyPosition:{x:s[0],y:s[1]}})),O.trigger(new e.Event(i,{type:"vmousemove",cyPosition:{x:s[0],y:s[1]}}))),null==O){var j=r.findNearestElement(s[0],s[1],!0);null!=j&&(j.trigger(new e.Event(i,{type:"touchmove",cyPosition:{x:s[0],y:s[1]}})),j.trigger(new e.Event(i,{type:"tapdrag",cyPosition:{x:s[0],y:s[1]}})),j.trigger(new e.Event(i,{type:"vmousemove",cyPosition:{x:s[0],y:s[1]}}))),null==j&&(o.trigger(new e.Event(i,{type:"touchmove",cyPosition:{x:s[0],y:s[1]}})),o.trigger(new e.Event(i,{type:"tapdrag",cyPosition:{x:s[0],y:s[1]}})),o.trigger(new e.Event(i,{type:"vmousemove",cyPosition:{x:s[0],y:s[1]}})))}r.touchData.last=j;for(var H=0;H<s.length;H++)s[H]&&r.touchData.startPosition[H]&&Math.abs(s[H]-r.touchData.startPosition[H])>4&&(r.touchData.singleTouchMoved=!0);if(a&&(null==O||O.isEdge())&&o.panningEnabled()&&o.userPanningEnabled()){O&&(O.unactivate(),r.data.bgActivePosistion||(r.data.bgActivePosistion={x:s[0],y:s[1]}),r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0),o.panBy({x:b[0]*o.zoom(),y:b[1]*o.zoom()}),r.swipePanning=!0;var m=r.projectIntoViewport(i.touches[0].pageX,i.touches[0].pageY);s[0]=m[0],s[1]=m[1]}}for(var w=0;w<s.length;w++)h[w]=s[w]},1e3/30),!1),r.registerBinding(window,"touchend",function(i){var n=r.touchData.capture;if(n){r.touchData.capture=!1,i.preventDefault();var o=r.data.select;r.swipePanning=!1,r.hoverData.draggingEles=!1;var s=r.data.cy,l=(r.getCachedNodes(),r.getCachedEdges(),r.touchData.now),c=r.touchData.earlier,u=r.touchData.start;if(i.touches[0]){var p=r.projectIntoViewport(i.touches[0].pageX,i.touches[0].pageY);l[0]=p[0],l[1]=p[1]}if(i.touches[1]){var p=r.projectIntoViewport(i.touches[1].pageX,i.touches[1].pageY);l[2]=p[0],l[3]=p[1]}if(i.touches[2]){var p=r.projectIntoViewport(i.touches[2].pageX,i.touches[2].pageY);l[4]=p[0],l[5]=p[1]}if(r.touchData.cxt){if(ctxTapend=new e.Event(i,{type:"cxttapend",cyPosition:{x:l[0],y:l[1]}}),u?(u.unactivate(),u.trigger(ctxTapend)):s.trigger(ctxTapend),!r.touchData.cxtDragged){var d=new e.Event(i,{type:"cxttap",cyPosition:{x:l[0],y:l[1]}});u?u.trigger(d):s.trigger(d)}return r.touchData.start&&(r.touchData.start._private.grabbed=!1),r.touchData.cxt=!1,r.touchData.start=null,void r.redraw()}{+new Date}if(!i.touches[2]&&s.boxSelectionEnabled()){clearTimeout(this.threeFingerSelectTimeout);var h=[],g=r.getAllInBox(o[0],o[1],o[2],o[3]);o[0]=void 0,o[1]=void 0,o[2]=void 0,o[3]=void 0,o[4]=0,r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0;for(var v=(new e.Event("select"),0);v<g.length;v++)g[v]._private.selectable&&h.push(g[v]);var f=new e.Collection(s,h);"single"===s.selectionType()&&s.$(":selected").not(f).unselect(),f.select(),g.length>0&&(r.data.canvasNeedsRedraw[t.NODE]=!0)}i.touches.length<2&&(r.pinching=!1,r.data.canvasNeedsRedraw[t.NODE]=!0,r.redraw());var y=!1;if(null!=u&&(u._private.active=!1,y=!0,u.trigger("unactivate")),i.touches[2])r.data.bgActivePosistion=void 0,r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0;else if(i.touches[1]);else if(i.touches[0]);else if(!i.touches[0]){if(r.data.bgActivePosistion=void 0,r.data.canvasNeedsRedraw[t.SELECT_BOX]=!0,null!=u){1==u._private.grabbed&&(u._private.grabbed=!1,u.trigger("free"),u._private.rscratch.inDragLayer=!1);for(var m=u._private.edges,b=0;b<m.length;b++)m[b]._private.rscratch.inDragLayer=!1;if(a(u,!1),u.selected())for(var x=s.$("node:selected"),w=0;w<x.length;w++){var _=x[w];_._private.rscratch.inDragLayer=!1;for(var m=_._private.edges,b=0;b<m.length;b++)m[b]._private.rscratch.inDragLayer=!1;a(_,!1)}r.data.canvasNeedsRedraw[t.DRAG]=!0,r.data.canvasNeedsRedraw[t.NODE]=!0,u.trigger(new e.Event(i,{type:"touchend",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"tapend",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"vmouseup",cyPosition:{x:l[0],y:l[1]}})),r.touchData.start=null}else{var E=r.findNearestElement(l[0],l[1],!0);null!=E&&E.trigger(new e.Event(i,{type:"touchend",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"tapend",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"vmouseup",cyPosition:{x:l[0],y:l[1]}})),null==E&&s.trigger(new e.Event(i,{type:"touchend",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"tapend",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"vmouseup",cyPosition:{x:l[0],y:l[1]}}))}null!=u&&!r.dragData.didDrag&&u._private.selectable&&Math.sqrt(Math.pow(r.touchData.startPosition[0]-l[0],2)+Math.pow(r.touchData.startPosition[1]-l[1],2))<6&&("single"===s.selectionType()?(s.$(":selected").not(u).unselect(),u.select()):u.selected()?u.unselect():u.select(),y=!0,r.data.canvasNeedsRedraw[t.NODE]=!0),0==r.touchData.singleTouchMoved&&(u?u.trigger(new e.Event(i,{type:"tap",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"vclick",cyPosition:{x:l[0],y:l[1]}})):s.trigger(new e.Event(i,{type:"tap",cyPosition:{x:l[0],y:l[1]}})).trigger(new e.Event(i,{type:"vclick",cyPosition:{x:l[0],y:l[1]}}))),r.touchData.singleTouchMoved=!0}for(var b=0;b<l.length;b++)c[b]=l[b];r.dragData.didDrag=!1,y&&u&&u.updateStyle(!1)}},!1)}}(cytoscape),function(e){"use strict";var t=e("renderer","canvas"),r=t.prototype,i=t.nodeShapes={};i.ellipse={draw:function(e,t,r,n,a){i.ellipse.drawPath(e,t,r,n,a),e.fill()},drawPath:function(e,t,r,i,n){e.beginPath(),e.translate(t,r),e.scale(i/2,n/2),e.arc(0,0,1,0,2*Math.PI*.999,!1),e.closePath(),e.scale(2/i,2/n),e.translate(-t,-r)},intersectLine:function(t,r,i,n,a,o,s){var l=e.math.intersectLineEllipse(a,o,t,r,i/2+s,n/2+s);return l},intersectBox:function(t,r,i,n,a,o,s,l,c){return e.math.boxIntersectEllipse(t,r,i,n,c,a,o,s,l)},checkPointRough:function(){return!0},checkPoint:function(e,t,r,i,n,a,o){return e-=a,t-=o,e/=i/2+r,t/=n/2+r,Math.pow(e,2)+Math.pow(t,2)<=1}},i.triangle={points:e.math.generateUnitNgonPointsFitToSquare(3,0),draw:function(e,t,n,a,o){r.drawPolygon(e,t,n,a,o,i.triangle.points)},drawPath:function(e,t,n,a,o){r.drawPolygonPath(e,t,n,a,o,i.triangle.points)},intersectLine:function(t,r,n,a,o,s,l){return e.math.polygonIntersectLine(o,s,i.triangle.points,t,r,n/2,a/2,l)},intersectBox:function(t,r,n,a,o,s,l,c,u){var p=i.triangle.points;return e.math.boxIntersectPolygon(t,r,n,a,p,o,s,l,c,[0,-1],u)},checkPointRough:function(t,r,n,a,o,s,l){return e.math.checkInBoundingBox(t,r,i.triangle.points,n,a,o,s,l)},checkPoint:function(t,r,n,a,o,s,l){return e.math.pointInsidePolygon(t,r,i.triangle.points,s,l,a,o,[0,-1],n)}},i.square={points:e.math.generateUnitNgonPointsFitToSquare(4,0),draw:function(e,t,n,a,o){r.drawPolygon(e,t,n,a,o,i.square.points)},drawPath:function(e,t,n,a,o){r.drawPolygonPath(e,t,n,a,o,i.square.points)},intersectLine:function(t,r,n,a,o,s,l){return e.math.polygonIntersectLine(o,s,i.square.points,t,r,n/2,a/2,l)},intersectBox:function(t,r,n,a,o,s,l,c,u){var p=i.square.points;return e.math.boxIntersectPolygon(t,r,n,a,p,o,s,l,c,[0,-1],u)},checkPointRough:function(t,r,n,a,o,s,l){return e.math.checkInBoundingBox(t,r,i.square.points,n,a,o,s,l)},checkPoint:function(t,r,n,a,o,s,l){return e.math.pointInsidePolygon(t,r,i.square.points,s,l,a,o,[0,-1],n)}},i.rectangle=i.square,i.octogon={},i.roundrectangle={points:e.math.generateUnitNgonPointsFitToSquare(4,0),draw:function(e,t,i,n,a){r.drawRoundRectangle(e,t,i,n,a,10)},drawPath:function(e,t,i,n,a){r.drawRoundRectanglePath(e,t,i,n,a,10)},intersectLine:function(t,r,i,n,a,o,s){return e.math.roundRectangleIntersectLine(a,o,t,r,i,n,s)},intersectBox:function(t,r,i,n,a,o,s,l,c){return e.math.roundRectangleIntersectBox(t,r,i,n,a,o,s,l,c)},checkPointRough:function(t,r,n,a,o,s,l){return e.math.checkInBoundingBox(t,r,i.roundrectangle.points,n,a,o,s,l)},checkPoint:function(t,r,n,a,o,s,l){var c=e.math.getRoundRectangleRadius(a,o);if(e.math.pointInsidePolygon(t,r,i.roundrectangle.points,s,l,a,o-2*c,[0,-1],n))return!0;if(e.math.pointInsidePolygon(t,r,i.roundrectangle.points,s,l,a-2*c,o,[0,-1],n))return!0;var u=function(e,t,r,i,n,a,o){return e-=r,t-=i,e/=n/2+o,t/=a/2+o,Math.pow(e,2)+Math.pow(t,2)<=1};return u(t,r,s-a/2+c,l-o/2+c,2*c,2*c,n)?!0:u(t,r,s+a/2-c,l-o/2+c,2*c,2*c,n)?!0:u(t,r,s+a/2-c,l+o/2-c,2*c,2*c,n)?!0:u(t,r,s-a/2+c,l+o/2-c,2*c,2*c,n)?!0:!1}},i.roundrectangle2={roundness:4.99,draw:function(e,t,i){2*roundness>=t||r.drawPolygon(e._private.position.x,e._private.position.y,t,i,nodeSapes.roundrectangle2.points)},intersectLine:function(t,r,n,a,o){return e.math.findPolygonIntersection(t,r,n,a,o,i.square.points)},intersectBox:function(){i.square.points}},i.pentagon={points:e.math.generateUnitNgonPointsFitToSquare(5,0),draw:function(e,t,n,a,o){r.drawPolygon(e,t,n,a,o,i.pentagon.points)},drawPath:function(e,t,n,a,o){r.drawPolygonPath(e,t,n,a,o,i.pentagon.points)},intersectLine:function(e,t,n,a,o,s,l){return r.polygonIntersectLine(o,s,i.pentagon.points,e,t,n/2,a/2,l)},intersectBox:function(t,r,n,a,o,s,l,c,u){var p=i.pentagon.points;return e.math.boxIntersectPolygon(t,r,n,a,p,o,s,l,c,[0,-1],u)},checkPointRough:function(t,r,n,a,o,s,l){return e.math.checkInBoundingBox(t,r,i.pentagon.points,n,a,o,s,l)},checkPoint:function(t,r,n,a,o,s,l){return e.math.pointInsidePolygon(t,r,i.pentagon.points,s,l,a,o,[0,-1],n)}},i.hexagon={points:e.math.generateUnitNgonPointsFitToSquare(6,0),draw:function(e,t,n,a,o){r.drawPolygon(e,t,n,a,o,i.hexagon.points)},drawPath:function(e,t,n,a,o){r.drawPolygonPath(e,t,n,a,o,i.hexagon.points)},intersectLine:function(t,r,n,a,o,s,l){return e.math.polygonIntersectLine(o,s,i.hexagon.points,t,r,n/2,a/2,l)},intersectBox:function(t,r,n,a,o,s,l,c,u){var p=i.hexagon.points;return e.math.boxIntersectPolygon(t,r,n,a,p,o,s,l,c,[0,-1],u)},checkPointRough:function(t,r,n,a,o,s,l){return e.math.checkInBoundingBox(t,r,i.hexagon.points,n,a,o,s,l)},checkPoint:function(t,r,n,a,o,s,l){return e.math.pointInsidePolygon(t,r,i.hexagon.points,s,l,a,o,[0,-1],n)}},i.heptagon={points:e.math.generateUnitNgonPointsFitToSquare(7,0),draw:function(e,t,n,a,o){r.drawPolygon(e,t,n,a,o,i.heptagon.points)},drawPath:function(e,t,n,a,o){r.drawPolygonPath(e,t,n,a,o,i.heptagon.points)},intersectLine:function(e,t,n,a,o,s,l){return r.polygonIntersectLine(o,s,i.heptagon.points,e,t,n/2,a/2,l)},intersectBox:function(e,t,n,a,o,s,l,c,u){var p=i.heptagon.points;return r.boxIntersectPolygon(e,t,n,a,p,o,s,l,c,[0,-1],u)},checkPointRough:function(t,r,n,a,o,s,l){return e.math.checkInBoundingBox(t,r,i.heptagon.points,n,a,o,s,l)},checkPoint:function(t,r,n,a,o,s,l){return e.math.pointInsidePolygon(t,r,i.heptagon.points,s,l,a,o,[0,-1],n)}},i.octagon={points:e.math.generateUnitNgonPointsFitToSquare(8,0),draw:function(e,t,n,a,o){r.drawPolygon(e,t,n,a,o,i.octagon.points)},drawPath:function(e,t,n,a,o){r.drawPolygonPath(e,t,n,a,o,i.octagon.points)},intersectLine:function(e,t,n,a,o,s,l){return r.polygonIntersectLine(o,s,i.octagon.points,e,t,n/2,a/2,l)},intersectBox:function(e,t,n,a,o,s,l,c,u){var p=i.octagon.points;return r.boxIntersectPolygon(e,t,n,a,p,o,s,l,c,[0,-1],u)},checkPointRough:function(t,r,n,a,o,s,l){return e.math.checkInBoundingBox(t,r,i.octagon.points,n,a,o,s,l)},checkPoint:function(t,r,n,a,o,s,l){return e.math.pointInsidePolygon(t,r,i.octagon.points,s,l,a,o,[0,-1],n)}};var n=new Array(20),a=e.math.generateUnitNgonPoints(5,0),o=e.math.generateUnitNgonPoints(5,Math.PI/5),s=.5*(3-Math.sqrt(5));s*=1.57;for(var l=0;l<o.length/2;l++)o[2*l]*=s,o[2*l+1]*=s;for(var l=0;5>l;l++)n[4*l]=a[2*l],n[4*l+1]=a[2*l+1],n[4*l+2]=o[2*l],n[4*l+3]=o[2*l+1];n=e.math.fitPolygonToSquare(n),i.star5=i.star={points:n,draw:function(e,t,n,a,o){r.drawPolygon(e,t,n,a,o,i.star5.points)},drawPath:function(e,t,n,a,o){r.drawPolygonPath(e,t,n,a,o,i.star5.points)},intersectLine:function(e,t,n,a,o,s,l){return r.polygonIntersectLine(o,s,i.star5.points,e,t,n/2,a/2,l)},intersectBox:function(e,t,n,a,o,s,l,c,u){var p=i.star5.points;return r.boxIntersectPolygon(e,t,n,a,p,o,s,l,c,[0,-1],u)},checkPointRough:function(t,r,n,a,o,s,l){return e.math.checkInBoundingBox(t,r,i.star5.points,n,a,o,s,l)},checkPoint:function(t,r,n,a,o,s,l){return e.math.pointInsidePolygon(t,r,i.star5.points,s,l,a,o,[0,-1],n)}}}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend({},r,t)}var r={liveUpdate:!0,ready:void 0,stop:void 0,maxSimulationTime:4e3,fit:!0,padding:[50,50,50,50],simulationBounds:void 0,ungrabifyWhileSimulating:!0,repulsion:void 0,stiffness:void 0,friction:void 0,gravity:!0,fps:void 0,precision:void 0,nodeMass:void 0,edgeLength:void 0,stepSize:1,stableEnergy:function(e){var t=e;return t.max<=.5||t.mean<=.3}};t.prototype.run=function(){function t(e,t){return null==t?void 0:"function"==typeof t?t.apply(e,[e._private.data,{nodes:o.length,edges:s.length,element:e}]):t}function r(e){var t=e.x,r=e.y,i=c,n=u,a=-2,o=2,s=4;return{x:t/i*s+a,y:r/n*s+o}}function i(e){n.fit&&a.fit(),e()}var n=this.options,a=n.cy,o=a.nodes(),s=a.edges(),l=a.container(),c=l.clientWidth,u=l.clientHeight,p=n.simulationBounds;n.simulationBounds?(c=p[2]-p[0],u=p[3]-p[1]):n.simulationBounds=[0,0,c,u];var d=n.simulationBounds;if(d.x1=d[0],d.y1=d[1],d.x2=d[2],d.y2=d[3],a.nodes().size()<=1)return n.fit&&a.reset(),a.nodes().position({x:Math.round((d.x1+d.x2)/2),y:Math.round((d.y1+d.y2)/2)}),a.one("layoutready",n.ready),a.trigger("layoutready"),a.one("layoutstop",n.stop),void a.trigger("layoutstop");var h=this.system=arbor.ParticleSystem(n.repulsion,n.stiffness,n.friction,n.gravity,n.fps,n.dt,n.precision);this.system=h,n.liveUpdate&&n.fit&&a.reset();var g,v=250,f=!1,y=+new Date,m={init:function(){},redraw:function(){var t=h.energy();if(null!=n.stableEnergy&&null!=t&&t.n>0&&n.stableEnergy(t))return void h.stop();clearTimeout(g),g=setTimeout(w,v);var r=[];h.eachNode(function(e,t){var i=(e.name,e.data),n=i.element;null!=n&&(n.locked()||n.grabbed()||(n.silentPosition({x:d.x1+t.x,y:d.y1+t.y}),r.push(n)))});var i=+new Date-y>=16;n.liveUpdate&&r.length>0&&i&&(new e.Collection(a,r).rtrigger("position"),y=+new Date),f||(f=!0,a.one("layoutready",n.ready),a.trigger("layoutready"))}};h.renderer=m,h.screenSize(c,u),h.screenPadding(n.padding[0],n.padding[1],n.padding[2],n.padding[3]),h.screenStep(n.stepSize);var b=function(e){grabbed=this;var t=h.fromScreen(this.position()),r=arbor.Point(t.x,t.y);switch(this.scratch().arbor.p=r,e.type){case"grab":this.scratch().arbor.fixed=!0;break;case"dragstop":this.scratch().arbor.fixed=!1,this.scratch().arbor.tempMass=1e3}};o.bind("grab drag dragstop",b),o.each(function(e,i){if(!this.isFullAutoParent()){var a=this._private.data.id,o=t(this,n.nodeMass),s=this._private.locked;if(!i.isFullAutoParent()){var l=r({x:i.position().x,y:i.position().y});i.locked()||(this.scratch().arbor=h.addNode(a,{element:this,mass:o,fixed:s,x:s?l.x:void 0,y:s?l.y:void 0}))}}}),s.each(function(){var e=(this.id(),this.source().id()),r=this.target().id(),i=t(this,n.edgeLength);this.scratch().arbor=h.addEdge(e,r,{length:i})});var x=o.filter(":grabbable");n.ungrabifyWhileSimulating&&x.ungrabify();var w=function(){function e(){n.liveUpdate||(n.fit&&a.reset(),a.nodes().rtrigger("position")),o.unbind("grab drag dragstop",b),n.ungrabifyWhileSimulating&&x.grabify(),a.one("layoutstop",n.stop),a.trigger("layoutstop")}window.isIE?i(function(){e()}):e()};h.start(),setTimeout(function(){h.stop()},n.maxSimulationTime)},t.prototype.stop=function(){null!=this.system&&system.stop()},e("layout","arbor",t)}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend({},r,t)}var r={fit:!0,ready:void 0,stop:void 0,directed:!1,padding:30,circle:!1,roots:void 0,maximalAdjustments:0};t.prototype.run=function(){var t,r=this.options,i=r,n=r.cy,a=n.nodes(),o=n.edges(),s=a.add(o),l=n.container(),c=l.clientWidth,u=l.clientHeight;if(e.is.elementOrCollection(i.roots))t=i.roots;else if(e.is.array(i.roots)){for(var p=[],d=0;d<i.roots.length;d++){var h=i.roots[d],g=n.getElementById(h);t.push(g)}t=new e.Collection(n,p)}else if(i.directed)t=a.roots();else{var v=a.maxDegree(!1);t=a.filter("[[degree = "+v+"]]")}var f=[],y={},m={};s.bfs(t,function(e,t){var r=this[0];f[t]||(f[t]=[]),f[t].push(r),y[r.id()]=!0,m[r.id()]=t},i.directed);for(var b=[],d=0;d<a.length;d++){var g=a[d];y[g.id()]||b.push(g)}for(var x=3*b.length,w=0;0!==b.length&&x>w;){for(var _=b.shift(),E=_.neighborhood().nodes(),S=!1,d=0;d<E.length;d++){var P=m[E[d].id()];if(void 0!==P){f[P].push(_),S=!0;break}}S||b.push(_),w++}for(;0!==b.length;){var _=b.shift(),S=!1;S||(0===f.length&&f.push([]),f[0].push(_))}var k=function(){for(var e=0;e<f.length;e++)for(var t=f[e],r=0;r<t.length;r++){var i=t[r];i._private.scratch.BreadthFirstLayout={depth:e,index:r}}};k();for(var M=0;M<i.maximalAdjustments;M++){for(var N=function(e){for(var t,r=e.connectedEdges('[target = "'+e.id()+'"]'),i=e._private.scratch.BreadthFirstLayout,n=0,a=0;a<r.length;a++){var o=r[a],s=o.source()[0],l=s._private.scratch.BreadthFirstLayout;i.depth<l.depth&&n<l.depth&&(n=l.depth,t=s)}return t},C=f.length,D=[],d=0;C>d;d++)for(var P=f[d],T=P.length,I=0;T>I;I++){var g=P[I],z=g._private.scratch.BreadthFirstLayout,B=N(g);B&&(z.intEle=B,D.push(g))}for(var d=0;d<D.length;d++){var g=D[d],z=g._private.scratch.BreadthFirstLayout,B=z.intEle,R=B._private.scratch.BreadthFirstLayout;f[z.depth].splice(z.index,1);for(var X=R.depth+1;X>f.length-1;)f.push([]);f[X].push(g),z.depth=X,z.index=f[X].length-1}k()}for(var Y=0,d=0;d<a.length;d++){var V=a[d].outerWidth(),L=a[d].outerHeight();Y=Math.max(Y,V,L)}Y*=1.75;for(var A={},O=function(e){if(A[e.id()])return A[e.id()];for(var t=e._private.scratch.BreadthFirstLayout.depth,r=e.neighborhood().nodes(),i=0,n=0,a=0;a<r.length;a++){var o=r[a],s=(o.edgesWith(e),o._private.scratch.BreadthFirstLayout.index),l=o._private.scratch.BreadthFirstLayout.depth,c=f[l].length;(t>l||0===t)&&(i+=s/c,n++)}return n=Math.max(1,n),i/=n,0===n&&(i=void 0),A[e.id()]=i,i},F=0;3>F;F++){for(var d=0;d<f.length;d++){var P=d;f[d]=f[d].sort(function(e,t){var r=O(e),i=O(t);return r-i})}k()}var q={x:c/2,y:u/2};a.positions(function(){var e=this[0],t=e._private.scratch.BreadthFirstLayout,r=t.depth,n=t.index,a=Math.max(c/(f[r].length+1),Y),o=Math.max(u/(f.length+1),Y),s=Math.min(c/2/f.length,u/2/f.length);if(s=Math.max(s,Y),i.circle){var l=s*r+s-(f.length>0&&f[0].length<=3?s/2:0),p=2*Math.PI/f[r].length*n;return 0===r&&1===f[0].length&&(l=1),{x:q.x+l*Math.cos(p),y:q.y+l*Math.sin(p)}}return{x:(n+1)*a,y:(r+1)*o}}),r.fit&&n.fit(i.padding),n.one("layoutready",r.ready),n.trigger("layoutready"),n.one("layoutstop",r.stop),n.trigger("layoutstop")
},t.prototype.stop=function(){},e("layout","breadthfirst",t)}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend({},r,t)}var r={fit:!0,ready:void 0,stop:void 0,rStepSize:10,padding:30,startAngle:1.5*Math.PI,counterclockwise:!1};t.prototype.run=function(){function e(){var e=0,t=u,r={x:l.x+g*Math.cos(e),y:l.y+g*Math.sin(e)},i={x:l.x+g*Math.cos(t),y:l.y+g*Math.sin(t)},n=Math.sqrt((i.x-r.x)*(i.x-r.x)+(i.y-r.y)*(i.y-r.y));return n}for(var t=this.options,r=t,i=t.cy,n=i.nodes().filter(function(){return!this.isFullAutoParent()}),a=(i.edges(),i.container()),o=a.clientWidth,s=a.clientHeight,l={x:o/2,y:s/2},c=r.startAngle,u=2*Math.PI/n.length,p=0,d=0;d<n.length;d++){var h=n[d];p=Math.max(h.outerWidth(),h.outerHeight())}for(var g=o/2-p;e()<p&&!(n.length<2);)g+=r.rStepSize;var d=0;n.positions(function(){var e=g*Math.cos(c),t=g*Math.sin(c),i={x:l.x+e,y:l.y+t};return d++,c=r.counterclockwise?c-u:c+u,i}),t.fit&&i.fit(r.padding),i.one("layoutready",t.ready),i.trigger("layoutready"),i.one("layoutstop",t.stop),i.trigger("layoutstop")},t.prototype.stop=function(){},e("layout","circle",t)}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend({},r,t)}var r={fit:!0,ready:void 0,stop:void 0,padding:30,startAngle:1.5*Math.PI,counterclockwise:!1,minNodeSpacing:10,height:void 0,width:void 0,concentric:function(){return this.degree()},levelWidth:function(e){return e.maxDegree()/4}};t.prototype.run=function(){for(var e=this.options,t=e,r=e.cy,i=r.nodes().filter(function(){return!this.isFullAutoParent()}),n=(r.edges(),r.container()),a=void 0!==t.width?t.width:n.clientWidth,o=void 0!==t.height?t.height:n.clientHeight,s={x:a/2,y:o/2},l=[],c=t.startAngle,u=0,p=0;p<i.length;p++){var d,h=i[p];d=t.concentric.call(h),l.push({value:d,node:h}),h._private.layoutData.concentric=d}i.updateMappers();for(var p=0;p<i.length;p++){var h=i[p];u=Math.max(u,h.outerWidth(),h.outerHeight())}l.sort(function(e,t){return t.value-e.value});for(var g=t.levelWidth(i),v=[[]],f=v[0],p=0;p<l.length;p++){var y=l[p];if(f.length>0){var m=Math.abs(f[0].value-y.value);m>=g&&(f=[],v.push(f))}f.push(y)}for(var b={},x=0,w=u+t.minNodeSpacing,p=0;p<v.length;p++){var _=v[p],E=2*Math.PI/_.length;if(_.length>1){var S=Math.cos(E)-Math.cos(0),P=Math.sin(E)-Math.sin(0),k=Math.sqrt(w*w/(S*S+P*P));x=Math.max(k,x)}for(var M=0;M<_.length;M++){var y=_[M],c=t.startAngle+(t.counterclockwise?1:-1)*E*M,N={x:s.x+x*Math.cos(c),y:s.y+x*Math.sin(c)};b[y.node.id()]=N}x+=w}i.positions(function(){var e=this.id();return b[e]}),e.fit&&r.fit(t.padding),r.one("layoutready",e.ready),r.trigger("layoutready"),r.one("layoutstop",e.stop),r.trigger("layoutstop")},t.prototype.stop=function(){},e("layout","concentric",t)}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend({},i,t)}var r,i={ready:function(){},stop:function(){},refresh:0,fit:!0,padding:30,randomize:!0,debug:!1,nodeRepulsion:1e4,nodeOverlap:10,idealEdgeLength:10,edgeElasticity:100,nestingFactor:5,gravity:250,numIter:100,initialTemp:200,coolingFactor:.95,minTemp:1};t.prototype.run=function(){var e=this.options,t=e.cy;r=1==e.debug?!0:!1;var i=new Date,a=n(t,e);r&&s(a),1==e.randomize&&(l(a,t),0<e.refresh&&c(a,t,e)),m(a,t,e);for(var o=0;o<e.numIter;o++)if(u(a,t,e,o),0<e.refresh&&0==o%e.refresh&&c(a,t,e),a.temperature=a.temperature*e.coolingFactor,w("New temperature: "+a.temperature),a.temperature<e.minTemp){w("Temperature drop below minimum threshold. Stopping computation in step "+o);break}c(a,t,e),1==e.fit&&t.fit(e.padding);var p=new Date;console.info("Layout took "+(p-i)+" ms"),t.one("layoutstop",e.stop),t.trigger("layoutstop")},t.prototype.stop=function(){var e=this.options;cy.one("layoutstop",e.stop),cy.trigger("layoutstop")};var n=function(e,t){for(var r={layoutNodes:[],idToIndex:{},nodeSize:e.nodes().size(),graphSet:[],indexToGraph:[],layoutEdges:[],edgeSize:e.edges().size(),temperature:t.initialTemp},i=e.nodes(),n=0;n<r.nodeSize;n++){var o={};o.id=i[n].data("id"),o.parentId=i[n].data("parent"),o.children=[],o.positionX=i[n].position("x"),o.positionY=i[n].position("y"),o.offsetX=0,o.offsetY=0,o.height=i[n].height(),o.width=i[n].width(),o.maxX=o.positionX+o.width/2,o.minX=o.positionX-o.width/2,o.maxY=o.positionY+o.height/2,o.minY=o.positionY-o.height/2,o.padLeft=i[n]._private.style["padding-left"].pxValue,o.padRight=i[n]._private.style["padding-right"].pxValue,o.padTop=i[n]._private.style["padding-top"].pxValue,o.padBottom=i[n]._private.style["padding-bottom"].pxValue,r.layoutNodes.push(o),r.idToIndex[o.id]=n}for(var s=[],l=0,c=-1,u=[],n=0;n<r.nodeSize;n++){var p=r.layoutNodes[n],d=p.parentId;void 0!=d?r.layoutNodes[r.idToIndex[d]].children.push(p.id):(s[++c]=p.id,u.push(p.id))}for(r.graphSet.push(u);c>=l;){var h=s[l++],g=r.idToIndex[h],v=r.layoutNodes[g],f=v.children;if(f.length>0){r.graphSet.push(f);for(var n=0;n<f.length;n++)s[++c]=f[n]}}for(var n=0;n<r.graphSet.length;n++)for(var y=r.graphSet[n],m=0;m<y.length;m++){var b=r.idToIndex[y[m]];r.indexToGraph[b]=n}for(var x=e.edges(),n=0;n<r.edgeSize;n++){var _=x[n],E={};E.id=_.data("id"),E.sourceId=_.data("source"),E.targetId=_.data("target");var S=t.idealEdgeLength,P=r.idToIndex[E.sourceId],k=r.idToIndex[E.targetId],M=r.indexToGraph[P],N=r.indexToGraph[k];if(M!=N){for(var C=a(E.sourceId,E.targetId,r),D=r.graphSet[C],T=0,o=r.layoutNodes[P];-1==$.inArray(o.id,D);)o=r.layoutNodes[r.idToIndex[o.parentId]],T++;for(o=r.layoutNodes[k];-1==$.inArray(o.id,D);)o=r.layoutNodes[r.idToIndex[o.parentId]],T++;w("LCA of nodes "+E.sourceId+" and "+E.targetId+". Index: "+C+" Contents: "+D.toString()+". Depth: "+T),S*=T*t.nestingFactor}E.idealLength=S,r.layoutEdges.push(E)}return r},a=function(e,t,r){var i=o(e,t,0,r);return 2>i.count?0:i.graph},o=function(e,t,r,i){var n=i.graphSet[r];if(-1<$.inArray(e,n)&&-1<$.inArray(t,n))return{count:2,graph:r};for(var a=0,s=0;s<n.length;s++){var l=n[s],c=i.idToIndex[l],u=i.layoutNodes[c].children;if(0!=u.length){var p=i.indexToGraph[i.idToIndex[u[0]]],d=o(e,t,p,i);if(0!=d.count){if(1!=d.count)return d;if(a++,2==a)break}}}return{count:a,graph:r}},s=function(e){if(r){console.debug("layoutNodes:");for(var t=0;t<e.nodeSize;t++){var i=e.layoutNodes[t],n="\nindex: "+t+"\nId: "+i.id+"\nChildren: "+i.children.toString()+"\nparentId: "+i.parentId+"\npositionX: "+i.positionX+"\npositionY: "+i.positionY+"\nOffsetX: "+i.offsetX+"\nOffsetY: "+i.offsetY+"\npadLeft: "+i.padLeft+"\npadRight: "+i.padRight+"\npadTop: "+i.padTop+"\npadBottom: "+i.padBottom;console.debug(n)}console.debug("idToIndex");for(var t in e.idToIndex)console.debug("Id: "+t+"\nIndex: "+e.idToIndex[t]);console.debug("Graph Set");for(var a=e.graphSet,t=0;t<a.length;t++)console.debug("Set : "+t+": "+a[t].toString());for(var n="IndexToGraph",t=0;t<e.indexToGraph.length;t++)n+="\nIndex : "+t+" Graph: "+e.indexToGraph[t];console.debug(n),n="Layout Edges";for(var t=0;t<e.layoutEdges.length;t++){var o=e.layoutEdges[t];n+="\nEdge Index: "+t+" ID: "+o.id+" SouceID: "+o.sourceId+" TargetId: "+o.targetId+" Ideal Length: "+o.idealLength}console.debug(n),n="nodeSize: "+e.nodeSize,n+="\nedgeSize: "+e.edgeSize,n+="\ntemperature: "+e.temperature,console.debug(n)}},l=function(e,t){for(var r=t.container(),i=r.clientWidth,n=r.clientHeight,a=0;a<e.nodeSize;a++){var o=e.layoutNodes[a];o.positionX=Math.random()*i,o.positionY=Math.random()*n}},c=function(e,t,r){var i=t.container(),n=(i.clientWidth,i.clientHeight,"Refreshing positions");w(n),t.nodes().positions(function(t,r){var i=e.layoutNodes[e.idToIndex[r.data("id")]];return n="Node: "+i.id+". Refreshed position: ("+i.positionX+", "+i.positionY+").",w(n),{x:i.positionX,y:i.positionY}}),1!=e.ready&&(n="Triggering layoutready",w(n),e.ready=!0,t.one("layoutready",r.ready),t.trigger("layoutready"))},u=function(e,t,r,i){var n="\n\n###############################";n+="\nSTEP: "+i,n+="\n###############################\n",w(n),p(e,t,r),v(e,t,r),f(e,t,r),y(e,t,r),m(e,t,r)},p=function(e,t,r){var i="calculateNodeForces";w(i);for(var n=0;n<e.graphSet.length;n++){var a=e.graphSet[n],o=a.length;i="Set: "+a.toString(),w(i);for(var s=0;o>s;s++)for(var l=e.layoutNodes[e.idToIndex[a[s]]],c=s+1;o>c;c++){var u=e.layoutNodes[e.idToIndex[a[c]]];d(l,u,e,t,r)}}},d=function(e,t,r,i,n){var a="Node repulsion. Node1: "+e.id+" Node2: "+t.id,o=t.positionX-e.positionX,s=t.positionY-e.positionY;if(a+="\ndirectionX: "+o+", directionY: "+s,0==o&&0==s)return void(a+="\nNodes have the same position.");var l=g(e,t,o,s);if(l>0){a+="\nNodes DO overlap.",a+="\nOverlap: "+l;var c=n.nodeOverlap*l,u=Math.sqrt(o*o+s*s);a+="\nDistance: "+u;var p=c*o/u,d=c*s/u}else{a+="\nNodes do NOT overlap.";var v=h(e,o,s),f=h(t,-1*o,-1*s),y=f.x-v.x,m=f.y-v.y,b=y*y+m*m,u=Math.sqrt(b);a+="\nDistance: "+u;var c=n.nodeRepulsion/b,p=c*y/u,d=c*m/u}e.offsetX-=p,e.offsetY-=d,t.offsetX+=p,t.offsetY+=d,a+="\nForceX: "+p+" ForceY: "+d,w(a)},h=function(e,t,r){var i=e.positionX,n=e.positionY,a=e.height,o=e.width,s=r/t,l=a/o,c="Computing clipping point of node "+e.id+" . Height:  "+a+", Width: "+o+"\nDirection "+t+", "+r,u={};do{if(0==t&&r>0){u.x=i,c+="\nUp direction",u.y=n+a/2;break}if(0==t&&0>r){u.x=i,u.y=n+a/2,c+="\nDown direction";break}if(t>0&&s>=-1*l&&l>=s){u.x=i+o/2,u.y=n+o*r/2/t,c+="\nRightborder";break}if(0>t&&s>=-1*l&&l>=s){u.x=i-o/2,u.y=n-o*r/2/t,c+="\nLeftborder";break}if(r>0&&(-1*l>=s||s>=l)){u.x=i+a*t/2/r,u.y=n+a/2,c+="\nTop border";break}if(0>r&&(-1*l>=s||s>=l)){u.x=i-a*t/2/r,u.y=n-a/2,c+="\nBottom border";break}}while(!1);return c+="\nClipping point found at "+u.x+", "+u.y,w(c),u},g=function(e,t,r,i){if(r>0)var n=e.maxX-t.minX;else var n=t.maxX-e.minX;if(i>0)var a=e.maxY-t.minY;else var a=t.maxY-e.minY;return n>=0&&a>=0?Math.sqrt(n*n+a*a):0},v=function(e,t,r){for(var i=0;i<e.edgeSize;i++){var n=e.layoutEdges[i],a=e.idToIndex[n.sourceId],o=e.layoutNodes[a],s=e.idToIndex[n.targetId],l=e.layoutNodes[s],c=l.positionX-o.positionX,u=l.positionY-o.positionY;if(0==c&&0==u)return;var p=h(o,c,u),d=h(l,-1*c,-1*u),g=d.x-p.x,v=d.y-p.y,f=Math.sqrt(g*g+v*v),y=Math.pow(n.idealLength-f,2)/r.edgeElasticity;if(0!=f)var m=y*g/f,b=y*v/f;else var m=0,b=0;o.offsetX+=m,o.offsetY+=b,l.offsetX-=m,l.offsetY-=b;var x="Edge force between nodes "+o.id+" and "+l.id;x+="\nDistance: "+f+" Force: ("+m+", "+b+")",w(x)}},f=function(e,t,r){var i="calculateGravityForces";w(i);for(var n=0;n<e.graphSet.length;n++){var a=e.graphSet[n],o=a.length;if(i="Set: "+a.toString(),w(i),0==n)var s=t.container(),l=s.clientHeight/2,c=s.clientWidth/2;else var u=e.layoutNodes[e.idToIndex[a[0]]],p=e.layoutNodes[e.idToIndex[u.parentId]],l=p.positionX,c=p.positionY;i="Center found at: "+l+", "+c,w(i);for(var d=0;o>d;d++){var h=e.layoutNodes[e.idToIndex[a[d]]];i="Node: "+h.id;var g=l-h.positionX,v=c-h.positionY,f=Math.sqrt(g*g+v*v);if(f>1){var y=r.gravity*g/f,m=r.gravity*v/f;h.offsetX+=y,h.offsetY+=m,i+=": Applied force: "+y+", "+m}else i+=": skypped since it's too close to center";w(i)}}},y=function(e){var t=[],r=0,i=-1;for(w("propagateForces"),t.push.apply(t,e.graphSet[0]),i+=e.graphSet[0].length;i>=r;){var n=t[r++],a=e.idToIndex[n],o=e.layoutNodes[a],s=o.children;if(0<s.length){var l=o.offsetX,c=o.offsetY,u="Propagating offset from parent node : "+o.id+". OffsetX: "+l+". OffsetY: "+c;u+="\n Children: "+s.toString(),w(u);for(var p=0;p<s.length;p++){var d=e.layoutNodes[e.idToIndex[s[p]]];d.offsetX+=l,d.offsetY+=c,t[++i]=s[p]}o.offsetX=0,o.offsetY=0}}},m=function(e){var t="Updating positions";w(t);for(var r=0;r<e.nodeSize;r++){var i=e.layoutNodes[r];0<i.children.length&&(w("Resetting boundaries of compound node: "+i.id),i.maxX=void 0,i.minX=void 0,i.maxY=void 0,i.minY=void 0)}for(var r=0;r<e.nodeSize;r++){var i=e.layoutNodes[r];if(0<i.children.length)w("Skipping position update of node: "+i.id);else{t="Node: "+i.id+" Previous position: ("+i.positionX+", "+i.positionY+").";var n=b(i.offsetX,i.offsetY,e.temperature);i.positionX+=n.x,i.positionY+=n.y,i.offsetX=0,i.offsetY=0,i.minX=i.positionX-i.width,i.maxX=i.positionX+i.width,i.minY=i.positionY-i.height,i.maxY=i.positionY+i.height,t+=" New Position: ("+i.positionX+", "+i.positionY+").",w(t),x(i,e)}}for(var r=0;r<e.nodeSize;r++){var i=e.layoutNodes[r];0<i.children.length&&(i.positionX=(i.maxX+i.minX)/2,i.positionY=(i.maxY+i.minY)/2,i.width=i.maxX-i.minX,i.height=i.maxY-i.minY,t="Updating position, size of compound node "+i.id,t+="\nPositionX: "+i.positionX+", PositionY: "+i.positionY,t+="\nWidth: "+i.width+", Height: "+i.height,w(t))}},b=function(e,t,r){var i="Limiting force: ("+e+", "+t+"). Max: "+r,n=Math.sqrt(e*e+t*t);if(n>r)var a={x:r*e/n,y:r*t/n};else var a={x:e,y:t};return i+=".\nResult: ("+a.x+", "+a.y+")",w(i),a},x=function(e,t){var r="Propagating new position/size of node "+e.id,i=e.parentId;if(void 0==i)return r+=". No parent node.",void w(r);var n=t.layoutNodes[t.idToIndex[i]],a=!1;return(void 0==n.maxX||e.maxX+n.padRight>n.maxX)&&(n.maxX=e.maxX+n.padRight,a=!0,r+="\nNew maxX for parent node "+n.id+": "+n.maxX),(void 0==n.minX||e.minX-n.padLeft<n.minX)&&(n.minX=e.minX-n.padLeft,a=!0,r+="\nNew minX for parent node "+n.id+": "+n.minX),(void 0==n.maxY||e.maxY+n.padBottom>n.maxY)&&(n.maxY=e.maxY+n.padBottom,a=!0,r+="\nNew maxY for parent node "+n.id+": "+n.maxY),(void 0==n.minY||e.minY-n.padTop<n.minY)&&(n.minY=e.minY-n.padTop,a=!0,r+="\nNew minY for parent node "+n.id+": "+n.minY),a?(w(r),x(n,t)):(r+=". No changes in boundaries/position of parent node "+n.id,void w(r))},w=function(e){r&&console.debug(e)};e("layout","cose",t)}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend({},r,t)}var r={fit:!0,padding:30,rows:void 0,columns:void 0,position:function(){},ready:void 0,stop:void 0};t.prototype.run=function(){var e=this.options,t=e,r=e.cy,i=r.nodes(),n=(r.edges(),r.container()),a=n.clientWidth,o=n.clientHeight;if(0==o||0==a)i.positions(function(){return{x:0,y:0}});else{var s=i.size(),l=Math.sqrt(s*o/a),c=Math.round(l),u=Math.round(a/o*l),p=function(e){if(void 0==e)return Math.min(c,u);var t=Math.min(c,u);t==c?c=e:u=e},d=function(e){if(void 0==e)return Math.max(c,u);var t=Math.max(c,u);t==c?c=e:u=e};if(null!=t.rows&&null!=t.columns)c=t.rows,u=t.columns;else if(null!=t.rows&&null==t.columns)c=t.rows,u=Math.ceil(s/c);else if(null==t.rows&&null!=t.columns)u=t.columns,c=Math.ceil(s/u);else if(u*c>s){var h=p(),g=d();(h-1)*g>=s?p(h-1):(g-1)*h>=s&&d(g-1)}else for(;s>u*c;){var h=p(),g=d();(g+1)*h>=s?d(g+1):p(h+1)}for(var v=a/u,f=o/c,y=0;y<i.length;y++){var m=i[y],b=m.outerWidth(),x=m.outerHeight();v=Math.max(v,b),f=Math.max(f,x)}for(var w={},_=function(e,t){return w["c-"+e+"-"+t]?!0:!1},E=function(e,t){w["c-"+e+"-"+t]=!0},S=0,P=0,k=function(){P++,P>=u&&(P=0,S++)},M={},y=0;y<i.length;y++){var m=i[y],N=t.position(m);if(N&&(void 0!==N.row||void 0!==N.col)){var C={row:N.row,col:N.col};if(void 0===C.col)for(C.col=0;_(C.row,C.col);)C.col++;else if(void 0===C.row)for(C.row=0;_(C.row,C.col);)C.row++;M[m.id()]=C,E(C.row,C.col)}}i.positions(function(e,t){var r,i;if(t.locked()||t.isFullAutoParent())return!1;var n=M[t.id()];if(n)r=n.col*v+v/2,i=n.row*f+f/2;else{for(;_(S,P);)k();r=P*v+v/2,i=S*f+f/2,E(S,P),k()}return{x:r,y:i}})}e.fit&&r.fit(t.padding),r.one("layoutready",e.ready),r.trigger("layoutready"),r.one("layoutstop",e.stop),r.trigger("layoutstop")},t.prototype.stop=function(){},e("layout","grid",t)}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend(!0,{},r,t)}var r={ready:function(){},stop:function(){}};t.prototype.run=function(){var e=this.options,t=e.cy;t.nodes().positions(function(){return{x:0,y:0}}),t.one("layoutready",e.ready),t.trigger("layoutready"),t.one("layoutstop",e.stop),t.trigger("layoutstop")},t.prototype.stop=function(){var e=this.options;cy.one("layoutstop",e.stop),cy.trigger("layoutstop")},e("layout","null",t)}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend(!0,{},r,t)}var r={fit:!0,ready:void 0,stop:void 0,positions:void 0,zoom:void 0,pan:void 0,padding:30};t.prototype.run=function(){function e(e){return null==t.positions?null:null==t.positions[e._private.data.id]?null:t.positions[e._private.data.id]}{var t=this.options,r=t.cy,i=r.nodes();r.edges(),r.container()}i.positions(function(t,r){var i=e(r);return r.locked()||null==i?!1:i}),null!=t.pan&&r.pan(t.pan),null!=t.zoom&&r.zoom(t.zoom),r.one("layoutready",t.ready),r.trigger("layoutready"),t.fit&&r.fit(t.padding),r.one("layoutstop",t.stop),r.trigger("layoutstop")},e("layout","preset",t),e("core","presetLayout",function(){var e=this,t={},r={};return e.nodes().each(function(e,t){r[t.data("id")]=t.position()}),t.positions=r,t.name="preset",t.zoom=e.zoom(),t.pan=e.pan(),t})}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend(!0,{},r,t)}var r={ready:void 0,stop:void 0,fit:!0,padding:30};t.prototype.run=function(){var e=this.options,t=e.cy,r=t.nodes(),i=(t.edges(),t.container()),n=i.clientWidth,a=i.clientHeight;r.positions(function(e,t){return t.locked()?!1:{x:Math.round(Math.random()*n),y:Math.round(Math.random()*a)}}),t.one("layoutready",e.ready),t.trigger("layoutready"),e.fit&&t.fit(e.padding),t.one("layoutstop",e.stop),t.trigger("layoutstop")},t.prototype.stop=function(){},e("layout","random",t)}(cytoscape),function(e){"use strict";function t(t){this.options=e.util.extend(!0,{},r,t)}var r={maxSimulationTime:1e3,ungrabifyWhileSimulating:!0,fit:!0,random:!1};t.prototype.run=function(){function e(e){var t=e.scratch("springy").model.id,r=b.layout.nodePoints[t].p,i=e.position(),n=null!=i.x&&null!=i.y?v(e.position()):{x:4*Math.random()-2,y:4*Math.random()-2};r.x=n.x,r.y=n.y}function t(){n.ungrabifyWhileSimulating&&x.ungrabify(),b.start()}function r(e){p.filterNodes(function(){return!1}),setTimeout(function(){n.ungrabifyWhileSimulating&&x.grabify(),e()},100)}var i=this,n=this.options,a=n.cy,o=a.nodes(),s=a.edges(),l=a.container(),c=l.clientWidth,u=l.clientHeight,p=new Springy.Graph;o.each(function(e,t){t.scratch("springy",{model:p.newNode({element:t})})}),s.each(function(e,t){fdSrc=t.source().scratch("springy").model,fdTgt=t.target().scratch("springy").model,t.scratch("springy",{model:p.newEdge(fdSrc,fdTgt,{element:t})})});var d=new Springy.Layout.ForceDirected(p,400,400,.5),h=d.getBoundingBox(),g=({bottomleft:new Springy.Vector(-2,-2),topright:new Springy.Vector(2,2)},function(e){var t=h.topright.subtract(h.bottomleft),r=e.subtract(h.bottomleft).divide(t.x).x*c,i=e.subtract(h.bottomleft).divide(t.y).y*u;return new Springy.Vector(r,i)}),v=function(e){var t=h.topright.subtract(h.bottomleft),r=e.x/c*t.x+h.bottomleft.x,i=e.y/u*t.y+h.bottomleft.y;return new Springy.Vector(r,i)},f=a.collection(),y=a.nodes().size(),m=1,b=new Springy.Renderer(d,function(){},function(){},function(t,r){var i=g(r),o=t.data.element;window.p=r,window.n=t,o.locked()?e(o):(o._private.position={x:i.x,y:i.y},f=f.add(o)),m==y&&(a.one("layoutready",n.ready),a.trigger("layoutready")),m++});o.each(function(t,r){n.random||e(r)}),setInterval(function(){f.size()>0&&(f.rtrigger("position"),f=a.collection())},50),o.bind("drag",function(){e(this)});var x=o.filter(":grabbable"),w=i.stopSystem=function(){r(function(){n.fit&&a.fit(),a.one("layoutstop",n.stop),a.trigger("layoutstop"),i.stopSystem=null})};t(),setTimeout(function(){w()},n.maxSimulationTime)},t.prototype.stop=function(){null!=this.stopSystem&&this.stopSystem()},e("layout","springy",t)}(cytoscape),function(e){"use strict";function t(){}t.prototype.notify=function(){},e("renderer","null",t)}(cytoscape);