## ---- echo = FALSE--------------------------------------------------------------------------------
library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    warning = FALSE,
    fig.align = "center",
    dev = "jpeg"
)
options(width = 100)

## ---- fig.width = 7, fig.height = 4---------------------------------------------------------------
library(tm)
data(crude)
term = lapply(crude$content, function(x) x$content)[1:10]
mat = matrix(rnorm(100*10), nrow = 100)

split = sample(letters[1:10], 100, replace = TRUE)

names(term) = letters[1:10]  ## names of `term` must be the same as `unique(split)`
str(term, nchar.max = 80)

library(ComplexHeatmap)
library(simplifyEnrichment)

Heatmap(mat, row_split = split, 
	right_annotation = rowAnnotation(wc = anno_word_cloud(split, term))
)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  align_to = split(seq_along(split), split)
#  Heatmap(mat, row_split = split,
#  	right_annotation = rowAnnotation(wc = anno_word_cloud(align_to, term))
#  )

## ---- fig.width = 7, fig.height = 4---------------------------------------------------------------
Heatmap(mat, row_split = split, row_dend_side = "right", row_title_side = "right",
	left_annotation = rowAnnotation(wc = anno_word_cloud(split, term, side = "left"))
)

## ---- fig.width = 7, fig.height = 4---------------------------------------------------------------
term = lapply(letters[1:10], function(x) {
	data.frame(LETTERS[1:10], 1:10)
})
names(term) = letters[1:10]
Heatmap(mat, row_split = split, 
	right_annotation = rowAnnotation(wc = anno_word_cloud(split, term))
)

## -------------------------------------------------------------------------------------------------
load(system.file("extdata", "golub_sig_go.RData", package = "simplifyEnrichment"))
head(km)
str(go_list)

## ---- echo = FALSE--------------------------------------------------------------------------------
ht_opt$message = FALSE

## ---- fig.width = 7, fig.height = 4---------------------------------------------------------------
library(circlize)
Heatmap(t(scale(t(sig_mat))), name = "z-score",
	col = colorRamp2(c(-2, 0, 2), c("green", "white", "red")),
	show_row_names = FALSE, show_column_names = FALSE, 
	row_title = NULL, column_title = NULL,
	show_row_dend = FALSE, show_column_dend = FALSE,
	row_split = km) +
rowAnnotation(go = anno_word_cloud_from_GO(km, go_list, max_words = 30))

## ---- fig.width = 7, fig.height = 4---------------------------------------------------------------
Heatmap(t(scale(t(sig_mat))), name = "z-score",
	col = colorRamp2(c(-2, 0, 2), c("green", "white", "red")),
	show_row_names = FALSE, show_column_names = FALSE, 
	row_title = NULL, column_title = NULL,
	show_row_dend = FALSE, show_column_dend = FALSE,
	row_split = km) +
rowAnnotation(go = anno_word_cloud_from_GO(km, go_list, max_words = 30, stat = "count"))

## ---- fig.width = 7, fig.height = 4---------------------------------------------------------------
mat = matrix(rnorm(100*10), nrow = 100)
split = sample(letters[1:5], 100, replace = TRUE)
term = lapply(letters[1:5], function(x) {
    data.frame(c("This is the first sentence.", "This is the second sentence."), c(1, 1))
})
names(term) = letters[1:5]
Heatmap(mat, row_split = split, 
    right_annotation = rowAnnotation(wc = anno_word_cloud(split, term,
    	add_new_line = TRUE, value_range = c(1, 1), fontsize_range = c(10, 10)))
)

## ---- fig.width = 7, fig.height = 4---------------------------------------------------------------
term = lapply(letters[1:5], function(x) {
    data.frame(c("This is the first sentence.", "This is the second sentence."), c(1, 2))
})
names(term) = letters[1:5]
Heatmap(mat, row_split = split, 
    right_annotation = rowAnnotation(wc = anno_word_cloud(split, term,
    	add_new_line = TRUE, value_range = c(1, 2), fontsize_range = c(8, 12)))
)

