## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  if (!require("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("signifinder")

## ---- message=FALSE-----------------------------------------------------------
# loading packages
library(SummarizedExperiment)
library(signifinder)
library(dplyr)
data(ovse)
ovse

## -----------------------------------------------------------------------------
availSigns <- availableSignatures()

## -----------------------------------------------------------------------------
knitr::kable(t(availSigns[1,]), caption = 'One signature fiels')

## -----------------------------------------------------------------------------
ovary_signatures <- availableSignatures(tissue = "ovary", 
                                        description = FALSE)
knitr::kable(ovary_signatures, 
             caption = 'Signatures developed for ovary.') %>% 
    kableExtra::kable_paper() %>% 
    kableExtra::scroll_box(width = "82%", height = "500px")

## -----------------------------------------------------------------------------
ovse <- ferroptosisSign(dataset = ovse,
                        inputType = "rnaseq")

## -----------------------------------------------------------------------------
ovse <- EMTSign(dataset = ovse,
                inputType = "rnaseq",
                author = "Miow")

## -----------------------------------------------------------------------------
ovse <- multipleSign(dataset = ovse, 
                     inputType = "rnaseq",
                     tissue = c("ovary", "pan-tissue"))

## -----------------------------------------------------------------------------
oneSignPlot(data = ovse, 
            whichSign = "Hypoxia_Buffa")

## -----------------------------------------------------------------------------
geneHeatmapSignPlot(data = ovse, 
                    whichSign = "LipidMetabolism_Zheng", 
                    logCount = TRUE)

geneHeatmapSignPlot(data = ovse, 
                    whichSign = c("IFN_Ayers", "Tinflam_Ayers"), 
                    logCount = TRUE)

## -----------------------------------------------------------------------------
sign_cor <- correlationSignPlot(data = ovse)
highest_correlated <- unique(unlist(
    sign_cor$data[(sign_cor$data$cor>0.95 & sign_cor$data$cor<1),c(1,2)]
    ))

## -----------------------------------------------------------------------------
heatmapSignPlot(data = ovse)
heatmapSignPlot(data = ovse, 
                whichSign = highest_correlated)

## -----------------------------------------------------------------------------
heatmapSignPlot(data = ovse, 
                clusterBySign = paste0("ConsensusOV_Chen_", c("IMR","DIF","PRO","MES")),
                sampleAnnot = ovse$OV_subtype, signAnnot = "topic")

## -----------------------------------------------------------------------------
mysurvData <- cbind(ovse$os, ovse$status)
rownames(mysurvData) <- rownames(colData(ovse))
head(mysurvData)

## -----------------------------------------------------------------------------
survivalSignPlot(data = ovse, 
                 survData = mysurvData, 
                 whichSign = "Pyroptosis_Ye", 
                 cutpoint = "optimal")

## -----------------------------------------------------------------------------
ridgelineSignPlot(data = ovse, 
                  whichSign = highest_correlated)
ridgelineSignPlot(data = ovse, 
                  whichSign = highest_correlated, 
                  groupByAnnot = ovse$OV_subtype)

## -----------------------------------------------------------------------------
sessionInfo()

